/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class CodeGeneratorParser
extends LookaheadParser {
    private static final long serialVersionUID = -1251248150731418714L;
    private static final String WARNING_PATTERN = "^(Warning:)(.*)";

    public CodeGeneratorParser() {
        super(WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        builder.setCategory(this.getCategory(matcher.group(2)));
        builder.setMessage(matcher.group(2));
        builder.setSeverity(Severity.WARNING_NORMAL);
        return builder.buildOptional();
    }

    private String getCategory(String line) {
        if (line.contains("no longer available in the Configuration Parameters")) {
            return "Configuration Parameters Unavailable";
        }
        if (line.contains("does not support multiword aliases")) {
            return "Multiword Aliases not Supported by Code Generation";
        }
        if (line.contains("Unnecessary Data Type Conversion")) {
            return "Unnecessary Data Type Conversion";
        }
        if (line.contains("Cannot close the model")) {
            return "Model Cannot be Closed";
        }
        if (line.contains("Cannot find library called")) {
            return "Library Not Found";
        }
        if (line.contains("File not found or permission denied")) {
            return "File not found or permission denied";
        }
        return "Other";
    }
}

