/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.util.XmlElementUtil;
import java.io.Serializable;
import java.util.Optional;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EclipseXMLParser
extends IssueParser {
    static final String PREVIEW_RELATED = "Preview Related";
    static final String COMPLIANCE = "Compliance";
    static final String MODULE = "Module";
    static final String RESTRICTION = "Restriction";
    static final String NLS = "NLS";
    static final String UNCHECKED_RAW = "Unchecked Raw";
    static final String UNNECESSARY_CODE = "Unnecessary Code";
    static final String NAME_SHADOWING_CONFLICT = "Name Shadowing Conflict";
    static final String POTENTIAL_PROGRAMMING_PROBLEM = "Potential Programming Problem";
    static final String CODE_STYLE = "Code Style";
    static final String INTERNAL = "Internal";
    static final String MEMBER = "Member";
    static final String TYPE = "Type";
    static final String IMPORT = "Import";
    static final String SYNTAX = "Syntax";
    static final String BUILDPATH = "Buildpath";
    static final String UNSPECIFIED = "Unspecified";
    private static final long serialVersionUID = 1L;

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return this.isXmlFile(readerFactory);
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        IssueBuilder issueBuilder = new IssueBuilder();
        try {
            Document doc = readerFactory.readDocument();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            XPathExpression sourcePath = xPath.compile("/compiler/sources/source[problems]");
            XPathExpression fileNamePath = xPath.compile("./@path");
            XPathExpression problemsPath = xPath.compile("problems/problem");
            Report report = new Report();
            NodeList sources = (NodeList)sourcePath.evaluate(doc, XPathConstants.NODESET);
            for (Element source : XmlElementUtil.nodeListToList(sources)) {
                String fileName = fileNamePath.evaluate(source);
                issueBuilder.setFileName(fileName);
                NodeList problems = (NodeList)problemsPath.evaluate(source, XPathConstants.NODESET);
                for (Element problem : XmlElementUtil.nodeListToList(problems)) {
                    issueBuilder.guessSeverity(this.extractSeverity(problem)).setLineStart(this.extractLineStart(problem)).setMessage(this.extractMessage(problem)).setCategory(this.decodeCategory(this.extractCategoryId(problem))).setAdditionalProperties((Serializable)((Object)this.extractColumnRange(problem)));
                    report.add(issueBuilder.build());
                }
            }
            Report report2 = report;
            issueBuilder.close();
            return report2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    issueBuilder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (XPathExpressionException e) {
                throw new ParsingException(e);
            }
        }
    }

    private String decodeCategory(String categoryId) {
        switch (categoryId) {
            case "0": {
                return UNSPECIFIED;
            }
            case "10": {
                return BUILDPATH;
            }
            case "20": {
                return SYNTAX;
            }
            case "30": {
                return IMPORT;
            }
            case "40": {
                return TYPE;
            }
            case "50": {
                return MEMBER;
            }
            case "60": {
                return INTERNAL;
            }
            case "70": {
                return "Javadoc";
            }
            case "80": {
                return CODE_STYLE;
            }
            case "90": {
                return POTENTIAL_PROGRAMMING_PROBLEM;
            }
            case "100": {
                return NAME_SHADOWING_CONFLICT;
            }
            case "110": {
                return "Deprecation";
            }
            case "120": {
                return UNNECESSARY_CODE;
            }
            case "130": {
                return UNCHECKED_RAW;
            }
            case "140": {
                return NLS;
            }
            case "150": {
                return RESTRICTION;
            }
            case "160": {
                return MODULE;
            }
            case "170": {
                return COMPLIANCE;
            }
            case "180": {
                return PREVIEW_RELATED;
            }
        }
        return "Other";
    }

    private String extractMessage(Element problem) {
        return XmlElementUtil.nodeListToList(problem.getChildNodes()).stream().filter(e -> "message".equals(e.getNodeName())).findFirst().map(e -> e.getAttribute("value")).orElse("");
    }

    private String extractSeverity(Element problem) {
        return problem.getAttribute("severity");
    }

    private String extractLineStart(Element problem) {
        return problem.getAttribute("line");
    }

    private String extractColumnRange(Element problem) {
        Optional<Element> ctx = XmlElementUtil.nodeListToList(problem.getChildNodes()).stream().filter(e -> "source_context".equals(e.getNodeName())).findFirst();
        StringBuilder range = new StringBuilder();
        ctx.map(e -> e.getAttribute("sourceStart")).ifPresent(range::append);
        range.append('-');
        ctx.map(e -> e.getAttribute("sourceEnd")).ifPresent(range::append);
        return range.toString();
    }

    private String extractCategoryId(Element problem) {
        return problem.getAttribute("categoryID");
    }
}

