/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class Gcc4LinkerParser
extends LookaheadParser {
    private static final long serialVersionUID = -2792019431810134790L;
    static final String WARNING_CATEGORY = "GCC4 Linker Error";
    private static final String LINKER_WARNING_PATTERN = "^(?:(.+?)(?:(?::(?:(\\d+):)? (undefined reference to .*))|(?::?\\(\\.\\w+\\+0x[0-9a-fA-F]+\\)): (?:(warning): )?(.*))|.*/ld(?:\\.exe)?: (?:(warning): )?(.*))$";

    public Gcc4LinkerParser() {
        super(LINKER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        if (StringUtils.isNotBlank((CharSequence)matcher.group(7))) {
            this.parseLdError(matcher, builder);
        } else if (StringUtils.isNotBlank((CharSequence)matcher.group(3))) {
            builder.setMessage(matcher.group(3));
            builder.setSeverity(Severity.WARNING_HIGH);
        } else {
            if (StringUtils.equalsIgnoreCase((CharSequence)matcher.group(4), (CharSequence)"warning")) {
                builder.setSeverity(Severity.WARNING_NORMAL);
            } else {
                builder.setSeverity(Severity.WARNING_HIGH);
            }
            String message = matcher.group(5);
            builder.setMessage(message);
            if (StringUtils.endsWith((CharSequence)message, (CharSequence)":")) {
                return Optional.empty();
            }
        }
        return builder.setFileName(StringUtils.defaultString((String)matcher.group(1))).setLineStart(matcher.group(2)).setCategory(WARNING_CATEGORY).buildOptional();
    }

    private void parseLdError(Matcher matcher, IssueBuilder builder) {
        if (StringUtils.equalsIgnoreCase((CharSequence)matcher.group(6), (CharSequence)"warning")) {
            builder.setSeverity(Severity.WARNING_NORMAL);
        } else {
            builder.setSeverity(Severity.WARNING_HIGH);
        }
        builder.setMessage(matcher.group(7));
    }
}

