/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GnuFortranParser
extends LookaheadParser {
    private static final long serialVersionUID = 0L;
    private static final String MESSAGE_START_REGEX = "(?s)^(.+\\.[^:]+):(\\d+)(?:\\.(\\d+)(?:-(\\d+))?)?:";
    private static final String INCLUDE_LINE_REGEX = "(?: {4}Included at .+)";
    private static final String NON_EMPTY_LINE_REGEX = ".+";
    private static final String EMPTY_LINE_REGEX = "^$";
    private static final Pattern MESSAGE_TRIM_PATTERN = Pattern.compile(" at \\(\\d\\)");
    private static final Pattern ERROR_MESSAGE_PATTERN = Pattern.compile("(Warning|Error|Fatal Error|Internal Error at \\(1\\)):\\s?(.*)");

    public GnuFortranParser() {
        super(MESSAGE_START_REGEX);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        while (lookahead.hasNext(INCLUDE_LINE_REGEX)) {
            lookahead.next();
        }
        if (!lookahead.hasNext(EMPTY_LINE_REGEX)) {
            return Optional.empty();
        }
        lookahead.next();
        if (!lookahead.hasNext(NON_EMPTY_LINE_REGEX)) {
            return Optional.empty();
        }
        lookahead.next();
        if (!lookahead.hasNext(NON_EMPTY_LINE_REGEX)) {
            return Optional.empty();
        }
        lookahead.next();
        if (!lookahead.hasNext()) {
            return Optional.empty();
        }
        String errorMessageLine = lookahead.peekNext();
        Matcher messageMatcher = ERROR_MESSAGE_PATTERN.matcher(errorMessageLine);
        if (!messageMatcher.matches()) {
            return Optional.empty();
        }
        lookahead.next();
        String category = MESSAGE_TRIM_PATTERN.matcher(messageMatcher.group(1)).replaceAll("");
        String message = MESSAGE_TRIM_PATTERN.matcher(messageMatcher.group(2)).replaceAll("");
        if (message.isEmpty() && lookahead.hasNext()) {
            message = MESSAGE_TRIM_PATTERN.matcher(lookahead.next()).replaceAll("");
        }
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setColumnStart(matcher.group(3)).setColumnEnd(matcher.group(4)).setCategory(category).setMessage(message).setSeverity(Severity.guessFromString(category)).buildOptional();
    }
}

