/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.JsonBaseParser;
import java.util.Optional;
import java.util.stream.Stream;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonLogParser
extends JsonBaseParser {
    private static final long serialVersionUID = 1349282064371959197L;

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        String fileName = readerFactory.getFileName();
        return !fileName.endsWith(".xml") && !fileName.endsWith(".json");
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        try (Stream<String> lines = readerFactory.readStream();){
            Report report = new Report();
            lines.map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith("//")).filter(line -> line.charAt(0) != '#').map(line -> this.parseIssue((String)line, report)).filter(Optional::isPresent).map(Optional::get).forEach(report::add);
            Report report2 = report;
            return report2;
        }
    }

    private Optional<Issue> parseIssue(String line, Report report) {
        try {
            JSONObject jsonIssue = new JSONObject(line);
            return this.convertToIssue(jsonIssue);
        }
        catch (JSONException e) {
            report.logException((Exception)((Object)e), "Could not parse line: \u00ab%s\u00bb", line);
            return Optional.empty();
        }
    }
}

