/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.RevApiInfoExtension;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class RevApiParser
extends JsonIssueParser {
    private static final long serialVersionUID = -2452699725595063377L;

    @Override
    protected void parseJsonArray(Report report, JSONArray jsonReport, IssueBuilder issueBuilder) {
        for (Object issue : jsonReport) {
            if (issue instanceof JSONObject) {
                report.add(this.convertToIssue((JSONObject)issue, issueBuilder));
                continue;
            }
            report.logError("RevApi issues no instance of JSON", new Object[0]);
        }
    }

    private Issue convertToIssue(JSONObject jsonIssue, IssueBuilder builder) {
        builder.setSeverity(this.evaluateSeverity(jsonIssue.getJSONArray("classification")));
        builder.setDescription(this.getDescription(jsonIssue));
        this.addAttachments(jsonIssue.getJSONArray("attachments"), builder);
        builder.setAdditionalProperties(this.convertToGroup(jsonIssue));
        return builder.build();
    }

    private RevApiInfoExtension convertToGroup(JSONObject jsonIssue) {
        return new RevApiInfoExtension(jsonIssue.getString("code"), RevApiParser.extractChange(jsonIssue, "old"), RevApiParser.extractChange(jsonIssue, "new"), RevApiParser.extractSeverities(jsonIssue));
    }

    private static Map<String, String> extractSeverities(JSONObject jsonIssue) {
        HashMap<String, String> allSeverities = new HashMap<String, String>();
        for (Object severity : jsonIssue.getJSONArray("classification")) {
            if (!(severity instanceof JSONObject)) continue;
            allSeverities.put(((JSONObject)severity).getString("compatibility"), ((JSONObject)severity).getString("severity"));
        }
        return allSeverities;
    }

    private static String extractChange(JSONObject jsonIssue, String key) {
        String value = jsonIssue.get(key).toString();
        return "null".equals(value) ? "-" : value;
    }

    private void addAttachments(JSONArray attachments, IssueBuilder builder) {
        String packageName = attachments.getJSONObject(0).getString("value");
        String classSimpleName = attachments.getJSONObject(2).getString("value");
        String elementKind = attachments.getJSONObject(3).getString("value");
        builder.setFileName(classSimpleName);
        builder.setPackageName(packageName);
        builder.setCategory(elementKind);
    }

    private Severity evaluateSeverity(JSONArray classification) {
        HashSet<Severity> allSeverities = new HashSet<Severity>();
        for (Object severity : classification) {
            if (!(severity instanceof JSONObject)) continue;
            allSeverities.add(this.toSeverity(((JSONObject)severity).getString("severity")));
        }
        if (allSeverities.contains(Severity.WARNING_HIGH)) {
            return Severity.WARNING_HIGH;
        }
        if (allSeverities.contains(Severity.WARNING_NORMAL)) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_LOW;
    }

    private Severity toSeverity(String level) {
        switch (level) {
            case "BREAKING": {
                return Severity.WARNING_HIGH;
            }
            case "POTENTIALLY_BREAKING": {
                return Severity.WARNING_NORMAL;
            }
        }
        return Severity.WARNING_LOW;
    }

    private String getDescription(JSONObject jsonIssue) {
        StringBuilder severityDescription = new StringBuilder();
        for (Object severity : jsonIssue.getJSONArray("classification")) {
            if (!(severity instanceof JSONObject)) continue;
            severityDescription.append("<p>Compatibility: ").append(((JSONObject)severity).getString("compatibility")).append(" Severity: ").append(((JSONObject)severity).getString("severity")).append("</p>");
        }
        return MessageFormat.format("<p><div><b>File</b>: {0}</div><div><b>Description:</b> {1} {2}</div><div><b>Change type:</b> {3}", jsonIssue.getJSONArray("attachments").getJSONObject(1).getString("value"), jsonIssue.getString("description"), jsonIssue.getString("name"), jsonIssue.getString("code")) + severityDescription;
    }
}

