/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.parser.JsonIssueParser;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.io.Reader;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public abstract class SonarQubeParser
extends JsonIssueParser {
    private static final long serialVersionUID = 1958805067002376816L;
    private static final String COMPONENTS = "components";
    private static final String ISSUES = "issues";
    private static final String ISSUE_COMPONENT = "component";
    private static final String ISSUE_MESSAGE = "message";
    private static final String ISSUE_SEVERITY = "severity";
    private static final String ISSUE_TYPE = "type";
    private static final String COMPONENT_KEY = "key";
    private static final String COMPONENT_PATH = "path";
    private static final String SEVERITY_BLOCKER = "BLOCKER";
    private static final String SEVERITY_CRITICAL = "CRITICAL";
    private static final String SEVERITY_MINOR = "MINOR";
    private static final String SEVERITY_INFO = "INFO";
    private static final String CATEGORY_SONAR_QUBE = "SonarQube";
    @CheckForNull
    private transient JSONArray components = new JSONArray();

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        boolean bl;
        block8: {
            Reader reader = readerFactory.create();
            try {
                bl = this.accepts((JSONObject)new JSONTokener(reader).nextValue());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return false;
                }
            }
            reader.close();
        }
        return bl;
    }

    abstract boolean accepts(JSONObject var1);

    @Override
    protected void parseJsonObject(Report report, JSONObject jsonReport, IssueBuilder issueBuilder) {
        this.extractComponents(jsonReport);
        if (jsonReport.has(ISSUES)) {
            this.extractIssues(jsonReport.optJSONArray(ISSUES), report, issueBuilder);
        }
    }

    private void extractIssues(JSONArray elements, Report report, IssueBuilder issueBuilder) {
        for (Object object : elements) {
            JSONObject issue;
            if (!(object instanceof JSONObject) || !this.filterIssue(issue = (JSONObject)object)) continue;
            report.add(this.createIssueFromJsonObject(issue, issueBuilder));
        }
    }

    private void extractComponents(JSONObject jsonReport) {
        if (jsonReport.has(COMPONENTS)) {
            this.components = jsonReport.optJSONArray(COMPONENTS);
        }
    }

    boolean filterIssue(JSONObject issue) {
        return true;
    }

    private Issue createIssueFromJsonObject(JSONObject issue, IssueBuilder issueBuilder) {
        return issueBuilder.setFileName(this.parseFilename(issue)).setLineStart(this.parseStart(issue)).setLineEnd(this.parseEnd(issue)).setType(this.parseType(issue)).setCategory(CATEGORY_SONAR_QUBE).setMessage(this.parseMessage(issue)).setSeverity(this.parsePriority(issue)).buildAndClean();
    }

    private String parseFilename(JSONObject issue) {
        String componentKey = issue.optString(ISSUE_COMPONENT, null);
        JSONObject component = this.findComponentByKey(componentKey);
        if (component == null) {
            String issueComponentKey = issue.optString(ISSUE_COMPONENT);
            return issueComponentKey.substring(issueComponentKey.lastIndexOf(58));
        }
        String filePath = component.optString(COMPONENT_PATH);
        String modulePath = this.getModulePath(component, issue);
        return modulePath + filePath;
    }

    abstract String getModulePath(JSONObject var1, JSONObject var2);

    abstract int parseStart(JSONObject var1);

    abstract int parseEnd(JSONObject var1);

    private String parseType(JSONObject issue) {
        return issue.optString(ISSUE_TYPE, "");
    }

    private String parseMessage(JSONObject issue) {
        return issue.optString(ISSUE_MESSAGE, "No message.");
    }

    private Severity parsePriority(JSONObject issue) {
        String severity = issue.optString(ISSUE_SEVERITY, null);
        return this.severityToPriority(severity);
    }

    String parseModulePath(JSONObject moduleKeyObject, String componentKey) {
        String moduleKey;
        JSONObject moduleComponent;
        Object modulePath = "";
        if (moduleKeyObject.has(componentKey) && (moduleComponent = this.findComponentByKey(moduleKey = moduleKeyObject.getString(componentKey))) != null && moduleComponent.has(COMPONENT_PATH)) {
            modulePath = moduleComponent.getString(COMPONENT_PATH) + "/";
        }
        return modulePath;
    }

    @CheckForNull
    private JSONObject findComponentByKey(String key) {
        if (this.components != null && key != null) {
            for (Object component : this.components) {
                JSONObject jsonComponent;
                if (!(component instanceof JSONObject) || !key.equals((jsonComponent = (JSONObject)component).optString(COMPONENT_KEY))) continue;
                return (JSONObject)component;
            }
        }
        return null;
    }

    private Severity severityToPriority(String severity) {
        Severity priority = Severity.WARNING_NORMAL;
        if (severity != null) {
            if (SEVERITY_BLOCKER.equals(severity) || SEVERITY_CRITICAL.equals(severity)) {
                priority = Severity.WARNING_HIGH;
            } else if (SEVERITY_MINOR.equals(severity) || SEVERITY_INFO.equals(severity)) {
                priority = Severity.WARNING_LOW;
            }
        }
        return priority;
    }
}

