/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.LookaheadParser;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.LookaheadStream;
import java.util.Optional;
import java.util.regex.Matcher;

public class SunCParser
extends LookaheadParser {
    private static final long serialVersionUID = -1251248150596418456L;
    private static final String SUN_CPP_WARNING_PATTERN = "^\\s*\"(.*)\"\\s*,\\s*line\\s*(\\d+)\\s*:\\s*(Warning|Error)(?:| .Anachronism.)\\s*(?:, \\s*([^:]*))?\\s*:\\s*(.*)$";

    public SunCParser() {
        super(SUN_CPP_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, LookaheadStream lookahead, IssueBuilder builder) {
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(matcher.group(4)).setMessage(matcher.group(5)).setSeverity(this.mapPriority(matcher)).buildOptional();
    }

    private Severity mapPriority(Matcher matcher) {
        if (SunCParser.equalsIgnoreCase(matcher.group(3), "warning")) {
            return Severity.WARNING_NORMAL;
        }
        return Severity.WARNING_HIGH;
    }
}

