/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.checkstyle;

import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester3.NodeCreateRule;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class TopicRule
extends NodeCreateRule {
    TopicRule() throws ParserConfigurationException {
        super(1);
    }

    public void end(String namespace, String name) throws TransformerException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Element subsection = (Element)this.getDigester().pop();
        String description = this.extractNodeContent(subsection);
        MethodUtils.invokeExactMethod((Object)this.getDigester().peek(), (String)"setValue", (Object)description);
    }

    @SuppressFBWarnings(value={"SECURITY"})
    private String extractNodeContent(Element subsection) throws TransformerException {
        StringWriter content = new StringWriter();
        Transformer transformer = new SecureXmlParserFactory().createTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(subsection), new StreamResult(content));
        String text = content.toString();
        String prefixRemoved = StringUtils.substringAfter((String)text, (String)">");
        String suffixRemoved = StringUtils.substringBeforeLast((String)prefixRemoved, (String)"<");
        String endSourceRemoved = StringUtils.replace((String)suffixRemoved, (String)"</source>", (String)"</code></pre>");
        return StringUtils.replace((String)endSourceRemoved, (String)"<source>", (String)"<pre><code>");
    }
}

