/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.dry.dupfinder;

import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.dry.AbstractDryParser;
import edu.hm.hafner.analysis.parser.dry.dupfinder.Duplicate;
import edu.hm.hafner.analysis.parser.dry.dupfinder.Fragment;
import edu.hm.hafner.analysis.parser.dry.dupfinder.Range;
import java.util.List;
import org.apache.commons.digester3.Digester;

public class DupFinderParser
extends AbstractDryParser<Duplicate> {
    private static final long serialVersionUID = 1357147358617711901L;

    public DupFinderParser(int highThreshold, int normalThreshold) {
        super(highThreshold, normalThreshold);
    }

    public DupFinderParser() {
        super(50, 25);
    }

    @Override
    protected void configureParser(Digester digester) {
        String duplicationXPath = "*/DuplicatesReport/Duplicates/Duplicate";
        digester.addObjectCreate(duplicationXPath, Duplicate.class);
        digester.addSetProperties(duplicationXPath, "Cost", "cost");
        digester.addSetNext(duplicationXPath, "add");
        String fragmentXPath = duplicationXPath + "/Fragment";
        digester.addObjectCreate(fragmentXPath, Fragment.class);
        digester.addBeanPropertySetter(fragmentXPath + "/FileName", "fileName");
        digester.addBeanPropertySetter(fragmentXPath + "/Text", "text");
        digester.addSetNext(fragmentXPath, "addFragment", Fragment.class.getName());
        String lineRangeXPath = fragmentXPath + "/LineRange";
        digester.addObjectCreate(lineRangeXPath, Range.class);
        digester.addSetProperties(lineRangeXPath, "Start", "start");
        digester.addSetProperties(lineRangeXPath, "End", "end");
        digester.addSetNext(lineRangeXPath, "setLineRange", Range.class.getName());
        String offsetRangeXPath = fragmentXPath + "/OffsetRange";
        digester.addObjectCreate(offsetRangeXPath, Range.class);
        digester.addSetProperties(offsetRangeXPath, "Start", "start");
        digester.addSetProperties(offsetRangeXPath, "End", "end");
        digester.addSetNext(offsetRangeXPath, "setOffsetRange", Range.class.getName());
    }

    @Override
    protected Report convertDuplicationsToIssues(List<Duplicate> duplications, IssueBuilder issueBuilder) {
        Report report = new Report();
        for (Duplicate duplication : duplications) {
            DuplicationGroup group = new DuplicationGroup();
            for (Fragment fragment : duplication.getFragments()) {
                group.setCodeFragment(fragment.getText());
                Range lineRange = fragment.getLineRange();
                int count = lineRange.getEnd() - lineRange.getStart() + 1;
                issueBuilder.setSeverity(this.getPriority(count)).setLineStart(lineRange.getStart()).setLineEnd(lineRange.getEnd()).setFileName(fragment.getFileName()).setType("DupFinder").setAdditionalProperties(group);
                Issue issue = issueBuilder.build();
                group.add(issue);
                report.add(issue);
            }
        }
        return report;
    }
}

