/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.dry.simian;

import edu.hm.hafner.analysis.DuplicationGroup;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.parser.dry.AbstractDryParser;
import edu.hm.hafner.analysis.parser.dry.simian.Block;
import edu.hm.hafner.analysis.parser.dry.simian.Set;
import java.util.List;
import org.apache.commons.digester3.Digester;

public class SimianParser
extends AbstractDryParser<Set> {
    private static final long serialVersionUID = 6507147028628714706L;

    public SimianParser(int highThreshold, int normalThreshold) {
        super(highThreshold, normalThreshold);
    }

    public SimianParser() {
        super(50, 25);
    }

    @Override
    protected void configureParser(Digester digester) {
        String duplicationXPath = "*/simian/check/set";
        digester.addObjectCreate(duplicationXPath, Set.class);
        digester.addSetProperties(duplicationXPath);
        digester.addSetNext(duplicationXPath, "add");
        String fileXPath = duplicationXPath + "/block";
        digester.addObjectCreate(fileXPath, Block.class);
        digester.addSetProperties(fileXPath);
        digester.addSetNext(fileXPath, "addBlock", Block.class.getName());
    }

    @Override
    protected Report convertDuplicationsToIssues(List<Set> duplications, IssueBuilder issueBuilder) {
        Report report = new Report();
        for (Set duplication : duplications) {
            DuplicationGroup group = new DuplicationGroup();
            for (Block file : duplication.getBlocks()) {
                issueBuilder.setSeverity(this.getPriority(duplication.getLineCount())).setLineStart(file.getStartLineNumber()).setLineEnd(file.getEndLineNumber()).setFileName(file.getSourceFile()).setAdditionalProperties(group).setType("Simian");
                Issue issue = issueBuilder.build();
                group.add(issue);
                report.add(issue);
            }
        }
        return report;
    }
}

