/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pvsstudio;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.util.IntegerParser;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

final class AnalyzerType {
    private static final int VIVA64_CCPP_ERRORCODE_BEGIN = 100;
    private static final int VIVA64_CCPP_ERRORCODE_END = 499;
    private static final int GENERAL_CCPP_LOW_ERRORCODE_BEGIN = 500;
    private static final int GENERAL_CCPP_LOW_ERRORCODE_END = 799;
    private static final int OPTIMIZATION_CCPP_ERRORCODE_BEGIN = 800;
    private static final int OPTIMIZATION_CCPP_ERRORCODE_END = 999;
    private static final int GENERAL_CCPP_HIGH_ERRORCODE_BEGIN = 1000;
    private static final int GENERAL_CCPP_HIGH_ERRORCODE_END = 1999;
    private static final int CUSTOMERSPECIFIC_CCPP_ERRORCODE_BEGIN = 2000;
    private static final int CUSTOMERSPECIFIC_CCPP_ERRORCODE_END = 2499;
    private static final int MISRA_CCPP_ERRORCODE_BEGIN = 2500;
    private static final int MISRA_CCPP_ERRORCODE_END = 2999;
    private static final int GENERAL_CS_ERRORCODE_BEGIN = 3000;
    private static final int GENERAL_CS_ERRORCODE_END = 3499;
    private static final int GENERAL_JAVA_ERRORCODE_BEGIN = 6000;
    private static final int GENERAL_JAVA_ERRORCODE_END = 6999;
    static final String VIVA_64_MESSAGE = "64-bit";
    static final String GENERAL_MESSAGE = "General Analysis";
    static final String OPTIMIZATION_MESSAGE = "Micro-optimization";
    static final String CUSTOMER_SPECIFIC_MESSAGE = "Specific Requests";
    static final String MISRA_MESSAGE = "MISRA";
    static final String UNKNOWN_MESSAGE = "Unknown";
    private static final AnalysisType[] ANALYSIS_TYPES = new AnalysisType[]{new Viva64(), new GENERAL(), new OPTIMIZATION(), new CustomerSpecific(), new MISRA()};

    private AnalyzerType() {
    }

    static AnalysisType fromErrorCode(String errorCodeStr) {
        if (IssueParser.equalsIgnoreCase(errorCodeStr, "External")) {
            return new GENERAL();
        }
        int errorCode = IntegerParser.parseInt(errorCodeStr.substring(1));
        return Arrays.stream(ANALYSIS_TYPES).map(type -> type.create(errorCode)).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).findFirst().orElse(new UNKNOWN());
    }

    static final class GENERAL
    implements AnalysisType {
        GENERAL() {
        }

        @Override
        public String getMessage() {
            return AnalyzerType.GENERAL_MESSAGE;
        }

        @Override
        public Optional<AnalysisType> create(int errorCode) {
            if (errorCode >= 500 && errorCode <= 799) {
                return Optional.of(new GENERAL());
            }
            if (errorCode >= 1000 && errorCode <= 1999) {
                return Optional.of(new GENERAL());
            }
            if (errorCode >= 3000 && errorCode <= 3499) {
                return Optional.of(new GENERAL());
            }
            if (errorCode >= 6000 && errorCode <= 6999) {
                return Optional.of(new GENERAL());
            }
            return Optional.empty();
        }
    }

    static interface AnalysisType {
        public String getMessage();

        public Optional<AnalysisType> create(int var1);
    }

    static final class UNKNOWN
    implements AnalysisType {
        UNKNOWN() {
        }

        @Override
        public String getMessage() {
            return AnalyzerType.UNKNOWN_MESSAGE;
        }

        @Override
        public Optional<AnalysisType> create(int errorCode) {
            return Optional.empty();
        }
    }

    static final class Viva64
    implements AnalysisType {
        Viva64() {
        }

        @Override
        public String getMessage() {
            return AnalyzerType.VIVA_64_MESSAGE;
        }

        @Override
        public Optional<AnalysisType> create(int errorCode) {
            if (errorCode >= 100 && errorCode <= 499) {
                return Optional.of(new Viva64());
            }
            return Optional.empty();
        }
    }

    static final class OPTIMIZATION
    implements AnalysisType {
        OPTIMIZATION() {
        }

        @Override
        public String getMessage() {
            return AnalyzerType.OPTIMIZATION_MESSAGE;
        }

        @Override
        public Optional<AnalysisType> create(int errorCode) {
            if (errorCode >= 800 && errorCode <= 999) {
                return Optional.of(new OPTIMIZATION());
            }
            return Optional.empty();
        }
    }

    static final class CustomerSpecific
    implements AnalysisType {
        CustomerSpecific() {
        }

        @Override
        public String getMessage() {
            return AnalyzerType.CUSTOMER_SPECIFIC_MESSAGE;
        }

        @Override
        public Optional<AnalysisType> create(int errorCode) {
            if (errorCode >= 2000 && errorCode <= 2499) {
                return Optional.of(new CustomerSpecific());
            }
            return Optional.empty();
        }
    }

    static final class MISRA
    implements AnalysisType {
        MISRA() {
        }

        @Override
        public String getMessage() {
            return AnalyzerType.MISRA_MESSAGE;
        }

        @Override
        public Optional<AnalysisType> create(int errorCode) {
            if (errorCode >= 2500 && errorCode <= 2999) {
                return Optional.of(new MISRA());
            }
            return Optional.empty();
        }
    }
}

