/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser.pvsstudio;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.parser.pvsstudio.PVSStudioParser;
import edu.hm.hafner.analysis.util.IntegerParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class PlogMessage {
    private String file = "";
    private int lineNumber = 0;
    private String errorCode = "";
    private String message = "";
    private String level = "";
    private static int failWarningsCount = 0;
    private static int falseAlarmCount = 0;

    PlogMessage() {
    }

    public String getHash() {
        return this.errorCode + this.message + this.file + this.lineNumber;
    }

    public String toString() {
        return this.message;
    }

    String getFilePath() {
        return this.file;
    }

    public int getLine() {
        return this.lineNumber;
    }

    public String getType() {
        return this.errorCode;
    }

    public String getLevel() {
        return this.level;
    }

    private static boolean skipMessage(NodeList elements) {
        return elements != null && elements.item(0) != null && IssueParser.equalsIgnoreCase(elements.item(0).getTextContent(), "true");
    }

    private static boolean nodeNotNull(NodeList elements) {
        return elements != null && elements.item(0) != null && elements.item(0).getTextContent() != null;
    }

    private static boolean errorCodeIsValid(String errorCode) {
        return !errorCode.isEmpty() && errorCode.charAt(0) == 'V';
    }

    private static void processNode(List<PlogMessage> plogMessages, Node node) {
        Element eElement = (Element)node;
        NodeList nodeFalseAlarm = eElement.getElementsByTagName("FalseAlarm");
        if (PlogMessage.skipMessage(nodeFalseAlarm)) {
            ++falseAlarmCount;
            return;
        }
        NodeList nodeFile = eElement.getElementsByTagName("File");
        PlogMessage msg = new PlogMessage();
        if (PlogMessage.nodeNotNull(nodeFile)) {
            msg.file = nodeFile.item(0).getTextContent().trim();
        }
        if (msg.file.isEmpty()) {
            ++failWarningsCount;
            return;
        }
        NodeList nodeErrorCode = eElement.getElementsByTagName("ErrorCode");
        if (PlogMessage.nodeNotNull(nodeErrorCode)) {
            msg.errorCode = nodeErrorCode.item(0).getTextContent().trim();
        }
        if (!PlogMessage.errorCodeIsValid(msg.errorCode)) {
            ++failWarningsCount;
            return;
        }
        msg.message = "<a target=\"_blank\" href=\"https://pvs-studio.com/en/docs/warnings/" + msg.errorCode.toLowerCase(Locale.ENGLISH) + "/\">" + msg.errorCode + "</a> " + eElement.getElementsByTagName("Message").item(0).getTextContent();
        msg.level = eElement.getElementsByTagName("Level").item(0).getTextContent();
        msg.lineNumber = IntegerParser.parseInt(eElement.getElementsByTagName("Line").item(0).getTextContent());
        if (msg.lineNumber <= 0) {
            ++failWarningsCount;
            return;
        }
        plogMessages.add(msg);
    }

    static List<PlogMessage> getMessagesFromReport(ReaderFactory readerFactory) {
        Document plogDoc = readerFactory.readDocument();
        plogDoc.getDocumentElement().normalize();
        NodeList nList = plogDoc.getElementsByTagName("PVS-Studio_Analysis_Log");
        falseAlarmCount = 0;
        failWarningsCount = 0;
        ArrayList<PlogMessage> plogMessages = new ArrayList<PlogMessage>();
        for (int nodeCount = 0; nodeCount < nList.getLength(); ++nodeCount) {
            Node nNode = nList.item(nodeCount);
            if (nNode.getNodeType() != 1) continue;
            PlogMessage.processNode(plogMessages, nNode);
        }
        if (plogMessages.size() + falseAlarmCount == 0 && failWarningsCount > 0) {
            Logger.getLogger(PVSStudioParser.class.getName()).log(Level.SEVERE, "No messages were parsed!");
        }
        return plogMessages;
    }
}

