/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.ssa.ComponentVisitor;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.trans.NodeComparator;
import EDU.purdue.cs.bloat.trans.ValueFolder;
import EDU.purdue.cs.bloat.trans.ValueFolding;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.MemRefExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ValueNumbering {
    public static boolean DEBUG = false;
    SSAGraph ssaGraph;
    HashMap tuples;
    ValueFolder folder;
    int next;
    public String debugDirName = "debug";
    public File debugDir;
    public boolean DUMP = false;
    private PrintWriter dump = new PrintWriter(System.out);

    public void transform(FlowGraph cfg) {
        if (this.DUMP || ValueFolding.DUMP) {
            String className = cfg.method().declaringClass().type().className();
            String methodName = cfg.method().name();
            String dirName = String.valueOf(this.debugDirName) + File.separator + className + File.separator + methodName;
            this.debugDir = new File(dirName);
            int nextDir = 1;
            while (this.debugDir.exists()) {
                this.debugDir = new File(String.valueOf(dirName) + "_" + nextDir);
                ++nextDir;
            }
            if (!this.debugDir.exists()) {
                this.debugDir.mkdirs();
            }
            try {
                File dumpFile = new File(this.debugDir, "vn_dump");
                this.dump = new PrintWriter((Writer)new FileWriter(dumpFile), true);
            }
            catch (IOException ex) {
                System.err.println(ex.toString());
            }
        }
        this.ssaGraph = new SSAGraph(cfg);
        this.tuples = new HashMap();
        this.folder = new ValueFolder(false, cfg.method().declaringClass().context());
        this.next = 0;
        final HashMap valid = new HashMap();
        final HashMap optimistic = new HashMap();
        this.ssaGraph.visitComponents(new ComponentVisitor(){

            public void visitComponent(List scc) {
                if (DEBUG || ValueNumbering.this.DUMP) {
                    ValueNumbering.this.dump.println("\nNumbering SCC = " + scc);
                }
                Iterator e = scc.iterator();
                while (e.hasNext()) {
                    Node node = (Node)e.next();
                    node.setValueNumber(-1);
                }
                if (scc.size() > 1) {
                    if (DEBUG || ValueNumbering.this.DUMP) {
                        ValueNumbering.this.dump.println("Optimistic-----------------------");
                    }
                    boolean changed = true;
                    while (changed) {
                        changed = false;
                        Iterator iter = scc.iterator();
                        while (iter.hasNext()) {
                            Node node = (Node)iter.next();
                            if (!ValueNumbering.this.valnum(node, optimistic)) continue;
                            changed = true;
                        }
                    }
                }
                if (DEBUG || ValueNumbering.this.DUMP) {
                    ValueNumbering.this.dump.println("Valid--------------------------------");
                }
                Iterator iter = scc.iterator();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    ValueNumbering.this.valnum(node, valid);
                }
            }
        });
        if (DEBUG || this.DUMP) {
            this.dump.println("Final value numbers--------------------------");
            this.printValueNumbers(cfg, new PrintWriter(this.dump));
        }
        if (this.DUMP) {
            System.out.println("    Dumping to: " + this.debugDir);
            try {
                File valueNumbers = new File(this.debugDir, "scc.txt");
                this.ssaGraph.printSCCs(new PrintWriter(new FileWriter(valueNumbers)));
            }
            catch (IOException ex) {
                System.err.println("IOException: " + ex);
            }
        }
        this.ssaGraph = null;
        this.tuples = null;
        this.folder.cleanup();
        this.folder = null;
        cfg.visit(new TreeVisitor(){

            public void visitTree(Tree tree) {
                tree.visitChildren(this);
            }

            public void visitNode(Node node) {
                node.visitChildren(this);
                Assert.isTrue(node.valueNumber() != -1, "No value number for " + node);
            }
        });
    }

    private void printValueNumbers(FlowGraph cfg, final PrintWriter pw) {
        cfg.visit(new TreeVisitor(){

            public void visitTree(Tree tree) {
                tree.visitChildren(this);
            }

            public void visitNode(Node node) {
                node.visitChildren(this);
                pw.println("VN[" + node + " " + System.identityHashCode(node) + "] = " + node.valueNumber());
            }
        });
    }

    private Node simplify(Node node) {
        ConstantExpr value;
        int v;
        if (DEBUG || this.DUMP) {
            this.dump.println("folding " + node + " in " + node.parent());
        }
        if ((v = node.valueNumber()) == -1) {
            return node;
        }
        if (node instanceof ConstantExpr) {
            this.folder.values.ensureSize(v + 1);
            this.folder.values.set(v, node);
            return node;
        }
        if (v < this.folder.values.size() && (value = (ConstantExpr)this.folder.values.get(v)) != null) {
            return value;
        }
        this.folder.node = null;
        node.visit(this.folder);
        if (DEBUG || this.DUMP) {
            this.dump.println("folded " + node + " to " + this.folder.node);
        }
        if (this.folder.node == null) {
            return node;
        }
        if (this.folder.node instanceof ConstantExpr) {
            this.folder.values.ensureSize(v + 1);
            this.folder.values.set(v, this.folder.node);
        }
        return this.folder.node;
    }

    private boolean valnum(Node node, HashMap table) {
        boolean changed = false;
        Tuple tuple = (Tuple)this.tuples.get(node);
        if (tuple == null) {
            Node s = this.simplify(node);
            tuple = new Tuple(s);
            this.tuples.put(node, tuple);
            if (DEBUG || this.DUMP) {
                this.dump.println("  New tuple " + tuple);
            }
        } else if (this.DUMP) {
            this.dump.println("  " + node + " mapped to tuple " + tuple);
        }
        Node w = (Node)table.get(tuple);
        if (DEBUG || this.DUMP) {
            this.dump.println("  Looking up " + tuple);
            this.dump.println("    " + tuple + " mapped to node " + w + (w != null ? " (VN = " + w.valueNumber() + ")" : ""));
        }
        int value = -1;
        if (w != null && w.valueNumber() != -1) {
            value = w.valueNumber();
        } else {
            if (DEBUG || this.DUMP) {
                this.dump.println("    New value number " + this.next);
            }
            value = this.next++;
        }
        Assert.isTrue(value != -1);
        Iterator iter = this.ssaGraph.equivalent(node).iterator();
        while (iter.hasNext()) {
            Node v = (Node)iter.next();
            Tuple t = (Tuple)this.tuples.get(v);
            if (t == null || v.valueNumber() == value) continue;
            v.setValueNumber(value);
            table.put(t, v);
            if (DEBUG || this.DUMP) {
                this.dump.println("    Assigning value number " + v.valueNumber() + " to " + v);
                this.dump.println("    Mapping tuple " + t + " to node " + v);
            }
            changed = true;
        }
        return changed;
    }

    class Tuple {
        Node node;
        int hash;

        public Tuple(Node node) {
            this.node = node;
            List children = ValueNumbering.this.ssaGraph.children(node);
            this.hash = NodeComparator.hashCode(node) + children.size();
        }

        public String toString() {
            List children = ValueNumbering.this.ssaGraph.children(this.node);
            String s = "<" + this.node + ", hash=" + this.hash;
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Node child = (Node)iter.next();
                s = String.valueOf(s) + ", " + child + "{" + child.valueNumber() + "}";
            }
            s = String.valueOf(s) + ">";
            return s;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Tuple) {
                Tuple t = (Tuple)obj;
                if (this.node == t.node) {
                    return true;
                }
                if (this.node instanceof MemRefExpr || t.node instanceof MemRefExpr) {
                    return false;
                }
                if (!NodeComparator.equals(this.node, t.node)) {
                    return false;
                }
                List children1 = ValueNumbering.this.ssaGraph.children(this.node);
                List children2 = ValueNumbering.this.ssaGraph.children(t.node);
                if (children1.size() != children2.size()) {
                    return false;
                }
                if (this.node instanceof PhiStmt) {
                    int v;
                    Node child;
                    int[] used = new int[ValueNumbering.this.next];
                    int free = 0;
                    Iterator iter = children1.iterator();
                    while (iter.hasNext()) {
                        child = (Node)iter.next();
                        v = child.valueNumber();
                        if (v != -1) {
                            int n = v;
                            used[n] = used[n] + 1;
                            continue;
                        }
                        ++free;
                    }
                    iter = children2.iterator();
                    while (iter.hasNext()) {
                        child = (Node)iter.next();
                        v = child.valueNumber();
                        if (v != -1) {
                            if (used[v] != 0) {
                                int n = v;
                                used[n] = used[n] - 1;
                                continue;
                            }
                            --free;
                            continue;
                        }
                        --free;
                    }
                    return free >= 0;
                }
                Iterator iter1 = children1.iterator();
                Iterator iter2 = children2.iterator();
                while (iter1.hasNext() && iter2.hasNext()) {
                    Node child1 = (Node)iter1.next();
                    Node child2 = (Node)iter2.next();
                    int v1 = child1.valueNumber();
                    int v2 = child2.valueNumber();
                    if (v1 == -1 || v2 == -1 || v1 == v2) continue;
                    return false;
                }
                return !iter1.hasNext() && !iter2.hasNext();
            }
            return false;
        }
    }
}

