/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.point.writer.CFPointWriter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class WriterCFProfileCollection
extends CFPointWriter {
    private static final String profileDimName = "profile";
    private static final String idName = "profileId";
    private static final String profileIndexName = "profileIndex";
    private static final boolean debug = false;
    private int name_strlen = 1;
    private Variable id;
    private Variable index;
    private Variable time;
    private Variable record;
    private HashMap<String, Integer> profileMap;
    private int recno = 0;
    private ArrayDouble.D1 timeArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 latArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 lonArray = new ArrayDouble.D1(1);
    private ArrayDouble.D1 altArray = new ArrayDouble.D1(1);
    private ArrayInt.D1 parentArray = new ArrayInt.D1(1);
    private int[] origin = new int[1];

    public WriterCFProfileCollection(String fileOut, List<Attribute> atts, NetcdfFileWriter.Version version) throws IOException {
        super(fileOut, atts, version);
        this.writer.addGroupAttribute(null, new Attribute("featureType", CF.FeatureType.profile.name()));
    }

    public void writeHeader(List<String> profileNames, List<VariableSimpleIF> dataVars, DateUnit timeUnit, String altUnits) throws IOException {
        this.altUnits = altUnits;
        this.createProfiles(profileNames);
        this.createObsVariables(timeUnit);
        this.createDataVariables(dataVars);
        this.writer.create();
        this.record = this.writer.addRecordStructure();
        this.writeProfileData(profileNames);
    }

    private void createProfiles(List<String> profileNames) throws IOException {
        int nprofiles = profileNames.size();
        for (String name : profileNames) {
            this.name_strlen = Math.max(this.name_strlen, name.length());
        }
        this.writer.addUnlimitedDimension("obs");
        ArrayList<Dimension> profileDims = new ArrayList<Dimension>(1);
        Dimension profileDim = this.writer.addDimension(null, profileDimName, nprofiles);
        profileDims.add(profileDim);
        this.id = this.writer.addStringVariable(null, idName, profileDims, this.name_strlen);
        this.writer.addVariableAttribute(this.id, new Attribute("long_name", "profile identifier"));
        this.writer.addVariableAttribute(this.id, new Attribute("cf_role", "profile_id"));
        Variable lat = this.writer.addVariable(null, "latitude", DataType.DOUBLE, profileDimName);
        this.writer.addVariableAttribute(lat, new Attribute("units", "degrees_north"));
        this.writer.addVariableAttribute(lat, new Attribute("long_name", "profile latitude"));
        Variable lon = this.writer.addVariable(null, "longitude", DataType.DOUBLE, profileDimName);
        this.writer.addVariableAttribute(lon, new Attribute("units", "degrees_east"));
        this.writer.addVariableAttribute(lon, new Attribute("long_name", "profile longitude"));
        if (this.altUnits != null) {
            Variable alt = this.writer.addVariable(null, "altitude", DataType.DOUBLE, profileDimName);
            this.writer.addVariableAttribute(alt, new Attribute("units", this.altUnits));
            this.writer.addVariableAttribute(alt, new Attribute("long_name", "profile altitude"));
        }
    }

    private void createObsVariables(DateUnit timeUnit) throws IOException {
        this.time = this.writer.addVariable(null, "time", DataType.DOUBLE, "obs");
        this.writer.addVariableAttribute(this.time, new Attribute("units", timeUnit.getUnitsString()));
        this.writer.addVariableAttribute(this.time, new Attribute("long_name", "time of measurement"));
        this.index = this.writer.addVariable(null, profileIndexName, DataType.INT, "obs");
        this.writer.addVariableAttribute(this.index, new Attribute("long_name", "profile index for this observation record"));
        this.writer.addVariableAttribute(this.index, new Attribute("instance_dimension", profileDimName));
    }

    private void createDataVariables(List<VariableSimpleIF> dataVars) throws IOException {
        String coordNames = "latitude longitude time";
        if (this.altUnits != null) {
            coordNames = coordNames + " altitude";
        }
        ArrayList<VariableSimpleIF> useDataVars = new ArrayList<VariableSimpleIF>(dataVars.size());
        for (VariableSimpleIF var : dataVars) {
            if (this.writer.findVariable(var.getShortName()) != null) continue;
            useDataVars.add(var);
        }
        for (VariableSimpleIF oldVar : useDataVars) {
            Variable newVar = this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), "obs");
            List<Attribute> atts = oldVar.getAttributes();
            for (Attribute att : atts) {
                newVar.addAttribute(att);
            }
            newVar.addAttribute(new Attribute("coordinates", coordNames));
        }
    }

    private void writeProfileData(List<String> profiles) throws IOException {
        int nprofiles = profiles.size();
        this.profileMap = new HashMap(2 * nprofiles);
        ArrayObject.D1 idArray = new ArrayObject.D1(String.class, nprofiles);
        for (int i = 0; i < profiles.size(); ++i) {
            String name = profiles.get(i);
            this.profileMap.put(name, i);
            idArray.set(i, name);
        }
        try {
            this.writer.writeStringData(this.id, idArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public void writeRecord(String profileName, PointFeature sobs, StructureData sdata) throws IOException {
        this.writeRecord(profileName, sobs.getObservationTime(), sobs.getObservationTimeAsCalendarDate(), sobs.getLocation(), sdata);
    }

    public void writeRecord(String profileName, double timeCoordValue, CalendarDate obsDate, EarthLocation loc, StructureData sdata) throws IOException {
        this.trackBB(loc, obsDate);
        Integer parentIndex = this.profileMap.get(profileName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find profile " + profileName);
        }
        int[] parentIndexArr = new int[]{parentIndex};
        ArrayStructureW sArray = new ArrayStructureW(sdata.getStructureMembers(), new int[]{1});
        sArray.setStructureData(sdata, 0);
        this.latArray.set(0, loc.getLatitude());
        this.lonArray.set(0, loc.getLongitude());
        this.altArray.set(0, loc.getAltitude());
        this.parentArray.set(0, (int)parentIndex);
        this.origin[0] = this.recno;
        try {
            if (this.record == null) {
                StructureMembers sm = sdata.getStructureMembers();
                for (StructureMembers.Member m : sm.getMembers()) {
                    Array tmpArray;
                    Number data;
                    Variable v = this.writer.findVariable(m.getName());
                    if (v == null || v.getShortName().equals("longitude") || v.getShortName().equals("latitude")) continue;
                    DataType v_dt = v.getDataType();
                    DataType m_dt = m.getDataType();
                    if (m_dt == DataType.DOUBLE) {
                        data = m.getDataArray().getDouble(0);
                        tmpArray = new ArrayDouble.D1(1);
                        ((ArrayDouble)tmpArray).setDouble(0, ((Double)data).doubleValue());
                        this.writer.write(this.writer.findVariable(m.getName()), this.origin, tmpArray);
                    }
                    if (m_dt != DataType.FLOAT) continue;
                    data = Float.valueOf(m.getDataArray().getFloat(0));
                    tmpArray = new ArrayFloat.D1(1);
                    ((ArrayFloat)tmpArray).setFloat(0, ((Float)data).floatValue());
                    this.writer.write(this.writer.findVariable(m.getName()), this.origin, tmpArray);
                }
            } else {
                this.writer.write(this.record, this.origin, sArray);
            }
            this.writer.write(this.index, this.origin, this.parentArray);
            this.writer.write(this.writer.findVariable("latitude"), parentIndexArr, this.latArray);
            this.writer.write(this.writer.findVariable("longitude"), parentIndexArr, this.lonArray);
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
        ++this.recno;
    }
}

