/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pkcs;

import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.MD2;
import edu.vt.middleware.crypt.digest.MD5;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.symmetric.AlgorithmSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PBES1Algorithm {
    PbeWithMD2AndDES_CBC("1.2.840.113549.1.5.1", new AlgorithmSpec("DES", "CBC", "PKCS5Padding"), new MD2()),
    PbeWithMD2AndRC2_CBC("1.2.840.113549.1.5.4", new AlgorithmSpec("RC2", "CBC", "PKCS5Padding"), new MD2()),
    PbeWithMD5AndDES_CBC("1.2.840.113549.1.5.3", new AlgorithmSpec("DES", "CBC", "PKCS5Padding"), new MD5()),
    PbeWithMD5AndRC2_CBC("1.2.840.113549.1.5.6", new AlgorithmSpec("RC2", "CBC", "PKCS5Padding"), new MD5()),
    PbeWithSHA1AndDES_CBC("1.2.840.113549.1.5.10", new AlgorithmSpec("DES", "CBC", "PKCS5Padding"), new SHA1()),
    PbeWithSHA1AndRC2_CBC("1.2.840.113549.1.5.11", new AlgorithmSpec("RC2", "CBC", "PKCS5Padding"), new SHA1());

    private String oid;
    private AlgorithmSpec spec;
    private DigestAlgorithm digest;

    private PBES1Algorithm(String id, AlgorithmSpec cipherSpec, DigestAlgorithm prf) {
        this.oid = id;
        this.spec = cipherSpec;
        this.digest = prf;
    }

    public static PBES1Algorithm fromOid(String oid) {
        for (PBES1Algorithm a : PBES1Algorithm.values()) {
            if (!a.getOid().equals(oid)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unknown PBES1Algorithm for OID " + oid);
    }

    public String getOid() {
        return this.oid;
    }

    public AlgorithmSpec getSpec() {
        return this.spec;
    }

    public DigestAlgorithm getDigest() {
        return this.digest;
    }
}

