/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.AbstractCli;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.io.Base64FilterInputStream;
import edu.vt.middleware.crypt.io.HexFilterInputStream;
import edu.vt.middleware.crypt.signature.SignatureAlgorithm;
import edu.vt.middleware.crypt.util.AbstractEncodingConverter;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.CryptReader;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class SignatureCli
extends AbstractCli {
    protected static final String OPT_ALG = "alg";
    protected static final String OPT_ENCODING = "encoding";
    protected static final String OPT_DIGEST = "digest";
    protected static final String OPT_KEY = "key";
    protected static final String OPT_SIGN = "sign";
    protected static final String OPT_VERIFY = "verify";
    private static final String COMMAND_NAME = "sign";

    public static void main(String[] args) {
        new SignatureCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions();
        Option alg = new Option(OPT_ALG, true, "signature algorithm; either DSA or RSA");
        alg.setArgName("name");
        alg.setOptionalArg(false);
        Option key = new Option(OPT_KEY, true, "DER-encoded PKCS#8 private key for signing or X.509 cert/public key for verification");
        key.setArgName("filepath");
        key.setOptionalArg(false);
        Option infile = new Option("in", true, "file to sign/verify; defaults to STDIN");
        infile.setArgName("filepath");
        infile.setOptionalArg(false);
        Option digest = new Option(OPT_DIGEST, true, "message digest algorithm used to produce encoded message to sign");
        digest.setArgName("algname");
        digest.setOptionalArg(false);
        Option encoding = new Option(OPT_ENCODING, true, "signature encoding format, either base64 or hex");
        encoding.setArgName("format");
        encoding.setOptionalArg(false);
        Option verify = new Option(OPT_VERIFY, true, "verify signature in given file; signature encoding determined by -encoding option");
        encoding.setArgName("sigfilepath");
        encoding.setOptionalArg(false);
        this.options.addOption(alg);
        this.options.addOption(key);
        this.options.addOption(infile);
        this.options.addOption(digest);
        this.options.addOption(encoding);
        this.options.addOption(verify);
        this.options.addOption(new Option("sign", "perform sign operation"));
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption("sign")) {
            this.sign(line);
        } else if (line.hasOption(OPT_VERIFY)) {
            this.verify(line);
        } else {
            this.printHelp();
        }
    }

    protected String getCommandName() {
        return "sign";
    }

    protected SignatureAlgorithm newInstance(CommandLine line) {
        SignatureAlgorithm sig = null;
        sig = line.hasOption(OPT_DIGEST) ? SignatureAlgorithm.newInstance(line.getOptionValue(OPT_ALG), line.getOptionValue(OPT_DIGEST)) : SignatureAlgorithm.newInstance(line.getOptionValue(OPT_ALG));
        return sig;
    }

    protected void sign(CommandLine line) throws Exception {
        this.validateOptions(line);
        SignatureAlgorithm sig = this.newInstance(line);
        File keyFile = new File(line.getOptionValue(OPT_KEY));
        System.err.println("Reading private key from " + keyFile);
        sig.setSignKey(this.readPrivateKey(line));
        sig.initSign();
        InputStream in = this.getInputStream(line);
        byte[] sigBytes = sig.sign(this.getInputStream(line));
        this.closeStream(in);
        if (line.hasOption(OPT_ENCODING)) {
            String encName = line.getOptionValue(OPT_ENCODING);
            AbstractEncodingConverter conv = null;
            if ("base64".equals(encName)) {
                conv = new Base64Converter();
            } else if ("hex".equals(encName)) {
                conv = new HexConverter();
            } else {
                throw new IllegalArgumentException("Unknown encoding.");
            }
            System.out.println(conv.fromBytes(sigBytes));
        } else {
            System.out.print(sigBytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verify(CommandLine line) throws Exception {
        this.validateOptions(line);
        InputStream in = this.getInputStream(line);
        SignatureAlgorithm sig = this.newInstance(line);
        sig.setVerifyKey(this.readPublicKey(line));
        sig.initVerify();
        boolean isVerified = false;
        try {
            isVerified = sig.verify(in, this.readSignature(line));
        }
        finally {
            this.closeStream(in);
        }
        if (isVerified) {
            System.out.println("SUCCESS -- signature verified.");
        } else {
            System.out.println("FAILURE -- signature does not match.");
        }
    }

    protected PublicKey readPublicKey(CommandLine line) throws Exception {
        PublicKey key = null;
        File keyFile = new File(line.getOptionValue(OPT_KEY));
        System.err.println("Reading public key from " + keyFile);
        try {
            key = CryptReader.readCertificate(keyFile).getPublicKey();
        }
        catch (Exception e) {
            key = CryptReader.readPublicKey(keyFile);
        }
        return key;
    }

    protected PrivateKey readPrivateKey(CommandLine line) throws CryptException, IOException {
        File keyFile = new File(line.getOptionValue(OPT_KEY));
        return CryptReader.readPrivateKey(keyFile);
    }

    protected byte[] readSignature(CommandLine line) throws IOException {
        InputStream in = this.getInputStream(line, OPT_VERIFY);
        if (line.hasOption(OPT_ENCODING)) {
            String encName = line.getOptionValue(OPT_ENCODING);
            if ("base64".equals(encName)) {
                in = new Base64FilterInputStream(in);
            } else if ("hex".equals(encName)) {
                in = new HexFilterInputStream(in);
            } else {
                throw new IllegalArgumentException("Unknown encoding.");
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int bufSize = 1024;
        byte[] buffer = new byte[1024];
        int count = 0;
        while ((count = in.read(buffer)) > 0) {
            os.write(buffer, 0, count);
        }
        return os.toByteArray();
    }

    protected void validateOptions(CommandLine line) {
        if (!line.hasOption(OPT_ALG)) {
            throw new IllegalArgumentException("alg option is required.");
        }
        if (!line.hasOption(OPT_KEY)) {
            throw new IllegalArgumentException("key option is required.");
        }
    }
}

