/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.symmetric;

import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class RC2
extends SymmetricAlgorithm {
    public static final String ALGORITHM = "RC2";
    private static final int[] EFFECTIVE_BITS_TO_VERSION = new int[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
    private static final int[] VERSION_TO_EFFECTIVE_BITS = new int[256];
    private int effectiveKeyBits = -1;

    public RC2() {
        this("CBC", "PKCS5Padding");
    }

    public RC2(String mode, String padding) {
        super(ALGORITHM, mode, padding);
    }

    public static int getEffectiveBits(int version) {
        if (version >= 256) {
            return version;
        }
        return VERSION_TO_EFFECTIVE_BITS[version];
    }

    public static int getVersion(int effectiveBits) {
        if (effectiveBits >= 256) {
            return effectiveBits;
        }
        return EFFECTIVE_BITS_TO_VERSION[effectiveBits];
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public void setEffectiveKeyBits(int numBits) {
        if (numBits < 1) {
            throw new IllegalArgumentException("EffectiveKeyBits must be positive integer.");
        }
        this.effectiveKeyBits = numBits;
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        AlgorithmParameterSpec spec;
        if (this.paramSpec != null) {
            spec = this.paramSpec;
        } else {
            int effective = this.effectiveKeyBits < 0 ? this.key.getEncoded().length * 8 : this.effectiveKeyBits;
            spec = this.iv != null ? new RC2ParameterSpec(effective, this.iv) : new RC2ParameterSpec(effective);
        }
        return spec;
    }

    static {
        for (int i = 0; i < EFFECTIVE_BITS_TO_VERSION.length; ++i) {
            RC2.VERSION_TO_EFFECTIVE_BITS[RC2.EFFECTIVE_BITS_TO_VERSION[i]] = i;
        }
    }
}

