/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.symmetric;

import edu.vt.middleware.crypt.AbstractEncryptionCli;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.pbe.AbstractEncryptionScheme;
import edu.vt.middleware.crypt.pbe.EncryptionScheme;
import edu.vt.middleware.crypt.pbe.OpenSSLEncryptionScheme;
import edu.vt.middleware.crypt.pbe.OpenSSLKeyGenerator;
import edu.vt.middleware.crypt.pbe.PBES1EncryptionScheme;
import edu.vt.middleware.crypt.pbe.PBES2EncryptionScheme;
import edu.vt.middleware.crypt.pbe.PBKDF1KeyGenerator;
import edu.vt.middleware.crypt.pbe.PBKDF2KeyGenerator;
import edu.vt.middleware.crypt.pbe.PKCS12EncryptionScheme;
import edu.vt.middleware.crypt.pbe.PKCS12KeyGenerator;
import edu.vt.middleware.crypt.pkcs.PBEParameter;
import edu.vt.middleware.crypt.pkcs.PBKDF2Parameters;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import edu.vt.middleware.crypt.util.CryptReader;
import edu.vt.middleware.crypt.util.CryptWriter;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class SymmetricCli
extends AbstractEncryptionCli {
    protected static final String OPT_MODE = "mode";
    protected static final String OPT_PADDING = "padding";
    protected static final String OPT_IV = "iv";
    protected static final String OPT_KEY = "key";
    protected static final String OPT_KEYSIZE = "keysize";
    protected static final String OPT_PBE = "pbe";
    protected static final String OPT_SCHEME = "scheme";
    protected static final String OPT_DIGEST = "digest";
    protected static final String OPT_SALT = "salt";
    protected static final String OPT_ITERATIONS = "iter";
    protected static final String OPT_GENKEY = "genkey";
    private static final String COMMAND_NAME = "enc";
    private HexConverter hexConv = new HexConverter();

    public static void main(String[] args) {
        new SymmetricCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions();
        Option mode = new Option(OPT_MODE, true, "cipher mode, e.g. CBC");
        mode.setArgName("name");
        mode.setOptionalArg(false);
        Option padding = new Option(OPT_PADDING, true, "cipher padding strategy, e.g. PKCS5Padding");
        padding.setArgName(OPT_PADDING);
        padding.setOptionalArg(false);
        Option key = new Option(OPT_KEY, true, "encryption/decryption key");
        key.setArgName("filepath");
        key.setOptionalArg(false);
        Option keySize = new Option(OPT_KEYSIZE, true, "key size in bits; only needed if -key option is not specified");
        keySize.setArgName("bits");
        keySize.setOptionalArg(false);
        Option iv = new Option(OPT_IV, true, "initialization vectory in hex");
        iv.setArgName("hex_iv");
        iv.setOptionalArg(false);
        Option pbe = new Option(OPT_PBE, true, "generate PBE key from password/phrase; uses pkcs5s2 by default");
        pbe.setArgName("password");
        pbe.setOptionalArg(false);
        Option pbeScheme = new Option(OPT_SCHEME, true, "PBE key generation mode; one of pkcs5s1, pkcs5s2, openssl, pkcs12");
        pbeScheme.setArgName("name");
        pbeScheme.setOptionalArg(false);
        Option pbeDigest = new Option(OPT_DIGEST, true, "digest algorithm to use with PBE mode pkcs5s1 or pkcs12");
        pbeDigest.setArgName("name");
        pbeDigest.setOptionalArg(false);
        Option salt = new Option(OPT_SALT, true, "salt for PBE key generation in hex");
        salt.setArgName("hex_salt");
        salt.setOptionalArg(false);
        Option iterations = new Option(OPT_ITERATIONS, true, "iteration count for PBE key generation");
        salt.setArgName("count");
        salt.setOptionalArg(false);
        this.options.addOption(mode);
        this.options.addOption(padding);
        this.options.addOption(key);
        this.options.addOption(keySize);
        this.options.addOption(iv);
        this.options.addOption(pbe);
        this.options.addOption(pbeScheme);
        this.options.addOption(pbeDigest);
        this.options.addOption(salt);
        this.options.addOption(iterations);
        this.options.addOption(new Option(OPT_GENKEY, "generate new encryption key"));
        this.options.addOption(new Option("encrypt", "perform encryption"));
        this.options.addOption(new Option("decrypt", "perform decryption"));
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption("encrypt")) {
            this.encrypt(line);
        } else if (line.hasOption("decrypt")) {
            this.decrypt(line);
        } else if (line.hasOption(OPT_GENKEY)) {
            this.genKey(line);
        } else {
            this.printHelp();
        }
    }

    protected SymmetricAlgorithm newAlgorithm(CommandLine line) {
        String algName = line.getOptionValue("cipher");
        SymmetricAlgorithm algorithm = null;
        algorithm = line.hasOption(OPT_MODE) ? (line.hasOption(OPT_PADDING) ? SymmetricAlgorithm.newInstance(algName, line.getOptionValue(OPT_MODE), line.getOptionValue(OPT_PADDING)) : SymmetricAlgorithm.newInstance(algName, line.getOptionValue(OPT_MODE), "PKCS5Padding")) : (line.hasOption(OPT_PADDING) ? SymmetricAlgorithm.newInstance(algName, "CBC", line.getOptionValue(OPT_PADDING)) : SymmetricAlgorithm.newInstance(algName));
        return algorithm;
    }

    protected String getCommandName() {
        return COMMAND_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encrypt(CommandLine line) throws Exception {
        this.validateOptions(line);
        SymmetricAlgorithm alg = this.newAlgorithm(line);
        if (line.hasOption(OPT_KEY)) {
            alg.setKey(this.readKey(line));
            if (line.hasOption(OPT_IV)) {
                alg.setIV(this.hexConv.toBytes(line.getOptionValue(OPT_IV)));
            }
            this.encrypt(alg, this.getInputStream(line), this.getOutputStream(line));
        } else if (line.hasOption(OPT_PBE)) {
            InputStream in = this.getInputStream(line);
            OutputStream out = this.getOutputStream(line);
            try {
                this.getPBEScheme(alg, line).encrypt(line.getOptionValue(OPT_PBE).toCharArray(), in, out);
            }
            finally {
                this.closeStream(in);
                this.closeStream(out);
            }
        } else {
            throw new IllegalArgumentException("Either -key or -pbe is required for encryption or decryption.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrypt(CommandLine line) throws Exception {
        this.validateOptions(line);
        SymmetricAlgorithm alg = this.newAlgorithm(line);
        if (line.hasOption(OPT_KEY)) {
            alg.setKey(this.readKey(line));
            if (line.hasOption(OPT_IV)) {
                alg.setIV(this.hexConv.toBytes(line.getOptionValue(OPT_IV)));
            }
            this.decrypt(alg, this.getInputStream(line), this.getOutputStream(line));
        } else if (line.hasOption(OPT_PBE)) {
            InputStream in = this.getInputStream(line);
            OutputStream out = this.getOutputStream(line);
            try {
                this.getPBEScheme(alg, line).decrypt(line.getOptionValue(OPT_PBE).toCharArray(), in, out);
            }
            finally {
                this.closeStream(in);
                this.closeStream(out);
            }
        } else {
            throw new IllegalArgumentException("Either -key or -pbe is required for encryption or decryption.");
        }
    }

    protected void genKey(CommandLine line) throws Exception {
        this.validateOptions(line);
        SymmetricAlgorithm alg = this.newAlgorithm(line);
        SecretKey key = null;
        if (line.hasOption(OPT_PBE)) {
            key = this.generatePBEKey(alg, line);
        } else if (line.hasOption(OPT_KEYSIZE)) {
            int size = Integer.parseInt(line.getOptionValue(OPT_KEYSIZE));
            System.err.println("Generating key of size " + size);
            key = alg.generateKey(size);
        } else {
            System.err.println("Generating key of default size for " + alg);
            key = alg.generateKey();
        }
        CryptWriter.writeEncodedKey((Key)key, this.getOutputStream(line));
        if (line.hasOption("out")) {
            System.err.println("Wrote key to " + line.getOptionValue("out"));
        }
    }

    protected SecretKey generatePBEKey(SymmetricAlgorithm alg, CommandLine line) throws Exception {
        byte[] derivedIV;
        byte[] derivedKey;
        int keySize;
        if (!line.hasOption(OPT_SALT)) {
            throw new IllegalArgumentException("Salt is required for PBE key generation.");
        }
        if (!line.hasOption(OPT_ITERATIONS)) {
            throw new IllegalArgumentException("Iteration count is required for PBE key generation.");
        }
        DigestAlgorithm digest = null;
        if (line.hasOption(OPT_DIGEST)) {
            digest = DigestAlgorithm.newInstance(line.getOptionValue(OPT_DIGEST));
        }
        String pbeScheme = null;
        if (line.hasOption(OPT_SCHEME)) {
            pbeScheme = line.getOptionValue(OPT_SCHEME).toLowerCase();
        }
        char[] pass = line.getOptionValue(OPT_PBE).toCharArray();
        byte[] salt = this.hexConv.toBytes(line.getOptionValue(OPT_SALT));
        int iterations = Integer.parseInt(line.getOptionValue(OPT_ITERATIONS));
        int n = keySize = line.hasOption(OPT_KEYSIZE) ? Integer.parseInt(line.getOptionValue(OPT_KEYSIZE)) : -1;
        if ("pkcs12".equals(pbeScheme)) {
            if (digest == null) {
                throw new IllegalArgumentException("pkcs12 requires a digest.");
            }
            if (keySize < 0) {
                throw new IllegalArgumentException("Key size is required for pkcs5s2 PBE key generation.");
            }
            System.err.println("Generating PKCS#12 PBE key.");
            PKCS12KeyGenerator generator = new PKCS12KeyGenerator(digest, salt, iterations);
            derivedKey = generator.generate(pass, keySize);
            derivedIV = generator.generate(pass, alg.getBlockSize() * 8);
        } else if ("pkcs5s1".equals(pbeScheme)) {
            if (digest == null) {
                throw new IllegalArgumentException("pkcs5s1 requires a digest.");
            }
            System.err.println("Generating PKCS#5 PBE key using PBKDF1 scheme.");
            PBKDF1KeyGenerator generator = new PBKDF1KeyGenerator(digest, salt, iterations);
            byte[] keyWithIV = generator.generate(pass, 128);
            derivedKey = new byte[8];
            derivedIV = new byte[8];
            System.arraycopy(keyWithIV, 0, derivedKey, 0, 8);
            System.arraycopy(keyWithIV, 8, derivedIV, 0, 16);
        } else if ("openssl".equals(pbeScheme)) {
            if (keySize < 0) {
                throw new IllegalArgumentException("Key size is required for pkcs5s2 PBE key generation.");
            }
            System.err.println("Generating OpenSSL PBE key.");
            OpenSSLKeyGenerator generator = new OpenSSLKeyGenerator(salt);
            derivedKey = generator.generate(pass, keySize);
            derivedIV = generator.generate(pass, alg.getBlockSize() * 8);
        } else {
            if (digest != null) {
                System.err.println("Ignoring digest for pkcs5s2 PBE scheme.");
            }
            if (keySize < 0) {
                throw new IllegalArgumentException("Key size is required for pkcs5s2 PBE key generation.");
            }
            System.err.println("Generating PKCS#5 PBE key using PBKDF2 scheme.");
            PBKDF2KeyGenerator generator = new PBKDF2KeyGenerator(salt, iterations);
            derivedKey = generator.generate(pass, keySize);
            derivedIV = generator.generate(pass, alg.getBlockSize() * 8);
        }
        System.err.println("Derived key: " + this.hexConv.fromBytes(derivedKey));
        System.err.println("Derived iv: " + this.hexConv.fromBytes(derivedIV));
        return new SecretKeySpec(derivedKey, alg.getAlgorithm());
    }

    protected SecretKey readKey(CommandLine line) throws CryptException, IOException {
        return CryptReader.readSecretKey(new File(line.getOptionValue(OPT_KEY)), line.getOptionValue("cipher"));
    }

    protected void validateOptions(CommandLine line) {
        if (!line.hasOption("cipher")) {
            throw new IllegalArgumentException("cipher option is required.");
        }
    }

    protected EncryptionScheme getPBEScheme(SymmetricAlgorithm alg, CommandLine line) {
        AbstractEncryptionScheme pbeScheme;
        int keySize;
        if (!line.hasOption(OPT_SALT)) {
            throw new IllegalArgumentException("Salt is required for PBE encryption/decryption.");
        }
        if (!line.hasOption(OPT_ITERATIONS)) {
            throw new IllegalArgumentException("Iteration count is required for PBE encryption/decryption.");
        }
        DigestAlgorithm digest = null;
        if (line.hasOption(OPT_DIGEST)) {
            digest = DigestAlgorithm.newInstance(line.getOptionValue(OPT_DIGEST));
        }
        String scheme = null;
        if (line.hasOption(OPT_SCHEME)) {
            scheme = line.getOptionValue(OPT_SCHEME).toLowerCase();
        }
        byte[] salt = this.hexConv.toBytes(line.getOptionValue(OPT_SALT));
        int iterations = Integer.parseInt(line.getOptionValue(OPT_ITERATIONS));
        int n = keySize = line.hasOption(OPT_KEYSIZE) ? Integer.parseInt(line.getOptionValue(OPT_KEYSIZE)) : 0;
        if ("pkcs12".equals(scheme)) {
            if (digest == null) {
                throw new IllegalArgumentException("pkcs12 requires a digest.");
            }
            if (keySize < 0) {
                throw new IllegalArgumentException("Key size is required for pkcs5s2 PBE key generation.");
            }
            System.err.println("Using PKCS#12 PBE encryption scheme.");
            pbeScheme = new PKCS12EncryptionScheme(alg, digest, new PBEParameter(salt, iterations), keySize);
        } else if ("pkcs5s1".equals(scheme)) {
            if (digest == null) {
                throw new IllegalArgumentException("pkcs12 requires a digest.");
            }
            System.err.println("Using PKCS#5 PBES1 encryption scheme.");
            pbeScheme = new PBES1EncryptionScheme(alg, digest, new PBEParameter(salt, iterations));
        } else if ("openssl".equals(scheme)) {
            if (keySize < 0) {
                throw new IllegalArgumentException("Key size is required for pkcs5s2 PBE key generation.");
            }
            System.err.println("Using OpenSSL encryption scheme.");
            pbeScheme = new OpenSSLEncryptionScheme(alg, salt, keySize);
        } else {
            if (digest != null) {
                System.err.println("Ignoring digest for pkcs5s2 PBE scheme.");
            }
            if (keySize < 0) {
                throw new IllegalArgumentException("Key size is required for pkcs5s2 PBE key generation.");
            }
            System.err.println("Using PKCS#5 PBES2 encryption scheme.");
            pbeScheme = new PBES2EncryptionScheme(alg, new PBKDF2Parameters(salt, iterations, keySize / 8));
        }
        if (line.hasOption(OPT_IV)) {
            System.err.println("Using provided IV instead of generated value.");
            alg.setIV(this.hexConv.toBytes(line.getOptionValue(OPT_IV)));
        }
        return pbeScheme;
    }
}

