/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.GeneralNameList;
import edu.vt.middleware.crypt.x509.types.KeyIdentifier;

public class AuthorityKeyIdentifier {
    private static final int HASH_FACTOR = 31;
    private KeyIdentifier keyIdentifier;
    private GeneralNameList authorityCertIssuer;
    private Integer authorityCertSerialNumber;

    public AuthorityKeyIdentifier() {
    }

    public AuthorityKeyIdentifier(KeyIdentifier id) {
        this(id, null, null);
    }

    public AuthorityKeyIdentifier(KeyIdentifier id, GeneralNameList issuerNames, Integer issuerSerial) {
        this.keyIdentifier = id;
        this.authorityCertIssuer = issuerNames;
        this.authorityCertSerialNumber = issuerSerial;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public GeneralNameList getAuthorityCertIssuer() {
        return this.authorityCertIssuer;
    }

    public Integer getAuthorityCertSerialNumber() {
        return this.authorityCertSerialNumber;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        if (this.keyIdentifier != null) {
            ++count;
            sb.append(this.keyIdentifier);
        }
        if (this.authorityCertSerialNumber != null) {
            if (++count > 1) {
                sb.append(", ");
            }
            sb.append("SN:");
            sb.append(this.authorityCertSerialNumber);
        }
        if (this.authorityCertIssuer != null) {
            if (++count > 1) {
                sb.append(", ");
            }
            sb.append(this.authorityCertIssuer);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            result = false;
        } else {
            AuthorityKeyIdentifier other = (AuthorityKeyIdentifier)obj;
            result = (this.keyIdentifier != null ? this.keyIdentifier.equals(other.getKeyIdentifier()) : other.getKeyIdentifier() == null) && (this.authorityCertIssuer != null ? this.authorityCertIssuer.equals(other.getAuthorityCertIssuer()) : other.getAuthorityCertIssuer() == null) && (this.authorityCertSerialNumber != null ? this.authorityCertSerialNumber.equals(other.getAuthorityCertSerialNumber()) : other.getAuthorityCertSerialNumber() == null);
        }
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        if (this.keyIdentifier != null) {
            hash = 31 * hash + this.keyIdentifier.hashCode();
        }
        if (this.authorityCertSerialNumber != null) {
            hash = 31 * hash + this.authorityCertSerialNumber.hashCode();
        }
        if (this.authorityCertIssuer != null) {
            hash = 31 * hash + this.authorityCertIssuer.hashCode();
        }
        return hash;
    }
}

