/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class Base64Util {
    private static Logger m_logger = Logger.getLogger(Base64Util.class);
    public static final int BASE64DEFAULTLENGTH = 64;
    public static final String LINE_SEPARATOR = "\n";
    static String chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String encode(byte[] raw) {
        return Base64Util.encode(raw, 64);
    }

    public static String encode(byte[] raw, int wrap) {
        if (raw == null) {
            return null;
        }
        int encLen = (raw.length + 2) / 3 * 4;
        if (wrap > 3) {
            wrap -= wrap % 4;
            encLen += 2 * (encLen / wrap);
        } else {
            wrap = Integer.MAX_VALUE;
        }
        StringBuffer encoded = new StringBuffer(encLen);
        int len3 = raw.length / 3 * 3;
        int outLen = 0;
        int i = 0;
        while (i < len3) {
            if (outLen + 4 > wrap) {
                encoded.append(LINE_SEPARATOR);
                outLen = 0;
            }
            encoded.append(Base64Util.encodeFullBlock(raw, i));
            i += 3;
            outLen += 4;
        }
        if (outLen >= wrap) {
            encoded.append(LINE_SEPARATOR);
        }
        if (len3 < raw.length) {
            encoded.append(Base64Util.encodeBlock(raw, raw.length, len3));
        }
        return encoded.toString();
    }

    public static int encodeToBlock(byte[] raw, int rawLen, StringBuffer sb, boolean bLastBlock) throws IOException {
        int wrap = 64;
        int outLen = 0;
        int len3 = rawLen / 3 * 3;
        int nBytesPerLine = wrap / 4 * 3;
        int nUsedBytes = 0;
        int nTotal = 0;
        if (!bLastBlock) {
            nUsedBytes = rawLen / nBytesPerLine * nBytesPerLine;
            int i = 0;
            while (i < nUsedBytes) {
                if (outLen + 4 > wrap) {
                    sb.append(LINE_SEPARATOR);
                    ++nTotal;
                    outLen = 0;
                }
                char[] encdata = Base64Util.encodeFullBlock(raw, i);
                nTotal += encdata.length;
                sb.append(encdata);
                i += 3;
                outLen += 4;
            }
            if (outLen >= wrap) {
                sb.append(LINE_SEPARATOR);
                ++nTotal;
            }
        } else {
            nUsedBytes = rawLen;
            int i = 0;
            while (i < len3) {
                if (outLen + 4 > wrap) {
                    sb.append(LINE_SEPARATOR);
                    outLen = 0;
                    ++nTotal;
                }
                char[] encdata = Base64Util.encodeFullBlock(raw, i);
                nTotal += encdata.length;
                sb.append(encdata);
                i += 3;
                outLen += 4;
            }
            if (outLen >= wrap) {
                sb.append(LINE_SEPARATOR);
                ++nTotal;
            }
            if (len3 < rawLen) {
                char[] encdata = Base64Util.encodeBlock(raw, rawLen, len3);
                nTotal += encdata.length;
                sb.append(encdata);
            }
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Input: " + rawLen + " used: " + nUsedBytes + " last: " + bLastBlock + " wrote: " + nTotal));
        }
        return nUsedBytes;
    }

    public static int encodeToStream(byte[] raw, OutputStream outs, boolean bLastBlock) throws IOException {
        int wrap = 64;
        int outLen = 0;
        int len3 = raw.length / 3 * 3;
        int nBytesPerLine = wrap / 4 * 3;
        int nUsedBytes = 0;
        int nTotal = 0;
        if (!bLastBlock) {
            nUsedBytes = raw.length / nBytesPerLine * nBytesPerLine;
            int i = 0;
            while (i < nUsedBytes) {
                if (outLen + 4 > wrap) {
                    outs.write(LINE_SEPARATOR.getBytes());
                    ++nTotal;
                    outLen = 0;
                }
                char[] encdata = Base64Util.encodeFullBlock(raw, i);
                nTotal += encdata.length;
                outs.write(new String(encdata).getBytes());
                i += 3;
                outLen += 4;
            }
            if (outLen >= wrap) {
                outs.write(LINE_SEPARATOR.getBytes());
                ++nTotal;
            }
        } else {
            nUsedBytes = raw.length;
            int i = 0;
            while (i < len3) {
                if (outLen + 4 > wrap) {
                    outs.write(LINE_SEPARATOR.getBytes());
                    outLen = 0;
                    ++nTotal;
                }
                char[] encdata = Base64Util.encodeFullBlock(raw, i);
                nTotal += encdata.length;
                outs.write(new String(encdata).getBytes());
                i += 3;
                outLen += 4;
            }
            if (outLen >= wrap) {
                outs.write(LINE_SEPARATOR.getBytes());
                ++nTotal;
            }
            if (len3 < raw.length) {
                char[] encdata = Base64Util.encodeBlock(raw, raw.length, len3);
                nTotal += encdata.length;
                outs.write(new String(encdata).getBytes());
            }
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Encoded: " + raw.length + " last: " + bLastBlock + " wrote: " + nTotal));
        }
        return nUsedBytes;
    }

    protected static char[] encodeBlock(byte[] raw, int rawLen, int offset) {
        int block = 0;
        int slack = rawLen - offset - 1;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("raw: " + rawLen + " offset " + offset + " slack: " + slack));
        }
        int end = slack >= 2 ? 2 : slack;
        for (int i = 0; i < 3; ++i) {
            int b = offset + i < rawLen ? raw[offset + i] : 0;
            int neuter = b < 0 ? b + 256 : b;
            block <<= 8;
            block += neuter;
        }
        char[] base64 = new char[4];
        for (int i = 3; i >= 0; --i) {
            int sixBit = block & 0x3F;
            base64[i] = Base64Util.getChar(sixBit);
            block >>= 6;
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    protected static char[] encodeFullBlock(byte[] raw, int offset) {
        int block = 0;
        for (int i = 0; i < 3; ++i) {
            block <<= 8;
            block += 0xFF & raw[offset + i];
        }
        block = ((raw[offset] & 0xFF) << 16) + ((raw[offset + 1] & 0xFF) << 8) + (raw[offset + 2] & 0xFF);
        char[] base64 = new char[4];
        for (int i = 3; i >= 0; --i) {
            int sixBit = block & 0x3F;
            base64[i] = Base64Util.getChar(sixBit);
            block >>= 6;
        }
        return base64;
    }

    protected static char getChar(int sixBit) {
        if (sixBit >= 0 && sixBit < 26) {
            return (char)(65 + sixBit);
        }
        if (sixBit >= 26 && sixBit < 52) {
            return (char)(97 + (sixBit - 26));
        }
        if (sixBit >= 52 && sixBit < 62) {
            return (char)(48 + (sixBit - 52));
        }
        if (sixBit == 62) {
            return '+';
        }
        if (sixBit == 63) {
            return '/';
        }
        return '?';
    }

    public static byte[] decode(byte[] base64) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(base64.length / 4 * 3);
        char[] four = new char[4];
        int i = 0;
        do {
            int j = 0;
            while (j < 4 && i < base64.length) {
                char c = (char)base64[i];
                if (c != ' ' && c != '\t' && c != '\n' && c != '=' && c != '\r') {
                    four[j] = c;
                    ++j;
                }
                ++i;
            }
            if (j <= 0) continue;
            int aux = 0;
            for (int k = 0; k < j; ++k) {
                aux |= chars.indexOf(four[k]) << 6 * (3 - k);
            }
            for (int m = 0; m < j - 1; ++m) {
                byte b = (byte)(aux >>> 8 * (2 - m) & 0xFF);
                bos.write(b);
            }
        } while (i < base64.length);
        return bos.toByteArray();
    }

    public static int decodeBlock(String base64, OutputStream out, boolean bLastBlock) {
        int nUsed = 0;
        int nPos = 0;
        int nDec = 0;
        StringBuffer sbBlock = null;
        do {
            sbBlock = new StringBuffer();
            while (nPos < base64.length() && sbBlock.length() < 4) {
                char ch = base64.charAt(nPos);
                if (ch != ' ' && ch != '\n' && ch != '\t' && ch != '\r') {
                    sbBlock.append(ch);
                }
                ++nPos;
            }
            while (bLastBlock && sbBlock.length() < 4) {
                sbBlock.append('=');
            }
            if (sbBlock.length() != 4) continue;
            int block = (Base64Util.getValue(sbBlock.charAt(0)) << 18) + (Base64Util.getValue(sbBlock.charAt(1)) << 12) + (Base64Util.getValue(sbBlock.charAt(2)) << 6) + Base64Util.getValue(sbBlock.charAt(3));
            byte[] decdata = new byte[3];
            for (int j = 2; j >= 0; --j) {
                decdata[j] = (byte)(block & 0xFF);
                block >>= 8;
            }
            nDec += decdata.length;
            try {
                out.write(decdata);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            nUsed = nPos;
        } while (nPos < base64.length());
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Decoding: " + base64.length() + " last: " + bLastBlock + " used: " + nUsed + " decoded: " + nDec));
        }
        return nUsed;
    }

    public static byte[] decode(String base64) {
        if (base64.length() < 30) {
            // empty if block
        }
        StringTokenizer tok = new StringTokenizer(base64, " \n\r\t", false);
        StringBuffer buf = new StringBuffer(base64.length());
        while (tok.hasMoreElements()) {
            buf.append(tok.nextToken());
        }
        base64 = buf.toString();
        int pad = 0;
        for (int i = base64.length() - 1; i > 0 && base64.charAt(i) == '='; --i) {
            ++pad;
        }
        int length = base64.length() / 4 * 3 - pad;
        byte[] raw = new byte[length];
        int i = 0;
        int rawIndex = 0;
        while (i < base64.length() - 3) {
            int block = (Base64Util.getValue(base64.charAt(i)) << 18) + (Base64Util.getValue(base64.charAt(i + 1)) << 12) + (Base64Util.getValue(base64.charAt(i + 2)) << 6) + Base64Util.getValue(base64.charAt(i + 3));
            for (int j = 2; j >= 0; --j) {
                if (rawIndex + j < raw.length) {
                    raw[rawIndex + j] = (byte)(block & 0xFF);
                }
                block >>= 8;
            }
            i += 4;
            rawIndex += 3;
        }
        return raw;
    }

    public static byte[] decodeWithoutWhitespace(String base64) {
        int pad = 0;
        for (int i = base64.length() - 1; i > 0 && base64.charAt(i) == '='; --i) {
            ++pad;
        }
        int length = base64.length() / 4 * 3 - pad;
        byte[] raw = new byte[length];
        int i = 0;
        int rawIndex = 0;
        while (i < base64.length()) {
            int block = (Base64Util.getValue(base64.charAt(i)) << 18) + (Base64Util.getValue(base64.charAt(i + 1)) << 12) + (Base64Util.getValue(base64.charAt(i + 2)) << 6) + Base64Util.getValue(base64.charAt(i + 3));
            for (int j = 2; j >= 0; --j) {
                if (rawIndex + j < raw.length) {
                    raw[rawIndex + j] = (byte)(block & 0xFF);
                }
                block >>= 8;
            }
            i += 4;
            rawIndex += 3;
        }
        return raw;
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }
}

