/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class CertID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_digestAlgorithm;
    private String m_id;
    private String m_uri;
    private byte[] m_digestValue;
    private String m_issuer;
    private BigInteger m_serial;
    private Signature m_signature;
    private int m_type;
    public static final int CERTID_TYPE_UNKNOWN = 0;
    public static final int CERTID_TYPE_SIGNER = 1;
    public static final int CERTID_TYPE_RESPONDER = 2;
    public static final int CERTID_TYPE_TSA = 3;
    public static final int CERTID_TYPE_CA = 4;
    public static final int CERTID_TYPE_RESPONDER_CA = 5;

    public CertID() {
        this.m_id = null;
        this.m_uri = null;
        this.m_digestAlgorithm = null;
        this.m_digestValue = null;
        this.m_serial = null;
        this.m_issuer = null;
        this.m_signature = null;
        this.m_type = 0;
    }

    public CertID(String certId, String digAlg, byte[] digest, BigInteger serial, String issuer, int type) throws DigiDocException {
        this.setId(certId);
        this.setDigestAlgorithm(digAlg);
        this.setDigestValue(digest);
        this.setSerial(serial);
        if (issuer != null) {
            this.setIssuer(issuer);
        }
        this.setType(type);
        this.m_signature = null;
    }

    public CertID(Signature sig, X509Certificate cert, int type) throws DigiDocException {
        if (type == 1) {
            this.setId(sig.getId() + "-CERTINFO");
        }
        if (type == 2) {
            this.setId(sig.getId() + "-RESPONDER_CERTINFO");
        }
        String sDigType = ConfigManager.instance().getDefaultDigestType(sig.getSignedDoc());
        String sDigAlg = ConfigManager.digType2Alg(sDigType);
        this.setDigestAlgorithm(sDigAlg);
        byte[] digest = null;
        try {
            digest = SignedDoc.digestOfType(cert.getEncoded(), sDigType);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 54);
        }
        this.setDigestValue(digest);
        this.setSerial(cert.getSerialNumber());
        this.setIssuer(ConvertUtils.convX509Name(cert.getIssuerX500Principal()));
        this.setType(type);
    }

    public CertID(Signature sig, X509Certificate cert, int type, String id) throws DigiDocException {
        this.setId(id);
        String sDigType = ConfigManager.instance().getDefaultDigestType(sig.getSignedDoc());
        String sDigAlg = ConfigManager.digType2Alg(sDigType);
        this.setDigestAlgorithm(sDigAlg);
        byte[] digest = null;
        try {
            digest = SignedDoc.digestOfType(cert.getEncoded(), sDigType);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 54);
        }
        this.setDigestValue(digest);
        this.setSerial(cert.getSerialNumber());
        this.setIssuer(ConvertUtils.convX509Name(cert.getIssuerX500Principal()));
        this.setType(type);
    }

    public Signature getSignature() {
        return this.m_signature;
    }

    public void setSignature(Signature sig) {
        this.m_signature = sig;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) throws DigiDocException {
        DigiDocException ex;
        if (this.m_signature != null && this.m_signature.getSignedDoc() != null && !this.m_signature.getSignedDoc().getVersion().equals("1.3") && (ex = this.validateId(str)) != null) {
            throw ex;
        }
        this.m_id = str;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String str) {
        this.m_uri = str;
    }

    private DigiDocException validateId(String str) {
        DigiDocException ex = null;
        if (str == null && !this.m_signature.getSignedDoc().getVersion().equals("1.3") && !this.m_signature.getSignedDoc().getFormat().equals("BDOC") && this.m_type == 2) {
            ex = new DigiDocException(47, "Cert Id must be in form: <signature-id>-RESPONDER_CERTINFO", null);
        }
        return ex;
    }

    public String getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    public void setDigestAlgorithm(String str) throws DigiDocException {
        DigiDocException ex = this.validateDigestAlgorithm(str);
        if (ex != null) {
            throw ex;
        }
        this.m_digestAlgorithm = str;
    }

    private DigiDocException validateDigestAlgorithm(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals("http://www.w3.org/2000/09/xmldsig#sha1") && !str.equals("http://www.w3.org/2001/04/xmlenc#sha256") && !str.equals("http://www.w3.org/2001/04/xmldsig-more#sha256") && !str.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            ex = new DigiDocException(20, "Currently supports only SHA-1, SHA-256 or SHA-512 digest algorithm", null);
        }
        return ex;
    }

    public byte[] getDigestValue() {
        return this.m_digestValue;
    }

    public void setDigestValue(byte[] data) throws DigiDocException {
        DigiDocException ex = this.validateDigestValue(data);
        if (ex != null) {
            throw ex;
        }
        this.m_digestValue = data;
    }

    private DigiDocException validateDigestValue(byte[] data) {
        DigiDocException ex = null;
        if (data == null || data.length != 20 && data.length != 32 && data.length != 64) {
            ex = new DigiDocException(21, "Invalid digest length", null);
        }
        return ex;
    }

    public BigInteger getSerial() {
        return this.m_serial;
    }

    public void setSerial(BigInteger i) throws DigiDocException {
        DigiDocException ex = this.validateSerial(i);
        if (ex != null) {
            throw ex;
        }
        this.m_serial = i;
    }

    private DigiDocException validateSerial(BigInteger i) {
        DigiDocException ex = null;
        if (i == null) {
            ex = new DigiDocException(42, "Certificates serial number cannot be empty!", null);
        }
        return ex;
    }

    public String getIssuer() {
        return this.m_issuer;
    }

    public void setIssuer(String str) throws DigiDocException {
        DigiDocException ex = this.validateIssuer(str);
        if (ex != null) {
            throw ex;
        }
        this.m_issuer = str;
    }

    private DigiDocException validateIssuer(String str) {
        DigiDocException ex = null;
        if (str == null && this.m_signature != null && this.m_signature.getSignedDoc().getVersion().equals("1.3")) {
            ex = new DigiDocException(118, "Issuer name cannot be empty", null);
        }
        return ex;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) throws DigiDocException {
        DigiDocException ex = this.validateType(n);
        if (ex != null) {
            throw ex;
        }
        this.m_type = n;
    }

    private DigiDocException validateType(int n) {
        DigiDocException ex = null;
        if (n < 0 || n > 5) {
            ex = new DigiDocException(119, "Invalid CertID type", null);
        }
        return ex;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateId(this.m_id);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateDigestAlgorithm(this.m_digestAlgorithm)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateDigestValue(this.m_digestValue)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateSerial(this.m_serial)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateIssuer(this.m_issuer)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateType(this.m_type)) != null) {
            errs.add(ex);
        }
        return errs;
    }
}

