/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import java.io.Serializable;
import java.security.cert.X509Certificate;

public class CertValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id;
    private Signature m_signature;
    private int m_type;
    private X509Certificate m_cert;
    public static final int CERTVAL_TYPE_UNKNOWN = 0;
    public static final int CERTVAL_TYPE_SIGNER = 1;
    public static final int CERTVAL_TYPE_RESPONDER = 2;
    public static final int CERTVAL_TYPE_TSA = 3;
    public static final int CERTVAL_TYPE_CA = 4;
    public static final int CERTVAL_TYPE_RESPONDER_CA = 5;

    public CertValue() {
        this.m_id = null;
        this.m_signature = null;
        this.m_cert = null;
        this.m_type = 0;
    }

    public CertValue(String id, X509Certificate cert, int type, Signature sig) {
        this.m_id = id;
        this.m_signature = sig;
        this.m_cert = cert;
        this.m_type = type;
    }

    public Signature getSignature() {
        return this.m_signature;
    }

    public void setSignature(Signature sig) {
        this.m_signature = sig;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public int getType() {
        return this.m_type;
    }

    public void setType(int n) throws DigiDocException {
        DigiDocException ex = this.validateType(n);
        if (ex != null) {
            throw ex;
        }
        this.m_type = n;
    }

    private DigiDocException validateType(int n) {
        DigiDocException ex = null;
        if (n < 0 || n > 3) {
            ex = new DigiDocException(119, "Invalid CertValue type", null);
        }
        return ex;
    }

    public X509Certificate getCert() {
        return this.m_cert;
    }

    public void setCert(X509Certificate cert) {
        this.m_cert = cert;
    }
}

