/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.CertID;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.UnsignedProperties;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class CompleteCertificateRefs
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UnsignedProperties m_unsignedProps;

    public CompleteCertificateRefs() {
        this.m_unsignedProps = null;
    }

    public CompleteCertificateRefs(String certId, String digAlg, byte[] digest, BigInteger serial) throws DigiDocException {
        CertID cid = new CertID(certId, digAlg, digest, serial, null, 2);
        this.addCertID(cid);
        this.m_unsignedProps = null;
    }

    public CompleteCertificateRefs(Signature sig, X509Certificate respCert) throws DigiDocException {
        CertID cid = new CertID(sig, respCert, 2);
        sig.addCertID(cid);
    }

    public int countCertIDs() {
        return this.m_unsignedProps.getSignature().countCertIDs();
    }

    public void addCertID(CertID cid) {
        this.m_unsignedProps.getSignature().addCertID(cid);
    }

    public CertID getCertID(int idx) {
        return this.m_unsignedProps.getSignature().getCertID(idx);
    }

    public CertID getLastCertId() {
        return this.m_unsignedProps.getSignature().getLastCertId();
    }

    public CertID getCertIdOfType(int type) {
        return this.m_unsignedProps.getSignature().getCertIdOfType(type);
    }

    public CertID getOrCreateCertIdOfType(int type) throws DigiDocException {
        return this.m_unsignedProps.getSignature().getOrCreateCertIdOfType(type);
    }

    public UnsignedProperties getUnsignedProperties() {
        return this.m_unsignedProps;
    }

    public void setUnsignedProperties(UnsignedProperties uprops) {
        this.m_unsignedProps = uprops;
    }

    public String getCertId() {
        CertID cid = this.getCertIdOfType(2);
        if (cid != null) {
            return cid.getId();
        }
        return null;
    }

    public void setCertId(String str) throws DigiDocException {
        CertID cid = this.getOrCreateCertIdOfType(2);
        cid.setId(str);
    }

    public String getCertDigestAlgorithm() {
        CertID cid = this.getCertIdOfType(2);
        if (cid != null) {
            return cid.getDigestAlgorithm();
        }
        return null;
    }

    public void setCertDigestAlgorithm(String str) throws DigiDocException {
        CertID cid = this.getOrCreateCertIdOfType(2);
        cid.setDigestAlgorithm(str);
    }

    public byte[] getCertDigestValue() {
        CertID cid = this.getCertIdOfType(2);
        if (cid != null) {
            return cid.getDigestValue();
        }
        return null;
    }

    public void setCertDigestValue(byte[] data) throws DigiDocException {
        CertID cid = this.getOrCreateCertIdOfType(2);
        cid.setDigestValue(data);
    }

    public BigInteger getCertSerial() {
        CertID cid = this.getCertIdOfType(2);
        if (cid != null) {
            return cid.getSerial();
        }
        return null;
    }

    public String getCertIssuer() {
        CertID cid = this.getCertIdOfType(2);
        if (cid != null) {
            return cid.getIssuer();
        }
        return null;
    }

    public void setCertSerial(BigInteger i) throws DigiDocException {
        CertID cid = this.getOrCreateCertIdOfType(2);
        cid.setSerial(i);
    }

    public ArrayList validate() {
        ArrayList errs = new ArrayList();
        for (int i = 0; i < this.countCertIDs(); ++i) {
            ArrayList a;
            CertID cid = this.getCertID(i);
            if (cid == null || (a = cid.validate()).size() <= 0) continue;
            errs.addAll(a);
        }
        return errs;
    }
}

