/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import java.io.Serializable;
import java.util.ArrayList;

public class DataFileAttribute
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private String m_value;

    public DataFileAttribute(String name, String value) throws DigiDocException {
        this.setName(name);
        this.setValue(value);
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String str) throws DigiDocException {
        DigiDocException ex = this.validateName(str);
        if (ex != null) {
            throw ex;
        }
        this.m_name = str;
    }

    private DigiDocException validateName(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(34, "Attribute name is required", null);
        }
        return ex;
    }

    public String getValue() {
        return this.m_value;
    }

    public void setValue(String str) throws DigiDocException {
        DigiDocException ex = this.validateValue(str);
        if (ex != null) {
            throw ex;
        }
        this.m_value = str;
    }

    private DigiDocException validateValue(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(35, "Attribute value is required", null);
        }
        return ex;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateName(this.m_name);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateValue(this.m_value)) != null) {
            errs.add(ex);
        }
        return errs;
    }

    public String toXML() throws DigiDocException {
        StringBuffer sb = new StringBuffer(this.m_name);
        sb.append("=\"");
        sb.append(this.m_value);
        sb.append("\"");
        return sb.toString();
    }

    public String toString() {
        String str = null;
        try {
            str = this.toXML();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

