/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;

public class KeyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Signature m_signature;
    private String m_id;

    public KeyInfo() {
        this.m_signature = null;
    }

    public KeyInfo(X509Certificate cert) throws DigiDocException {
        this.setSignersCertificate(cert);
    }

    public Signature getSignature() {
        return this.m_signature;
    }

    public void setSignature(Signature sig) {
        this.m_signature = sig;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public X509Certificate getSignersCertificate() {
        CertValue cval;
        X509Certificate cert = null;
        if (this.m_signature != null && (cval = this.m_signature.getCertValueOfType(1)) != null) {
            cert = cval.getCert();
        }
        return cert;
    }

    public String getSubjectFirstName() {
        X509Certificate cert = this.getSignersCertificate();
        if (cert != null) {
            return SignedDoc.getSubjectFirstName(cert);
        }
        return null;
    }

    public String getSubjectLastName() {
        X509Certificate cert = this.getSignersCertificate();
        if (cert != null) {
            return SignedDoc.getSubjectLastName(cert);
        }
        return null;
    }

    public String getSubjectPersonalCode() {
        X509Certificate cert = this.getSignersCertificate();
        if (cert != null) {
            return SignedDoc.getSubjectPersonalCode(cert);
        }
        return null;
    }

    public void setSignersCertificate(X509Certificate cert) throws DigiDocException {
        DigiDocException ex = this.validateSignersCertificate(cert);
        if (ex != null) {
            throw ex;
        }
        if (this.m_signature != null) {
            CertValue cval = this.m_signature.getOrCreateCertValueOfType(1);
            cval.setCert(cert);
        }
    }

    private DigiDocException validateSignersCertificate(X509Certificate cert) {
        DigiDocException ex = null;
        if (cert == null) {
            ex = new DigiDocException(39, "Signers certificate is required", null);
        }
        return ex;
    }

    public BigInteger getSignerKeyModulus() {
        X509Certificate cert = this.getSignersCertificate();
        if (cert != null) {
            return ((RSAPublicKey)cert.getPublicKey()).getModulus();
        }
        return null;
    }

    public BigInteger getSignerKeyExponent() {
        X509Certificate cert = this.getSignersCertificate();
        if (cert != null) {
            return ((RSAPublicKey)cert.getPublicKey()).getPublicExponent();
        }
        return null;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = null;
        X509Certificate cert = this.getSignersCertificate();
        if (cert != null) {
            ex = this.validateSignersCertificate(cert);
        }
        if (ex != null) {
            errs.add(ex);
        }
        return errs;
    }
}

