/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.utils.ConvertUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ManifestFileEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_mediaType;
    private String m_fullPath;

    public ManifestFileEntry(String mediaType, String fullPath) {
        this.m_mediaType = mediaType;
        this.m_fullPath = fullPath;
    }

    public String getMediaType() {
        return this.m_mediaType;
    }

    public String getFullPath() {
        return this.m_fullPath;
    }

    public void setMediaType(String s) {
        this.m_mediaType = s;
    }

    public void setFullPath(String s) {
        this.m_fullPath = s;
    }

    public byte[] toXML() throws DigiDocException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(ConvertUtils.str2data("<manifest:file-entry "));
            bos.write(ConvertUtils.str2data("manifest:media-type=\""));
            bos.write(ConvertUtils.str2data(this.m_mediaType));
            bos.write(ConvertUtils.str2data("\" manifest:full-path=\""));
            bos.write(ConvertUtils.str2data(ConvertUtils.escapeXmlSymbols(this.m_fullPath)));
            bos.write(ConvertUtils.str2data("\" />\n"));
        }
        catch (IOException ex) {
            DigiDocException.handleException(ex, 89);
        }
        return bos.toByteArray();
    }

    public String toString() {
        String str = null;
        try {
            str = new String(this.toXML());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }
}

