/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Identifier;
import java.io.Serializable;
import java.util.ArrayList;

public class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Identifier m_identifier;
    private String m_description;
    private ArrayList m_docRefs;

    public ObjectIdentifier(Identifier id) throws DigiDocException {
        this.setIdentifier(id);
        this.m_description = null;
        this.m_docRefs = null;
    }

    public Identifier getIdentifier() {
        return this.m_identifier;
    }

    public void setIdentifier(Identifier id) throws DigiDocException {
        DigiDocException ex = this.validateIdentifier(id);
        if (ex != null) {
            throw ex;
        }
        this.m_identifier = id;
    }

    private DigiDocException validateIdentifier(Identifier id) {
        DigiDocException ex = null;
        if (id == null) {
            ex = new DigiDocException(167, "Identifier is a required attribute", null);
        }
        return ex;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setUri(String str) {
        this.m_description = str;
    }

    public int countDocumentationReferences() {
        return this.m_docRefs == null ? 0 : this.m_docRefs.size();
    }

    public void addDataObjectFormat(String dor) {
        if (this.m_docRefs == null) {
            this.m_docRefs = new ArrayList();
        }
        this.m_docRefs.add(dor);
    }

    public String getDocumentationReference(int idx) {
        if (this.m_docRefs != null && idx < this.m_docRefs.size()) {
            return (String)this.m_docRefs.get(idx);
        }
        return null;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateIdentifier(this.m_identifier);
        if (ex != null) {
            errs.add(ex);
        }
        return errs;
    }
}

