/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class OcspRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_uri;
    private String m_responderId;
    private Date m_producedAt;
    private String m_digestAlgorithm;
    private byte[] m_digestValue;

    public OcspRef() {
        this.m_uri = null;
        this.m_responderId = null;
        this.m_producedAt = null;
        this.m_digestAlgorithm = null;
        this.m_digestValue = null;
    }

    public OcspRef(String uri, String respId, Date producedAt, String digAlg, byte[] digest) throws DigiDocException {
        this.setUri(uri);
        this.setResponderId(respId);
        this.setProducedAt(producedAt);
        this.setDigestAlgorithm(digAlg);
        this.setDigestValue(digest);
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setUri(String str) throws DigiDocException {
        DigiDocException ex = this.validateUri(str);
        if (ex != null) {
            throw ex;
        }
        this.m_uri = str;
    }

    private DigiDocException validateUri(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(48, "OCSP ref uri must be in form: #<ref-id>", null);
        }
        return ex;
    }

    public String getResponderId() {
        return this.m_responderId;
    }

    public void setResponderId(String str) throws DigiDocException {
        DigiDocException ex = this.validateResponderId(str);
        if (ex != null) {
            throw ex;
        }
        this.m_responderId = str;
    }

    public String getResponderCommonName() {
        int idx1;
        String name = null;
        if (this.m_responderId != null && (idx1 = this.m_responderId.indexOf("CN=")) != -1) {
            int idx2;
            idx1 += 2;
            while (idx1 < this.m_responderId.length() && !Character.isLetter(this.m_responderId.charAt(idx1))) {
                ++idx1;
            }
            for (idx2 = idx1; idx2 < this.m_responderId.length() && this.m_responderId.charAt(idx2) != ',' && this.m_responderId.charAt(idx2) != '/'; ++idx2) {
            }
            name = this.m_responderId.substring(idx1, idx2);
        }
        return name;
    }

    private DigiDocException validateResponderId(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(49, "ResponderId cannot be empty!", null);
        }
        return ex;
    }

    public Date getProducedAt() {
        return this.m_producedAt;
    }

    public void setProducedAt(Date d) throws DigiDocException {
        DigiDocException ex = this.validateProducedAt(d);
        if (ex != null) {
            throw ex;
        }
        this.m_producedAt = d;
    }

    private DigiDocException validateProducedAt(Date d) {
        DigiDocException ex = null;
        if (d == null) {
            ex = new DigiDocException(50, "ProducedAt timestamp cannot be empty!", null);
        }
        return ex;
    }

    public String getDigestAlgorithm() {
        return this.m_digestAlgorithm;
    }

    public void setDigestAlgorithm(String str) throws DigiDocException {
        DigiDocException ex = this.validateDigestAlgorithm(str);
        if (ex != null) {
            throw ex;
        }
        this.m_digestAlgorithm = str;
    }

    private DigiDocException validateDigestAlgorithm(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals("http://www.w3.org/2000/09/xmldsig#sha1") && !str.equals("http://www.w3.org/2001/04/xmlenc#sha256") && !str.equals("http://www.w3.org/2001/04/xmldsig-more#sha256") && !str.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            ex = new DigiDocException(20, "Currently supports only SHA1, SHA256 or SHA256 digest algorithm", null);
        }
        return ex;
    }

    public byte[] getDigestValue() {
        return this.m_digestValue;
    }

    public void setDigestValue(byte[] data) throws DigiDocException {
        DigiDocException ex = this.validateDigestValue(data);
        if (ex != null) {
            throw ex;
        }
        this.m_digestValue = data;
    }

    private DigiDocException validateDigestValue(byte[] data) {
        DigiDocException ex = null;
        if (data == null || data.length != 20 && data.length != 32 && data.length != 64) {
            ex = new DigiDocException(21, "Invalid digest length", null);
        }
        return ex;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateUri(this.m_uri);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateResponderId(this.m_responderId)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateProducedAt(this.m_producedAt)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateDigestAlgorithm(this.m_digestAlgorithm)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateDigestValue(this.m_digestValue)) != null) {
            errs.add(ex);
        }
        return errs;
    }
}

