/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Identifier;
import ee.sk.digidoc.KeyInfo;
import ee.sk.digidoc.Notary;
import ee.sk.digidoc.QualifyingProperties;
import ee.sk.digidoc.SignatureValue;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.SignedInfo;
import ee.sk.digidoc.SignedProperties;
import ee.sk.digidoc.TimestampInfo;
import ee.sk.digidoc.UnsignedProperties;
import ee.sk.digidoc.factory.DigiDocGenFactory;
import ee.sk.digidoc.factory.DigiDocVerifyFactory;
import ee.sk.digidoc.factory.DigiDocXmlGenFactory;
import ee.sk.utils.ConfigManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class Signature
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SignedDoc m_sigDoc;
    private String m_id;
    private SignedInfo m_signedInfo;
    private SignatureValue m_signatureValue;
    private String m_comment;
    private KeyInfo m_keyInfo;
    private SignedProperties m_sigProp;
    private QualifyingProperties m_qualProp;
    private UnsignedProperties m_unsigProp;
    private byte[] m_origContent;
    private ArrayList m_certIds;
    private ArrayList m_certValues;
    private ArrayList m_timestamps;
    private ArrayList m_errs;
    private String m_path;
    private boolean m_bAltDigMatch;
    private String m_profile;
    private String m_httpFrom;
    private static Logger m_logger = Logger.getLogger(Signature.class);

    public Signature(SignedDoc sigDoc) {
        this.m_sigDoc = sigDoc;
        this.m_id = null;
        this.m_signedInfo = null;
        this.m_signatureValue = null;
        this.m_keyInfo = null;
        this.m_sigProp = null;
        this.m_unsigProp = null;
        this.m_origContent = null;
        this.m_certIds = null;
        this.m_certValues = null;
        this.m_timestamps = null;
        this.m_path = null;
        this.m_profile = null;
        this.m_errs = null;
        this.m_httpFrom = null;
        this.m_bAltDigMatch = false;
        this.m_comment = null;
    }

    public SignedDoc getSignedDoc() {
        return this.m_sigDoc;
    }

    public void setSignedDoc(SignedDoc sigDoc) {
        this.m_sigDoc = sigDoc;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) throws DigiDocException {
        DigiDocException ex = this.validateId(str);
        if (ex != null) {
            throw ex;
        }
        this.m_id = str;
    }

    public byte[] getOrigContent() {
        return this.m_origContent;
    }

    public void setOrigContent(byte[] data) {
        this.m_origContent = data;
    }

    private DigiDocException validateId(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(36, "Id is a required attribute", null);
        }
        return ex;
    }

    public SignedInfo getSignedInfo() {
        return this.m_signedInfo;
    }

    public void setSignedInfo(SignedInfo si) throws DigiDocException {
        this.m_signedInfo = si;
    }

    public boolean isEllipticCurveSiganture() {
        return this.m_signedInfo != null && this.m_signedInfo.getSignatureMethod() != null && (this.m_signedInfo.getSignatureMethod().equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || this.m_signedInfo.getSignatureMethod().equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || this.m_signedInfo.getSignatureMethod().equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || this.m_signedInfo.getSignatureMethod().equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || this.m_signedInfo.getSignatureMethod().equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512"));
    }

    @Deprecated
    public boolean getAltDigestMatch() {
        return this.m_bAltDigMatch;
    }

    public void setAltDigestMatch(boolean b) {
        this.m_bAltDigMatch = b;
    }

    public byte[] calculateSignedInfoDigest() throws DigiDocException {
        return this.m_signedInfo.calculateDigest();
    }

    public byte[] calculateSignedInfoXML() throws DigiDocException {
        DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this.m_sigDoc);
        return genFac.signedInfoToXML(this, this.m_signedInfo);
    }

    public String getHttpFrom() {
        return this.m_httpFrom;
    }

    public void setHttpFrom(String s) {
        this.m_httpFrom = s;
    }

    public SignatureValue getSignatureValue() {
        return this.m_signatureValue;
    }

    public void setSignatureValue(SignatureValue sv) throws DigiDocException {
        this.m_signatureValue = sv;
        this.m_origContent = null;
    }

    public void setSignatureValue(byte[] sigv) throws DigiDocException {
        SignatureValue sv = new SignatureValue(this, sigv);
        this.setSignatureValue(sv);
    }

    public KeyInfo getKeyInfo() {
        return this.m_keyInfo;
    }

    public void setKeyInfo(KeyInfo ki) throws DigiDocException {
        this.m_keyInfo = ki;
    }

    public SignedProperties getSignedProperties() {
        return this.m_sigProp;
    }

    public void setSignedProperties(SignedProperties sp) throws DigiDocException {
        this.m_sigProp = sp;
    }

    public UnsignedProperties getUnsignedProperties() {
        return this.m_unsigProp;
    }

    public void setUnsignedProperties(UnsignedProperties usp) throws DigiDocException {
        this.m_unsigProp = usp;
    }

    public int countCertIDs() {
        return this.m_certIds == null ? 0 : this.m_certIds.size();
    }

    public void addCertID(CertID cid) {
        if (this.m_certIds == null) {
            this.m_certIds = new ArrayList();
        }
        cid.setSignature(this);
        this.m_certIds.add(cid);
    }

    public CertID getCertID(int idx) {
        if (this.m_certIds != null && idx < this.m_certIds.size()) {
            return (CertID)this.m_certIds.get(idx);
        }
        return null;
    }

    public CertID getLastCertId() {
        if (this.m_certIds != null && this.m_certIds.size() > 0) {
            return (CertID)this.m_certIds.get(this.m_certIds.size() - 1);
        }
        return null;
    }

    public CertID getCertIdOfType(int type) {
        for (int i = 0; this.m_certIds != null && i < this.m_certIds.size(); ++i) {
            CertID cid = (CertID)this.m_certIds.get(i);
            if (cid.getType() != type) continue;
            return cid;
        }
        return null;
    }

    public CertID getOrCreateCertIdOfType(int type) throws DigiDocException {
        CertID cid = this.getCertIdOfType(type);
        if (cid == null) {
            cid = new CertID();
            cid.setType(type);
            this.addCertID(cid);
        }
        return cid;
    }

    public int countCertValues() {
        return this.m_certValues == null ? 0 : this.m_certValues.size();
    }

    public void addCertValue(CertValue cval) {
        if (this.m_certValues == null) {
            this.m_certValues = new ArrayList();
        }
        cval.setSignature(this);
        this.m_certValues.add(cval);
    }

    public CertValue getCertValue(int idx) {
        if (this.m_certValues != null && idx < this.m_certValues.size()) {
            return (CertValue)this.m_certValues.get(idx);
        }
        return null;
    }

    public CertValue getLastCertValue() {
        if (this.m_certValues != null && this.m_certValues.size() > 0) {
            return (CertValue)this.m_certValues.get(this.m_certValues.size() - 1);
        }
        return null;
    }

    public CertValue getCertValueOfType(int type) {
        for (int i = 0; this.m_certValues != null && i < this.m_certValues.size(); ++i) {
            CertValue cval = (CertValue)this.m_certValues.get(i);
            if (cval.getType() != type) continue;
            return cval;
        }
        return null;
    }

    public CertValue getOrCreateCertValueOfType(int type) throws DigiDocException {
        CertValue cval = this.getCertValueOfType(type);
        if (cval == null) {
            cval = new CertValue();
            cval.setType(type);
            this.addCertValue(cval);
        }
        return cval;
    }

    public CertValue findCertValueWithSerial(BigInteger serNo) {
        for (int i = 0; this.m_certValues != null && i < this.m_certValues.size(); ++i) {
            CertValue cval = (CertValue)this.m_certValues.get(i);
            if (!cval.getCert().getSerialNumber().equals(serNo)) continue;
            return cval;
        }
        return null;
    }

    public X509Certificate findResponderCert() {
        CertValue cval = this.getCertValueOfType(2);
        if (cval != null) {
            return cval.getCert();
        }
        return null;
    }

    public ArrayList findTSACerts() {
        ArrayList<X509Certificate> vec = new ArrayList<X509Certificate>();
        for (int i = 0; this.m_certValues != null && i < this.m_certValues.size(); ++i) {
            CertValue cval = (CertValue)this.m_certValues.get(i);
            if (cval.getType() != 3) continue;
            vec.add(cval.getCert());
        }
        return vec;
    }

    public int countTimestampInfos() {
        return this.m_timestamps == null ? 0 : this.m_timestamps.size();
    }

    public void addTimestampInfo(TimestampInfo ts) {
        if (this.m_timestamps == null) {
            this.m_timestamps = new ArrayList();
        }
        ts.setSignature(this);
        this.m_timestamps.add(ts);
    }

    public TimestampInfo getTimestampInfo(int idx) {
        if (this.m_timestamps != null && idx < this.m_timestamps.size()) {
            return (TimestampInfo)this.m_timestamps.get(idx);
        }
        return null;
    }

    public TimestampInfo getLastTimestampInfo() {
        if (this.m_timestamps != null && this.m_timestamps.size() > 0) {
            return (TimestampInfo)this.m_timestamps.get(this.m_timestamps.size() - 1);
        }
        return null;
    }

    public TimestampInfo getTimestampInfoOfType(int type) {
        for (int i = 0; this.m_timestamps != null && i < this.m_timestamps.size(); ++i) {
            TimestampInfo ts = (TimestampInfo)this.m_timestamps.get(i);
            if (ts.getType() != type) continue;
            return ts;
        }
        return null;
    }

    public TimestampInfo getOrCreateTimestampInfoOfType(int type) throws DigiDocException {
        TimestampInfo ts = this.getTimestampInfoOfType(type);
        if (ts == null) {
            ts = new TimestampInfo();
            ts.setType(type);
            this.addTimestampInfo(ts);
        }
        return ts;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String s) {
        this.m_path = s;
    }

    public String getProfile() {
        return this.m_profile;
    }

    public void setProfile(String s) {
        this.m_profile = s;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String s) {
        this.m_comment = s;
    }

    public void getConfirmation() throws DigiDocException {
        if (this.m_sigDoc.getFormat().equals("DIGIDOC-XML") || this.m_sigDoc.getFormat().equals("SK-XML")) {
            if (this.m_profile == null || this.m_profile.equalsIgnoreCase("TM")) {
                DigiDocGenFactory.finalizeXadesT(this.m_sigDoc, this);
                DigiDocGenFactory.finalizeXadesC(this.m_sigDoc, this);
                DigiDocGenFactory.finalizeXadesXL_TM(this.m_sigDoc, this);
            }
        } else {
            String profile = this.m_profile;
            if (profile == null) {
                profile = this.m_sigDoc.getProfile();
            }
            if (profile == null || profile.trim().length() == 0) {
                profile = ConfigManager.instance().getStringProperty("DIGIDOC_DEFAULT_PROFILE", "TM");
            }
            DigiDocGenFactory.finalizeSignature(this.m_sigDoc, this, this.m_signatureValue.getValue(), profile);
        }
        if (this.m_origContent != null) {
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this.m_sigDoc);
            String str = new String(this.m_origContent);
            int idx1 = str.indexOf("</SignedProperties>");
            if (idx1 != -1) {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    bos.write(this.m_origContent, 0, idx1);
                    bos.write("</SignedProperties>".getBytes());
                    bos.write(genFac.unsignedPropertiesToXML(this, this.m_unsigProp));
                    bos.write("</QualifyingProperties></Object></Signature>".getBytes());
                    this.m_origContent = bos.toByteArray();
                }
                catch (IOException ex) {
                    DigiDocException.handleException(ex, 66);
                }
            }
        }
    }

    public boolean hasBdoc2NoncePolicy() {
        Identifier id;
        return this.m_sigProp != null && this.m_sigProp.getSignaturePolicyIdentifier() != null && this.m_sigProp.getSignaturePolicyIdentifier().getSignaturePolicyId() != null && this.m_sigProp.getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyId() != null && this.m_sigProp.getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyId().getIdentifier() != null && (id = this.m_sigProp.getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyId().getIdentifier()).getQualifier().equals(Identifier.OIDAsURN) && id.getUri().equals(Identifier.BDOC_210_OID);
    }

    public boolean verify(SignedDoc sdoc, ArrayList lerrs) {
        boolean bOk1;
        boolean bOk = true;
        ArrayList lerrs1 = this.validate();
        if (lerrs1 != null && lerrs1.size() > 0) {
            bOk = false;
            if (lerrs != null) {
                lerrs.addAll(lerrs1);
            }
        }
        if (!(bOk1 = DigiDocVerifyFactory.verifySignature(sdoc, this, lerrs1 = new ArrayList()))) {
            bOk = false;
        }
        if (lerrs1 != null && lerrs1.size() > 0) {
            bOk = false;
            if (lerrs != null) {
                lerrs.addAll(lerrs1);
            }
        }
        return bOk;
    }

    public ArrayList verify(SignedDoc sdoc, boolean checkDate, boolean demandConfirmation) {
        Object do1 = null;
        Object dt1 = null;
        Object dt2 = null;
        ArrayList lerrs = new ArrayList();
        boolean bOk = DigiDocVerifyFactory.verifySignature(sdoc, this, lerrs);
        return lerrs;
    }

    public ArrayList validate() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateId(this.m_id);
        if (ex != null) {
            errs.add(ex);
        }
        ArrayList e = null;
        if (this.m_signedInfo != null) {
            e = this.m_signedInfo.validate();
        } else {
            errs.add(new DigiDocException(75, "Missing SignedInfo element", null));
        }
        if (e != null && !e.isEmpty()) {
            errs.addAll(e);
        }
        if (this.m_signatureValue != null) {
            e = this.m_signatureValue.validate();
        }
        if (e != null && !e.isEmpty()) {
            errs.addAll(e);
        }
        if (this.m_keyInfo != null) {
            e = this.m_keyInfo.validate();
        } else {
            errs.add(new DigiDocException(75, "Missing KeyInfo element", null));
        }
        if (e != null && !e.isEmpty()) {
            errs.addAll(e);
        }
        if (this.m_sigProp != null && !(e = this.m_sigProp.validate()).isEmpty()) {
            errs.addAll(e);
        }
        if (this.m_unsigProp != null && !(e = this.m_unsigProp.validate()).isEmpty()) {
            errs.addAll(e);
        }
        return errs;
    }

    public QualifyingProperties getQualifyingProperties() {
        return this.m_qualProp;
    }

    public void setQualifyingProperties(QualifyingProperties prop) {
        this.m_qualProp = prop;
    }

    public String getSubject() {
        return this.m_keyInfo.getSubjectFirstName() + " " + this.m_keyInfo.getSubjectLastName() + " " + this.m_keyInfo.getSubjectPersonalCode();
    }

    public ArrayList getErrors() {
        return this.m_errs;
    }

    public void setErrors(ArrayList l) {
        this.m_errs = l;
    }

    public String getStatus() {
        if (this.m_errs == null || this.m_errs.size() == 0) {
            if (this.m_signatureValue != null && this.m_signatureValue.getValue() != null) {
                return "OK";
            }
            return "INCOMPLETE";
        }
        return "ERROR";
    }

    public Date getSignatureProducedAtTime() {
        Notary not;
        if (this.m_unsigProp != null && (not = this.m_unsigProp.getNotary()) != null) {
            return not.getProducedAt();
        }
        return null;
    }

    public String toString() {
        try {
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this.m_sigDoc);
            return new String(genFac.signatureToXML(this), "UTF-8");
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error converting Signature to string: " + ex));
            return null;
        }
    }
}

