/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.KeyInfo;
import ee.sk.digidoc.Manifest;
import ee.sk.digidoc.ManifestFileEntry;
import ee.sk.digidoc.Reference;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignatureProductionPlace;
import ee.sk.digidoc.SignedInfo;
import ee.sk.digidoc.UnsignedProperties;
import ee.sk.digidoc.factory.DigiDocFactory;
import ee.sk.digidoc.factory.DigiDocGenFactory;
import ee.sk.digidoc.factory.DigiDocVerifyFactory;
import ee.sk.digidoc.factory.DigiDocXmlGenFactory;
import ee.sk.utils.ConfigManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.security.MessageDigest;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.log4j.Logger;

public class SignedDoc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_format;
    private String m_version;
    private ArrayList m_dataFiles;
    private ArrayList m_signatures;
    private Manifest m_manifest;
    private String m_mimeType;
    private String m_nsXmlDsig;
    private String m_nsXades;
    private String m_nsAsic;
    private String m_profile;
    private String m_comment;
    private Hashtable m_sigFormats;
    private long m_size;
    private String m_path;
    private String m_file;
    private static Logger m_logger = Logger.getLogger(SignedDoc.class);
    public static final String FORMAT_SK_XML = "SK-XML";
    public static final String FORMAT_DIGIDOC_XML = "DIGIDOC-XML";
    public static final String FORMAT_BDOC = "BDOC";
    public static final String FORMAT_BDOC_MIME = "application/vnd.bdoc";
    public static final String VERSION_1_0 = "1.0";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String BDOC_VERSION_1_0 = "1.0";
    public static final String BDOC_VERSION_1_1 = "1.1";
    public static final String BDOC_VERSION_2_1 = "2.1";
    public static final String BDOC_PROFILE_BES = "BES";
    public static final String BDOC_PROFILE_T = "T";
    public static final String BDOC_PROFILE_CL = "C-L";
    public static final String BDOC_PROFILE_TM = "TM";
    public static final String BDOC_PROFILE_TS = "TS";
    public static final String BDOC_PROFILE_TMA = "TM-A";
    public static final String BDOC_PROFILE_TSA = "TS-A";
    public static final String SHA1_DIGEST_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final String SHA1_DIGEST_TYPE = "SHA-1";
    public static final String SHA1_DIGEST_TYPE_BAD = "SHA-1-00";
    public static final String SHA256_DIGEST_ALGORITHM_1 = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String SHA256_DIGEST_ALGORITHM_2 = "http://www.w3.org/2001/04/xmldsig-more#sha256";
    public static final String SHA256_DIGEST_TYPE = "SHA-256";
    public static final String SHA224_DIGEST_TYPE = "SHA-224";
    public static final String SHA224_DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmldsig-more#sha224";
    public static final String SHA384_DIGEST_TYPE = "SHA-384";
    public static final String SHA384_DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmldsig-more#sha384";
    public static final String SHA512_DIGEST_TYPE = "SHA-512";
    public static final String SHA512_DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha512";
    public static final int SHA1_DIGEST_LENGTH = 20;
    public static final int SHA224_DIGEST_LENGTH = 28;
    public static final int SHA256_DIGEST_LENGTH = 32;
    public static final int SHA512_DIGEST_LENGTH = 64;
    public static final String CANONICALIZATION_METHOD_20010315 = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String CANONICALIZATION_METHOD_1_1 = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String CANONICALIZATION_METHOD_2010_10_EXC = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_20001026 = "http://www.w3.org/TR/2000/CR-xml-c14n-20001026";
    public static final String RSA_SHA1_SIGNATURE_METHOD = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final String RSA_SHA224_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha224";
    public static final String RSA_SHA256_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String RSA_SHA384_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
    public static final String RSA_SHA512_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
    public static final String ECDSA_SHA1_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1";
    public static final String ECDSA_SHA224_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224";
    public static final String ECDSA_SHA256_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
    public static final String ECDSA_SHA384_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
    public static final String ECDSA_SHA512_SIGNATURE_METHOD = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
    public static final String DIGIDOC_DETATCHED_TRANSFORM = "http://www.sk.ee/2002/10/digidoc#detatched-document-signature";
    public static final String ENVELOPED_TRANSFORM = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String SIGNEDPROPERTIES_TYPE = "http://uri.etsi.org/01903#SignedProperties";
    public static String xmlns_xmldsig = "http://www.w3.org/2000/09/xmldsig#";
    public static String xmlns_etsi = "http://uri.etsi.org/01903/v1.1.1#";
    public static String xmlns_digidoc13 = "http://www.sk.ee/DigiDoc/v1.3.0#";
    public static String xmlns_asic = "http://uri.etsi.org/02918/v1.2.1#";
    public static final String LIB_NAME = "JDigiDoc";
    public static final String LIB_VERSION = "${env.JDD_VERSION}";
    public static String xmlns_xades_123 = "http://uri.etsi.org/01903/v1.3.2#";
    public static final String SIG_FILE_NAME = "META-INF/signature";
    public static final String SIG_FILE_NAME_20 = "META-INF/signatures";
    public static final String MIMET_FILE_NAME = "mimetype";
    public static final String MIMET_FILE_CONTENT_10 = "application/vnd.bdoc-1.0";
    public static final String MIMET_FILE_CONTENT_11 = "application/vnd.bdoc-1.1";
    public static final String MIMET_FILE_CONTENT_20 = "application/vnd.etsi.asic-e+zip";
    public static final String MANIF_DIR_META_INF = "META-INF";
    public static final String MANIF_FILE_NAME = "META-INF/manifest.xml";
    public static final String MIME_SIGNATURE_BDOC_ = "signature/bdoc-";
    private static final String PEM_HDR1 = "-----BEGIN CERTIFICATE-----\n";
    private static final String PEM_HDR2 = "\n-----END CERTIFICATE-----";

    public SignedDoc() {
        this.m_format = null;
        this.m_version = null;
        this.m_dataFiles = null;
        this.m_signatures = null;
        this.m_manifest = null;
        this.m_mimeType = null;
        this.m_nsXmlDsig = null;
        this.m_nsXades = null;
        this.m_nsAsic = null;
        this.m_file = null;
        this.m_path = null;
        this.m_comment = null;
    }

    public SignedDoc(String format, String version) throws DigiDocException {
        this.setFormatAndVersion(format, version);
        this.m_dataFiles = null;
        this.m_signatures = null;
        this.m_manifest = null;
        this.m_mimeType = null;
        this.m_nsXmlDsig = null;
        this.m_nsXades = null;
        this.m_comment = null;
        if (format.equals(FORMAT_BDOC)) {
            this.m_manifest = new Manifest();
            ManifestFileEntry fe = new ManifestFileEntry(this.getManifestEntry(version), "/");
            this.m_manifest.addFileEntry(fe);
            this.setDefaultNsPref(FORMAT_BDOC);
        }
    }

    public void setDefaultNsPref(String format) {
        if (format.equals(FORMAT_BDOC)) {
            this.m_nsXmlDsig = "ds";
            this.m_nsXades = "xades";
            this.m_nsAsic = "asic";
        }
        if (format.equals(FORMAT_DIGIDOC_XML) || format.equals(FORMAT_SK_XML)) {
            this.m_nsXmlDsig = null;
            this.m_nsXades = null;
            this.m_nsAsic = null;
        }
    }

    private String getManifestEntry(String ver) {
        if (ver.equals("1.0")) {
            return MIMET_FILE_CONTENT_10;
        }
        if (ver.equals("1.1")) {
            return MIMET_FILE_CONTENT_11;
        }
        return MIMET_FILE_CONTENT_20;
    }

    public ManifestFileEntry findManifestEntryByPath(String fullPath) {
        return this.m_manifest.findFileEntryByPath(fullPath);
    }

    public String getFormat() {
        return this.m_format;
    }

    public void setFormat(String str) throws DigiDocException {
        DigiDocException ex = this.validateFormat(str);
        if (ex != null) {
            throw ex;
        }
        this.m_format = str;
    }

    public ArrayList getDataFiles() {
        return this.m_dataFiles;
    }

    public void setDataFiles(ArrayList l) {
        this.m_dataFiles = l;
    }

    public ArrayList getSignatures() {
        return this.m_signatures;
    }

    public long getSize() {
        return this.m_size;
    }

    public void setSize(long l) {
        this.m_size = l;
    }

    public String getFile() {
        return this.m_file;
    }

    public void setFile(String fname) {
        this.m_file = fname;
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String p) {
        this.m_path = p;
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String s) {
        this.m_comment = s;
    }

    public void addSignatureProfile(String sigId, String profile) {
        if (this.m_sigFormats == null) {
            this.m_sigFormats = new Hashtable();
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Register signature: " + sigId + " profile: " + profile));
        }
        this.m_sigFormats.put(sigId, profile);
    }

    public String findSignatureProfile(String sigId) {
        return this.m_sigFormats != null && sigId != null ? (String)this.m_sigFormats.get(sigId) : null;
    }

    public String getXmlDsigNs() {
        return this.m_nsXmlDsig;
    }

    public void setXmlDsigNs(String str) {
        this.m_nsXmlDsig = str;
    }

    public String getXadesNs() {
        return this.m_nsXades;
    }

    public void setXadesNs(String str) {
        this.m_nsXades = str;
    }

    public String getAsicNs() {
        return this.m_nsAsic;
    }

    public void setAsicNs(String str) {
        this.m_nsAsic = str;
    }

    public String getProfile() {
        return this.m_profile;
    }

    public void setProfile(String s) {
        this.m_profile = s;
    }

    private DigiDocException validateFormat(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(13, "Format attribute is mandatory!", null);
        } else {
            if (!(str.equals(FORMAT_BDOC) || str.equals(FORMAT_SK_XML) || str.equals(FORMAT_DIGIDOC_XML))) {
                ex = new DigiDocException(13, "Currently supports only SK-XML, DIGIDOC-XML and BDOC formats", null);
            }
            if (str.equals(FORMAT_BDOC)) {
                if (this.m_manifest == null) {
                    this.m_manifest = new Manifest();
                }
                if (this.m_manifest.findFileEntryByPath("/") == null) {
                    ManifestFileEntry fe = new ManifestFileEntry(this.getManifestEntry(this.m_version), "/");
                    this.m_manifest.addFileEntry(fe);
                }
                this.setDefaultNsPref(FORMAT_BDOC);
            }
        }
        return ex;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String str) throws DigiDocException {
        DigiDocException ex = this.validateVersion(str);
        if (ex != null) {
            throw ex;
        }
        this.m_version = str;
    }

    private DigiDocException validateVersion(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(13, "Version attribute is mandatory!", null);
        } else if (this.m_format != null) {
            if (this.m_format.equals(FORMAT_SK_XML) && !str.equals("1.0")) {
                ex = new DigiDocException(13, "Format SK-XML supports only version 1.0", null);
            }
            if (this.m_format.equals(FORMAT_DIGIDOC_XML) && !str.equals("1.1") && !str.equals(VERSION_1_2) && !str.equals(VERSION_1_3)) {
                ex = new DigiDocException(13, "Format DIGIDOC-XML supports only versions 1.1, 1.2, 1.3", null);
            }
            if (this.m_format.equals(FORMAT_BDOC) && !str.equals(BDOC_VERSION_2_1)) {
                ex = new DigiDocException(13, "Format BDOC supports only versions 2.1", null);
            }
        }
        return ex;
    }

    public void setFormatAndVersion(String sFormat, String sVersion) throws DigiDocException {
        this.m_format = sFormat;
        this.m_version = sVersion;
        DigiDocException ex = this.validateFormatAndVersion();
        if (ex != null) {
            throw ex;
        }
    }

    public DigiDocException validateFormatAndVersion() {
        Object ex = null;
        if (this.m_format == null || this.m_version == null) {
            return new DigiDocException(13, "Format and version attributes are mandatory!", null);
        }
        if (this.m_format.equals(FORMAT_DIGIDOC_XML) || this.m_format.equals(FORMAT_SK_XML)) {
            if (!this.m_version.equals(VERSION_1_3)) {
                return new DigiDocException(13, "Only format DIGIDOC-XML version 1.3 is supported!", null);
            }
        } else if (this.m_format.equals(FORMAT_BDOC)) {
            if (!this.m_version.equals(BDOC_VERSION_2_1)) {
                return new DigiDocException(13, "Format BDOC supports only versions 2.1", null);
            }
        } else {
            return new DigiDocException(13, "Invalid format attribute!", null);
        }
        return null;
    }

    public Manifest getManifest() {
        return this.m_manifest;
    }

    public void setManifest(Manifest m) {
        this.m_manifest = m;
    }

    public String getMimeType() {
        return this.m_mimeType;
    }

    public void setMimeType(String str) {
        this.m_mimeType = str;
    }

    public int countDataFiles() {
        return this.m_dataFiles == null ? 0 : this.m_dataFiles.size();
    }

    public void cleanupDfCache() {
        for (int i = 0; this.m_dataFiles != null && i < this.m_dataFiles.size(); ++i) {
            DataFile df = (DataFile)this.m_dataFiles.get(i);
            df.cleanupDfCache();
        }
    }

    public InputStream findDataFileAsStream(String dfName) {
        try {
            if (this.m_file != null) {
                ZipFile zis;
                ZipArchiveEntry ze;
                StringBuffer sbName = new StringBuffer();
                if (this.m_path != null) {
                    sbName.append(this.m_path);
                    sbName.append(File.separator);
                }
                sbName.append(this.m_file);
                File fZip = new File(sbName.toString());
                if (fZip.isFile() && fZip.canRead() && (ze = (zis = new ZipFile(fZip)).getEntry(dfName)) != null) {
                    return zis.getInputStream(ze);
                }
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading bdoc: " + ex));
        }
        return null;
    }

    public String getNewDataFileId() {
        int nDf = 0;
        String id = "D" + nDf;
        boolean bExists = false;
        do {
            bExists = false;
            for (int d = 0; d < this.countDataFiles(); ++d) {
                DataFile df = this.getDataFile(d);
                if (!df.getId().equals(id)) continue;
                id = "D" + ++nDf;
                bExists = true;
            }
        } while (bExists);
        return id;
    }

    public DataFile addDataFile(File inputFile, String mime, String contentType) throws DigiDocException {
        DigiDocException ex1 = this.validateFormatAndVersion();
        if (ex1 != null) {
            throw ex1;
        }
        boolean bExists = false;
        for (int i = 0; i < this.countDataFiles(); ++i) {
            DataFile df1 = this.getDataFile(i);
            if (!df1.getFileName().equals(inputFile.getName())) continue;
            bExists = true;
        }
        if (bExists && this.m_format.equals(FORMAT_BDOC)) {
            m_logger.error((Object)("Duplicate DataFile name: " + inputFile.getName()));
            throw new DigiDocException(28, "Duplicate DataFile filename: " + inputFile.getName(), null);
        }
        DataFile df = new DataFile(this.getNewDataFileId(), contentType, inputFile.getAbsolutePath(), mime, this);
        if (inputFile.canRead()) {
            df.setSize(inputFile.length());
        }
        this.addDataFile(df);
        if (this.m_format.equals(FORMAT_BDOC)) {
            df.setId(inputFile.getName());
        }
        return df;
    }

    public void writeToFile(File outputFile) throws DigiDocException {
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            this.writeToStream(os);
            ((OutputStream)os).close();
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public void writeToStream(OutputStream os) throws DigiDocException {
        DigiDocException ex1 = this.validateFormatAndVersion();
        if (ex1 != null) {
            throw ex1;
        }
        try {
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this);
            if (this.m_format.equals(FORMAT_BDOC)) {
                int i;
                ZipArchiveOutputStream zos = new ZipArchiveOutputStream(os);
                zos.setEncoding("UTF-8");
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("OS: " + (os != null ? "OK" : "NULL")));
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"Writing: mimetype");
                }
                ZipArchiveEntry ze = new ZipArchiveEntry(MIMET_FILE_NAME);
                if (this.m_comment == null) {
                    this.m_comment = DigiDocGenFactory.getUserInfo(this.m_format, this.m_version);
                }
                ze.setComment(this.m_comment);
                ze.setMethod(0);
                CRC32 crc = new CRC32();
                if (this.m_version.equals("1.0")) {
                    ze.setSize((long)MIMET_FILE_CONTENT_10.getBytes().length);
                    crc.update(MIMET_FILE_CONTENT_10.getBytes());
                }
                if (this.m_version.equals("1.1")) {
                    ze.setSize((long)MIMET_FILE_CONTENT_11.getBytes().length);
                    crc.update(MIMET_FILE_CONTENT_11.getBytes());
                }
                if (this.m_version.equals(BDOC_VERSION_2_1)) {
                    ze.setSize((long)MIMET_FILE_CONTENT_20.getBytes().length);
                    crc.update(MIMET_FILE_CONTENT_20.getBytes());
                }
                ze.setCrc(crc.getValue());
                zos.putArchiveEntry((ArchiveEntry)ze);
                if (this.m_version.equals("1.0")) {
                    zos.write(MIMET_FILE_CONTENT_10.getBytes());
                }
                if (this.m_version.equals("1.1")) {
                    zos.write(MIMET_FILE_CONTENT_11.getBytes());
                }
                if (this.m_version.equals(BDOC_VERSION_2_1)) {
                    zos.write(MIMET_FILE_CONTENT_20.getBytes());
                }
                zos.closeArchiveEntry();
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"Writing: META-INF/manifest.xml");
                }
                ze = new ZipArchiveEntry(MANIF_DIR_META_INF);
                ze = new ZipArchiveEntry(MANIF_FILE_NAME);
                ze.setComment(DigiDocGenFactory.getUserInfo(this.m_format, this.m_version));
                zos.putArchiveEntry((ArchiveEntry)ze);
                zos.write(this.m_manifest.toXML());
                zos.closeArchiveEntry();
                for (i = 0; i < this.countDataFiles(); ++i) {
                    DataFile df = this.getDataFile(i);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Writing DF: " + df.getFileName() + " content: " + df.getContentType() + " df-cache: " + (df.getDfCacheFile() != null ? df.getDfCacheFile().getAbsolutePath() : "NONE")));
                    }
                    InputStream is = null;
                    is = df.hasAccessToDataFile() ? df.getBodyAsStream() : this.findDataFileAsStream(df.getFileName());
                    if (is == null) continue;
                    File dfFile = new File(df.getFileName());
                    String fileName = dfFile.getName();
                    ze = new ZipArchiveEntry(fileName);
                    if (df.getComment() == null) {
                        df.setComment(DigiDocGenFactory.getUserInfo(this.m_format, this.m_version));
                    }
                    ze.setComment(df.getComment());
                    ze.setSize(dfFile.length());
                    ze.setTime(df.getLastModDt() != null ? df.getLastModDt().getTime() : dfFile.lastModified());
                    zos.putArchiveEntry((ArchiveEntry)ze);
                    byte[] data = new byte[2048];
                    int nRead = 0;
                    int nTotal = 0;
                    crc = new CRC32();
                    while ((nRead = is.read(data)) > 0) {
                        zos.write(data, 0, nRead);
                        nTotal += nRead;
                        crc.update(data, 0, nRead);
                    }
                    ze.setSize((long)nTotal);
                    ze.setCrc(crc.getValue());
                    zos.closeArchiveEntry();
                    is.close();
                }
                for (i = 0; i < this.countSignatures(); ++i) {
                    Signature sig = this.getSignature(i);
                    String sFileName = sig.getPath();
                    if (sFileName == null) {
                        sFileName = this.m_version.equals(BDOC_VERSION_2_1) ? SIG_FILE_NAME_20 + (i + 1) + ".xml" : SIG_FILE_NAME + (i + 1) + ".xml";
                    }
                    if (!sFileName.startsWith(MANIF_DIR_META_INF)) {
                        sFileName = "META-INF/" + sFileName;
                    }
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Writing SIG: " + sFileName + " orig: " + (sig.getOrigContent() != null ? "OK" : "NULL")));
                    }
                    ze = new ZipArchiveEntry(sFileName);
                    if (sig.getComment() == null) {
                        sig.setComment(DigiDocGenFactory.getUserInfo(this.m_format, this.m_version));
                    }
                    ze.setComment(sig.getComment());
                    String sSig = null;
                    sSig = sig.getOrigContent() != null ? new String(sig.getOrigContent(), "UTF-8") : sig.toString();
                    if (sSig != null && !sSig.startsWith("<?xml")) {
                        sSig = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + sSig;
                    }
                    byte[] sdata = sSig.getBytes("UTF-8");
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Writing SIG: " + sFileName + " xml:\n---\n " + (sSig != null ? sSig : "NULL") + "\n---\n "));
                    }
                    ze.setSize((long)sdata.length);
                    crc = new CRC32();
                    crc.update(sdata);
                    ze.setCrc(crc.getValue());
                    zos.putArchiveEntry((ArchiveEntry)ze);
                    zos.write(sdata);
                    zos.closeArchiveEntry();
                }
                zos.close();
            } else if (this.m_format.equals(FORMAT_DIGIDOC_XML)) {
                int i;
                os.write(this.xmlHeader().getBytes());
                for (i = 0; i < this.countDataFiles(); ++i) {
                    DataFile df = this.getDataFile(i);
                    df.writeToFile(os);
                    os.write("\n".getBytes());
                }
                for (i = 0; i < this.countSignatures(); ++i) {
                    Signature sig = this.getSignature(i);
                    if (sig.getOrigContent() != null) {
                        os.write(sig.getOrigContent());
                    } else {
                        os.write(genFac.signatureToXML(sig));
                    }
                    os.write("\n".getBytes());
                }
                os.write(this.xmlTrailer().getBytes());
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 11);
        }
    }

    public void addDataFile(DataFile df) throws DigiDocException {
        if (this.countSignatures() > 0) {
            throw new DigiDocException(14, "Cannot add DataFiles when signatures exist!", null);
        }
        boolean bExists = false;
        for (int i = 0; i < this.countDataFiles(); ++i) {
            DataFile df1 = this.getDataFile(i);
            if (!df1.getFileName().equals(df.getFileName())) continue;
            bExists = true;
        }
        if (bExists && this.m_format.equals(FORMAT_BDOC)) {
            m_logger.error((Object)("Duplicate DataFile name: " + df.getFileName()));
            throw new DigiDocException(28, "Duplicate DataFile filename: " + df.getFileName(), null);
        }
        if (this.m_format.equals(FORMAT_BDOC) && df.getFileName() != null) {
            df.setContentType("BINARY");
            String sFile = df.getFileName();
            if (sFile.indexOf(47) != -1 || sFile.indexOf(92) != -1) {
                File fT = new File(sFile);
                sFile = fT.getName();
            }
            if (this.findManifestEntryByPath(sFile) == null) {
                ManifestFileEntry fe = new ManifestFileEntry(df.getMimeType(), sFile);
                this.m_manifest.addFileEntry(fe);
            }
        }
        if (this.m_dataFiles == null) {
            this.m_dataFiles = new ArrayList();
        }
        if (df.getId() == null) {
            df.setId(this.getNewDataFileId());
        }
        this.m_dataFiles.add(df);
    }

    public DataFile getDataFile(int idx) {
        if (this.m_dataFiles != null && idx >= 0 && idx < this.m_dataFiles.size()) {
            return (DataFile)this.m_dataFiles.get(idx);
        }
        return null;
    }

    public DataFile getLastDataFile() {
        if (this.m_dataFiles != null && this.m_dataFiles.size() > 0) {
            return (DataFile)this.m_dataFiles.get(this.m_dataFiles.size() - 1);
        }
        return null;
    }

    public void removeDataFile(int idx) throws DigiDocException {
        if (this.countSignatures() > 0) {
            throw new DigiDocException(14, "Cannot remove DataFiles when signatures exist!", null);
        }
        DataFile df = this.getDataFile(idx);
        if (df != null) {
            this.m_dataFiles.remove(idx);
            if (this.m_manifest != null) {
                this.m_manifest.removeFileEntryWithPath(df.getFileName());
            }
        } else {
            throw new DigiDocException(29, "Invalid DataFile index!", null);
        }
    }

    public DataFile findDataFileById(String id) {
        for (int i = 0; this.m_dataFiles != null && i < this.m_dataFiles.size(); ++i) {
            DataFile df = (DataFile)this.m_dataFiles.get(i);
            if (df.getId() == null || id == null || !df.getId().equals(id)) continue;
            return df;
        }
        return null;
    }

    public int countSignatures() {
        return this.m_signatures == null ? 0 : this.m_signatures.size();
    }

    public String getNewSignatureId() {
        int nS = 0;
        String id = "S" + nS;
        boolean bExists = false;
        do {
            bExists = false;
            for (int i = 0; i < this.countSignatures(); ++i) {
                Signature sig = this.getSignature(i);
                if (!sig.getId().equals(id)) continue;
                id = "S" + ++nS;
                bExists = true;
            }
        } while (bExists);
        return id;
    }

    public Signature findSignatureById(String sigId) {
        for (int i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            if (!sig.getId().equals(sigId)) continue;
            return sig;
        }
        return null;
    }

    public Signature findSignatureByPath(String path) {
        for (int i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            if (sig.getPath() == null || !sig.getPath().equals(path)) continue;
            return sig;
        }
        return null;
    }

    public Signature prepareSignature(X509Certificate cert, String[] claimedRoles, SignatureProductionPlace adr) throws DigiDocException {
        DigiDocException ex1 = this.validateFormatAndVersion();
        if (ex1 != null) {
            throw ex1;
        }
        return DigiDocGenFactory.prepareXadesBES(this, this.m_profile, cert, claimedRoles, adr, null, null, null);
    }

    public Signature prepareXadesTSignature(X509Certificate cert, String sigDatId, byte[] sigDatHash) throws DigiDocException {
        Signature sig = new Signature(this);
        sig.setId(this.getNewSignatureId());
        SignedInfo si = new SignedInfo(sig, RSA_SHA1_SIGNATURE_METHOD, CANONICALIZATION_METHOD_20010315);
        Reference ref = new Reference(si, "#" + sigDatId, SHA1_DIGEST_ALGORITHM, sigDatHash, TRANSFORM_20001026);
        si.addReference(ref);
        sig.setSignedInfo(si);
        KeyInfo ki = new KeyInfo(cert);
        sig.setKeyInfo(ki);
        ki.setSignature(sig);
        CertValue cval = new CertValue(null, cert, 1, sig);
        sig.addCertValue(cval);
        CertID cid = new CertID(sig, cert, 1);
        sig.addCertID(cid);
        this.addSignature(sig);
        UnsignedProperties usp = new UnsignedProperties(sig, null, null);
        sig.setUnsignedProperties(usp);
        return sig;
    }

    public void addSignature(Signature sig) {
        if (this.m_signatures == null) {
            this.m_signatures = new ArrayList();
        }
        this.m_signatures.add(sig);
        if (this.m_format != null && this.m_format.equals(FORMAT_BDOC)) {
            Signature sig1 = null;
            if (sig.getPath() != null) {
                sig1 = this.findSignatureByPath(sig.getPath());
            }
            if (sig1 == null) {
                if (this.m_version.equals(BDOC_VERSION_2_1)) {
                    sig.setPath(SIG_FILE_NAME_20 + this.m_signatures.size() + ".xml");
                } else {
                    sig.setPath(SIG_FILE_NAME + this.m_signatures.size() + ".xml");
                }
                if (!this.m_version.equals(BDOC_VERSION_2_1)) {
                    ManifestFileEntry fe = new ManifestFileEntry(MIME_SIGNATURE_BDOC_ + this.m_version + "/" + sig.getProfile(), SIG_FILE_NAME + this.m_signatures.size() + ".xml");
                    this.m_manifest.addFileEntry(fe);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Register in manifest new signature: " + sig.getId()));
                    }
                }
            }
        }
    }

    public void readSignature(InputStream is) throws DigiDocException {
        DigiDocFactory ddfac = ConfigManager.instance().getDigiDocFactory();
        Signature sig = ddfac.readSignature(this, is);
    }

    public Signature getSignature(int idx) {
        if (this.m_signatures != null && idx >= 0 && idx < this.m_signatures.size()) {
            return (Signature)this.m_signatures.get(idx);
        }
        return null;
    }

    public void removeSignature(int idx) throws DigiDocException {
        if (this.m_signatures == null || idx < 0 || idx >= this.m_signatures.size()) {
            throw new DigiDocException(36, "Invalid signature index: " + idx, null);
        }
        this.m_signatures.remove(idx);
    }

    public Signature getLastSignature() {
        if (this.m_signatures != null && this.m_signatures.size() > 0) {
            return (Signature)this.m_signatures.get(this.m_signatures.size() - 1);
        }
        return null;
    }

    public void removeLastSiganture() {
        if (this.m_signatures.size() > 0) {
            this.m_signatures.remove(this.m_signatures.size() - 1);
        }
    }

    public int removeSignaturesWithoutValue() {
        int nRemove = 0;
        boolean bOk = true;
        do {
            bOk = true;
            for (int i = 0; this.m_signatures != null && i < this.m_signatures.size() && bOk; ++i) {
                Signature sig = (Signature)this.m_signatures.get(i);
                if (sig.getSignatureValue() != null && sig.getSignatureValue().getValue() != null && sig.getSignatureValue().getValue().length != 0) continue;
                this.m_signatures.remove(sig);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Remove invalid sig: " + sig.getId()));
                }
                bOk = false;
                ++nRemove;
            }
        } while (!bOk);
        return nRemove;
    }

    public ArrayList validate(boolean bStrong) {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateFormat(this.m_format);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateVersion(this.m_version)) != null) {
            errs.add(ex);
        }
        if (this.m_format != null && this.m_version != null && (this.m_format.equals(FORMAT_SK_XML) || this.m_format.equals(FORMAT_DIGIDOC_XML) && (this.m_version.equals("1.1") || this.m_version.equals(VERSION_1_2)) || this.m_format.equals(FORMAT_BDOC) && (this.m_version.equals("1.0") || this.m_version.equals("1.1")))) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Old and unsupported format: " + this.m_format + " version: " + this.m_version));
            }
            ex = new DigiDocException(177, "Old and unsupported format: " + this.m_format + " version: " + this.m_version, null);
            errs.add(ex);
        }
        if (this.m_profile != null && (this.m_profile.equals(BDOC_PROFILE_T) || this.m_profile.equals(BDOC_PROFILE_TS) || this.m_profile.equals(BDOC_PROFILE_TSA))) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)"T, TS and TSA profiles are currently not supported!");
            }
            ex = new DigiDocException(81, "T, TS and TSA profiles are currently not supported!", null);
            errs.add(ex);
        }
        try {
            ArrayList e;
            int i;
            if (this.getFormat() != null && this.getFormat().equals(FORMAT_BDOC)) {
                DigiDocVerifyFactory.verifyManifestEntries(this, errs);
            }
            for (i = 0; i < this.countDataFiles(); ++i) {
                DataFile df = this.getDataFile(i);
                e = df.validate(bStrong);
                if (e.isEmpty()) continue;
                errs.addAll(e);
            }
            for (i = 0; i < this.countSignatures(); ++i) {
                Signature sig = this.getSignature(i);
                e = sig.validate();
                if (e.isEmpty()) continue;
                errs.addAll(e);
            }
            for (i = 0; i < this.countSignatures(); ++i) {
                Signature sig1 = this.getSignature(i);
                for (int j = 0; j < this.countSignatures(); ++j) {
                    Signature sig2 = this.getSignature(j);
                    if (this.getFormat() == null || !this.getFormat().equals(FORMAT_BDOC) || sig2.getId() == null || sig1.getId() == null || sig2.getId().equals(sig1.getId()) || sig2.getPath() == null || sig1.getPath() == null || !sig2.getPath().equals(sig1.getPath())) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Signatures: " + sig1.getId() + " and " + sig2.getId() + " are in same file: " + sig1.getPath()));
                    }
                    ex = new DigiDocException(75, "More than one signature in signatures.xml file is unsupported", null);
                    errs.add(ex);
                }
            }
        }
        catch (DigiDocException ex2) {
            errs.add(ex2);
        }
        return errs;
    }

    public static boolean hasFatalErrs(ArrayList lerrs) {
        for (int i = 0; lerrs != null && i < lerrs.size(); ++i) {
            DigiDocException ex = (DigiDocException)lerrs.get(i);
            if (ex.getCode() != 75) continue;
            return true;
        }
        return false;
    }

    public ArrayList verify(boolean checkDate, boolean demandConfirmation) {
        ArrayList errs = this.validate(true);
        if (SignedDoc.hasFatalErrs(errs)) {
            return errs;
        }
        for (int i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            ArrayList e = sig.verify(this, checkDate, demandConfirmation);
            if (e.isEmpty()) continue;
            errs.addAll(e);
        }
        if (this.countSignatures() == 0) {
            errs.add(new DigiDocException(98, "This document is not signed!", null));
        }
        return errs;
    }

    private String xmlHeader() {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (this.m_format.equals(FORMAT_DIGIDOC_XML)) {
            sb.append("<SignedDoc format=\"");
            sb.append(this.m_format);
            sb.append("\" version=\"");
            sb.append(this.m_version);
            sb.append("\"");
            if (this.m_version.equals(VERSION_1_3)) {
                sb.append(" xmlns=\"");
                sb.append(xmlns_digidoc13);
                sb.append("\"");
            }
            sb.append(">\n");
        }
        return sb.toString();
    }

    private String xmlTrailer() {
        if (this.m_format.equals(FORMAT_DIGIDOC_XML)) {
            return "\n</SignedDoc>";
        }
        return "";
    }

    public String toXML() throws DigiDocException {
        String str;
        int i;
        StringBuffer sb = new StringBuffer(this.xmlHeader());
        for (i = 0; i < this.countDataFiles(); ++i) {
            DataFile df = this.getDataFile(i);
            str = df.toString();
            sb.append(str);
            sb.append("\n");
        }
        for (i = 0; i < this.countSignatures(); ++i) {
            Signature sig = this.getSignature(i);
            str = sig.toString();
            sb.append(str);
            sb.append("\n");
        }
        sb.append(this.xmlTrailer());
        return sb.toString();
    }

    public String toString() {
        String str = null;
        try {
            str = this.toXML();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static byte[] digest(byte[] data) throws DigiDocException {
        return SignedDoc.digestOfType(data, SHA1_DIGEST_TYPE);
    }

    public static byte[] digestOfType(byte[] data, String digType) throws DigiDocException {
        byte[] dig = null;
        try {
            MessageDigest sha = MessageDigest.getInstance(digType, "BC");
            sha.update(data);
            dig = sha.digest();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 54);
        }
        return dig;
    }

    private static String getDnPart(String sDn, String sField, String sOid) {
        if (sDn != null && sDn.length() > 0) {
            String s = sField + "=";
            boolean bQ = false;
            int n1 = sDn.toUpperCase().indexOf(s.toUpperCase());
            if (n1 == -1 && sOid != null) {
                s = "OID." + sOid + "=";
                n1 = sDn.toUpperCase().indexOf(s.toUpperCase());
            }
            if (n1 >= 0) {
                int n2;
                if (sDn.charAt(n1 += s.length()) == '\"') {
                    bQ = true;
                    ++n1;
                }
                if ((n2 = sDn.indexOf(bQ ? "\", " : ", ", n1)) == -1) {
                    n2 = sDn.length();
                }
                if (n2 > n1 && n2 <= sDn.length()) {
                    return sDn.substring(n1, n2);
                }
            }
        }
        return null;
    }

    public static String getSubjectFirstName(X509Certificate cert) {
        String dn = SignedDoc.getDN(cert);
        String name = null;
        String cn = SignedDoc.getDnPart(dn, "CN", null);
        if (cn != null) {
            int idx2;
            int idx1;
            for (idx1 = 0; idx1 < cn.length() && cn.charAt(idx1) != ','; ++idx1) {
            }
            if (idx1 < cn.length()) {
                ++idx1;
            }
            for (idx2 = idx1; idx2 < cn.length() && cn.charAt(idx2) != ',' && cn.charAt(idx2) != '/'; ++idx2) {
            }
            name = cn.substring(idx1, idx2);
        }
        return name;
    }

    public static String getSubjectLastName(X509Certificate cert) {
        String dn = SignedDoc.getDN(cert);
        String name = null;
        String cn = SignedDoc.getDnPart(dn, "CN", null);
        if (cn != null) {
            int idx2;
            int idx1;
            for (idx1 = 0; idx1 < cn.length() && !Character.isLetter(cn.charAt(idx1)); ++idx1) {
            }
            for (idx2 = idx1; idx2 < cn.length() && cn.charAt(idx2) != ',' && dn.charAt(idx2) != '/'; ++idx2) {
            }
            name = cn.substring(idx1, idx2);
        }
        return name;
    }

    public static String getSubjectPersonalCode(X509Certificate cert) {
        String dn = SignedDoc.getDN(cert);
        String code = SignedDoc.getDnPart(dn, "SERIALNUMBER", "2.5.4.5");
        if (code != null) {
            return code;
        }
        String cn = SignedDoc.getDnPart(dn, "CN", null);
        if (cn != null) {
            int idx2;
            int idx1;
            for (idx1 = 0; idx1 < cn.length() && !Character.isDigit(cn.charAt(idx1)); ++idx1) {
            }
            for (idx2 = idx1; idx2 < cn.length() && Character.isDigit(cn.charAt(idx2)); ++idx2) {
            }
            if (idx2 > idx1 + 7) {
                code = cn.substring(idx1, idx2);
            }
        }
        return code;
    }

    private static String getDN(X509Certificate cert) {
        return cert.getSubjectX500Principal().getName("RFC1779");
    }

    public static String getCommonName(String dn) {
        return SignedDoc.getDnPart(dn, "CN", null);
    }

    public static X509Certificate readCertificate(byte[] data) throws DigiDocException {
        X509Certificate cert = null;
        try {
            ByteArrayInputStream certStream = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(certStream);
            certStream.close();
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading certificate: " + ex));
            return null;
        }
        return cert;
    }

    public static byte[] readFile(File inFile) throws IOException, FileNotFoundException {
        byte[] data = null;
        FileInputStream is = new FileInputStream(inFile);
        DataInputStream dis = new DataInputStream(is);
        data = new byte[dis.available()];
        dis.readFully(data);
        dis.close();
        is.close();
        return data;
    }

    public static X509Certificate readCertificate(File certFile) throws DigiDocException {
        X509Certificate cert = null;
        try {
            FileInputStream fis = new FileInputStream(certFile);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)certificateFactory.generateCertificate(fis);
            fis.close();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeCertificate(X509Certificate cert, File certFile) throws DigiDocException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(certFile);
            fos.write(PEM_HDR1.getBytes());
            fos.write(Base64Util.encode(cert.getEncoded()).getBytes());
            fos.write(PEM_HDR2.getBytes());
            fos.close();
            fos = null;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ex2) {
                    m_logger.error((Object)("Error closing streams: " + ex2));
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate readCertificate(String certLocation) throws DigiDocException {
        X509Certificate cert = null;
        InputStream isCert = null;
        try {
            URL url = null;
            if (certLocation.startsWith("http")) {
                url = new URL(certLocation);
                isCert = url.openStream();
            } else if (certLocation.startsWith("jar://")) {
                ClassLoader cl = ConfigManager.instance().getClass().getClassLoader();
                isCert = cl.getResourceAsStream(certLocation.substring(6));
            } else {
                isCert = new FileInputStream(certLocation);
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)certificateFactory.generateCertificate(isCert);
            isCert.close();
            isCert = null;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 10);
        }
        finally {
            if (isCert != null) {
                try {
                    isCert.close();
                }
                catch (Exception ex2) {
                    m_logger.error((Object)("Error closing streams: " + ex2));
                }
            }
        }
        return cert;
    }

    public static boolean compareDigests(byte[] dig1, byte[] dig2) {
        boolean ok = dig1 != null && dig2 != null && dig1.length == dig2.length;
        for (int i = 0; ok && i < dig1.length; ++i) {
            if (dig1[i] == dig2[i]) continue;
            ok = false;
        }
        return ok;
    }

    public static byte[] hex2bin(String hexString) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            for (int i = 0; hexString != null && i < hexString.length(); i += 2) {
                String tmp = hexString.substring(i, i + 2);
                Integer x = new Integer(Integer.parseInt(tmp, 16));
                bos.write(x.byteValue());
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error converting hex string: " + ex));
        }
        return bos.toByteArray();
    }

    public static String bin2hex(byte[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            String str = Integer.toHexString(arr[i]);
            if (str.length() == 2) {
                sb.append(str);
            }
            if (str.length() < 2) {
                sb.append("0");
                sb.append(str);
            }
            if (str.length() <= 2) continue;
            sb.append(str.substring(str.length() - 2));
        }
        return sb.toString();
    }
}

