/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DataObjectFormat;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Reference;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.SignedProperties;
import ee.sk.digidoc.factory.CanonicalizationFactory;
import ee.sk.digidoc.factory.DigiDocXmlGenFactory;
import ee.sk.utils.ConfigManager;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class SignedInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String m_id = null;
    private Signature m_signature;
    private String m_signatureMethod;
    private String m_canonicalizationMethod;
    private ArrayList m_references;
    private byte[] m_origDigest;
    private byte[] m_origXml;

    public SignedInfo(Signature sig) {
        this.m_signature = sig;
        this.m_signatureMethod = null;
        this.m_canonicalizationMethod = null;
        this.m_references = null;
        this.m_origDigest = null;
        this.m_origXml = null;
    }

    public SignedInfo(Signature sig, String signatureMethod, String canonicalizationMethod) throws DigiDocException {
        this.m_signature = sig;
        this.setSignatureMethod(signatureMethod);
        this.setCanonicalizationMethod(canonicalizationMethod);
        this.m_references = null;
        this.m_origDigest = null;
    }

    public Signature getSignature() {
        return this.m_signature;
    }

    public void setSignature(Signature sig) {
        this.m_signature = sig;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) {
        this.m_id = str;
    }

    public byte[] getOrigDigest() {
        return this.m_origDigest;
    }

    public void setOrigDigest(byte[] data) {
        this.m_origDigest = data;
    }

    public byte[] getOrigXml() {
        return this.m_origXml;
    }

    public void setOrigXml(byte[] b) {
        this.m_origXml = b;
    }

    public String getSignatureMethod() {
        return this.m_signatureMethod;
    }

    public void setSignatureMethod(String str) throws DigiDocException {
        DigiDocException ex = this.validateSignatureMethod(str);
        if (ex != null) {
            throw ex;
        }
        this.m_signatureMethod = str;
    }

    private DigiDocException validateSignatureMethod(String str) {
        DigiDocException ex = null;
        if (!(str != null && (str.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || str.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224") || str.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || str.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || str.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || str.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || str.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || str.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")))) {
            ex = new DigiDocException(24, "Currently supports only RSA-SHA1, RSA-SHA224, RSA-SHA256, RSA-SHA512, ECDSA-SHA1, ECDSA-SHA224, ECDSA-SHA256 and ECDSA-SHA512 signatures", null);
        }
        return ex;
    }

    public String getCanonicalizationMethod() {
        return this.m_canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String str) throws DigiDocException {
        DigiDocException ex = this.validateCanonicalizationMethod(str);
        if (ex != null) {
            throw ex;
        }
        this.m_canonicalizationMethod = str;
    }

    private DigiDocException validateCanonicalizationMethod(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") && !str.equals("http://www.w3.org/2006/12/xml-c14n11") && !str.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            ex = new DigiDocException(25, "Currently supports only Canonical XML 1.0, 1.1 and exc", null);
        }
        return ex;
    }

    public int countReferences() {
        return this.m_references == null ? 0 : this.m_references.size();
    }

    public void addReference(Reference ref) {
        if (this.m_references == null) {
            this.m_references = new ArrayList();
        }
        this.m_references.add(ref);
    }

    public Reference getReference(int idx) {
        return (Reference)this.m_references.get(idx);
    }

    public Reference getReferenceForDataFile(DataFile df) {
        Reference ref = null;
        String fName = null;
        if (df.getFileName() != null) {
            File fT = new File(df.getFileName());
            fName = fT.getName();
        }
        for (int i = 0; this.m_references != null && i < this.m_references.size(); ++i) {
            Reference r1 = (Reference)this.m_references.get(i);
            if (r1.getUri().equals("/" + df.getId())) {
                ref = r1;
                break;
            }
            if (r1.getUri().equals(df.getId()) || r1.getUri().equals(df.getFileName()) || r1.getUri().equals(fName)) {
                ref = r1;
                break;
            }
            if (!r1.getUri().equals("#" + df.getId())) continue;
            ref = r1;
            break;
        }
        return ref;
    }

    public Reference getReferenceForSignedProperties(SignedProperties sp) {
        Reference ref = null;
        for (int i = 0; this.m_references != null && i < this.m_references.size(); ++i) {
            Reference r1 = (Reference)this.m_references.get(i);
            if (!r1.getUri().equals("#" + sp.getId())) continue;
            ref = r1;
            break;
        }
        return ref;
    }

    public Reference getReferenceForDataObjectFormat(DataObjectFormat dof) {
        Reference ref = null;
        String sUri = dof.getObjectReference();
        if (sUri.startsWith("#")) {
            sUri = sUri.substring(1);
        }
        for (int i = 0; this.m_references != null && i < this.m_references.size(); ++i) {
            Reference r1 = (Reference)this.m_references.get(i);
            if (!r1.getId().equals(sUri)) continue;
            ref = r1;
            break;
        }
        return ref;
    }

    public DataObjectFormat getDataObjectFormatForReference(Reference ref) {
        if (this.getSignature().getSignedProperties() != null && this.getSignature().getSignedProperties().getSignedDataObjectProperties() != null) {
            for (int i = 0; i < this.getSignature().getSignedProperties().getSignedDataObjectProperties().countDataObjectFormats(); ++i) {
                DataObjectFormat dof = this.getSignature().getSignedProperties().getSignedDataObjectProperties().getDataObjectFormat(i);
                if (!dof.getObjectReference().equals("#" + ref.getId())) continue;
                return dof;
            }
        }
        return null;
    }

    public Reference getLastReference() {
        return (Reference)this.m_references.get(this.m_references.size() - 1);
    }

    private ArrayList validateReferences() {
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        if (this.countReferences() < 2) {
            errs.add(new DigiDocException(26, "At least 2 References are required!", null));
        } else {
            for (int i = 0; i < this.countReferences(); ++i) {
                Reference ref = this.getReference(i);
                ArrayList e = ref.validate();
                if (e.isEmpty()) continue;
                errs.addAll(e);
            }
        }
        return errs;
    }

    public ArrayList validate() {
        ArrayList e;
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateSignatureMethod(this.m_signatureMethod);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateCanonicalizationMethod(this.m_canonicalizationMethod)) != null) {
            errs.add(ex);
        }
        if (!(e = this.validateReferences()).isEmpty()) {
            errs.addAll(e);
        }
        return errs;
    }

    public byte[] calculateDigest() throws DigiDocException {
        if (this.m_origDigest == null) {
            CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this.m_signature.getSignedDoc());
            byte[] xml = genFac.signedInfoToXML(this.m_signature, this);
            byte[] tmp = canFac.canonicalize(xml, this.m_canonicalizationMethod);
            byte[] hash = null;
            if (this.m_signatureMethod.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1")) {
                hash = SignedDoc.digestOfType(tmp, "SHA-1");
            }
            if (this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256")) {
                hash = SignedDoc.digestOfType(tmp, "SHA-256");
            }
            if (this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224") || this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224")) {
                hash = SignedDoc.digestOfType(tmp, "SHA-224");
            }
            if (this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384") || this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384")) {
                hash = SignedDoc.digestOfType(tmp, "SHA-384");
            }
            if (this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || this.m_signatureMethod.equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")) {
                hash = SignedDoc.digestOfType(tmp, "SHA-512");
            }
            return hash;
        }
        return this.m_origDigest;
    }
}

