/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignaturePolicyIdentifier;
import ee.sk.digidoc.SignatureProductionPlace;
import ee.sk.digidoc.SignedDataObjectProperties;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.CanonicalizationFactory;
import ee.sk.digidoc.factory.DigiDocXmlGenFactory;
import ee.sk.utils.ConfigManager;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;

public class SignedProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Signature m_sig;
    private String m_id;
    private String m_target;
    private Date m_signingTime;
    private String m_certDigestAlgorithm;
    private String m_certId;
    private byte[] m_certDigestValue;
    private BigInteger m_certSerial;
    private SignatureProductionPlace m_address;
    private ArrayList m_claimedRoles;
    private byte[] m_origDigest;
    private SignaturePolicyIdentifier m_signaturePolicyIdentifier;
    private ArrayList m_dataObjectFormats;
    private SignedDataObjectProperties m_sigDataObjectProp;

    public SignedProperties(Signature sig) {
        this.m_sig = sig;
        this.m_id = null;
        this.m_target = null;
        this.m_signingTime = null;
        this.m_certDigestAlgorithm = null;
        this.m_certDigestValue = null;
        this.m_certSerial = null;
        this.m_claimedRoles = null;
        this.m_address = null;
        this.m_certId = null;
        this.m_origDigest = null;
        this.m_signaturePolicyIdentifier = null;
        this.m_sigDataObjectProp = null;
    }

    public SignedProperties(Signature sig, String id, String target, Date signingTime, String certId, String certDigAlg, byte[] digest, BigInteger serial) throws DigiDocException {
        this.m_sig = sig;
        this.setId(id);
        this.setTarget(target);
        this.setSigningTime(signingTime);
        this.setCertId(certId);
        this.setCertDigestAlgorithm(certDigAlg);
        this.setCertDigestValue(digest);
        this.setCertSerial(serial);
        this.m_claimedRoles = null;
        this.m_address = null;
        this.m_origDigest = null;
        this.m_signaturePolicyIdentifier = null;
        this.m_sigDataObjectProp = null;
    }

    public SignedProperties(Signature sig, X509Certificate cert, String[] claimedRoles, SignatureProductionPlace adr) throws DigiDocException {
        this.m_sig = sig;
        this.setId(sig.getId() + "-SignedProperties");
        this.setTarget("#" + sig.getId());
        this.setSigningTime(new Date());
        this.setCertId(sig.getId() + "-CERTINFO");
        try {
            String sDigType = ConfigManager.instance().getDefaultDigestType(sig.getSignedDoc());
            String sDigAlg = ConfigManager.digType2Alg(sDigType);
            this.setCertDigestAlgorithm(sDigAlg);
            this.setCertDigestValue(SignedDoc.digestOfType(cert.getEncoded(), sDigType));
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 54);
        }
        this.setCertSerial(cert.getSerialNumber());
        if (claimedRoles != null && claimedRoles.length > 0) {
            for (int i = 0; i < claimedRoles.length; ++i) {
                this.addClaimedRole(claimedRoles[i]);
            }
        }
        if (adr != null) {
            this.setSignatureProductionPlace(adr);
        }
        this.m_origDigest = null;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String str) throws DigiDocException {
        DigiDocException ex = this.validateId(str);
        if (ex != null) {
            throw ex;
        }
        this.m_id = str;
    }

    public byte[] getOrigDigest() {
        return this.m_origDigest;
    }

    public void setOrigDigest(byte[] data) {
        this.m_origDigest = data;
    }

    private DigiDocException validateId(String str) {
        DigiDocException ex = null;
        if (str == null) {
            ex = new DigiDocException(43, "Id must not be empty", null);
        }
        return ex;
    }

    public String getTarget() {
        return this.m_target;
    }

    public void setTarget(String str) throws DigiDocException {
        DigiDocException ex = this.validateTarget(str);
        if (ex != null) {
            throw ex;
        }
        this.m_target = str;
    }

    private DigiDocException validateTarget(String str) {
        DigiDocException ex = null;
        if (str == null && this.m_sig.getSignedDoc().getFormat().equals("DIGIDOC-XML") && !this.m_sig.getSignedDoc().getVersion().equals("1.3")) {
            ex = new DigiDocException(44, "Target must be in form: #<signature-id>", null);
        }
        return ex;
    }

    public String getCertId() {
        return this.m_certId;
    }

    public void setCertId(String str) throws DigiDocException {
        DigiDocException ex;
        if (this.m_sig.getSignedDoc() != null && !this.m_sig.getSignedDoc().getFormat().equals("BDOC") && !this.m_sig.getSignedDoc().getVersion().equals("1.3") && (ex = this.validateCertId(str)) != null) {
            throw ex;
        }
        this.m_certId = str;
    }

    private DigiDocException validateCertId(String str) {
        DigiDocException ex = null;
        if (str == null && !this.m_sig.getSignedDoc().getFormat().equals("BDOC")) {
            ex = new DigiDocException(46, "Cert Id must be in form: <signature-id>-CERTINFO", null);
        }
        return ex;
    }

    public SignatureProductionPlace getSignatureProductionPlace() {
        return this.m_address;
    }

    public void setSignatureProductionPlace(SignatureProductionPlace adr) throws DigiDocException {
        this.m_address = adr;
    }

    public SignaturePolicyIdentifier getSignaturePolicyIdentifier() {
        return this.m_signaturePolicyIdentifier;
    }

    public void setSignaturePolicyIdentifier(SignaturePolicyIdentifier spi) throws DigiDocException {
        this.m_signaturePolicyIdentifier = spi;
    }

    public Date getSigningTime() {
        return this.m_signingTime;
    }

    public void setSigningTime(Date d) throws DigiDocException {
        DigiDocException ex = this.validateSigningTime(d);
        if (ex != null) {
            throw ex;
        }
        this.m_signingTime = d;
    }

    private DigiDocException validateSigningTime(Date d) {
        DigiDocException ex = null;
        if (d == null) {
            ex = new DigiDocException(40, "Singing time cannot be empty!", null);
        }
        return ex;
    }

    public String getCertDigestAlgorithm() {
        return this.m_certDigestAlgorithm;
    }

    public void setCertDigestAlgorithm(String str) throws DigiDocException {
        DigiDocException ex = this.validateCertDigestAlgorithm(str);
        if (ex != null) {
            throw ex;
        }
        this.m_certDigestAlgorithm = str;
    }

    private DigiDocException validateCertDigestAlgorithm(String str) {
        DigiDocException ex = null;
        if (str == null || !str.equals("http://www.w3.org/2000/09/xmldsig#sha1") && !str.equals("http://www.w3.org/2001/04/xmlenc#sha256") && !str.equals("http://www.w3.org/2001/04/xmldsig-more#sha256") && !str.equals("http://www.w3.org/2001/04/xmlenc#sha512")) {
            ex = new DigiDocException(20, "Currently supports only SHA1, SHA256 or SHA256 digest algorithm", null);
        }
        return ex;
    }

    public byte[] getCertDigestValue() {
        return this.m_certDigestValue;
    }

    public void setCertDigestValue(byte[] data) throws DigiDocException {
        DigiDocException ex = this.validateCertDigestValue(data);
        if (ex != null) {
            throw ex;
        }
        this.m_certDigestValue = data;
    }

    private DigiDocException validateCertDigestValue(byte[] data) {
        DigiDocException ex = null;
        if (data == null || data.length != 20 && data.length != 32 && data.length != 64) {
            ex = new DigiDocException(21, "Invalid digest length", null);
        }
        return ex;
    }

    public BigInteger getCertSerial() {
        return this.m_certSerial;
    }

    public void setCertSerial(BigInteger i) throws DigiDocException {
        DigiDocException ex = this.validateCertSerial(i);
        if (ex != null) {
            throw ex;
        }
        this.m_certSerial = i;
    }

    private DigiDocException validateCertSerial(BigInteger i) {
        DigiDocException ex = null;
        if (i == null) {
            ex = new DigiDocException(42, "Certificates serial number cannot be empty!", null);
        }
        return ex;
    }

    public int countClaimedRoles() {
        return this.m_claimedRoles == null ? 0 : this.m_claimedRoles.size();
    }

    public void addClaimedRole(String role) {
        if (this.m_claimedRoles == null) {
            this.m_claimedRoles = new ArrayList();
        }
        this.m_claimedRoles.add(role);
    }

    public String getClaimedRole(int idx) {
        return (String)this.m_claimedRoles.get(idx);
    }

    public SignedDataObjectProperties getSignedDataObjectProperties() {
        return this.m_sigDataObjectProp;
    }

    public void setSignedDataObjectProperties(SignedDataObjectProperties sigDataObjProp) {
        this.m_sigDataObjectProp = sigDataObjProp;
    }

    public ArrayList validate() {
        ArrayList errs2;
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        DigiDocException ex = this.validateId(this.m_id);
        if (ex != null) {
            errs.add(ex);
        }
        if ((ex = this.validateTarget(this.m_target)) != null) {
            errs.add(ex);
        }
        if (!this.m_sig.getSignedDoc().getVersion().equals("1.3") && (ex = this.validateCertId(this.m_certId)) != null) {
            errs.add(ex);
        }
        if (this.m_claimedRoles != null && this.m_claimedRoles.size() > 2) {
            ex = new DigiDocException(167, "Currently supports no more than 2 ClaimedRoles", null);
            errs.add(ex);
        }
        if ((ex = this.validateSigningTime(this.m_signingTime)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateCertDigestAlgorithm(this.m_certDigestAlgorithm)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateCertDigestValue(this.m_certDigestValue)) != null) {
            errs.add(ex);
        }
        if ((ex = this.validateCertSerial(this.m_certSerial)) != null) {
            errs.add(ex);
        }
        if (this.m_sigDataObjectProp != null && (errs2 = this.m_sigDataObjectProp.validate()) != null && errs2.size() > 0) {
            errs.addAll(errs2);
        }
        return errs;
    }

    public byte[] calculateDigest() throws DigiDocException {
        if (this.m_origDigest == null) {
            CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(this.m_sig.getSignedDoc());
            byte[] xml = genFac.signedPropertiesToXML(this.m_sig, this);
            byte[] tmp = canFac.canonicalize(xml, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            String sDigType = ConfigManager.instance().getDefaultDigestType(this.m_sig.getSignedDoc());
            byte[] hash = SignedDoc.digestOfType(tmp, sDigType);
            return hash;
        }
        return this.m_origDigest;
    }
}

