/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc;

import ee.sk.digidoc.SignedDoc;
import ee.sk.utils.ConvertUtils;
import iaik.pkcs.pkcs11.Token;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import org.apache.log4j.Logger;

public class TokenKeyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int m_nr;
    private transient Token m_token;
    private long m_nSlot;
    private byte[] m_id;
    private X509Certificate m_cert;
    private String m_label;
    private static Logger m_logger = Logger.getLogger(TokenKeyInfo.class);

    public TokenKeyInfo(int nr, long nSlot, Token tok, byte[] id, String label, X509Certificate cert) {
        this.m_nSlot = nSlot;
        this.m_token = tok;
        this.m_id = id;
        this.m_label = label;
        this.m_cert = cert;
    }

    public int getNr() {
        return this.m_nr;
    }

    public byte[] getId() {
        return this.m_id;
    }

    public Token getToken() {
        return this.m_token;
    }

    public long getSlot() {
        return this.m_nSlot;
    }

    public X509Certificate getCert() {
        return this.m_cert;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getTokenName() {
        try {
            if (this.m_token != null) {
                return this.m_token.getTokenInfo().getLabel();
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading token name: " + ex));
        }
        return null;
    }

    public String getCertName() {
        try {
            if (this.m_cert != null) {
                return SignedDoc.getCommonName(this.m_cert.getSubjectDN().getName());
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading token name: " + ex));
        }
        return null;
    }

    public String getCertHex() {
        try {
            if (this.m_cert != null) {
                return SignedDoc.bin2hex(this.m_cert.getEncoded());
            }
            return null;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error encoding cert: " + ex));
            return null;
        }
    }

    public String getIdHex() {
        try {
            if (this.m_id != null) {
                return SignedDoc.bin2hex(this.m_id);
            }
            return null;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error encoding id: " + ex));
            return null;
        }
    }

    public String getCertSerial() {
        try {
            if (this.m_cert != null) {
                return this.m_cert.getSerialNumber().toString();
            }
            return null;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading cert serial: " + ex));
            return null;
        }
    }

    public boolean isSignatureKey() {
        return ConvertUtils.isSignatureCert(this.m_cert);
    }

    public boolean isEncryptKey() {
        return ConvertUtils.isEncryptCert(this.m_cert);
    }
}

