/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.c14n;

import ee.sk.digidoc.c14n.FragmentBase_Bounds;
import ee.sk.digidoc.c14n.common.Convert;

public abstract class FragmentBase {
    public byte[] Data;
    public int Offset;
    public int Length;
    public FragmentBase_Bounds ExplicitBounds;

    protected FragmentBase() {
    }

    public byte[] get_DataBytes() {
        return Convert.ToByteArray(this.Data, this.Offset, this.Length);
    }

    protected boolean SplitBy(String[] e) {
        boolean ret = false;
        String[] stringArray3 = e;
        for (int num4 = 0; num4 < stringArray3.length; ++num4) {
            String var = stringArray3[num4];
            if (!this.SplitBy(var)) continue;
            ret = true;
            break;
        }
        return ret;
    }

    protected abstract boolean SplitBy(String var1);

    public boolean StartsWith(String e) {
        if (e.length() > this.Length) {
            return false;
        }
        return Convert.ToString(this.Data, this.Offset, e.length()).equals(e);
    }

    public String get_DataString() {
        return Convert.ToString(this.Data, this.Offset, this.Length, "UTF-8");
    }

    public boolean get_Item(String ds) {
        return this.get_DataString().equals(ds);
    }

    public boolean get_Item(String[] ds) {
        for (int i = 0; i < ds.length; ++i) {
            if (!this.get_Item(ds[i])) continue;
            return true;
        }
        return false;
    }

    public int get_LastOffset() {
        return this.Offset + this.Length;
    }

    protected char GetChar(int o) {
        char c = (char)this.Data[this.Offset + o];
        return c;
    }

    protected boolean InBounds(int p) {
        if (p < 0) {
            return false;
        }
        if (this.ExplicitBounds != null && !this.ExplicitBounds.InBounds(p)) {
            return false;
        }
        return p < this.Data.length;
    }

    protected static void SplitBy(FragmentBase left, FragmentBase right, int length) {
        left.Length = length;
        right.Length -= length;
        right.Offset += length;
    }

    public static String GetDataBetweenFragments(FragmentBase from, FragmentBase to) {
        return Convert.ToString(from.Data, from.Offset + from.Length, to.Offset - from.get_LastOffset());
    }
}

