/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.c14n;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.c14n.TinyXMLCanonicalizerHandler;
import ee.sk.digidoc.c14n.TinyXMLParser;
import ee.sk.digidoc.factory.CanonicalizationFactory;
import java.io.ByteArrayOutputStream;
import java.io.RandomAccessFile;

public class TinyXMLCanonicalizer
implements CanonicalizationFactory {
    @Override
    public void init() throws DigiDocException {
    }

    public byte[] canonicalize(String filename, String uri) throws DigiDocException {
        byte[] byteArray3;
        RandomAccessFile f = null;
        try {
            f = new RandomAccessFile(filename, "r");
            byte[] data = new byte[(int)f.length()];
            int n = f.read(data);
            if (n <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            byteArray3 = this.canonicalize(data, uri);
        }
        catch (Throwable exc) {
            throw new DigiDocException(0, "unknown", exc);
        }
        finally {
            try {
                if (f != null) {
                    f.close();
                }
            }
            catch (Exception exception) {}
        }
        return byteArray3;
    }

    @Override
    public byte[] canonicalize(byte[] data, String uri) throws DigiDocException {
        byte[] byteArray3;
        try {
            TinyXMLParser p = new TinyXMLParser();
            TinyXMLCanonicalizerHandler h = new TinyXMLCanonicalizerHandler();
            p.Parse(h, TinyXMLCanonicalizer.NormalizeLineBreaks(data));
            byteArray3 = h.get_Bytes();
        }
        catch (Throwable exc) {
            throw new DigiDocException(0, "unknown", exc);
        }
        return byteArray3;
    }

    public static byte[] NormalizeLineBreaks(byte[] data) {
        int len = data.length;
        ByteArrayOutputStream o = new ByteArrayOutputStream(len);
        byte[] n = new byte[]{10};
        for (int i = 0; i < len; ++i) {
            byte c = data[i];
            if (c == 13) {
                boolean skip = false;
                if (i + 1 < len && (c = data[i + 1]) == 10) {
                    skip = true;
                }
                if (skip) continue;
                o.write(n, 0, 1);
                continue;
            }
            o.write(data, i, 1);
        }
        return o.toByteArray();
    }
}

