/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.c14n;

import ee.sk.digidoc.c14n.EntityParser;
import ee.sk.digidoc.c14n.TinyXMLCanonicalizerHandler_TextStringNormalizer;
import ee.sk.digidoc.c14n.TinyXMLParser_Attribute;
import ee.sk.digidoc.c14n.TinyXMLParser_Attribute_AttributeComparator;
import ee.sk.digidoc.c14n.TinyXMLParser_CData;
import ee.sk.digidoc.c14n.TinyXMLParser_Comment;
import ee.sk.digidoc.c14n.TinyXMLParser_Element;
import ee.sk.digidoc.c14n.TinyXMLParser_Handler;
import ee.sk.digidoc.c14n.TinyXMLParser_NestedElement;
import ee.sk.digidoc.c14n.TinyXMLParser_Tag;
import ee.sk.digidoc.c14n.TinyXMLParser_TextNode;
import ee.sk.digidoc.c14n.common.Convert;
import ee.sk.digidoc.c14n.common.StringImplementation;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;

public class TinyXMLCanonicalizerHandler
implements TinyXMLParser_Handler {
    public ByteArrayOutputStream BaseStream = new ByteArrayOutputStream();
    public boolean AppendNewlineAfterDocumentElement = false;
    public boolean IsWithComments = false;

    public byte[] get_Bytes() {
        return this.BaseStream.toByteArray();
    }

    public void Write(String e) {
        byte[] u = Convert.ToByteArray(e, "UTF-8");
        this.BaseStream.write(u, 0, u.length);
    }

    @Override
    public void startElement(TinyXMLParser_Element e) {
        this.Write("<" + e.get_TagName());
        ArrayList x = e.get_Attributes();
        this.WriteAttributes(x, e);
        this.Write(">");
    }

    private void WriteAttributes(ArrayList x, TinyXMLParser_Element owner) {
        int length = x.size();
        if (length > 0) {
            Collections.sort(x, new TinyXMLParser_Attribute_AttributeComparator());
            for (int i = 0; i < length; ++i) {
                this.WriteAttribute(x, owner, i);
            }
        }
    }

    private boolean CanNormalizeXMLNS(TinyXMLParser_Attribute a, TinyXMLParser_Element owner) {
        if (owner == null) {
            return false;
        }
        if (owner.Parent == null) {
            return false;
        }
        TinyXMLParser_Attribute u = TinyXMLCanonicalizerHandler.GetAnyParentXMLNS(a, owner.Parent);
        String _a = this.GetAttributeNormalizedValue(a);
        if (u == null) {
            return _a.equals("");
        }
        String _u = this.GetAttributeNormalizedValue(u);
        return _u.equals(_a);
    }

    private void WriteAttribute(ArrayList x, TinyXMLParser_Element owner, int i) {
        TinyXMLParser_Attribute a = (TinyXMLParser_Attribute)x.get(i);
        if (a.get_IsXMLNS() && this.CanNormalizeXMLNS(a, owner)) {
            return;
        }
        Object[] stringArray2 = new String[]{" ", a.NameFragment.get_DataString(), "=\"", this.GetAttributeNormalizedValue(a), "\""};
        this.Write(StringImplementation.Concat(stringArray2));
    }

    private String GetAttributeNormalizedValue(TinyXMLParser_Attribute a) {
        EntityParser p = EntityParser.Of(a.get_ValueFragment());
        TinyXMLCanonicalizerHandler_TextStringNormalizer tx = new TinyXMLCanonicalizerHandler_TextStringNormalizer();
        tx.IsAttribute = true;
        p.Resolver = tx;
        return p.get_Text();
    }

    @Override
    public void endElement(TinyXMLParser_Element e) {
        this.Write("</" + e.get_TagName() + ">");
        if (this.AppendNewlineAfterDocumentElement && e.Parent == null) {
            this.WriteLine();
        }
    }

    private void WriteLine() {
        this.Write("\n");
    }

    @Override
    public void PI(TinyXMLParser_Tag e) {
        if (e.get_Name().equals("xml")) {
            return;
        }
        this.Write("<?");
        this.Write(e.get_NameFragment().get_DataString());
        ArrayList x = e.Attributes;
        this.WriteAttributes(x, null);
        this.Write("?>");
        this.WriteLine();
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void text(TinyXMLParser_TextNode str) {
        if (str.Parent != null) {
            EntityParser p = EntityParser.Of(str.ValueFragment);
            p.Resolver = new TinyXMLCanonicalizerHandler_TextStringNormalizer();
            this.Write(p.get_Text());
        }
    }

    @Override
    public void cdata(TinyXMLParser_CData str) {
        this.Write(TinyXMLCanonicalizerHandler_TextStringNormalizer.StaticResolveTextCData(str.get_DataString()));
    }

    @Override
    public void comment(TinyXMLParser_Comment str) {
        if (this.IsWithComments) {
            this.Write("<!-- ");
            this.Write(str.ValueTag.get_DataString());
            this.Write(" -->");
            if (str.Parent == null) {
                this.WriteLine();
            }
        }
    }

    @Override
    public void nestedElement(TinyXMLParser_NestedElement e) {
    }

    private static TinyXMLParser_Attribute GetAnyParentXMLNS(TinyXMLParser_Attribute a, TinyXMLParser_Element e) {
        TinyXMLParser_Element p = e;
        while (p != null) {
            TinyXMLParser_Attribute x = p.GetXMLNSAttributeValue(a.get_NameString());
            if (x != null) {
                return x;
            }
            p = p.Parent;
        }
        return null;
    }

    private static void DumpBytes(String j, String[] enc) {
        String[] stringArray1 = enc;
        for (int num2 = 0; num2 < stringArray1.length; ++num2) {
            String var = stringArray1[num2];
            TinyXMLCanonicalizerHandler.DumpBytes(j, var);
        }
    }

    private static void DumpBytes(String j, String enc) {
    }
}

