/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.c14n;

import ee.sk.digidoc.c14n.TinyXMLParser_CData;
import ee.sk.digidoc.c14n.TinyXMLParser_Comment;
import ee.sk.digidoc.c14n.TinyXMLParser_Document;
import ee.sk.digidoc.c14n.TinyXMLParser_Element;
import ee.sk.digidoc.c14n.TinyXMLParser_Fragment;
import ee.sk.digidoc.c14n.TinyXMLParser_Handler;
import ee.sk.digidoc.c14n.TinyXMLParser_NestedElement;
import ee.sk.digidoc.c14n.TinyXMLParser_Tag;
import ee.sk.digidoc.c14n.TinyXMLParser_TextNode;
import ee.sk.digidoc.c14n.common.StringImplementation;
import java.util.Stack;

public class TinyXMLParser {
    public void Fail(TinyXMLParser_Fragment f, String reason) throws RuntimeException {
        Object[] objectArray0 = new Object[]{"Error line ", new Integer(f.get_TextPosition().get_Line()), ", column ", new Integer(f.get_TextPosition().get_Column()), " - ", reason};
        throw new RuntimeException(StringImplementation.Concat(objectArray0));
    }

    public void Parse(TinyXMLParser_Handler h, byte[] data) {
        try {
            TinyXMLParser_Document doc = new TinyXMLParser_Document();
            doc.ParseHandler = h;
            Stack<TinyXMLParser_Element> a = new Stack<TinyXMLParser_Element>();
            h.startDocument();
            TinyXMLParser_Fragment f = TinyXMLParser_Fragment.Of(data, 0);
            if (f == null) {
                return;
            }
            f.OwnerDocument = doc;
            f.SplitMarkup();
            TinyXMLParser_Element current = null;
            while (f != null) {
                if (f.get_IsMarkup()) {
                    if (f.get_Item("<!")) {
                        TinyXMLParser_NestedElement nested = TinyXMLParser_NestedElement.Of(f);
                        if (nested != null) {
                            h.nestedElement(nested);
                            f = nested.End.get_Next();
                            continue;
                        }
                    } else {
                        TinyXMLParser_CData u;
                        if (f.get_Item("<?")) {
                            TinyXMLParser_Tag def = TinyXMLParser_Tag.Of(f);
                            h.PI(def);
                            f = def.End.get_Next();
                            continue;
                        }
                        if (f.get_Item("<!--")) {
                            TinyXMLParser_Comment comment = new TinyXMLParser_Comment();
                            comment.ValueTag = TinyXMLParser_Tag.Of(f);
                            comment.Parent = current;
                            h.comment(comment);
                            f = comment.ValueTag.End.get_Next();
                            continue;
                        }
                        if (f.get_Item("<")) {
                            TinyXMLParser_Element n = TinyXMLParser_Element.Of(current, f);
                            f = n.Begin.End.get_Next();
                            h.startElement(n);
                            if (n.Begin.End.get_Item("/>")) {
                                h.endElement(n);
                                continue;
                            }
                            if (current != null) {
                                a.push(current);
                            } else {
                                if (doc.DocumentElement != null) {
                                    this.Fail(f, "document element already defined");
                                }
                                doc.DocumentElement = n;
                            }
                            current = n;
                            continue;
                        }
                        if (f.get_Item("</")) {
                            if (current == null) {
                                this.Fail(f, "tag is not open");
                            }
                            current.End = TinyXMLParser_Tag.Of(f);
                            if (!current.get_IsValid()) {
                                this.Fail(f, "tags dont match : " + current.get_NameOfBeginTagFragment().get_DataString() + " vs " + current.get_NameOfEndTagFragment().get_DataString());
                            }
                            f = current.End.End.get_Next();
                            h.endElement(current);
                            if (a.size() == 0) {
                                current = null;
                                continue;
                            }
                            current = (TinyXMLParser_Element)a.pop();
                            continue;
                        }
                        if (f.get_Item("<![") && (u = TinyXMLParser_CData.Of(f)) != null) {
                            h.cdata(u);
                            f = u.End.get_Next();
                            continue;
                        }
                    }
                }
                f.JoinNonMarkup();
                TinyXMLParser_TextNode ux = new TinyXMLParser_TextNode();
                ux.Parent = current;
                ux.ValueFragment = f;
                h.text(ux);
                f = f.get_Next();
            }
            h.endDocument();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

