/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Manifest;
import ee.sk.digidoc.ManifestFileEntry;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.SAXDigiDocException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BdocManifestParser
extends DefaultHandler {
    private SignedDoc m_sdoc;
    private Logger m_logger = null;
    public static final String MIME_SIGNATURE_BDOC_BES = "signature/bdoc-1.0/BES";
    public static final String MIME_SIGNATURE_BDOC_T = "signature/bdoc-1.1/T";
    public static final String MIME_SIGNATURE_BDOC_CL = "signature/bdoc-1.1/C-L";
    public static final String MIME_SIGNATURE_BDOC_TM = "signature/bdoc-1.0/TM";
    public static final String MIME_SIGNATURE_BDOC_TS = "signature/bdoc-1.0/TS";
    public static final String MIME_SIGNATURE_BDOC_TMA = "signature/bdoc-1.0/TM-A";
    public static final String MIME_SIGNATURE_BDOC_TSA = "signature/bdoc-1.0/TS-A";

    public BdocManifestParser(SignedDoc sdoc) {
        this.m_sdoc = sdoc;
        this.m_logger = Logger.getLogger(BdocManifestParser.class);
    }

    private InputStream removeDtd(InputStream is) {
        block7: {
            try {
                int n;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] data = new byte[2048];
                while ((n = is.read(data)) > 0) {
                    bos.write(data, 0, n);
                }
                data = bos.toByteArray();
                bos.close();
                String s = new String(data, "UTF-8");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Manifest orig:\n------\n" + s + "\n------\n"));
                }
                data = null;
                int p1 = s.indexOf("<!DOCTYPE");
                int p2 = 0;
                if (p1 > 0) {
                    p2 = s.indexOf(">", p1);
                    if (p2 > 0) {
                        String s2 = s.substring(0, p1) + s.substring(p2 + 1);
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Manifest no-dtd:\n------\n" + s2 + "\n------\n"));
                        }
                        return new ByteArrayInputStream(s2.getBytes());
                    }
                    break block7;
                }
                return new ByteArrayInputStream(s.getBytes("UTF-8"));
            }
            catch (Exception ex) {
                this.m_logger.error((Object)("Error removing dtd: " + ex));
            }
        }
        return is;
    }

    public Manifest readManifest(InputStream is) throws DigiDocException {
        BdocManifestParser handler = this;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)"Start reading manifest.xml");
        }
        try {
            factory.setValidating(false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            InputStream is2 = this.removeDtd(is);
            saxParser.parse(is2, (DefaultHandler)handler);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_sdoc.getManifest() == null) {
            throw new DigiDocException(13, "This document is not in manifest.xml format", null);
        }
        return this.m_sdoc.getManifest();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXDigiDocException {
        String tag;
        int p1;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Start Element: " + qName + " lname: " + lName + " uri: " + namespaceURI));
        }
        if ((p1 = (tag = qName).indexOf(58)) > 0) {
            tag = qName.substring(p1 + 1);
        }
        if (tag.equals("manifest")) {
            Manifest mf = new Manifest();
            this.m_sdoc.setManifest(mf);
        }
        if (tag.equals("file-entry")) {
            String sType = null;
            String sPath = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String key = attrs.getQName(i);
                p1 = key.indexOf(58);
                if (p1 > 0) {
                    key = key.substring(p1 + 1);
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("attr: " + key));
                }
                if (key.equals("media-type")) {
                    sType = attrs.getValue(i);
                }
                if (!key.equals("full-path")) continue;
                sPath = attrs.getValue(i);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Manif entry: " + sPath + " type: " + sType));
            }
            ManifestFileEntry fe = new ManifestFileEntry(sType, sPath);
            this.m_sdoc.getManifest().addFileEntry(fe);
            try {
                if (sPath.equals("/")) {
                    this.m_sdoc.setMimeType(sType);
                    this.m_sdoc.setFormat("BDOC");
                    if (sType != null && sType.equals("application/vnd.bdoc-1.0")) {
                        this.m_sdoc.setVersion("1.0");
                    }
                    if (sType != null && sType.equals("application/vnd.bdoc-1.1")) {
                        this.m_sdoc.setVersion("1.1");
                    }
                    this.m_sdoc.setProfile("BES");
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Sdoc: " + this.m_sdoc.getFormat() + " / " + this.m_sdoc.getVersion() + " / " + this.m_sdoc.getProfile()));
                    }
                } else if (sPath.indexOf("signature") != -1) {
                    String sigProfile;
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Find sig: " + sPath + " type: " + sType));
                    }
                    if (!(!sType.startsWith("signature/bdoc") || sType.equals(MIME_SIGNATURE_BDOC_BES) || sType.equals(MIME_SIGNATURE_BDOC_T) || sType.equals(MIME_SIGNATURE_BDOC_CL) || sType.equals(MIME_SIGNATURE_BDOC_TM) || sType.equals(MIME_SIGNATURE_BDOC_TS) || sType.equals(MIME_SIGNATURE_BDOC_TMA) || sType.equals(MIME_SIGNATURE_BDOC_TSA))) {
                        DigiDocException dex = new DigiDocException(13, "Invalid bdoc format: " + sPath, null);
                        SAXDigiDocException.handleException(dex);
                    }
                    if ((sigProfile = this.m_sdoc.findSignatureProfile(sPath)) == null) {
                        if (sType.equals(MIME_SIGNATURE_BDOC_BES)) {
                            this.m_sdoc.addSignatureProfile(sPath, "BES");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES")) {
                                this.m_sdoc.setProfile("BES");
                            }
                        }
                        if (sType.equals(MIME_SIGNATURE_BDOC_T)) {
                            this.m_sdoc.addSignatureProfile(sPath, "T");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES") || this.m_sdoc.getProfile().equals("T")) {
                                this.m_sdoc.setProfile("T");
                            }
                        }
                        if (sType.equals(MIME_SIGNATURE_BDOC_CL)) {
                            this.m_sdoc.addSignatureProfile(sPath, "C-L");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES") || this.m_sdoc.getProfile().equals("T") || this.m_sdoc.getProfile().equals("C-L")) {
                                this.m_sdoc.setProfile("C-L");
                            }
                        }
                        if (sType.equals(MIME_SIGNATURE_BDOC_TM)) {
                            this.m_sdoc.addSignatureProfile(sPath, "TM");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES") || this.m_sdoc.getProfile().equals("T") || this.m_sdoc.getProfile().equals("C-L") || this.m_sdoc.getProfile().equals("TM")) {
                                this.m_sdoc.setProfile("TM");
                            }
                        }
                        if (sType.equals(MIME_SIGNATURE_BDOC_TS)) {
                            this.m_sdoc.addSignatureProfile(sPath, "TS");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES") || this.m_sdoc.getProfile().equals("T") || this.m_sdoc.getProfile().equals("C-L") || this.m_sdoc.getProfile().equals("TS")) {
                                this.m_sdoc.setProfile("TS");
                            }
                        }
                        if (sType.equals(MIME_SIGNATURE_BDOC_TMA)) {
                            this.m_sdoc.addSignatureProfile(sPath, "TM-A");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES") || this.m_sdoc.getProfile().equals("T") || this.m_sdoc.getProfile().equals("C-L") || this.m_sdoc.getProfile().equals("TM") || this.m_sdoc.getProfile().equals("TM-A")) {
                                this.m_sdoc.setProfile("TM-A");
                            }
                        }
                        if (sType.equals(MIME_SIGNATURE_BDOC_TSA)) {
                            this.m_sdoc.addSignatureProfile(sPath, "TS-A");
                            if (this.m_sdoc.getProfile() == null || this.m_sdoc.getProfile().equals("BES") || this.m_sdoc.getProfile().equals("T") || this.m_sdoc.getProfile().equals("C-L") || this.m_sdoc.getProfile().equals("TS") || this.m_sdoc.getProfile().equals("TS-A")) {
                                this.m_sdoc.setProfile("TS-A");
                            }
                        }
                    }
                } else if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Manifest df: " + sPath));
                }
            }
            catch (DigiDocException ex) {
                SAXDigiDocException.handleException(ex);
            }
        }
    }

    private boolean isCorrectDataFilePath(String sPath) {
        if (sPath != null && sPath.length() > 0) {
            return !sPath.startsWith("/") && !sPath.startsWith("..") && (sPath.length() <= 3 || !Character.isLetter(sPath.charAt(0)) || sPath.charAt(1) != ':' || sPath.charAt(2) != '\\');
        }
        return false;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
    }
}

