/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Notary;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.DigiDocFactory;
import ee.sk.digidoc.factory.NotaryFactory;
import ee.sk.digidoc.factory.TrustServiceFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class BouncyCastleNotaryFactory
implements NotaryFactory {
    public static final String nonceOid = "1.3.6.1.5.5.7.48.1.2";
    private X509Certificate m_signCert = null;
    private PrivateKey m_signKey = null;
    private boolean m_bSignRequests = false;
    private Logger m_logger = Logger.getLogger(BouncyCastleNotaryFactory.class);
    private static final Random RANDOM_GENERATOR = new SecureRandom();
    private static final int V_ASN1_OCTET_STRING = 4;

    private byte[] createRandomBytes(int byteCount) {
        byte[] randomBytes = new byte[byteCount];
        RANDOM_GENERATOR.nextBytes(randomBytes);
        return randomBytes;
    }

    @Override
    public X509Certificate getNotaryCert(String responderCN, String specificCertNr) {
        try {
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            return tslFac.findOcspByCN(responderCN, true);
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error searching responder cert for: " + responderCN + " - " + ex));
            return null;
        }
    }

    public X509Certificate[] getNotaryCerts(String responderCN, String specificCertNr) {
        try {
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            return tslFac.findOcspsByCNAndNr(responderCN, true, specificCertNr);
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error searching responder cert for: " + responderCN + " - " + ex));
            return null;
        }
    }

    @Override
    public X509Certificate getCACert(String responderCN) {
        try {
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            X509Certificate cert = tslFac.findOcspByCN(responderCN, true);
            if (cert != null) {
                return tslFac.findCaForCert(cert, true, null);
            }
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error searching responder ca cert for: " + responderCN + " - " + ex));
        }
        return null;
    }

    @Override
    public Notary getConfirmation(byte[] nonce, X509Certificate signersCert, String notId, String httpFrom) throws DigiDocException {
        TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
        X509Certificate caCert = tslFac.findCaForCert(signersCert, true, null);
        X509Certificate ocspCert = tslFac.findOcspByCN(ConvertUtils.getCommonName(ConvertUtils.convX509Name(signersCert.getIssuerX500Principal())), true);
        return this.getConfirmation(nonce, signersCert, caCert, ocspCert, notId, httpFrom);
    }

    public Notary getConfirmation(Signature sig, byte[] nonce, X509Certificate signersCert, X509Certificate caCert, X509Certificate notaryCert, String notId, String ocspUrl, String httpFrom, String format, String formatVer) throws DigiDocException {
        Notary not = null;
        OCSPReq req = null;
        OCSPResp resp = null;
        try {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("getConfirmation, nonce " + Base64Util.encode(nonce, 0) + " cert: " + (signersCert != null ? signersCert.getSerialNumber().toString() : "NULL") + " CA: " + (caCert != null ? caCert.getSerialNumber().toString() : "NULL") + " responder: " + (notaryCert != null ? notaryCert.getSerialNumber().toString() : "NULL") + " notId: " + notId + " signRequest: " + this.m_bSignRequests + " url: " + ocspUrl));
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Check cert: " + (signersCert != null ? signersCert.getSubjectDN().getName() : "NULL")));
                this.m_logger.debug((Object)("Check CA cert: " + (caCert != null ? caCert.getSubjectDN().getName() : "NULL")));
            }
            req = this.createOCSPRequest(nonce, signersCert, caCert, this.m_bSignRequests, sig != null && sig.getSignedDoc().getFormat().equals("BDOC"));
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("REQUEST:\n" + Base64Util.encode(req.getEncoded(), 0)));
            }
            resp = this.sendRequestToUrl(req, ocspUrl, httpFrom, format, formatVer);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("RESPONSE:\n" + (resp != null ? Base64Util.encode(resp.getEncoded(), 0) : "NULL")));
            }
            if (resp != null) {
                this.verifyRespStatus(resp);
            }
            not = this.parseAndVerifyResponse(sig, notId, signersCert, resp, nonce, notaryCert, caCert);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"Confirmation OK!");
            }
        }
        catch (DigiDocException ex) {
            this.m_logger.error((Object)("Error receiving OCSP confirmation: " + ex + " nonce: " + ConvertUtils.bin2hex(nonce) + " len: " + nonce.length));
            try {
                byte[] b = req.getEncoded();
                this.m_logger.error((Object)("OCSP req: " + ConvertUtils.bin2hex(b) + " len: " + b.length));
                b = resp.getEncoded();
                this.m_logger.error((Object)("OCSP req: " + ConvertUtils.bin2hex(b) + " len: " + b.length));
            }
            catch (Exception ex2) {
                this.m_logger.error((Object)("Error converting OCSP info: " + ex2));
            }
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
        }
        return not;
    }

    public Notary getConfirmation(byte[] nonce, X509Certificate signersCert, X509Certificate caCert, X509Certificate notaryCert, String notId, String httpFrom) throws DigiDocException {
        return this.getConfirmation(null, nonce, signersCert, caCert, notaryCert, notId, ConfigManager.instance().getProperty("DIGIDOC_OCSP_RESPONDER_URL"), httpFrom, null, null);
    }

    @Override
    public Notary getConfirmation(Signature sig, X509Certificate signersCert, X509Certificate caCert) throws DigiDocException {
        Notary not = null;
        if (sig == null) {
            throw new DigiDocException(167, "Signature is NULL for ocsp request!", null);
        }
        try {
            OCSPResp resp;
            String notId = sig.getId().replace('S', 'N');
            byte[] nonce = SignedDoc.digestOfType(sig.getSignatureValue().getValue(), sig.getSignedDoc().getFormat().equals("BDOC") ? "SHA-256" : "SHA-1");
            X509Certificate notaryCert = null;
            if (sig.getUnsignedProperties() != null) {
                notaryCert = sig.getUnsignedProperties().getRespondersCertificate();
            }
            not = this.getConfirmation(sig, nonce, signersCert, caCert, notaryCert, notId, ConfigManager.instance().getProperty("DIGIDOC_OCSP_RESPONDER_URL"), sig.getHttpFrom(), sig.getSignedDoc().getFormat(), sig.getSignedDoc().getVersion());
            if (notaryCert == null && sig != null && sig.getUnsignedProperties() != null && (resp = new OCSPResp(not.getOcspResponseData())) != null && resp.getResponseObject() != null) {
                String respId = this.responderIDtoString((BasicOCSPResp)resp.getResponseObject());
                TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
                notaryCert = tslFac.findOcspByCN(SignedDoc.getCommonName(respId), true);
                if (notaryCert != null) {
                    sig.getUnsignedProperties().setRespondersCertificate(notaryCert);
                }
                CertID cid = new CertID(sig, notaryCert, 2);
                sig.addCertID(cid);
                cid.setUri("#" + sig.getId() + "-RESPONDER_CERT");
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
        }
        return not;
    }

    @Override
    public Notary getConfirmation(Signature sig, X509Certificate signersCert, X509Certificate caCert, X509Certificate notaryCert, String ocspUrl) throws DigiDocException {
        Notary not = null;
        if (sig == null) {
            throw new DigiDocException(167, "Signature is NULL for ocsp request!", null);
        }
        try {
            OCSPResp resp;
            String notId = sig.getId().replace('S', 'N');
            byte[] nonce = SignedDoc.digestOfType(sig.getSignatureValue().getValue(), sig.getSignedDoc().getFormat().equals("BDOC") ? "SHA-256" : "SHA-1");
            if (notaryCert == null && sig.getUnsignedProperties() != null) {
                notaryCert = sig.getUnsignedProperties().getRespondersCertificate();
            }
            if ((not = this.getConfirmation(sig, nonce, signersCert, caCert, notaryCert, notId, ocspUrl, sig.getHttpFrom(), sig.getSignedDoc().getFormat(), sig.getSignedDoc().getVersion())) != null && sig.getUnsignedProperties() != null) {
                sig.getUnsignedProperties().setNotary(not);
            }
            if (notaryCert == null && sig != null && sig.getUnsignedProperties() != null && sig.getUnsignedProperties().getNotary() != null && (resp = new OCSPResp(sig.getUnsignedProperties().getNotary().getOcspResponseData())) != null && resp.getResponseObject() != null && notaryCert == null) {
                String respId = this.responderIDtoString((BasicOCSPResp)resp.getResponseObject());
                TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
                notaryCert = tslFac.findOcspByCN(ConvertUtils.getCommonName(respId), true);
                if (notaryCert != null) {
                    sig.getUnsignedProperties().setRespondersCertificate(notaryCert);
                    CertID cid = new CertID(sig, notaryCert, 2);
                    sig.addCertID(cid);
                    cid.setUri("#" + sig.getId() + "-RESPONDER_CERT");
                }
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
        }
        return not;
    }

    @Override
    public Notary getConfirmation(Signature sig, X509Certificate signersCert) throws DigiDocException {
        String notId = sig.getId().replace('S', 'N');
        byte[] nonce = SignedDoc.digestOfType(sig.getSignatureValue().getValue(), sig.getSignedDoc().getFormat().equals("BDOC") ? "SHA-256" : "SHA-1");
        TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
        X509Certificate caCert = tslFac.findCaForCert(signersCert, true, null);
        X509Certificate ocspCert = tslFac.findOcspByCN(ConvertUtils.getCommonName(ConvertUtils.convX509Name(signersCert.getIssuerX500Principal())), true);
        return this.getConfirmation(nonce, signersCert, caCert, ocspCert, notId, sig.getHttpFrom());
    }

    private String composeHttpFrom() {
        String sFrom = null;
        try {
            NetworkInterface ni = null;
            Enumeration<NetworkInterface> eNi = NetworkInterface.getNetworkInterfaces();
            if (eNi != null && eNi.hasMoreElements()) {
                ni = eNi.nextElement();
            }
            if (ni != null) {
                InetAddress ia = null;
                Enumeration<InetAddress> eA = ni.getInetAddresses();
                if (eA != null && eA.hasMoreElements()) {
                    ia = eA.nextElement();
                }
                if (ia != null) {
                    sFrom = ia.getHostAddress();
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("FROM: " + sFrom));
                }
            }
        }
        catch (Exception ex2) {
            this.m_logger.error((Object)("Error finding ip-adr: " + ex2));
        }
        return sFrom;
    }

    @Override
    public OCSPResp checkCertificate(X509Certificate cert) throws DigiDocException {
        return this.checkCertificate(cert, this.composeHttpFrom());
    }

    @Override
    public OCSPResp checkCertificate(X509Certificate cert, String httpFrom) throws DigiDocException {
        OCSPResp resp = null;
        try {
            DigiDocFactory ddocFac = ConfigManager.instance().getDigiDocFactory();
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            X509Certificate caCert = tslFac.findCaForCert(cert, true, null);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Find CA for: " + SignedDoc.getCommonName(ConvertUtils.convX509Name(cert.getIssuerX500Principal()))));
                this.m_logger.debug((Object)("Check cert: " + cert.getSubjectDN().getName()));
                this.m_logger.debug((Object)("Check CA cert: " + caCert.getSubjectDN().getName()));
            }
            byte[] nonce1 = SignedDoc.digest(this.createRandomBytes(32));
            OCSPReq req = this.createOCSPRequest(nonce1, cert, caCert, this.m_bSignRequests, false);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Sending ocsp request: " + req.getEncoded().length + " bytes"));
                this.m_logger.debug((Object)("REQUEST:\n" + Base64Util.encode(req.getEncoded(), 0)));
            }
            String ocspUrl = tslFac.findOcspUrlForCert(cert, 0, true);
            resp = this.sendRequestToUrl(req, ocspUrl, httpFrom, null, null);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Got ocsp response: " + (resp != null ? resp.getEncoded().length : 0) + " bytes"));
                if (resp != null) {
                    this.m_logger.debug((Object)("RESPONSE:\n" + Base64Util.encode(resp.getEncoded(), 0)));
                }
            }
            this.verifyRespStatus(resp);
            BasicOCSPResp basResp = (BasicOCSPResp)resp.getResponseObject();
            byte[] nonce2 = this.getNonce(basResp, null);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Nonce1: " + (nonce1 != null ? ConvertUtils.bin2hex(nonce1) + " len: " + nonce1.length : "NULL") + " nonce2: " + (nonce2 != null ? ConvertUtils.bin2hex(nonce2) + " len: " + nonce2.length : "NULL")));
            }
            if (!SignedDoc.compareDigests(nonce1, nonce2)) {
                throw new DigiDocException(69, "Invalid nonce value! Possible replay attack!", null);
            }
            try {
                String respId = this.responderIDtoString(basResp);
                X509Certificate notaryCert = this.getNotaryCert(ConvertUtils.getCommonName(respId), null);
                boolean bOk = false;
                if (notaryCert == null) {
                    throw new DigiDocException(70, "Responder cert not found for: " + respId, null);
                }
                X509CertificateHolder ch = new X509CertificateHolder(notaryCert.getEncoded());
                bOk = basResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ch));
                if (!bOk) {
                    throw new DigiDocException(70, "OCSP verification error!", null);
                }
            }
            catch (Exception ex) {
                this.m_logger.error((Object)"OCSP Signature verification error!!!", (Throwable)ex);
                DigiDocException.handleException(ex, 70);
            }
            this.checkCertStatus(cert, basResp, caCert);
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
        }
        return resp;
    }

    @Override
    public OCSPResp sendCertOcsp(X509Certificate cert, X509Certificate caCert, String url, ByteArrayOutputStream bosNonce, StringBuffer sbRespId, ByteArrayOutputStream bosReq, String httpFrom) throws DigiDocException {
        try {
            BasicOCSPResp basResp;
            String sRespId;
            OCSPResp resp = null;
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Find CA for: " + SignedDoc.getCommonName(ConvertUtils.convX509Name(cert.getIssuerX500Principal()))));
                this.m_logger.debug((Object)("Check cert: " + cert.getSubjectDN().getName()));
                this.m_logger.debug((Object)("Check CA cert: " + caCert.getSubjectDN().getName()));
            }
            byte[] nonce1 = SignedDoc.digest(this.createRandomBytes(32));
            bosNonce.write(nonce1);
            OCSPReq req = this.createOCSPRequest(nonce1, cert, caCert, false, false);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Sending ocsp request: " + req.getEncoded().length + " bytes"));
                this.m_logger.debug((Object)("REQUEST:\n" + Base64Util.encode(req.getEncoded(), 0)));
            }
            if (req != null && bosReq != null) {
                bosReq.write(req.getEncoded());
            }
            if ((resp = this.sendRequestToUrl(req, url, httpFrom, null, null)) != null && (sRespId = this.responderIDtoString(basResp = (BasicOCSPResp)resp.getResponseObject())) != null) {
                sbRespId.append(sRespId);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Got ocsp response: " + (resp != null ? resp.getEncoded().length : 0) + " bytes"));
                if (resp != null) {
                    this.m_logger.debug((Object)("RESPONSE:\n" + Base64Util.encode(resp.getEncoded(), 0)));
                }
            }
            return resp;
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
            return null;
        }
    }

    @Override
    public boolean checkCertOcsp(OCSPResp resp, X509Certificate cert, X509Certificate ocspCert, byte[] nonce1, X509Certificate caCert) throws DigiDocException {
        try {
            this.verifyRespStatus(resp);
            BasicOCSPResp basResp = (BasicOCSPResp)resp.getResponseObject();
            byte[] nonce2 = this.getNonce(basResp, null);
            if (!SignedDoc.compareDigests(nonce1, nonce2)) {
                throw new DigiDocException(69, "Invalid nonce value! Possible replay attack!", null);
            }
            boolean bOk = false;
            try {
                X509CertificateHolder ch = new X509CertificateHolder(ocspCert.getEncoded());
                bOk = basResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ch));
            }
            catch (Exception ex) {
                this.m_logger.error((Object)"OCSP Signature verification error!!!", (Throwable)ex);
                DigiDocException.handleException(ex, 70);
            }
            this.checkCertStatusWithCa(cert, basResp, caCert);
            return bOk;
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
            return false;
        }
    }

    @Override
    public void checkCertificateOcspOrCrl(X509Certificate cert, boolean bUseOcsp) throws DigiDocException {
        try {
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            X509Certificate caCert = tslFac.findCaForCert(cert, true, null);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Find CA for: " + SignedDoc.getCommonName(ConvertUtils.convX509Name(cert.getIssuerX500Principal()))));
                this.m_logger.debug((Object)("Check cert: " + cert.getSubjectDN().getName()));
                this.m_logger.debug((Object)("Check CA cert: " + caCert.getSubjectDN().getName()));
            }
            byte[] nonce1 = SignedDoc.digest(this.createRandomBytes(32));
            OCSPReq req = this.createOCSPRequest(nonce1, cert, caCert, this.m_bSignRequests, false);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Sending ocsp request: " + req.getEncoded().length + " bytes"));
                this.m_logger.debug((Object)("REQUEST:\n" + Base64Util.encode(req.getEncoded(), 0)));
            }
            OCSPResp resp = this.sendRequest(req, null, null, null);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Got ocsp response: " + resp.getEncoded().length + " bytes"));
                this.m_logger.debug((Object)("RESPONSE:\n" + Base64Util.encode(resp.getEncoded(), 0)));
            }
            this.verifyRespStatus(resp);
            BasicOCSPResp basResp = (BasicOCSPResp)resp.getResponseObject();
            byte[] nonce2 = this.getNonce(basResp, null);
            if (!SignedDoc.compareDigests(nonce1, nonce2)) {
                throw new DigiDocException(69, "Invalid nonce value! Possible replay attack!", null);
            }
            try {
                String respId = this.responderIDtoString(basResp);
                X509Certificate notaryCert = this.getNotaryCert(SignedDoc.getCommonName(respId), null);
                X509CertificateHolder ch = new X509CertificateHolder(notaryCert.getEncoded());
                boolean bOk = basResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ch));
                if (!bOk) {
                    this.m_logger.error((Object)"OCSP Signature verification error!!!");
                    throw new DigiDocException(70, "OCSP Signature verification error!!!", null);
                }
            }
            catch (Exception ex) {
                this.m_logger.error((Object)"OCSP Signature verification error!!!", (Throwable)ex);
                DigiDocException.handleException(ex, 70);
            }
            this.checkCertStatus(cert, basResp, caCert);
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 66);
        }
    }

    private Notary parseAndVerifyResponse(Signature sig, OCSPResp resp, byte[] nonce1) throws DigiDocException {
        String notId = sig.getId().replace('S', 'N');
        X509Certificate sigCert = sig.getKeyInfo().getSignersCertificate();
        return this.parseAndVerifyResponse(sig, notId, sigCert, resp, nonce1, null, null);
    }

    private Notary parseAndVerifyResponse(Signature sig, String notId, X509Certificate signersCert, OCSPResp resp, byte[] nonce1, X509Certificate notaryCert, X509Certificate caCert) throws DigiDocException {
        Notary not = null;
        if (resp == null) {
            throw new DigiDocException(69, "OCSP response is null!", null);
        }
        if (resp.getStatus() != 0) {
            if (resp.getStatus() == 6) {
                throw new DigiDocException(163, "OCSP response unauthorized! ", null);
            }
            throw new DigiDocException(69, "OCSP response unsuccessfull!", null);
        }
        try {
            BasicOCSPResp basResp = (BasicOCSPResp)resp.getResponseObject();
            String respId = this.responderIDtoString(basResp);
            if (notaryCert == null) {
                String nCn = ConvertUtils.getCommonName(respId);
                notaryCert = this.getNotaryCert(nCn, null);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Find notary cert: " + nCn + " found: " + (notaryCert != null ? "OK" : "NULL")));
                }
            }
            if (notaryCert == null) {
                throw new DigiDocException(70, "Notary cert not found for: " + respId, null);
            }
            boolean bOk = false;
            try {
                X509CertificateHolder ch = new X509CertificateHolder(notaryCert.getEncoded());
                bOk = basResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ch));
            }
            catch (Exception ex) {
                this.m_logger.error((Object)"OCSP Signature verification error!!!", (Throwable)ex);
                DigiDocException.handleException(ex, 70);
            }
            if (!bOk) {
                this.m_logger.error((Object)"OCSP Signature verification error!!!");
                throw new DigiDocException(70, "OCSP Signature verification error!!!", null);
            }
            if (this.m_logger.isDebugEnabled() && notaryCert != null) {
                this.m_logger.debug((Object)("Using responder cert: " + notaryCert.getSerialNumber().toString()));
            }
            byte[] nonce2 = this.getNonce(basResp, sig != null ? sig.getSignedDoc() : null);
            boolean ok = true;
            if (nonce1 == null || nonce2 == null || nonce1.length != nonce2.length) {
                ok = false;
            }
            for (int i = 0; nonce1 != null && nonce2 != null && i < nonce1.length; ++i) {
                if (nonce1[i] == nonce2[i]) continue;
                ok = false;
            }
            if (this.m_logger.isDebugEnabled() && notaryCert != null) {
                this.m_logger.debug((Object)("NONCE ddoc: " + (sig != null ? sig.getSignedDoc().getFormat() : "NULL") + " ok: " + ok));
            }
            if (!ok && sig != null) {
                this.m_logger.error((Object)("DDOC ver: " + sig.getSignedDoc().getVersion() + " SIG: " + sig.getId() + " Real nonce: " + Base64Util.encode(nonce2, 0) + " SigVal hash: " + Base64Util.encode(nonce1, 0) + " SigVal hash hex: " + ConvertUtils.bin2hex(nonce1)));
                throw new DigiDocException(71, "OCSP response's nonce doesn't match the requests nonce!", null);
            }
            this.checkCertStatus(signersCert, basResp, caCert);
            not = new Notary(notId, resp.getEncoded(), respId, basResp.getProducedAt());
            if (notaryCert != null) {
                not.setCertNr(notaryCert.getSerialNumber().toString());
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 72);
        }
        return not;
    }

    private void checkCertStatus(Signature sig, BasicOCSPResp basResp) throws DigiDocException {
        this.checkCertStatus(sig.getKeyInfo().getSignersCertificate(), basResp, null);
    }

    private void checkCertStatus(X509Certificate cert, BasicOCSPResp basResp, X509Certificate caCert) throws DigiDocException {
        try {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Checking response status, CERT: " + (cert != null ? cert.getSubjectDN().getName() : "NULL") + " SEARCH: " + (cert != null ? SignedDoc.getCommonName(ConvertUtils.convX509Name(cert.getIssuerX500Principal())) : "NULL")));
            }
            if (cert == null) {
                throw new DigiDocException(92, "No certificate to check! Error reading certificate from file?", null);
            }
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            if (caCert == null) {
                caCert = tslFac.findCaForCert(cert, true, null);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("CA cert: " + (caCert != null ? caCert.getSubjectDN().getName() : "NULL")));
                this.m_logger.debug((Object)("RESP: " + basResp));
                this.m_logger.debug((Object)("CERT: " + cert.getSubjectDN().getName() + " ISSUER: " + ConvertUtils.convX509Name(cert.getIssuerX500Principal()) + " nr: " + (caCert != null ? ConvertUtils.bin2hex(caCert.getSerialNumber().toByteArray()) : "NULL")));
            }
            if (caCert == null) {
                throw new DigiDocException(92, "Unknown CA cert: " + cert.getIssuerDN().getName(), null);
            }
            SingleResp[] sresp = basResp.getResponses();
            CertificateID rc = this.creatCertReq(cert, caCert);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Search alg: " + rc.getHashAlgOID() + " cert ser: " + cert.getSerialNumber().toString() + " serial: " + rc.getSerialNumber() + " issuer: " + Base64Util.encode(rc.getIssuerKeyHash()) + " subject: " + Base64Util.encode(rc.getIssuerNameHash())));
            }
            boolean ok = false;
            for (int i = 0; i < sresp.length; ++i) {
                CertificateID id = sresp[i].getCertID();
                if (id == null) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Got alg: " + id.getHashAlgOID() + " serial: " + id.getSerialNumber() + " issuer: " + Base64Util.encode(id.getIssuerKeyHash()) + " subject: " + Base64Util.encode(id.getIssuerNameHash())));
                }
                if (!rc.getHashAlgOID().equals((Object)id.getHashAlgOID()) || !rc.getSerialNumber().equals(id.getSerialNumber()) || !SignedDoc.compareDigests(rc.getIssuerKeyHash(), id.getIssuerKeyHash()) || !SignedDoc.compareDigests(rc.getIssuerNameHash(), id.getIssuerNameHash())) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)"Found it!");
                }
                ok = true;
                CertificateStatus status = sresp[i].getCertStatus();
                if (status == null) break;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("CertStatus: " + status.getClass().getName()));
                }
                if (status instanceof RevokedStatus) {
                    this.m_logger.error((Object)"Certificate has been revoked!");
                    throw new DigiDocException(91, "Certificate has been revoked!", null);
                }
                if (!(status instanceof UnknownStatus)) break;
                this.m_logger.error((Object)"Certificate status is unknown!");
                throw new DigiDocException(92, "Certificate status is unknown!", null);
            }
            if (!ok) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)"Error checkCertStatus - not found ");
                }
                throw new DigiDocException(88, "Bad OCSP response status!", null);
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error checkCertStatus: " + ex));
            ex.printStackTrace();
            throw new DigiDocException(88, "Error checking OCSP response status!", null);
        }
    }

    private void checkCertStatusWithCa(X509Certificate cert, BasicOCSPResp basResp, X509Certificate caCert) throws DigiDocException {
        try {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Checking response status, CERT: " + cert.getSubjectDN().getName() + " SEARCH: " + SignedDoc.getCommonName(ConvertUtils.convX509Name(cert.getIssuerX500Principal()))));
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("CA cert: " + (caCert == null ? "NULL" : "OK")));
                this.m_logger.debug((Object)("RESP: " + basResp));
                this.m_logger.debug((Object)("CERT: " + cert.getSubjectDN().getName() + " ISSUER: " + ConvertUtils.convX509Name(cert.getIssuerX500Principal())));
                if (caCert != null) {
                    this.m_logger.debug((Object)("CA CERT: " + caCert.getSubjectDN().getName()));
                }
            }
            SingleResp[] sresp = basResp.getResponses();
            CertificateID rc = null;
            if (cert != null && caCert != null) {
                rc = this.creatCertReq(cert, caCert);
            }
            if (this.m_logger.isDebugEnabled() && rc != null) {
                this.m_logger.debug((Object)("Search alg: " + rc.getHashAlgOID() + " serial: " + rc.getSerialNumber() + " issuer: " + Base64Util.encode(rc.getIssuerKeyHash()) + " subject: " + Base64Util.encode(rc.getIssuerNameHash())));
            }
            boolean ok = false;
            for (int i = 0; i < sresp.length; ++i) {
                CertificateID id = sresp[i].getCertID();
                if (id == null) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Got alg: " + id.getHashAlgOID() + " serial: " + id.getSerialNumber() + " issuer: " + Base64Util.encode(id.getIssuerKeyHash()) + " subject: " + Base64Util.encode(id.getIssuerNameHash())));
                }
                if (rc == null || !rc.getHashAlgOID().equals((Object)id.getHashAlgOID()) || !rc.getSerialNumber().equals(id.getSerialNumber()) || !SignedDoc.compareDigests(rc.getIssuerKeyHash(), id.getIssuerKeyHash()) || !SignedDoc.compareDigests(rc.getIssuerNameHash(), id.getIssuerNameHash())) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)"Found it!");
                }
                ok = true;
                CertificateStatus status = sresp[i].getCertStatus();
                if (status == null) break;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("CertStatus: " + status.getClass().getName()));
                }
                if (status instanceof RevokedStatus) {
                    this.m_logger.error((Object)"Certificate has been revoked!");
                    throw new DigiDocException(88, "Certificate has been revoked!", null);
                }
                if (!(status instanceof UnknownStatus)) break;
                this.m_logger.error((Object)"Certificate status is unknown!");
                throw new DigiDocException(88, "Certificate status is unknown!", null);
            }
            if (!ok) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)"Error checkCertStatus - not found ");
                }
                throw new DigiDocException(88, "Bad OCSP response status!", null);
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error checkCertStatus: " + ex));
            ex.printStackTrace();
            throw new DigiDocException(88, "Error checking OCSP response status!", null);
        }
    }

    @Override
    public Notary parseAndVerifyResponse(Signature sig, Notary not) throws DigiDocException {
        try {
            OCSPResp resp = new OCSPResp(not.getOcspResponseData());
            BasicOCSPResp basResp = (BasicOCSPResp)resp.getResponseObject();
            X509Certificate[] lNotCerts = null;
            try {
                X509Certificate rCert;
                CertValue cvOcsp;
                X509CertificateHolder ch;
                String respondIDstr = this.responderIDtoString(basResp);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SIG: " + (sig == null ? "NULL" : sig.getId())));
                    this.m_logger.debug((Object)("UP: " + (sig.getUnsignedProperties() == null ? "NULL" : "OK: " + sig.getUnsignedProperties().getNotary().getId())));
                    this.m_logger.debug((Object)("RESP-CERT: " + (sig.getUnsignedProperties().getRespondersCertificate() == null ? "NULL" : "OK")));
                    this.m_logger.debug((Object)("RESP-ID: " + respondIDstr));
                    CertID cid = sig.getCertID(2);
                    if (cid != null) {
                        this.m_logger.debug((Object)("CID: " + cid.getType() + " id: " + cid.getId() + ", " + cid.getSerial() + " issuer: " + cid.getIssuer()));
                    }
                    this.m_logger.debug((Object)("RESP: " + Base64Util.encode(resp.getEncoded())));
                }
                if (lNotCerts == null && sig != null) {
                    int n1;
                    String respSrch = respondIDstr;
                    if (respSrch.indexOf("CN") != -1) {
                        respSrch = ConvertUtils.getCommonName(respondIDstr);
                    }
                    if (respSrch.startsWith("byKey: ")) {
                        respSrch = respSrch.substring("byKey: ".length());
                    }
                    if ((n1 = respSrch.indexOf(44)) > 0) {
                        respSrch = respSrch.substring(0, n1);
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Search not cert by: " + respSrch));
                    }
                    lNotCerts = this.getNotaryCerts(respSrch, null);
                }
                if (lNotCerts == null || lNotCerts.length == 0) {
                    throw new DigiDocException(117, "No certificate for responder: '" + respondIDstr + "' found in local certificate store!", null);
                }
                boolean bOk = false;
                for (int j = 0; lNotCerts != null && j < lNotCerts.length && !bOk; ++j) {
                    void cert = lNotCerts[j];
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Verify using responders cert: " + (cert != null ? ConvertUtils.getCommonName(cert.getSubjectDN().getName()) + " nr: " + cert.getSerialNumber().toString() : "NULL")));
                    }
                    if (cert != null) {
                        ch = new X509CertificateHolder(cert.getEncoded());
                        bOk = basResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ch));
                    } else {
                        bOk = false;
                    }
                    if (!this.m_logger.isDebugEnabled()) continue;
                    this.m_logger.debug((Object)("OCSP resp: " + (basResp != null ? this.responderIDtoString(basResp) : "NULL") + " verify using: " + (cert != null ? ConvertUtils.getCommonName(cert.getSubjectDN().getName()) : "NULL") + " verify: " + bOk));
                }
                if (bOk && (cvOcsp = sig.getCertValueOfType(2)) != null && (rCert = cvOcsp.getCert()) != null) {
                    ch = new X509CertificateHolder(rCert.getEncoded());
                    bOk = basResp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ch));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("OCSP resp: " + (basResp != null ? this.responderIDtoString(basResp) : "NULL") + " verify using cert in xml: " + ConvertUtils.getCommonName(rCert.getSubjectDN().getName()) + " verify: " + bOk));
                    }
                }
                if (!bOk) {
                    throw new DigiDocException(70, "OCSP verification error!", null);
                }
            }
            catch (Exception ex) {
                this.m_logger.error((Object)("Signature verification error: " + ex));
                ex.printStackTrace();
                DigiDocException.handleException(ex, 70);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Verif sig: " + sig.getId() + " format: " + sig.getSignedDoc().getFormat() + " nonce policy: " + sig.hasBdoc2NoncePolicy()));
            }
            boolean ok = true;
            if (sig.getSignedDoc().getFormat().equals("SK-XML") || sig.getSignedDoc().getFormat().equals("DIGIDOC-XML") || sig.getSignedDoc().getFormat().equals("BDOC") && sig.hasBdoc2NoncePolicy()) {
                byte[] nonce1 = SignedDoc.digestOfType(sig.getSignatureValue().getValue(), sig.getSignedDoc().getFormat().equals("BDOC") ? "SHA-256" : "SHA-1");
                byte[] nonce2 = this.getNonce(basResp, sig.getSignedDoc());
                if (nonce1 == null || nonce2 == null || nonce1.length != nonce2.length) {
                    ok = false;
                }
                for (int i = 0; nonce1 != null && nonce2 != null && i < nonce1.length && i < nonce2.length; ++i) {
                    if (nonce1[i] == nonce2[i]) continue;
                    ok = false;
                }
                if (!ok && sig.getSignedDoc() != null) {
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("SigVal\n---\n" + Base64Util.encode(sig.getSignatureValue().getValue()) + "\n---\nOCSP\n---\n" + Base64Util.encode(not.getOcspResponseData()) + "\n---\n"));
                        this.m_logger.debug((Object)("DDOC ver: " + sig.getSignedDoc().getVersion() + " SIG: " + sig.getId() + " NOT: " + not.getId() + " Real nonce: " + (nonce2 != null ? Base64Util.encode(nonce2, 0) : "NULL") + " noncelen: " + (nonce2 != null ? nonce2.length : 0) + " SigVal hash: " + (nonce1 != null ? Base64Util.encode(nonce1, 0) : "NULL") + " SigVal hash hex: " + (nonce1 != null ? ConvertUtils.bin2hex(nonce1) : "NULL") + " svlen: " + (nonce1 != null ? nonce1.length : 0)));
                    }
                    throw new DigiDocException(71, "OCSP response's nonce doesn't match the requests nonce!", null);
                }
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Verify not: " + not.getId()));
            }
            this.checkCertStatus(sig, basResp);
            not.setProducedAt(basResp.getProducedAt());
            not.setResponderId(this.responderIDtoString(basResp));
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 72);
        }
        return not;
    }

    private String responderIDtoString(BasicOCSPResp basResp) {
        if (basResp != null) {
            ResponderID respid = basResp.getResponderId().toASN1Primitive();
            ASN1Primitive o = ((DERTaggedObject)respid.toASN1Object()).getObject();
            if (o instanceof DEROctetString) {
                DEROctetString oc = (DEROctetString)o;
                return "byKey: " + SignedDoc.bin2hex(oc.getOctets());
            }
            X509Name name = new X509Name((ASN1Sequence)o);
            return "byName: " + name.toString();
        }
        return null;
    }

    private byte[] getNonce(BasicOCSPResp basResp, SignedDoc sdoc) {
        if (basResp != null) {
            try {
                byte[] b;
                Extension ext;
                byte[] nonce2 = null;
                Set extOids = basResp.getNonCriticalExtensionOIDs();
                boolean bAsn1 = false;
                String sType = null;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Nonce exts: " + extOids.size()));
                }
                if (extOids.size() >= 1 && (ext = basResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce)) != null) {
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Ext: " + ext.getExtnId() + " val-len: " + (ext.getExtnValue() != null ? ext.getExtnValue().getOctets().length : 0)));
                    }
                    if (ext.getExtnValue() != null && ext.getExtnValue().getOctets() != null && ext.getExtnValue().getOctets().length == 20) {
                        nonce2 = ext.getExtnValue().getOctets();
                        this.m_logger.debug((Object)("Raw nonce len: " + (nonce2 != null ? nonce2.length : 0)));
                    } else {
                        ASN1Encodable extObj = ext.getParsedValue();
                        nonce2 = extObj.toASN1Primitive().getEncoded();
                    }
                }
                boolean bCheckOcspNonce = ConfigManager.instance().getBooleanProperty("CHECK_OCSP_NONCE", false);
                if (sdoc != null && sdoc.getFormat() != null && sdoc.getFormat().equals("BDOC")) {
                    bCheckOcspNonce = true;
                }
                if (sdoc != null && sdoc.getFormat() != null && sdoc.getFormat().equals("SK-XML")) {
                    bCheckOcspNonce = false;
                }
                if (this.m_logger.isDebugEnabled() && nonce2 != null) {
                    this.m_logger.debug((Object)("Nonce hex: " + ConvertUtils.bin2hex(nonce2) + " b64: " + Base64Util.encode(nonce2) + " len: " + nonce2.length + " asn1: " + bAsn1));
                }
                if ((sdoc != null && sdoc.getFormat() != null && sdoc.getFormat().equals("DIGIDOC-XML") || sdoc == null) && nonce2 != null && nonce2.length == 22) {
                    b = new byte[20];
                    System.arraycopy(nonce2, nonce2.length - 20, b, 0, 20);
                    nonce2 = b;
                    bAsn1 = true;
                    sType = "ASN1-NONCE";
                }
                if (sdoc != null && sdoc.getFormat() != null && sdoc.getFormat().equals("BDOC") && nonce2 != null) {
                    sType = ConvertUtils.findDigType(nonce2);
                    if (sType != null) {
                        b = ConvertUtils.removePrefix(nonce2);
                        nonce2 = b;
                    }
                    boolean bl = bAsn1 = sType != null;
                }
                if (this.m_logger.isDebugEnabled() && nonce2 != null) {
                    this.m_logger.debug((Object)("Nonce hex: " + ConvertUtils.bin2hex(nonce2) + " b64: " + Base64Util.encode(nonce2) + " len: " + nonce2.length + " type: " + sType));
                } else {
                    this.m_logger.debug((Object)"No nonce");
                }
                if (!bAsn1 && bCheckOcspNonce) {
                    throw new DigiDocException(71, "Invalid nonce: " + (nonce2 != null ? ConvertUtils.bin2hex(nonce2) + " length: " + nonce2.length : "NO-NONCE") + "!", null);
                }
                return nonce2;
            }
            catch (Exception ex) {
                this.m_logger.error((Object)("Error reading ocsp nonce: " + ex));
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void verifyRespStatus(OCSPResp resp) throws DigiDocException {
        if (resp == null || resp.getStatus() != 0) {
            throw new DigiDocException(69, "OCSP response unsuccessfull! ", null);
        }
        int status = resp.getStatus();
        switch (status) {
            case 2: {
                this.m_logger.error((Object)"An internal error occured in the OCSP Server!");
                break;
            }
            case 1: {
                this.m_logger.error((Object)"Your request did not fit the RFC 2560 syntax!");
                break;
            }
            case 5: {
                this.m_logger.error((Object)"Your request was not signed!");
                break;
            }
            case 3: {
                this.m_logger.error((Object)"The server was too busy to answer you!");
                break;
            }
            case 6: {
                this.m_logger.error((Object)"The server could not authenticate you!");
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.m_logger.error((Object)("Unknown OCSPResponse status code! " + status));
            }
        }
    }

    private CertificateID creatCertReq(X509Certificate signersCert, X509Certificate caCert) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateEncodingException, DigiDocException, Exception {
        DigestCalculatorProvider dcp = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        X509CertificateHolder caCertHolder = new X509CertificateHolder(caCert.getEncoded());
        return new CertificateID(dcp.get(CertificateID.HASH_SHA1), caCertHolder, signersCert.getSerialNumber());
    }

    private OCSPReq createOCSPRequest(byte[] nonce, X509Certificate signersCert, X509Certificate caCert, boolean bSigned, boolean bBdoc) throws DigiDocException {
        OCSPReq req = null;
        OCSPReqBuilder ocspRequest = new OCSPReqBuilder();
        try {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Request for: " + (signersCert != null ? ConvertUtils.getCommonName(ConvertUtils.convX509Name(signersCert.getSubjectX500Principal())) : "NULL") + " CA: " + (caCert != null ? ConvertUtils.getCommonName(ConvertUtils.convX509Name(caCert.getSubjectX500Principal())) : "NULL")));
            }
            if (signersCert == null) {
                throw new DigiDocException(65, "Missing signers cert for ocsp request", null);
            }
            if (caCert == null) {
                throw new DigiDocException(65, "Missing CA cert for ocsp request", null);
            }
            CertificateID certId = this.creatCertReq(signersCert, caCert);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Request for: " + certId.getHashAlgOID() + " serial: " + certId.getSerialNumber() + " issuer: " + ConvertUtils.bin2hex(certId.getIssuerKeyHash()) + " subject: " + ConvertUtils.bin2hex(certId.getIssuerNameHash()) + " nonce: " + ConvertUtils.bin2hex(nonce) + " len: " + nonce.length));
            }
            ocspRequest.addRequest(certId);
            if (nonce != null && ConvertUtils.findDigType(nonce) == null && bBdoc) {
                byte[] b = ConvertUtils.addDigestAsn1Prefix(nonce);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Nonce in: " + ConvertUtils.bin2hex(nonce) + " in-len: " + nonce.length + " with-asn1: " + ConvertUtils.bin2hex(b) + " out-len: " + (b != null ? b.length : 0) + " out-pref: " + ConvertUtils.findDigType(b)));
                }
                nonce = b;
            }
            if (nonce != null) {
                ExtensionsGenerator extGen = new ExtensionsGenerator();
                if (bBdoc) {
                    extGen.addExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, nonce);
                } else {
                    extGen.addExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1Encodable)new DEROctetString(nonce));
                }
                ocspRequest.setRequestExtensions(extGen.generate());
            }
            GeneralName name = null;
            if (bSigned) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SignCert: " + (this.m_signCert != null ? this.m_signCert.toString() : "NULL")));
                }
                if (this.m_signCert == null) {
                    throw new DigiDocException(17, "Invalid config file! Attempting to sign ocsp request but PKCS#12 token not configured!", null);
                }
                name = new GeneralName((X509Name)PrincipalUtil.getSubjectX509Principal((X509Certificate)this.m_signCert));
            } else {
                if (signersCert == null) {
                    throw new DigiDocException(68, "Signature owners certificate is NULL!", null);
                }
                name = new GeneralName((X509Name)PrincipalUtil.getSubjectX509Principal((X509Certificate)signersCert));
            }
            ocspRequest.setRequestorName(name);
            if (bSigned) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Signing ocsp request with: " + (this.m_signCert != null ? this.m_signCert.getSubjectX500Principal().getName() : "NULL")));
                }
                X509CertificateHolder[] chain = new X509CertificateHolder[]{new X509CertificateHolder(this.m_signCert.getEncoded())};
                req = ocspRequest.build(new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(this.m_signKey), chain);
                if (!req.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(chain[0]))) {
                    this.m_logger.error((Object)"Verify failed");
                }
            } else {
                req = ocspRequest.build();
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 65);
        }
        return req;
    }

    private OCSPResp sendRequest(OCSPReq req, String httpFrom, String format, String formatVer) throws DigiDocException {
        String responderUrl = ConfigManager.instance().getProperty("DIGIDOC_OCSP_RESPONDER_URL");
        return this.sendRequestToUrl(req, responderUrl, httpFrom, format, formatVer);
    }

    private String getUserInfo(String format, String formatVer) {
        StringBuffer sb = null;
        try {
            sb = new StringBuffer("LIB ");
            sb.append("JDigiDoc");
            sb.append("/");
            sb.append("${env.JDD_VERSION}");
            if (format != null && formatVer != null) {
                sb.append(" format: ");
                sb.append(format);
                sb.append("/");
                sb.append(formatVer);
            }
            sb.append(" Java: ");
            sb.append(System.getProperty("java.version"));
            sb.append("/");
            sb.append(System.getProperty("java.vendor"));
            sb.append(" OS: ");
            sb.append(System.getProperty("os.name"));
            sb.append("/");
            sb.append(System.getProperty("os.arch"));
            sb.append("/");
            sb.append(System.getProperty("os.version"));
            sb.append(" JVM: ");
            sb.append(System.getProperty("java.vm.name"));
            sb.append("/");
            sb.append(System.getProperty("java.vm.vendor"));
            sb.append("/");
            sb.append(System.getProperty("java.vm.version"));
        }
        catch (Throwable ex) {
            this.m_logger.error((Object)("Error reading java system properties: " + ex));
        }
        return sb != null ? sb.toString() : null;
    }

    private OCSPResp sendRequestToUrl(OCSPReq req, String url, String httpFrom, String format, String formatVer) throws DigiDocException {
        OCSPResp resp = null;
        try {
            int nConfTm;
            byte[] breq = req.getEncoded();
            URL uUrl = new URL(url);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Connecting to ocsp url: " + url));
            }
            URLConnection con = uUrl.openConnection();
            int nTmout = con.getConnectTimeout();
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Default connection timeout: " + nTmout + " [ms]"));
            }
            if ((nConfTm = ConfigManager.instance().getIntProperty("OCSP_TIMEOUT", -1)) >= 0) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Setting connection and read timeout to: " + nConfTm + " [ms]"));
                }
                con.setConnectTimeout(nConfTm);
                con.setReadTimeout(nConfTm);
            }
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "application/ocsp-request");
            String sUserInfo = this.getUserInfo(format, formatVer);
            if (sUserInfo != null) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("User-Agent: " + sUserInfo));
                }
                con.setRequestProperty("User-Agent", sUserInfo);
            }
            if (httpFrom != null && httpFrom.trim().length() > 0) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("X-Forwarded-For: " + httpFrom));
                }
                con.setRequestProperty("X-Forwarded-For", httpFrom);
            }
            OutputStream os = con.getOutputStream();
            os.write(breq);
            os.close();
            InputStream is = con.getInputStream();
            int cl = con.getContentLength();
            byte[] bresp = null;
            if (cl > 0) {
                int rc;
                int avail = 0;
                do {
                    avail = is.available();
                    byte[] data = new byte[avail];
                    rc = is.read(data);
                    if (bresp == null) {
                        bresp = new byte[rc];
                        System.arraycopy(data, 0, bresp, 0, rc);
                        continue;
                    }
                    byte[] tmp = new byte[bresp.length + rc];
                    System.arraycopy(bresp, 0, tmp, 0, bresp.length);
                    System.arraycopy(data, 0, tmp, bresp.length, rc);
                    bresp = tmp;
                } while ((cl -= rc) > 0);
            }
            is.close();
            if (bresp != null) {
                resp = new OCSPResp(bresp);
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 65);
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws DigiDocException {
        FileInputStream fi = null;
        try {
            String sigFlag;
            String proxyHost = ConfigManager.instance().getProperty("DIGIDOC_PROXY_HOST");
            String proxyPort = ConfigManager.instance().getProperty("DIGIDOC_PROXY_PORT");
            if (proxyHost != null && proxyPort != null) {
                System.setProperty("http.proxyHost", proxyHost);
                System.setProperty("http.proxyPort", proxyPort);
            }
            this.m_bSignRequests = (sigFlag = ConfigManager.instance().getProperty("SIGN_OCSP_REQUESTS")) != null && sigFlag.equals("true");
            Provider prv = (Provider)Class.forName(ConfigManager.instance().getProperty("DIGIDOC_SECURITY_PROVIDER")).newInstance();
            Security.addProvider(prv);
            if (this.m_bSignRequests) {
                String p12file = ConfigManager.instance().getProperty("DIGIDOC_PKCS12_CONTAINER");
                String p12paswd = ConfigManager.instance().getProperty("DIGIDOC_PKCS12_PASSWD");
                String p12serial = ConfigManager.instance().getProperty("DIGIDOC_OCSP_SIGN_CERT_SERIAL");
                if (p12file != null && p12paswd != null) {
                    fi = new FileInputStream(p12file);
                    KeyStore store = KeyStore.getInstance("PKCS12", "BC");
                    store.load(fi, p12paswd.toCharArray());
                    Enumeration<String> en = store.aliases();
                    String pName = null;
                    while (en.hasMoreElements()) {
                        String n = en.nextElement();
                        if (!store.isKeyEntry(n)) continue;
                        pName = n;
                    }
                    this.m_signKey = (PrivateKey)store.getKey(pName, null);
                    Certificate[] certs = store.getCertificateChain(pName);
                    for (int i = 0; certs != null && i < certs.length; ++i) {
                        X509Certificate cert = (X509Certificate)certs[i];
                        if (this.m_logger.isInfoEnabled()) {
                            this.m_logger.info((Object)("Cert " + i + " subject: " + ConvertUtils.convX509Name(cert.getSubjectX500Principal())));
                            this.m_logger.info((Object)("Cert " + i + " issuer: " + ConvertUtils.convX509Name(cert.getIssuerX500Principal())));
                            this.m_logger.info((Object)("Cert " + i + " serial: " + cert.getSerialNumber()));
                            this.m_logger.info((Object)("Cert " + i + " is-ca: " + ConvertUtils.isCACert(cert)));
                        }
                        if (p12serial == null || cert == null || !cert.getSerialNumber().equals(new BigInteger(p12serial))) continue;
                        this.m_signCert = (X509Certificate)certs[i];
                    }
                }
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 67);
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                    fi = null;
                }
                catch (Exception ex2) {
                    this.m_logger.error((Object)("Error closing input stream: " + ex2));
                }
            }
        }
    }
}

