/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.TimestampInfo;
import ee.sk.digidoc.factory.HttpAuthenticator;
import ee.sk.digidoc.factory.TimestampFactory;
import ee.sk.utils.ConfigManager;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.tsp.TimeStampToken;

public class BouncyCastleTimestampFactory
implements TimestampFactory {
    private Logger m_logger = Logger.getLogger(BouncyCastleTimestampFactory.class);

    @Override
    public void init() throws DigiDocException {
    }

    @Override
    public boolean verifyTimestamp(TimestampInfo ts, X509Certificate tsaCert) throws DigiDocException {
        boolean bOk = false;
        TimeStampToken tstok = ts.getTimeStampToken();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Verifying TS: " + ts.getId() + " nr: " + ts.getSerialNumber() + " msg-imprint: " + Base64Util.encode(tstok.getTimeStampInfo().getMessageImprintDigest()) + " real digest: " + Base64Util.encode(ts.getHash())));
        }
        if (!SignedDoc.compareDigests(ts.getMessageImprint(), ts.getHash())) {
            this.m_logger.error((Object)("TS digest: " + Base64Util.encode(ts.getMessageImprint()) + " real digest: " + Base64Util.encode(ts.getHash())));
            throw new DigiDocException(126, "Bad digest for timestamp: " + ts.getId(), null);
        }
        if (tstok != null) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("TS: " + tstok.getTimeStampInfo().getSerialNumber()));
            }
            try {
                bOk = true;
            }
            catch (Exception ex) {
                bOk = false;
                this.m_logger.error((Object)("Timestamp verification error: " + ex));
                throw new DigiDocException(126, "Invalid timestamp: " + ex.getMessage(), ex);
            }
        }
        return bOk;
    }

    private int findTSAIndex(Signature sig, String cn) {
        int idx = 0;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Cearch index for: " + cn));
        }
        int nTsas = ConfigManager.instance().getIntProperty("DIGIDOC_TSA_COUNT", 0);
        for (int i = 0; i < nTsas; ++i) {
            String s1 = ConfigManager.instance().getProperty("DIGIDOC_TSA" + (i + 1) + "_CN");
            if (s1 == null || !s1.equals(cn)) continue;
            return i + 1;
        }
        return idx;
    }

    private X509Certificate findTSACert(int idx) throws DigiDocException {
        return SignedDoc.readCertificate(ConfigManager.instance().getProperty("DIGIDOC_TSA" + idx + "_CERT"));
    }

    private X509Certificate findTSACACert(int idx) throws DigiDocException {
        String fname = ConfigManager.instance().getProperty("DIGIDOC_TSA" + idx + "_CA_CERT");
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Read ca cert: " + fname));
        }
        return SignedDoc.readCertificate(fname);
    }

    @Override
    public ArrayList verifySignaturesTimestamps(Signature sig) {
        TimestampInfo ts;
        Date d1 = null;
        Date d2 = null;
        ArrayList<DigiDocException> errs = new ArrayList<DigiDocException>();
        ArrayList tsaCerts = sig.findTSACerts();
        for (int t = 0; t < sig.countTimestampInfos() && (ts = sig.getTimestampInfo(t)) != null; ++t) {
            if (ts.getType() == 3) {
                d1 = ts.getTime();
            }
            if (ts.getType() == 4) {
                d2 = ts.getTime();
            }
            boolean bVerified = false;
            DigiDocException ex2 = null;
            for (int j = 0; j < tsaCerts.size(); ++j) {
                X509Certificate tsaCert = (X509Certificate)tsaCerts.get(j);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Verifying TS: " + ts.getId() + " with: " + SignedDoc.getCommonName(tsaCert.getSubjectDN().getName())));
                }
                try {
                    if (this.verifyTimestamp(ts, tsaCert)) {
                        bVerified = true;
                        if (!this.m_logger.isDebugEnabled()) break;
                        this.m_logger.debug((Object)("TS: " + ts.getId() + " - OK"));
                        break;
                    }
                    this.m_logger.error((Object)("TS: " + ts.getId() + " - NOK"));
                    continue;
                }
                catch (DigiDocException ex) {
                    ex2 = ex;
                    this.m_logger.error((Object)("TS: " + ts.getId() + " - ERROR: " + ex));
                }
            }
            if (bVerified) continue;
            errs.add(ex2);
        }
        if (d1 != null && d2 != null) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("SignatureTimeStamp: " + d1 + " SigAndRefsTimeStamp: " + d2));
            }
            if (d1.after(d2)) {
                DigiDocException ex = new DigiDocException(126, "SignatureTimeStamp time must be before SigAndRefsTimeStamp time!", null);
                errs.add(ex);
            }
        }
        return errs;
    }

    @Override
    public TimeStampResponse requestTimestamp(String algorithm, byte[] digest, String url) {
        try {
            TimeStampResponse resp;
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("TS req: " + algorithm + " dig-len: " + (digest != null ? digest.length : 0) + " url: " + url + " digest: " + Base64Util.encode(digest)));
            }
            TimeStampRequestGenerator gen = new TimeStampRequestGenerator();
            gen.setCertReq(true);
            TimeStampRequest req = gen.generate(algorithm, digest);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("TS req nonce: " + (req.getNonce() != null ? req.getNonce().toString() : "NULL") + " msg-imprint: " + (req.getMessageImprintDigest() != null ? Base64Util.encode(req.getMessageImprintDigest()) : "NULL")));
            }
            URL uUrl = new URL(url);
            String ocspAuth = ConfigManager.instance().getProperty("DIGIDOC_OCSP_AUTH");
            if (ocspAuth != null) {
                String ocspAuthUser = ConfigManager.instance().getProperty("DIGIDOC_OCSP_AUTH_USER");
                String ocspAuthPasswd = ConfigManager.instance().getProperty("DIGIDOC_OCSP_AUTH_PASSWD");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("OCSP http auth: " + ocspAuthUser + "/" + ocspAuthPasswd));
                }
                HttpAuthenticator auth = new HttpAuthenticator(ocspAuthUser, ocspAuthPasswd);
                Authenticator.setDefault(auth);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Connecting to: " + url));
            }
            URLConnection con = uUrl.openConnection();
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Conn opened: " + (con != null ? "OK" : "NULL")));
            }
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "application/timestamp-query");
            OutputStream os = con.getOutputStream();
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("OS: " + (os != null ? "OK" : "NULL")));
            }
            if (os != null) {
                os.write(req.getEncoded());
                os.close();
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Wrote: " + req.getEncoded().length));
            }
            InputStream is = con.getInputStream();
            int cl = con.getContentLength();
            byte[] bresp = null;
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Recv: " + cl + " bytes"));
            }
            if (cl > 0) {
                int rc;
                int avail = 0;
                do {
                    avail = is.available();
                    byte[] data = new byte[avail];
                    rc = is.read(data);
                    if (bresp == null) {
                        bresp = new byte[rc];
                        System.arraycopy(data, 0, bresp, 0, rc);
                        continue;
                    }
                    byte[] tmp = new byte[bresp.length + rc];
                    System.arraycopy(bresp, 0, tmp, 0, bresp.length);
                    System.arraycopy(data, 0, tmp, bresp.length, rc);
                    bresp = tmp;
                } while ((cl -= rc) > 0);
            }
            is.close();
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Received: " + (bresp != null ? bresp.length : 0) + " bytes"));
            }
            TimeStampResponse timeStampResponse = resp = bresp != null ? new TimeStampResponse(bresp) : null;
            if (this.m_logger.isDebugEnabled() && resp != null && resp.getTimeStampToken() != null && resp.getTimeStampToken().getTimeStampInfo() != null) {
                this.m_logger.debug((Object)("TS resp: " + resp.getTimeStampToken().getTimeStampInfo().getSerialNumber().toString() + " msg-imprint: " + Base64Util.encode(resp.getTimeStampToken().getTimeStampInfo().getMessageImprintDigest())));
            }
            return resp;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Timestamp getting error: " + ex));
            return null;
        }
    }

    public TimeStampToken readTsTok(byte[] data) {
        try {
            ASN1InputStream aIn = new ASN1InputStream(data);
            CMSSignedData cmsD = new CMSSignedData((InputStream)aIn);
            TimeStampToken tstok = new TimeStampToken(cmsD);
            if (this.m_logger.isDebugEnabled() && tstok != null && tstok.getTimeStampInfo() != null) {
                this.m_logger.debug((Object)("TSTok: " + tstok.getTimeStampInfo().getSerialNumber().toString() + " hash: " + Base64Util.encode(tstok.getTimeStampInfo().getMessageImprintDigest())));
            }
            return tstok;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Timestamp getting error: " + ex));
            return null;
        }
    }
}

