/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.CompleteCertificateRefs;
import ee.sk.digidoc.CompleteRevocationRefs;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DataObjectFormat;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Identifier;
import ee.sk.digidoc.IncludeInfo;
import ee.sk.digidoc.KeyInfo;
import ee.sk.digidoc.ManifestFileEntry;
import ee.sk.digidoc.Notary;
import ee.sk.digidoc.ObjectIdentifier;
import ee.sk.digidoc.OcspRef;
import ee.sk.digidoc.Reference;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignaturePolicyId;
import ee.sk.digidoc.SignaturePolicyIdentifier;
import ee.sk.digidoc.SignatureProductionPlace;
import ee.sk.digidoc.SignedDataObjectProperties;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.SignedInfo;
import ee.sk.digidoc.SignedProperties;
import ee.sk.digidoc.SpUri;
import ee.sk.digidoc.TimestampInfo;
import ee.sk.digidoc.UnsignedProperties;
import ee.sk.digidoc.factory.DigiDocXmlGenFactory;
import ee.sk.digidoc.factory.NotaryFactory;
import ee.sk.digidoc.factory.TimestampFactory;
import ee.sk.digidoc.factory.TrustServiceFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.tsp.TSPAlgorithms;
import org.bouncycastle.tsp.TimeStampResponse;

public class DigiDocGenFactory {
    private static Logger m_logger = Logger.getLogger(DigiDocGenFactory.class);
    private static final String DIGI_OID_TEST = "1.3.6.1.4.1.10015.3.2.1";
    private static final String DIGI_OID_LIVE1 = "1.3.6.1.4.1.10015.1.2.3.1";
    private static final String DIGI_OID_LIVE2 = "1.3.6.1.4.1.10015.1.2.3.2";
    private static final String DIGI_OID_LIVE_TEST = "1.3.6.1.4.1.10015.1.2";
    private static final String DIGI_OID_TEST_TEST = "1.3.6.1.4.1.10015.3.2";
    private static final int PRE2011_KEYLEN = 162;
    private static final String RMID_OID_TEST = "1.3.6.1.4.1.10015.3.3.1";
    private static final String ASUTUSE_OID_TEST = "1.3.6.1.4.1.10015.3.7.1";
    private static final String MID_OID_TEST = "1.3.6.1.4.1.10015.3.11.1";
    public static final String BDOC_210_OID = "urn:oid:1.3.6.1.4.1.10015.1000.3.2.1";
    public static final String BDOC_210_DIGEST_VALUE = "3Tl1oILSvOAWomdI9VeWV6IA/32eSXRUri9kPEz1IVs=";
    public static final String BDOC_210_DIGEST_HEX = "dd3975a082d2bce016a26748f5579657a200ff7d9e497454ae2f643c4cf5215b";
    public static final String BDOC_210_DIGEST_METHOD = "http://www.w3.org/2001/04/xmlenc#sha256";
    public static final String BDOC_210_SPURI = "https://www.sk.ee/repository/bdoc-spec21.pdf";
    public static final String[] TEST_OIDS_PREFS = new String[]{"1.3.6.1.4.1.10015.3.7", "1.3.6.1.4.1.10015.7", "1.3.6.1.4.1.10015.3.3", "1.3.6.1.4.1.10015.3.11", "1.3.6.1.4.1.10015.3.2", "1.3.6.1.4.1.10015.3.1"};

    private static boolean certHasPolicy(X509Certificate cert, String sOid) {
        try {
            X509Extensions ext;
            ByteArrayInputStream bIn;
            ASN1InputStream aIn;
            ASN1Sequence seq;
            X509CertificateStructure obj;
            TBSCertificateStructure tbsCert;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Read cert policies: " + cert.getSerialNumber().toString()));
            }
            if ((tbsCert = (obj = new X509CertificateStructure(seq = (ASN1Sequence)(aIn = new ASN1InputStream((InputStream)(bIn = new ByteArrayInputStream(cert.getEncoded())))).readObject())).getTBSCertificate()).getVersion() == 3 && (ext = tbsCert.getExtensions()) != null) {
                Enumeration en = ext.oids();
                while (en.hasMoreElements()) {
                    Object o = en.nextElement();
                    if (!(o instanceof ASN1ObjectIdentifier)) continue;
                    ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)o;
                    X509Extension extVal = ext.getExtension(oid);
                    ASN1OctetString oct = extVal.getValue();
                    ASN1InputStream extIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(oct.getOctets()));
                    if (!oid.equals((Object)X509Extension.certificatePolicies)) continue;
                    ASN1Sequence cp = (ASN1Sequence)extIn.readObject();
                    for (int i = 0; i != cp.size(); ++i) {
                        String sId;
                        PolicyInformation pol = PolicyInformation.getInstance((Object)cp.getObjectAt(i));
                        if (pol == null || (sId = pol.getPolicyIdentifier().getId()) == null) continue;
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Policy: " + sId));
                        }
                        if (!sId.startsWith(sOid)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading cert policies: " + ex));
        }
        return false;
    }

    public static boolean is2011Card(X509Certificate cert) {
        return cert != null && cert.getPublicKey() instanceof RSAPublicKey && ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() == 2048;
    }

    public static boolean isDigiIdCard(X509Certificate cert) {
        return cert != null && cert.getPublicKey() instanceof RSAPublicKey && ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() == 1024 && (DigiDocGenFactory.certHasPolicy(cert, DIGI_OID_LIVE_TEST) || DigiDocGenFactory.certHasPolicy(cert, DIGI_OID_TEST_TEST) || DigiDocGenFactory.certHasPolicy(cert, RMID_OID_TEST) || DigiDocGenFactory.certHasPolicy(cert, ASUTUSE_OID_TEST) || DigiDocGenFactory.certHasPolicy(cert, MID_OID_TEST));
    }

    public static boolean isPre2011IdCard(X509Certificate cert) {
        return cert != null && cert.getPublicKey() instanceof RSAPublicKey && ((RSAPublicKey)cert.getPublicKey()).getModulus().bitLength() == 1024 && !DigiDocGenFactory.certHasPolicy(cert, DIGI_OID_LIVE_TEST) && !DigiDocGenFactory.certHasPolicy(cert, DIGI_OID_TEST_TEST);
    }

    public static boolean isTestCard(X509Certificate cert) {
        if (cert != null) {
            String cn = ConvertUtils.getCommonName(cert.getSubjectDN().getName());
            for (int i = 0; i < TEST_OIDS_PREFS.length; ++i) {
                String sOid = TEST_OIDS_PREFS[i];
                if (!(i == 1 ? DigiDocGenFactory.certHasPolicy(cert, sOid) && cn != null && cn.indexOf("TEST") != -1 : DigiDocGenFactory.certHasPolicy(cert, sOid))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEcPubKey(X509Certificate cert) {
        return cert != null && cert.getPublicKey().getAlgorithm().equals("EC");
    }

    public static SignedDoc createSignedDoc(String format, String version, String profile) throws DigiDocException {
        String ver = version;
        if (format != null && format.equals("BDOC")) {
            ver = "2.1";
            if (profile == null || profile.trim().length() == 0) {
                profile = ConfigManager.instance().getStringProperty("DIGIDOC_DEFAULT_PROFILE", "TM");
            }
        }
        if (format != null && (format.equals("SK-XML") || format.equals("DIGIDOC-XML"))) {
            if (ver == null) {
                ver = "1.3";
            }
            profile = "TM";
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Creating digidoc: " + format + " / " + ver + " / " + profile));
        }
        SignedDoc sdoc = new SignedDoc(format, ver);
        sdoc.setProfile(profile);
        return sdoc;
    }

    private static void registerCert(X509Certificate cert, int type, String id, Signature sig) throws DigiDocException {
        String sid = id;
        if (sid != null) {
            sid = sid.replace(" ", "_");
        }
        CertValue cval = new CertValue(sid, cert, type, sig);
        sig.addCertValue(cval);
        CertID cid = new CertID(sig, cert, type);
        sig.addCertID(cid);
        if (type != 1) {
            cid.setUri("#" + cval.getId());
        }
    }

    public static Signature prepareXadesBES(SignedDoc sdoc, String profile, X509Certificate cert, String[] claimedRoles, SignatureProductionPlace adr, String sId, String sSigMethod, String sDigType) throws DigiDocException {
        TrustServiceFactory tslFac;
        X509Certificate ca;
        Reference ref;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Prepare signature in sdoc: " + sdoc.getFormat() + "/" + sdoc.getVersion() + "/" + sdoc.getProfile() + " profile: " + profile + " signer: " + (cert != null ? SignedDoc.getCommonName(cert.getSubjectDN().getName()) : "unknown") + " id " + sId));
        }
        if (claimedRoles != null && claimedRoles.length > 1) {
            m_logger.error((Object)"Currently supports no more than 1 ClaimedRole");
            throw new DigiDocException(15, "Currently supports no more than 1 ClaimedRole", null);
        }
        if (cert == null) {
            m_logger.error((Object)"Signers certificate missing during signature preparation!");
            throw new DigiDocException(39, "Signers certificate missing during signature preparation!", null);
        }
        boolean bCheckNonRepu = ConfigManager.instance().getBooleanProperty("KEY_USAGE_CHECK", true);
        if (bCheckNonRepu && !ConfigManager.isSignatureKey(cert)) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)"Signers cert does not have non-repudiation bit set!");
            }
            throw new DigiDocException(162, "Signers cert does not have non-repudiation bit set!", null);
        }
        Signature sig = new Signature(sdoc);
        sig.setId(sId != null ? sId : sdoc.getNewSignatureId());
        if (profile != null) {
            sig.setProfile(profile);
            if (sdoc.getProfile() == null || sdoc.getProfile().equals("BES")) {
                sdoc.setProfile(profile);
            }
        } else {
            sig.setProfile(sdoc.getProfile());
        }
        SignedInfo si = new SignedInfo(sig, sSigMethod != null ? sSigMethod : "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        if (sdoc.getFormat().equals("BDOC") && sdoc.getVersion().equals("2.1")) {
            si.setCanonicalizationMethod("http://www.w3.org/2006/12/xml-c14n11");
            sdoc.setDefaultNsPref("BDOC");
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Signer: " + cert.getSubjectDN().getName() + " EC key: " + DigiDocGenFactory.isEcPubKey(cert) + " pre-2011: " + DigiDocGenFactory.isPre2011IdCard(cert) + " digi-id: " + DigiDocGenFactory.isDigiIdCard(cert) + " 2011: " + DigiDocGenFactory.is2011Card(cert)));
        }
        if (sSigMethod == null && sdoc.getFormat().equals("BDOC")) {
            if (DigiDocGenFactory.isPre2011IdCard(cert)) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"Generating rsa-sha224 signature for pre-2011 card");
                }
                si.setSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224");
            } else {
                String dType = ConfigManager.instance().getStringProperty("DIGIDOC_DIGEST_TYPE", "SHA-256");
                String sSigMeth = ConfigManager.digType2SigMeth(dType, DigiDocGenFactory.isEcPubKey(cert));
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Generating digest: " + dType + " and signature: " + sSigMeth));
                }
                if (sSigMeth != null) {
                    si.setSignatureMethod(sSigMeth);
                } else {
                    throw new DigiDocException(20, "Invalid digest type: " + dType, null);
                }
            }
        }
        if (sdoc.getFormat().equals("BDOC")) {
            si.setId(sig.getId() + "-SignedInfo");
        }
        SignedDataObjectProperties sdop = new SignedDataObjectProperties();
        for (int i = 0; i < sdoc.countDataFiles(); ++i) {
            DataFile df = sdoc.getDataFile(i);
            if (!df.isDigestsCalculated()) {
                df.calculateFileSizeAndDigest(null);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Add ref for df: " + df.getId()));
            }
            ref = new Reference(si, df, sDigType);
            if (sdoc.getFormat().equals("BDOC")) {
                ref.setId(sig.getId() + "-ref-" + i);
            }
            si.addReference(ref);
            if (!sdoc.getFormat().equals("BDOC") || !sdoc.getVersion().equals("2.1")) continue;
            DataObjectFormat dof = new DataObjectFormat("#" + ref.getId());
            dof.setMimeType(df.getMimeType());
            sdop.addDataObjectFormat(dof);
        }
        KeyInfo ki = new KeyInfo(cert);
        if (sdoc.getFormat().equals("BDOC")) {
            ki.setId(sig.getId() + "-KeyInfo");
        }
        sig.setKeyInfo(ki);
        ki.setSignature(sig);
        DigiDocGenFactory.registerCert(cert, 1, null, sig);
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Signer cert: " + cert.getSubjectDN().getName()));
        }
        if (sdoc.getFormat().equals("BDOC") && (ca = (tslFac = ConfigManager.instance().getTslFactory()).findCaForCert(cert, true, null)) != null) {
            String caId = sig.getId() + "-CA_CERT" + sig.countCertValues();
            DigiDocGenFactory.registerCert(ca, 4, caId, sig);
        }
        SignedProperties sp = new SignedProperties(sig, cert, claimedRoles, adr);
        sig.setSignedProperties(sp);
        if (sdoc.getFormat().equals("BDOC") && sdoc.getVersion().equals("2.1") && (sig.getProfile().equals("TM") || sig.getProfile().equals("BES") || sig.getProfile().equals("C-L") || sig.getProfile().equals("TM-A"))) {
            sp.setSignedDataObjectProperties(sdop);
            Identifier id1 = new Identifier(Identifier.OIDAsURN);
            ObjectIdentifier oid1 = new ObjectIdentifier(id1);
            SignaturePolicyId spi1 = new SignaturePolicyId(oid1);
            spi1.setDigestAlgorithm(BDOC_210_DIGEST_METHOD);
            if (sdoc.getVersion().equals("2.1")) {
                id1.setUri(BDOC_210_OID);
                spi1.setDigestValue(ConvertUtils.hex2bin(BDOC_210_DIGEST_HEX));
                spi1.addSigPolicyQualifier(new SpUri(BDOC_210_SPURI));
            }
            SignaturePolicyIdentifier spid1 = new SignaturePolicyIdentifier(spi1);
            sp.setSignaturePolicyIdentifier(spid1);
        } else {
            SignaturePolicyIdentifier spid1 = new SignaturePolicyIdentifier(null);
            sp.setSignaturePolicyIdentifier(spid1);
        }
        ref = new Reference(si, sp, sDigType);
        if (sdoc.getFormat().equals("BDOC")) {
            ref.setId(sig.getId() + "-ref-sp");
        }
        ref.setType("http://uri.etsi.org/01903#SignedProperties");
        si.addReference(ref);
        sig.setSignedInfo(si);
        sdoc.addSignature(sig);
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Prepared signature: " + sig.getId() + "/" + sig.getProfile()));
        }
        return sig;
    }

    public static Signature finalizeXadesBES(Signature sig, byte[] sigVal) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Finalize XAdES-BES sigval: " + (sigVal != null ? sigVal.length : 0) + " bytes"));
        }
        if (sigVal != null) {
            sig.setSignatureValue(sigVal);
        }
        return sig;
    }

    public static Signature finalizeXadesT(SignedDoc sdoc, Signature sig) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Finalize XAdES-T: " + sig.getId() + " profile: " + sig.getProfile()));
        }
        UnsignedProperties usp = new UnsignedProperties(sig);
        sig.setUnsignedProperties(usp);
        if (sdoc.getFormat().equals("BDOC")) {
            TimeStampResponse tresp;
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(sdoc);
            TimestampFactory tsFac = ConfigManager.instance().getTimestampFactory();
            StringBuffer sb = new StringBuffer();
            String tsaUrl = ConfigManager.instance().getProperty("DIGIDOC_TSA_URL");
            genFac.signatureValue2xml(sb, sig.getSignatureValue(), true);
            String sSigValXml = sb.toString().trim();
            byte[] hash = SignedDoc.digestOfType(sSigValXml.getBytes(), sdoc.getFormat().equals("BDOC") ? "SHA-256" : "SHA-1");
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Get sig-val-ts for: " + Base64Util.encode(hash) + " uri: " + tsaUrl + " DATA:\n---\n" + sSigValXml + "\n---\n"));
            }
            if ((tresp = tsFac.requestTimestamp(TSPAlgorithms.SHA1.getId(), hash, tsaUrl)) != null) {
                TimestampInfo ti = new TimestampInfo(sig.getId() + "-T0", sig, 3, hash, tresp);
                ti.addIncludeInfo(new IncludeInfo("#" + sig.getId() + "-SIG"));
                sig.addTimestampInfo(ti);
                try {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Timestamp: " + Base64Util.encode(tresp.getEncoded())));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sig.setProfile("T");
                try {
                    X509Certificate x509Certificate = SignedDoc.readCertificate(new File("/Users/veiko/workspace/jdigidoc/trunk/iaik-tsa.crt"));
                }
                catch (Exception ex) {
                    m_logger.error((Object)("Error ts: " + ex));
                }
            }
        }
        return sig;
    }

    public static Signature finalizeXadesC(SignedDoc sdoc, Signature sig) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Finalize XAdES-C: " + sig.getId() + " profile: " + sig.getProfile()));
        }
        CompleteRevocationRefs rrefs = new CompleteRevocationRefs();
        CompleteCertificateRefs crefs = new CompleteCertificateRefs();
        UnsignedProperties usp = sig.getUnsignedProperties();
        if (usp == null) {
            usp = new UnsignedProperties(sig);
            sig.setUnsignedProperties(usp);
        }
        usp.setCompleteCertificateRefs(crefs);
        usp.setCompleteRevocationRefs(rrefs);
        rrefs.setUnsignedProperties(usp);
        crefs.setUnsignedProperties(usp);
        sig.setUnsignedProperties(usp);
        sig.setProfile("C-L");
        return sig;
    }

    public static String getUserInfo(String format, String formatVer) {
        StringBuffer sb = null;
        try {
            sb = new StringBuffer("LIB ");
            sb.append("JDigiDoc");
            sb.append("/");
            sb.append("${env.JDD_VERSION}");
            if (format != null && formatVer != null) {
                sb.append(" format: ");
                sb.append(format);
                sb.append("/");
                sb.append(formatVer);
            }
            sb.append(" Java: ");
            sb.append(System.getProperty("java.version"));
            sb.append("/");
            sb.append(System.getProperty("java.vendor"));
            sb.append(" OS: ");
            sb.append(System.getProperty("os.name"));
            sb.append("/");
            sb.append(System.getProperty("os.arch"));
            sb.append("/");
            sb.append(System.getProperty("os.version"));
            sb.append(" JVM: ");
            sb.append(System.getProperty("java.vm.name"));
            sb.append("/");
            sb.append(System.getProperty("java.vm.vendor"));
            sb.append("/");
            sb.append(System.getProperty("java.vm.version"));
        }
        catch (Throwable ex) {
            m_logger.error((Object)("Error reading java system properties: " + ex));
        }
        return sb != null ? sb.toString() : null;
    }

    public static Signature finalizeXadesXL_TM(SignedDoc sdoc, Signature sig) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Finalize XAdES-TM: " + sig.getId() + " profile: " + sig.getProfile()));
        }
        NotaryFactory notFac = ConfigManager.instance().getNotaryFactory();
        X509Certificate cert = sig.getKeyInfo().getSignersCertificate();
        TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
        String ocspUrl = tslFac.findOcspUrlForCert(cert, 0, true);
        if (ocspUrl == null) {
            ocspUrl = ConfigManager.instance().getProperty("DIGIDOC_OCSP_RESPONDER_URL");
        }
        X509Certificate caCert = tslFac.findCaForCert(cert, true, null);
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Get confirmation for cert: " + (cert != null ? ConvertUtils.getCommonName(cert.getSubjectDN().getName()) : "NULL") + " CA: " + (caCert != null ? ConvertUtils.getCommonName(caCert.getSubjectDN().getName()) : "NULL") + " URL: " + (ocspUrl != null ? ocspUrl : "NONE")));
        }
        Notary not = notFac.getConfirmation(sig, cert, caCert, null, ocspUrl);
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Resp-id: " + (not != null ? not.getResponderId() : "NULL")));
        }
        String sRespId = null;
        if (not != null) {
            sRespId = ConvertUtils.getCommonName(not.getResponderId());
        }
        X509Certificate rcert = null;
        if (not != null) {
            rcert = notFac.getNotaryCert(sRespId, not.getCertNr());
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Find responder cert by: " + sRespId + " and nr: " + (not != null ? not.getCertNr() : "NULL") + " found: " + (rcert != null ? "OK" : "NO") + " format: " + sdoc.getFormat()));
        }
        if (sdoc.getFormat().equals("BDOC") && rcert != null) {
            X509Certificate rcacert = tslFac.findCaForCert(rcert, true, null);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Register responders CA: " + (rcacert != null ? rcacert.getSubjectDN().getName() : "NULL")));
            }
            if (rcacert != null) {
                String caId = not.getId() + "-CA_CERT" + sig.countCertValues();
                DigiDocGenFactory.registerCert(rcacert, 5, caId, sig);
            } else {
                m_logger.error((Object)("Responder ca not found for resp-id: " + sRespId));
            }
        }
        OcspRef orf = new OcspRef("#" + not.getId(), not.getResponderId(), not.getProducedAt(), sdoc.getFormat().equals("BDOC") ? BDOC_210_DIGEST_METHOD : "http://www.w3.org/2000/09/xmldsig#sha1", SignedDoc.digestOfType(not.getOcspResponseData(), sdoc.getFormat().equals("BDOC") ? "SHA-256" : "SHA-1"));
        sig.getUnsignedProperties().getCompleteRevocationRefs().addOcspRef(orf);
        sig.setProfile("TM");
        if (sdoc.getFormat().equals("BDOC") && sig.getPath() != null) {
            ManifestFileEntry mfe;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Find signature: " + sig.getPath()));
            }
            if ((mfe = sdoc.findManifestEntryByPath(sig.getPath())) != null) {
                mfe.setMediaType("signature/bdoc-" + sdoc.getVersion() + "/" + sig.getProfile());
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Change signature: " + sig.getPath() + " type: " + mfe.getMediaType()));
                }
            }
        }
        return sig;
    }

    public static Signature finalizeXadesXL_TS(SignedDoc sdoc, Signature sig) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Finalize XAdES-TS: " + sig.getId() + " profile: " + sig.getProfile()));
        }
        if (sdoc.getFormat().equals("BDOC")) {
            DigiDocXmlGenFactory genFac = new DigiDocXmlGenFactory(sdoc);
            TimestampFactory tsFac = ConfigManager.instance().getTimestampFactory();
            String sTsaCert = ConfigManager.instance().getStringProperty("DIGIDOC_TSA_CRT", null);
            if (sTsaCert != null) {
                X509Certificate tsaCrt;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("TSA cert: " + sTsaCert));
                }
                if ((tsaCrt = SignedDoc.readCertificate(sTsaCert)) != null) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Add tsa cert: " + tsaCrt.getSubjectDN().getName()));
                    }
                    DigiDocGenFactory.registerCert(tsaCrt, 3, sig.getId() + "-TSA", sig);
                }
            }
            sig.setProfile("TS");
        }
        return sig;
    }

    public static Signature finalizeSignature(SignedDoc sdoc, Signature sig, byte[] sigVal, String profile) throws DigiDocException {
        String prf = profile;
        if (prf == null) {
            prf = sdoc.getProfile();
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Finalize sig: " + sig.getId() + " profile: " + prf + " sdoc: " + sdoc.getFormat() + "/" + sdoc.getVersion()));
        }
        DigiDocGenFactory.finalizeXadesBES(sig, sigVal);
        if (prf != null) {
            if (prf.equals("T") || prf.equals("C-L") || prf.equals("TS")) {
                DigiDocGenFactory.finalizeXadesT(sdoc, sig);
            }
            if (prf.equals("C-L") || prf.equals("TM") || prf.equals("TS")) {
                DigiDocGenFactory.finalizeXadesC(sdoc, sig);
            }
            if (prf.equals("TM")) {
                DigiDocGenFactory.finalizeXadesXL_TM(sdoc, sig);
            }
            if (prf.equals("TS")) {
                DigiDocGenFactory.finalizeXadesXL_TS(sdoc, sig);
            }
        }
        return sig;
    }
}

