/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.factory.HttpAuthenticator;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class DigiDocServiceFactory {
    private static Logger m_logger = Logger.getLogger(DigiDocServiceFactory.class);
    public static final String STAT_OUTSTANDING_TRANSACTION = "OUTSTANDING_TRANSACTION";
    public static final String STAT_SIGNATURE = "SIGNATURE";
    public static final String STAT_ERROR = "ERROR";
    private static final String g_xmlHdr1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:d=\"http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl\" xmlns:mss=\"http://www.sk.ee:8096/MSSP_GW/MSSP_GW.wsdl\"><SOAP-ENV:Body SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><d:MobileCreateSignature>";
    private static final String g_xmlEnd1 = "</d:MobileCreateSignature></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final String g_xmlHdr2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:d=\"http://www.sk.ee/DigiDocService/DigiDocService_2_3.wsdl\" xmlns:mss=\"http://www.sk.ee:8096/MSSP_GW/MSSP_GW.wsdl\"><SOAP-ENV:Body SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><d:GetMobileCreateSignatureStatus>";
    private static final String g_xmlEnd2 = "</d:GetMobileCreateSignatureStatus></SOAP-ENV:Body></SOAP-ENV:Envelope>";

    private static void addElem(StringBuffer xml, String tag, String value) {
        if (value != null && value.trim().length() > 0) {
            xml.append("<");
            xml.append(tag);
            xml.append(">");
            xml.append(value);
            xml.append("</");
            xml.append(tag);
            xml.append(">");
        }
    }

    private static String findElemValue(String msg, String tag) {
        int nIdx1 = 0;
        int nIdx2 = 0;
        if (msg != null && tag != null && (nIdx1 = msg.indexOf("<" + tag)) != -1) {
            while (msg.charAt(nIdx1) != '>') {
                ++nIdx1;
            }
            nIdx2 = msg.indexOf("</" + tag, ++nIdx1);
            if (nIdx1 > 0 && nIdx2 > 0) {
                return msg.substring(nIdx1, nIdx2);
            }
        }
        return null;
    }

    private static String findAttrValue(String msg, String attr) {
        int nIdx1 = 0;
        int nIdx2 = 0;
        if (msg != null && attr != null && (nIdx1 = msg.indexOf(attr)) != -1) {
            while (msg.charAt(nIdx1) != '=') {
                ++nIdx1;
            }
            if (msg.charAt(++nIdx1) == '\"') {
                ++nIdx1;
            }
            nIdx2 = msg.indexOf("\"", nIdx1);
            if (nIdx1 > 0 && nIdx2 > 0) {
                return msg.substring(nIdx1, nIdx2);
            }
        }
        return null;
    }

    private static String pullUrl(String url, String msg) {
        try {
            String ocspAuth;
            URL uUrl = new URL(url);
            String storename = ConfigManager.instance().getProperty("DDS_TRUSTSTORE");
            String storpass = ConfigManager.instance().getProperty("DDS_STOREAPASS");
            String stortype = ConfigManager.instance().getProperty("DDS_STORETYPE");
            if (storename != null) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("https truststore: " + storename + "/" + stortype));
                }
                System.setProperty("javax.net.ssl.trustStore", storename);
                System.setProperty("javax.net.ssl.trustStorePassword", storpass);
                System.setProperty("javax.net.ssl.trustStoreType", stortype);
            }
            if ((ocspAuth = ConfigManager.instance().getProperty("DIGIDOC_OCSP_AUTH")) != null) {
                String ocspAuthUser = ConfigManager.instance().getProperty("DIGIDOC_OCSP_AUTH_USER");
                String ocspAuthPasswd = ConfigManager.instance().getProperty("DIGIDOC_OCSP_AUTH_PASSWD");
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("http auth: " + ocspAuthUser + "/" + ocspAuthPasswd));
                }
                HttpAuthenticator auth = new HttpAuthenticator(ocspAuthUser, ocspAuthPasswd);
                Authenticator.setDefault(auth);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Connecting to: " + url));
            }
            URLConnection con = uUrl.openConnection();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Conn opened: " + (con != null ? "OK" : "NULL")));
            }
            con.setAllowUserInteraction(false);
            con.setUseCaches(false);
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setRequestProperty("Content-Type", "text/xml; charset=utf-8");
            con.setRequestProperty("User-Agent", "JDigiDoc / ${env.JDD_VERSION}");
            con.setRequestProperty("SOAPAction", "");
            OutputStream os = con.getOutputStream();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("OS: " + (os != null ? "OK" : "NULL")));
            }
            if (os != null) {
                os.write(msg.getBytes("UTF-8"));
                os.close();
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Wrote: " + msg.length()));
            }
            InputStream is = con.getInputStream();
            int cl = con.getContentLength();
            byte[] bresp = null;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Recv: " + cl + " bytes"));
            }
            if (cl > 0) {
                int rc;
                int avail = 0;
                do {
                    avail = is.available();
                    byte[] data = new byte[avail];
                    rc = is.read(data);
                    if (bresp == null) {
                        bresp = new byte[rc];
                        System.arraycopy(data, 0, bresp, 0, rc);
                        continue;
                    }
                    byte[] tmp = new byte[bresp.length + rc];
                    System.arraycopy(bresp, 0, tmp, 0, bresp.length);
                    System.arraycopy(data, 0, tmp, bresp.length, rc);
                    bresp = tmp;
                } while ((cl -= rc) > 0);
            }
            is.close();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Received: " + (bresp != null ? bresp.length : 0) + " bytes"));
            }
            String resp = bresp != null ? new String(bresp, "UTF-8") : null;
            return resp;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Soap error: " + ex));
            return null;
        }
    }

    public static String ddsSign(SignedDoc sdoc, String sIdCode, String sPhoneNo, String sLang, String sServiceName, String sManifest, String sCity, String sState, String sZip, String sCountry, StringBuffer sbChallenge) throws DigiDocException {
        String sSessCode = null;
        if (sdoc == null) {
            throw new DigiDocException(128, "Missing SignedDoc object", null);
        }
        if (sIdCode == null || sIdCode.trim().length() < 11) {
            throw new DigiDocException(128, "Missing or invalid personal id-code", null);
        }
        if (sPhoneNo == null || sPhoneNo.trim().length() < 5) {
            throw new DigiDocException(128, "Missing or invalid phone number", null);
        }
        if (sCountry == null || sCountry.trim().length() < 2) {
            throw new DigiDocException(128, "Missing or invalid country code", null);
        }
        ConfigManager cfg = ConfigManager.instance();
        String sUrl = cfg.getProperty("DDS_URL");
        StringBuffer sbMsg = new StringBuffer(g_xmlHdr1);
        DigiDocServiceFactory.addElem(sbMsg, "IDCode", sIdCode);
        DigiDocServiceFactory.addElem(sbMsg, "SignersCountry", sCountry);
        DigiDocServiceFactory.addElem(sbMsg, "PhoneNo", sPhoneNo);
        DigiDocServiceFactory.addElem(sbMsg, "Language", sLang);
        DigiDocServiceFactory.addElem(sbMsg, "ServiceName", sServiceName);
        DigiDocServiceFactory.addElem(sbMsg, "Role", sManifest);
        DigiDocServiceFactory.addElem(sbMsg, "City", sCity);
        DigiDocServiceFactory.addElem(sbMsg, "StateOrProvince", sState);
        DigiDocServiceFactory.addElem(sbMsg, "PostalCode", sZip);
        DigiDocServiceFactory.addElem(sbMsg, "CountryName", sCountry);
        sbMsg.append("<DataFiles>");
        for (int i = 0; i < sdoc.countDataFiles(); ++i) {
            DataFile df = sdoc.getDataFile(i);
            sbMsg.append("<DataFileDigest>");
            DigiDocServiceFactory.addElem(sbMsg, "Id", df.getId());
            DigiDocServiceFactory.addElem(sbMsg, "DigestType", "sha1");
            String sHash = Base64Util.encode(df.getDigest());
            DigiDocServiceFactory.addElem(sbMsg, "DigestValue", sHash);
            sbMsg.append("</DataFileDigest>");
        }
        sbMsg.append("</DataFiles>");
        DigiDocServiceFactory.addElem(sbMsg, "Format", sdoc.getFormat());
        DigiDocServiceFactory.addElem(sbMsg, "Version", sdoc.getVersion());
        String sId = sdoc.getNewSignatureId();
        DigiDocServiceFactory.addElem(sbMsg, "SignatureID", sId);
        DigiDocServiceFactory.addElem(sbMsg, "MessagingMode", "asynchClientServer");
        DigiDocServiceFactory.addElem(sbMsg, "AsyncConfiguration", "0");
        sbMsg.append(g_xmlEnd1);
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Sending:\n---\n" + sbMsg.toString() + "\n---\n"));
        }
        String sResp = DigiDocServiceFactory.pullUrl(sUrl, sbMsg.toString());
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Received:\n---\n" + sResp + "\n---\n"));
        }
        if (sResp != null && sResp.trim().length() > 0) {
            sSessCode = DigiDocServiceFactory.findElemValue(sResp, "Sesscode");
            String s = DigiDocServiceFactory.findElemValue(sResp, "ChallengeID");
            if (s != null) {
                sbChallenge.append(s);
            }
        }
        return sSessCode;
    }

    public static String ddsGetStatus(SignedDoc sdoc, String sSesscode) throws DigiDocException {
        String s;
        String sStatus = null;
        if (sdoc == null) {
            throw new DigiDocException(128, "Missing SignedDoc object", null);
        }
        if (sSesscode == null || sSesscode.trim().length() == 0) {
            throw new DigiDocException(128, "Missing or invalid  session code", null);
        }
        ConfigManager cfg = ConfigManager.instance();
        String sUrl = cfg.getProperty("DDS_URL");
        StringBuffer sbMsg = new StringBuffer(g_xmlHdr2);
        DigiDocServiceFactory.addElem(sbMsg, "Sesscode", sSesscode);
        DigiDocServiceFactory.addElem(sbMsg, "WaitSignature", "false");
        sbMsg.append(g_xmlEnd2);
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Sending:\n---\n" + sbMsg.toString() + "\n---\n"));
        }
        String sResp = DigiDocServiceFactory.pullUrl(sUrl, sbMsg.toString());
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Received:\n---\n" + sResp + "\n---\n"));
        }
        if (sResp != null && sResp.trim().length() > 0 && (sStatus = DigiDocServiceFactory.findElemValue(sResp, "Status")) != null && sStatus.equals(STAT_SIGNATURE) && (s = DigiDocServiceFactory.findElemValue(sResp, "Signature")) != null) {
            String sSig = ConvertUtils.unescapeXmlSymbols(s);
            String sId = DigiDocServiceFactory.findAttrValue(sSig, "Id");
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Signature: " + sId + "\n---\n" + sSig + "\n---\n"));
            }
            Signature sig = new Signature(sdoc);
            sig.setId(sId);
            try {
                sig.setOrigContent(sSig.getBytes("UTF-8"));
            }
            catch (Exception ex) {
                m_logger.error((Object)("Error adding signature: " + ex));
                DigiDocException.handleException(ex, 128);
            }
            sdoc.addSignature(sig);
        }
        return sStatus;
    }
}

