/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DataObjectFormat;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Identifier;
import ee.sk.digidoc.ManifestFileEntry;
import ee.sk.digidoc.Notary;
import ee.sk.digidoc.OcspRef;
import ee.sk.digidoc.Rdn;
import ee.sk.digidoc.Reference;
import ee.sk.digidoc.SigPolicyQualifier;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.SignedProperties;
import ee.sk.digidoc.SpUri;
import ee.sk.digidoc.factory.DigiDocGenFactory;
import ee.sk.digidoc.factory.NotaryFactory;
import ee.sk.digidoc.factory.TrustServiceFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.File;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public class DigiDocVerifyFactory {
    private static Logger m_logger = Logger.getLogger(DigiDocVerifyFactory.class);
    private static boolean m_prvInited = false;
    private static final String DIG_TYPE_WARNING = "The current BDoc container uses weaker encryption method than officialy accepted in Estonia. We do not recommend you to add signature to this document. There is an option to re-sign this document in a new container.";
    private static final String DIGIDOC_VERIFY_ALGORITHM = "RSA/NONE/PKCS1Padding";

    public static void initProvider() {
        try {
            if (!m_prvInited) {
                Provider prv = (Provider)Class.forName(ConfigManager.instance().getProperty("DIGIDOC_SECURITY_PROVIDER")).newInstance();
                Security.addProvider(prv);
                m_prvInited = true;
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error initting provider: " + ex));
        }
    }

    public static boolean compareDigests(byte[] dig1, byte[] dig2) {
        boolean ok = dig1 != null && dig2 != null && dig1.length == dig2.length;
        for (int i = 0; ok && i < dig1.length; ++i) {
            if (dig1[i] == dig2[i]) continue;
            ok = false;
        }
        return ok;
    }

    public static boolean verifyManifestEntries(SignedDoc sdoc, List lerrs) throws DigiDocException {
        boolean bOk = true;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)"Verifying manifest entries");
        }
        if (sdoc != null && sdoc.getFormat() != null && sdoc.getFormat().equals("BDOC")) {
            boolean bF;
            for (int i = 0; i < sdoc.countDataFiles(); ++i) {
                DataFile df = sdoc.getDataFile(i);
                bF = false;
                String sFileName = df.getFileName();
                File ft1 = new File(df.getFileName());
                sFileName = ft1.getName();
                if (sdoc.getManifest() != null) {
                    for (int j = 0; j < sdoc.getManifest().getNumFileEntries(); ++j) {
                        ManifestFileEntry mfe = sdoc.getManifest().getFileEntry(j);
                        if (mfe == null) continue;
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Manifest entry: " + mfe.getFullPath() + " mime: " + mfe.getMediaType() + " df: " + df.getId() + " df-mime: " + df.getMimeType()));
                        }
                        if (mfe.getFullPath() == null || !mfe.getFullPath().equals(sFileName)) continue;
                        if (bF) {
                            lerrs.add(new DigiDocException(180, "Duplicate ManifestFileEntry for: " + df.getFileName(), null));
                            if (m_logger.isDebugEnabled()) {
                                m_logger.error((Object)("Duplicate ManifestFileEntry for: " + df.getFileName()));
                            }
                            bOk = false;
                        } else {
                            bF = true;
                        }
                        if (mfe.getMediaType() != null && df.getMimeType() != null && mfe.getMediaType().equals(df.getMimeType())) continue;
                        lerrs.add(new DigiDocException(181, "DataFile " + df.getFileName() + " mime-type: " + df.getMimeType() + " does not match manifest mime type: " + mfe.getMediaType(), null));
                        if (m_logger.isDebugEnabled()) {
                            m_logger.error((Object)("DataFile " + df.getFileName() + " mime-type: " + df.getMimeType() + " does not match manifest mime type: " + mfe.getMediaType()));
                        }
                        bOk = false;
                    }
                    for (int s = 0; s < sdoc.countSignatures(); ++s) {
                        DataObjectFormat dof;
                        Signature sig = sdoc.getSignature(s);
                        Reference dRef = sig.getSignedInfo().getReferenceForDataFile(df);
                        if (dRef == null || (dof = sig.getSignedInfo().getDataObjectFormatForReference(dRef)) == null || df.getMimeType() == null || dof.getMimeType() == null || dof.getMimeType().equals(df.getMimeType())) continue;
                        lerrs.add(new DigiDocException(181, "DataFile " + df.getFileName() + " mime-type: " + df.getMimeType() + " does not match signature: " + sig.getId() + " mime type: " + dof.getMimeType(), null));
                        if (m_logger.isDebugEnabled()) {
                            m_logger.error((Object)("DataFile " + df.getFileName() + " mime-type: " + df.getMimeType() + " does not match signature: " + sig.getId() + " mime type: " + dof.getMimeType()));
                        }
                        bOk = false;
                    }
                }
                if (bF) continue;
                lerrs.add(new DigiDocException(180, "Missing ManifestFileEntry for: " + df.getFileName(), null));
                if (!m_logger.isDebugEnabled()) continue;
                m_logger.error((Object)("Missing ManifestFileEntry1 for: " + sFileName));
            }
            for (int j = 0; j < sdoc.getManifest().getNumFileEntries(); ++j) {
                ManifestFileEntry mfe = sdoc.getManifest().getFileEntry(j);
                if (mfe == null) {
                    m_logger.error((Object)"Invalid manifest entry");
                    continue;
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Check manifest entry: " + mfe.getFullPath() + " mime: " + mfe.getMediaType()));
                }
                if (mfe.getFullPath() != null && mfe.getFullPath().equals("/")) continue;
                bF = false;
                for (int i = 0; i < sdoc.countDataFiles(); ++i) {
                    DataFile df = sdoc.getDataFile(i);
                    String sFileName = df.getFileName();
                    File ft1 = new File(df.getFileName());
                    sFileName = ft1.getName();
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Manifest entry: " + mfe.getFullPath() + " mime: " + mfe.getMediaType() + " found df: " + df.getId() + " df-mime: " + df.getMimeType()));
                    }
                    if (mfe.getFullPath() == null || !mfe.getFullPath().equals(sFileName)) continue;
                    if (bF) {
                        lerrs.add(new DigiDocException(180, "Duplicate DataFile: " + df.getId() + " with name: " + df.getFileName(), null));
                        if (m_logger.isDebugEnabled()) {
                            m_logger.error((Object)("Duplicate DataFile: " + df.getId() + " with name: " + df.getFileName()));
                        }
                        bOk = false;
                        continue;
                    }
                    bF = true;
                }
                if (bF) continue;
                lerrs.add(new DigiDocException(180, "Missing DataFile for ManifestFileEntry: " + mfe.getFullPath(), null));
                if (!m_logger.isDebugEnabled()) continue;
                m_logger.error((Object)("Missing DataFile for ManifestFileEntry: " + mfe.getFullPath()));
            }
        }
        return bOk;
    }

    private static boolean verifyDataFileHash(SignedDoc sdoc, DataFile df, Reference ref, List lerrs) {
        boolean bOk = true;
        if (df != null) {
            byte[] dfDig;
            block27: {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Check digest for DF: " + df.getId() + " ref: " + (ref != null ? ref.getUri() : "NULL")));
                }
                String sDigType = null;
                if (ref != null) {
                    sDigType = ConfigManager.digAlg2Type(ref.getDigestAlgorithm());
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Check digest for DF: " + df.getId() + " type: " + sDigType));
                }
                dfDig = null;
                try {
                    if (sDigType != null) {
                        dfDig = df.getDigestValueOfType(sDigType);
                    }
                }
                catch (DigiDocException ex) {
                    lerrs.add(ex);
                    bOk = false;
                    m_logger.error((Object)("Error calculating hash for df: " + df.getId() + " - " + ex));
                    ex.printStackTrace();
                    if (ex.getNestedException() == null) break block27;
                    ex.getNestedException().printStackTrace();
                }
            }
            if (ref != null) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Compare digest: " + (dfDig != null ? Base64Util.encode(dfDig, 0) : "NONE") + " hex: " + (dfDig != null ? ConvertUtils.bin2hex(dfDig) : "NONE") + " alt digest: " + (df.getAltDigest() != null ? Base64Util.encode(df.getAltDigest(), 0) : "NONE") + " to: " + (ref.getDigestValue() != null ? Base64Util.encode(ref.getDigestValue()) : "NONE") + " hex: " + (ref.getDigestValue() != null ? ConvertUtils.bin2hex(ref.getDigestValue()) : "NONE")));
                }
                DigiDocException exd = null;
                if (!SignedDoc.compareDigests(ref.getDigestValue(), dfDig)) {
                    exd = new DigiDocException(79, "Bad digest for DataFile: " + df.getId(), null);
                    lerrs.add(exd);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("BAD DIGEST for DF: " + df.getId()));
                    }
                    bOk = false;
                }
                if (!bOk && df.getAltDigest() != null) {
                    if (SignedDoc.compareDigests(ref.getDigestValue(), df.getAltDigest())) {
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("DF: " + df.getId() + " alternate digest matches!"));
                            m_logger.debug((Object)("GOOD ALT DIGEST for DF: " + df.getId()));
                        }
                        if (exd != null) {
                            lerrs.remove(exd);
                        }
                        ref.getSignedInfo().getSignature().setAltDigestMatch(true);
                        if (!ref.getSignedInfo().getSignature().getSignedDoc().getFormat().equals("SK-XML")) {
                            exd = new DigiDocException(173, "Bad digest for DataFile: " + df.getId() + " alternate digest matches!", null);
                            lerrs.add(exd);
                        }
                        bOk = false;
                    }
                } else if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"GOOD DIGEST");
                }
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"No Reference");
                }
                lerrs.add(new DigiDocException(78, "No Reference element for DataFile: " + df.getId(), null));
                bOk = false;
            }
            if (sdoc.getFormat().equals("BDOC")) {
                String sFile = df.getFileName();
                if (sFile != null && (sFile.indexOf(47) != -1 || sFile.indexOf(92) != -1)) {
                    File fT = new File(sFile);
                    sFile = fT.getName();
                }
                ManifestFileEntry mfe = sdoc.getManifest().findFileEntryByPath(sFile);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("DF: " + df.getId() + " file: " + sFile + " manifest-entry: " + (mfe != null ? "OK" : "NULL")));
                    if (mfe == null) {
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("No manifest.xml entry for: " + df.getFileName()));
                        }
                        lerrs.add(new DigiDocException(28, "No manifest.xml entry for: " + df.getFileName(), null));
                        bOk = false;
                    }
                }
            }
        } else {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)"Invalid data-file");
            }
            bOk = false;
        }
        return bOk;
    }

    private static boolean verifySignedPropretiesHash(Signature sig, List lerrs) {
        boolean bOk = true;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Verifying signed-props of: " + sig.getId()));
        }
        SignedProperties sp = sig.getSignedProperties();
        boolean bSha1Check = ConfigManager.instance().getBooleanProperty("BDOC_SHA1_CHECK", true);
        if (sp != null) {
            Reference ref2 = sig.getSignedInfo().getReferenceForSignedProperties(sp);
            if (ref2 != null && sig.getSignedDoc().getFormat().equals("BDOC") && ref2.getDigestAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#sha1") && ConfigManager.instance().getBooleanProperty("BDOC_SHA1_CHECK", true)) {
                lerrs.add(new DigiDocException(129, DIG_TYPE_WARNING, null));
                if (m_logger.isInfoEnabled()) {
                    m_logger.info((Object)("SignedProperties for signature: " + sig.getId() + " has weak digest type: " + ref2.getDigestAlgorithm()));
                }
            }
            if (ref2 != null) {
                byte[] spDig = null;
                try {
                    spDig = sp.calculateDigest();
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("SignedProp real digest: " + Base64Util.encode(spDig, 0)));
                    }
                }
                catch (DigiDocException ex) {
                    lerrs.add(ex);
                    bOk = false;
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Compare it to: " + Base64Util.encode(ref2.getDigestValue(), 0)));
                }
                if (!SignedDoc.compareDigests(ref2.getDigestValue(), spDig)) {
                    lerrs.add(new DigiDocException(79, "Bad digest for SignedProperties: " + sp.getId(), null));
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)"BAD DIGEST for sig-prop");
                    }
                    bOk = false;
                } else if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"GOOD DIGEST");
                }
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("No Reference element for SignedProperties: " + sp.getId()));
                }
                lerrs.add(new DigiDocException(80, "No Reference element for SignedProperties: " + sp.getId(), null));
                bOk = false;
            }
        } else {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("No Reference element for SignedProperties of sig: " + sig.getId()));
            }
            lerrs.add(new DigiDocException(80, "No Reference element for SignedProperties sig: " + sig.getId(), null));
            bOk = false;
        }
        return bOk;
    }

    public static boolean verify(byte[] digest, byte[] signature, X509Certificate cert, boolean bSoftCert, String sigMethod) throws DigiDocException {
        boolean rc = false;
        try {
            if (cert == null) {
                throw new DigiDocException(81, "Invalid or missing signers cert!", null);
            }
            if (bSoftCert) {
                ConfigManager.instance();
                String sigType = ConfigManager.sigMeth2SigType(sigMethod, true);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Verify xml:\n---\n" + new String(digest) + "\n---\n len: " + digest.length + " method: " + sigMethod + " sig-type: " + sigType + "\n---\n" + ConvertUtils.bin2hex(signature) + " sig-len: " + signature.length));
                }
                if (sigType == null) {
                    throw new DigiDocException(81, "Signature method: " + sigMethod + " not provided!", null);
                }
                java.security.Signature sig = java.security.Signature.getInstance(sigType, ConfigManager.addProvider());
                sig.initVerify(cert.getPublicKey());
                sig.update(digest);
                rc = sig.verify(signature);
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Verify sig: " + signature.length + " bytes, alg: " + DIGIDOC_VERIFY_ALGORITHM + " sig-alg: " + sigMethod));
                }
                Cipher cryptoEngine = Cipher.getInstance(DIGIDOC_VERIFY_ALGORITHM, "BC");
                cryptoEngine.init(2, cert);
                byte[] decdig = null;
                try {
                    decdig = cryptoEngine.doFinal(signature);
                }
                catch (ArrayIndexOutOfBoundsException ex2) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Invalid signature value. Signers cert and signature value don't match! - " + ex2));
                    }
                    throw new DigiDocException(81, "Invalid signature value! Signers cert and signature value don't match!", ex2);
                }
                String digType2 = ConfigManager.sigMeth2Type(sigMethod);
                String digType1 = ConvertUtils.findDigType(decdig);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Decrypted digest: '" + SignedDoc.bin2hex(decdig) + "' len: " + decdig.length + " has-pref: " + digType1 + " must-have: " + digType2 + " alg: " + sigMethod));
                }
                if (digType1 != null && digType1.equals("SHA-1-00")) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)"Invalid signature asn.1 prefix with 0x00 byte");
                    }
                    throw new DigiDocException(174, "Invalid signature asn.1 prefix with 0x00 byte", null);
                }
                if (digType1 == null || digType2 != null && digType1 != null && !digType2.equals(digType1)) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Signature asn.1 prefix: " + digType1 + " does not match: " + digType2));
                    }
                    throw new DigiDocException(166, "Signature asn.1 prefix: " + digType1 + " does not match: " + digType2, null);
                }
                byte[] cdigest = ConvertUtils.removePrefix(decdig);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Signed digest: '" + (cdigest != null ? SignedDoc.bin2hex(cdigest) : "NULL") + "' calc-digest: '" + SignedDoc.bin2hex(digest) + "'"));
                }
                if (decdig != null && cdigest != null && decdig.length == cdigest.length) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Signature value decrypted len: " + decdig.length + " missing ASN.1 structure prefix"));
                    }
                    throw new DigiDocException(81, "Invalid signature value! Signature value decrypted len: " + decdig.length + " missing ASN.1 structure prefix", null);
                }
                rc = DigiDocVerifyFactory.compareDigests(digest, cdigest);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Result: " + rc));
            }
            if (!rc) {
                throw new DigiDocException(81, "Invalid signature value!", null);
            }
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 81);
        }
        return rc;
    }

    public static boolean verifySignatureValue(SignedDoc sdoc, Signature sig, List lerrs) {
        boolean bOk = true;
        if (sdoc == null) {
            m_logger.error((Object)"SignedDoc is null");
            return false;
        }
        if (sig == null) {
            m_logger.error((Object)"Signature is null");
            return false;
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Verifying signature value of: " + sig.getId()));
        }
        try {
            byte[] dig = sig.getSignedInfo().calculateDigest();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("SignedInfo real digest: " + Base64Util.encode(dig, 0) + " hex: " + SignedDoc.bin2hex(dig) + " sig: " + ConvertUtils.bin2hex(sig.getSignatureValue().getValue()) + " len: " + sig.getSignatureValue().getValue().length));
            }
            if (sdoc.getFormat().equals("BDOC") && (sig.getSignedInfo().getSignatureMethod().equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || sig.getSignedInfo().getSignatureMethod().equals("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1")) && ConfigManager.instance().getBooleanProperty("BDOC_SHA1_CHECK", true)) {
                lerrs.add(new DigiDocException(129, DIG_TYPE_WARNING, null));
                if (m_logger.isInfoEnabled()) {
                    m_logger.info((Object)("Signature: " + sig.getId() + " has weak signature method: " + sig.getSignedInfo().getSignatureMethod()));
                }
            }
            if (sig.getSignatureValue() != null && sig.getSignatureValue().getValue() != null && dig != null) {
                if (sdoc.getFormat().equals("BDOC") && sig.isEllipticCurveSiganture()) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Verify sdoc: " + sdoc.getFormat() + "/" + sdoc.getVersion() + " prefs: " + sdoc.getXmlDsigNs() + "/" + sdoc.getAsicNs() + "/" + sdoc.getXadesNs()));
                    }
                    byte[] xml = sig.getSignedInfo().getOrigXml();
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Verify xml:\n---\n" + new String(xml) + "\n---\n"));
                    }
                    bOk = DigiDocVerifyFactory.verify(xml, sig.getSignatureValue().getValue(), sig.getKeyInfo().getSignersCertificate(), true, sig.getSignedInfo().getSignatureMethod());
                } else {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Verify sig: " + ConvertUtils.bin2hex(sig.getSignatureValue().getValue()) + " len: " + sig.getSignatureValue().getValue().length + " hlen: " + ConvertUtils.bin2hex(sig.getSignatureValue().getValue()).length()));
                    }
                    bOk = DigiDocVerifyFactory.verify(dig, sig.getSignatureValue().getValue(), sig.getKeyInfo().getSignersCertificate(), false, sig.getSignedInfo().getSignatureMethod());
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"GOOD DIGEST");
                }
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"Missing signature value!");
                }
                lerrs.add(new DigiDocException(38, "Missing signature value!", null));
                bOk = false;
            }
        }
        catch (DigiDocException ex) {
            lerrs.add(ex);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("BAD DIGEST for sig-inf: " + sig.getId() + " - " + ex.toString()));
                m_logger.debug((Object)("TRACE: " + ConvertUtils.getTrace(ex)));
                m_logger.debug((Object)("sig-val-len: " + (sig.getSignatureValue() != null && sig.getSignatureValue().getValue() != null ? sig.getSignatureValue().getValue().length : 0)));
                m_logger.debug((Object)("signer: " + (sig.getKeyInfo() != null && sig.getKeyInfo().getSignersCertificate() != null ? sig.getKeyInfo().getSignersCertificate().getSubjectDN().getName() : "NULL")));
            }
            bOk = false;
        }
        return bOk;
    }

    public static boolean verifyCertificate(X509Certificate cert, X509Certificate caCert) throws DigiDocException {
        boolean rc = false;
        try {
            if (caCert != null) {
                cert.verify(caCert.getPublicKey());
                rc = true;
            }
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 94);
        }
        return rc;
    }

    public static boolean verifySignersCerificate(Signature sig, List lerrs) {
        boolean bOk = true;
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Verifying CA of signature: " + sig.getId() + " signed-at: " + ConvertUtils.date2string(sig.getSignedProperties().getSigningTime(), sig.getSignedDoc()) + " produced: " + ConvertUtils.date2string(sig.getSignatureProducedAtTime(), sig.getSignedDoc())));
            }
            TrustServiceFactory tslFac = ConfigManager.instance().getTslFactory();
            if (sig.getKeyInfo().getSignersCertificate() == null) {
                lerrs.add(new DigiDocException(39, "Signers cert missing!", null));
                return false;
            }
            X509Certificate caCert = tslFac.findCaForCert(sig.getKeyInfo().getSignersCertificate(), true, sig.getSignatureProducedAtTime());
            X509Certificate cert = sig.getKeyInfo().getSignersCertificate();
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Check signer: " + cert.getSubjectDN().getName() + " issued by: " + cert.getIssuerDN().getName() + " SUB from: " + ConvertUtils.date2string(cert.getNotBefore(), sig.getSignedDoc()) + " to: " + ConvertUtils.date2string(cert.getNotAfter(), sig.getSignedDoc()) + " by CA: " + (caCert != null ? caCert.getSubjectDN().getName() : "NOT FOUND") + " CA from: " + (caCert != null ? ConvertUtils.date2string(caCert.getNotBefore(), sig.getSignedDoc()) : "?") + " to: " + (caCert != null ? ConvertUtils.date2string(caCert.getNotAfter(), sig.getSignedDoc()) : "?") + " ca-ahel: " + (DigiDocGenFactory.isTestCard(cert) ? "TEST" : "LIVE")));
            }
            if (caCert != null) {
                bOk = DigiDocVerifyFactory.verifyCertificate(cert, caCert);
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Signer: " + ConvertUtils.getCommonName(sig.getKeyInfo().getSignersCertificate().getSubjectDN().getName()) + " is issued by trusted CA: " + ConvertUtils.getCommonName(caCert.getSubjectDN().getName())));
                }
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("CA not found for: " + ConvertUtils.getCommonName(cert.getSubjectDN().getName())));
                }
                lerrs.add(new DigiDocException(39, "Signers cert not trusted, missing CA cert!", null));
                bOk = false;
            }
            if (!ConfigManager.isSignatureKey(cert)) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"Signers cert does not have non-repudiation bit set!");
                }
                lerrs.add(new DigiDocException(162, "Signers cert does not have non-repudiation bit set!", null));
                bOk = false;
            }
            CertID cid = sig.getCertIdOfType(1);
            if (cert != null && cid != null) {
                boolean bMatch = true;
                List aCertRdns = DigiDocVerifyFactory.parseDN(ConvertUtils.convX509Name(cert.getIssuerX500Principal()));
                List aCertIdRdns = DigiDocVerifyFactory.parseDN(cid.getIssuer());
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Signed: " + cid.getIssuer() + " cert: " + ConvertUtils.convX509Name(cert.getIssuerX500Principal()) + " cert rdn-s: " + aCertRdns.size() + " signed rdn-s: " + aCertIdRdns.size()));
                }
                for (int i = 0; i < aCertIdRdns.size(); ++i) {
                    Rdn r1 = (Rdn)aCertIdRdns.get(i);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Signed RDN: " + r1.getId() + "/" + r1.getValue()));
                    }
                    boolean bF = false;
                    for (int j = 0; j < aCertRdns.size(); ++j) {
                        Rdn r2 = (Rdn)aCertRdns.get(j);
                        if (r1.getId() == null || r2.getId() == null || !r1.getId().equalsIgnoreCase(r2.getId()) || r1.getValue() == null || r2.getValue() == null || !r1.getValue().equalsIgnoreCase(r2.getValue())) continue;
                        bF = true;
                    }
                    if (!bF && m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Different for signed: " + r1.getId() + "/" + r1.getValue()));
                    }
                    if (bF || r1.getId() == null || !r1.getId().equals("CN") && !r1.getId().equals("LT") && !r1.getId().equals("ST") && !r1.getId().equals("O") && !r1.getId().equals("OU") && !r1.getId().equals("C") && !r1.getId().equals("STREET") && !r1.getId().equals("DC") && !r1.getId().equals("UID")) continue;
                    m_logger.error((Object)("No match for signed: " + r1.getId() + "/" + r1.getValue()));
                    bMatch = false;
                }
                if (!bMatch) {
                    m_logger.error((Object)("Signers cert issuer DN: " + ConvertUtils.convX509Name(cert.getIssuerX500Principal()) + " and signed Issuername: " + cid.getIssuer() + " don't match"));
                    lerrs.add(new DigiDocException(81, "Signing certificate issuer information does not match", null));
                }
                if (cid.getSerial() != null) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Signed IssuerSerial: " + cid.getSerial().toString() + " cert serial: " + cert.getSerialNumber().toString()));
                    }
                    if (!cid.getSerial().equals(cert.getSerialNumber())) {
                        m_logger.error((Object)("Signers cert issuer serial: " + cert.getSerialNumber().toString() + " and signed IssuerSerial: " + cid.getSerial().toString() + " don't match"));
                        lerrs.add(new DigiDocException(81, "Signing certificate issuer information does not match", null));
                    }
                }
            }
        }
        catch (DigiDocException ex) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Signers certificate not trusted for: " + sig.getId()));
            }
            lerrs.add(ex);
            bOk = false;
        }
        return bOk;
    }

    public static boolean verifySigningTime(Signature sig, List lerrs) {
        boolean bOk = true;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Verifying signing time signature: " + sig.getId()));
        }
        try {
            Date dProdAt = null;
            if (sig != null && sig.getUnsignedProperties() != null && sig.getUnsignedProperties().getNotary() != null) {
                dProdAt = sig.getUnsignedProperties().getNotary().getProducedAt();
            }
            if (dProdAt != null) {
                sig.getKeyInfo().getSignersCertificate().checkValidity(dProdAt);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Signers cert: " + ConvertUtils.getCommonName(sig.getKeyInfo().getSignersCertificate().getSubjectDN().getName()) + " was valid on: " + ConvertUtils.date2string(dProdAt, sig.getSignedDoc())));
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Signers certificate has expired for: " + sig.getId()));
            lerrs.add(new DigiDocException(82, "Signers certificate has expired!", null));
            bOk = false;
        }
        return bOk;
    }

    public static boolean verifySignatureFromLiveAndOcspFromTest(Signature sig, List lerrs) {
        boolean bOk = true;
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Verifying live/test for signature: " + sig.getId()));
        }
        X509Certificate cert = null;
        X509Certificate rCert = null;
        if (sig != null) {
            CertValue cvOcsp = sig.getCertValueOfType(2);
            if (sig.getKeyInfo() != null && cvOcsp != null) {
                cert = sig.getKeyInfo().getSignersCertificate();
                rCert = cvOcsp.getCert();
                if (cert != null && rCert != null && DigiDocGenFactory.isTestCard(rCert) && !DigiDocGenFactory.isTestCard(cert)) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)"Signer from LIVE CA-chain but OCSP from TEST CA-chain!");
                    }
                    lerrs.add(new DigiDocException(178, "Signer from LIVE CA-chain but OCSP from TEST CA-chain!", null));
                    bOk = false;
                }
            }
        }
        return bOk;
    }

    public static boolean verifySignatureOCSP(Signature sig, List lerrs) {
        boolean bOk;
        block43: {
            bOk = true;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Verifying OCSP for signature: " + sig.getId()));
            }
            try {
                if (sig.getUnsignedProperties() != null && sig.getUnsignedProperties().countNotaries() > 0) {
                    CertValue cvOcsp = sig.getCertValueOfType(2);
                    CertID cidOcsp = sig.getCertIdOfType(2);
                    X509Certificate rCert = null;
                    String sIssuer = null;
                    BigInteger sSerial = null;
                    byte[] cHash = null;
                    if (cvOcsp != null) {
                        rCert = cvOcsp.getCert();
                    }
                    if (cidOcsp != null) {
                        sIssuer = cidOcsp.getIssuer();
                        sSerial = cidOcsp.getSerial();
                        cHash = cidOcsp.getDigestValue();
                    }
                    X509Certificate cert = sig.getKeyInfo().getSignersCertificate();
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Responders cert: " + (rCert != null ? rCert.getSerialNumber().toString() : "NULL") + " - " + (rCert != null ? rCert.getSubjectDN().getName() : "NULL") + " complete cert refs nr: " + sSerial + " - " + sIssuer + " ca-ahel: " + (rCert != null ? (DigiDocGenFactory.isTestCard(rCert) ? "TEST" : "LIVE") : "?")));
                    }
                    if (rCert != null && !rCert.getSerialNumber().equals(sSerial) && !sig.getSignedDoc().getFormat().equals("BDOC")) {
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Wrong notarys certificate: " + rCert.getSerialNumber() + " ref: " + sSerial));
                        }
                        lerrs.add(new DigiDocException(53, "Wrong notarys certificate: " + rCert.getSerialNumber() + " ref: " + sSerial, null));
                        bOk = false;
                    }
                    try {
                        if (!sig.getSignedDoc().getFormat().equals("BDOC")) {
                            byte[] digest = SignedDoc.digestOfType(rCert.getEncoded(), sig.getSignedDoc().getFormat().equals("BDOC") ? "SHA-256" : "SHA-1");
                            if (m_logger.isDebugEnabled()) {
                                m_logger.debug((Object)("Not cert calc hash: " + Base64Util.encode(digest, 0) + " cert-ref hash: " + Base64Util.encode(sig.getUnsignedProperties().getCompleteCertificateRefs().getCertDigestValue(), 0)));
                            }
                            if (!DigiDocVerifyFactory.compareDigests(digest, sig.getUnsignedProperties().getCompleteCertificateRefs().getCertDigestValue())) {
                                lerrs.add(new DigiDocException(53, "Notary certificates digest doesn't match!", null));
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)"Notary certificates digest doesn't match!");
                                }
                                bOk = false;
                            }
                            if (sig.getSignedDoc().getFormat().equals("BDOC") && sig.getUnsignedProperties().getCompleteCertificateRefs().getCertDigestAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#sha1") && ConfigManager.instance().getBooleanProperty("BDOC_SHA1_CHECK", true)) {
                                lerrs.add(new DigiDocException(129, DIG_TYPE_WARNING, null));
                                if (m_logger.isInfoEnabled()) {
                                    m_logger.info((Object)("CompleteCertificateRefs for signature: " + sig.getId() + " has weak digest type: " + sig.getUnsignedProperties().getCompleteCertificateRefs().getCertDigestAlgorithm()));
                                }
                            }
                        }
                    }
                    catch (DigiDocException ex) {
                        lerrs.add(ex);
                        bOk = false;
                    }
                    catch (Exception ex) {
                        bOk = false;
                        lerrs.add(new DigiDocException(53, "Error calculating notary certificate digest!", null));
                    }
                    if (sig.getUnsignedProperties().countNotaries() > 1) {
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)"Currently supports only one OCSP");
                        }
                        lerrs.add(new DigiDocException(70, "Currently supports only one OCSP", null));
                        bOk = false;
                    }
                    if (!sig.getSignedDoc().getFormat().equals("BDOC")) {
                        try {
                            for (int i = 0; i < sig.getUnsignedProperties().countNotaries(); ++i) {
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("Signature: " + sig.getId() + " not: " + i + " notaries: " + sig.getUnsignedProperties().countNotaries()));
                                }
                                Notary not = sig.getUnsignedProperties().getNotaryById(i);
                                byte[] ocspData = not.getOcspResponseData();
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("OCSP value: " + not.getId() + " data: " + (ocspData != null ? ocspData.length : 0) + " bytes"));
                                }
                                if (ocspData == null || ocspData.length == 0) {
                                    lerrs.add(new DigiDocException(83, "OCSP value is empty!", null));
                                    bOk = false;
                                    continue;
                                }
                                OcspRef orf = sig.getUnsignedProperties().getCompleteRevocationRefs().getOcspRefByUri("#" + not.getId());
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("OCSP ref: " + (orf != null ? orf.getUri() : "NULL")));
                                }
                                if (orf == null) {
                                    lerrs.add(new DigiDocException(83, "No OCSP ref for uri: #" + not.getId(), null));
                                    bOk = false;
                                    continue;
                                }
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("OCSP data len: " + ocspData.length));
                                }
                                byte[] digest1 = SignedDoc.digestOfType(ocspData, sig.getSignedDoc().getFormat().equals("BDOC") && (orf.getDigestAlgorithm().equals("http://www.w3.org/2001/04/xmlenc#sha256") || orf.getDigestAlgorithm().equals("http://www.w3.org/2001/04/xmldsig-more#sha256")) ? "SHA-256" : "SHA-1");
                                byte[] digest2 = orf.getDigestValue();
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("Check ocsp: " + not.getId() + " calc hash: " + Base64Util.encode(digest1, 0) + " refs-hash: " + Base64Util.encode(digest2, 0)));
                                }
                                if (!sig.getSignedDoc().getFormat().equals("SK-XML") && !DigiDocVerifyFactory.compareDigests(digest1, digest2)) {
                                    lerrs.add(new DigiDocException(83, "Notarys digest doesn't match!", null));
                                    if (m_logger.isDebugEnabled()) {
                                        m_logger.debug((Object)"Notarys digest doesn't match!");
                                    }
                                    bOk = false;
                                }
                                if (sig.getSignedDoc().getFormat().equals("BDOC") && orf.getDigestAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#sha1") && ConfigManager.instance().getBooleanProperty("BDOC_SHA1_CHECK", true)) {
                                    lerrs.add(new DigiDocException(129, DIG_TYPE_WARNING, null));
                                    if (m_logger.isInfoEnabled()) {
                                        m_logger.info((Object)("CompleteRevocationRefs for signature: " + sig.getId() + " has weak digest type: " + orf.getDigestAlgorithm()));
                                    }
                                }
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("Check ocsp: " + not.getId() + " prodAt: " + (not.getProducedAt() != null ? ConvertUtils.date2string(not.getProducedAt(), sig.getSignedDoc()) : "NULL") + " orf prodAt: " + (orf.getProducedAt() != null ? ConvertUtils.date2string(orf.getProducedAt(), sig.getSignedDoc()) : "NULL")));
                                }
                                if (not.getProducedAt() == null || orf.getProducedAt() == null || ConvertUtils.date2string(not.getProducedAt(), sig.getSignedDoc()).equals(ConvertUtils.date2string(orf.getProducedAt(), sig.getSignedDoc()))) continue;
                                if (m_logger.isDebugEnabled()) {
                                    m_logger.debug((Object)("Notary: " + not.getId() + " producedAt: " + (not.getProducedAt() != null ? ConvertUtils.date2string(not.getProducedAt(), sig.getSignedDoc()) : "NULL") + " does not match OcpsRef-s producedAt: " + (orf.getProducedAt() != null ? ConvertUtils.date2string(orf.getProducedAt(), sig.getSignedDoc()) : "NULL")));
                                }
                                lerrs.add(new DigiDocException(70, "Notary: " + not.getId() + " producedAt: " + (not.getProducedAt() != null ? ConvertUtils.date2string(not.getProducedAt(), sig.getSignedDoc()) : "NULL") + " does not match OcpsRef-s producedAt: " + (orf.getProducedAt() != null ? ConvertUtils.date2string(orf.getProducedAt(), sig.getSignedDoc()) : "NULL"), null));
                            }
                        }
                        catch (DigiDocException ex) {
                            lerrs.add(ex);
                            bOk = false;
                        }
                    }
                    try {
                        NotaryFactory notFac = ConfigManager.instance().getNotaryFactory();
                        for (int i = 0; i < sig.getUnsignedProperties().countNotaries(); ++i) {
                            Notary not = sig.getUnsignedProperties().getNotaryById(i);
                            if (m_logger.isDebugEnabled()) {
                                m_logger.debug((Object)("Verify notary: " + not.getId() + " ocsp: " + (not.getOcspResponseData() != null ? not.getOcspResponseData().length : 0) + " responder: " + not.getResponderId()));
                            }
                            notFac.parseAndVerifyResponse(sig, not);
                        }
                        break block43;
                    }
                    catch (DigiDocException ex) {
                        lerrs.add(ex);
                        bOk = false;
                        break block43;
                    }
                }
                bOk = false;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"Signature has no OCSP confirmation!");
                }
                lerrs.add(new DigiDocException(90, "Signature has no OCSP confirmation!", null));
            }
            catch (Exception ex) {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Failed to verify OCSP for: " + sig.getId()));
                }
                lerrs.add(new DigiDocException(82, "Failed to verify OCSP for: " + sig.getId(), null));
                bOk = false;
            }
        }
        return bOk;
    }

    public static boolean verifySignature(SignedDoc sdoc, Signature sig, List lerrs) {
        int i;
        boolean bOk = true;
        boolean b = false;
        DigiDocVerifyFactory.initProvider();
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Verifying signature: " + sig.getId() + " profile: " + sig.getProfile()));
        }
        if (sig.getProfile() != null && (sig.getProfile().equals("T") || sig.getProfile().equals("TS") || sig.getProfile().equals("TS-A"))) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)"T, TS and TSA profiles are currently not supported!");
            }
            lerrs.add(new DigiDocException(81, "T, TS and TSA profiles are currently not supported!", null));
        }
        for (i = 0; i < sdoc.countDataFiles(); ++i) {
            Reference ref;
            DataFile df = sdoc.getDataFile(i);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Verifying DF: " + df.getId() + " file: " + df.getFileName()));
            }
            if ((ref = sig.getSignedInfo().getReferenceForDataFile(df)) != null && ref.getDigestAlgorithm() != null && sdoc.getFormat().equals("BDOC") && ref.getDigestAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#sha1") && ConfigManager.instance().getBooleanProperty("BDOC_SHA1_CHECK", true)) {
                lerrs.add(new DigiDocException(129, DIG_TYPE_WARNING, null));
                if (m_logger.isInfoEnabled()) {
                    m_logger.info((Object)("DataFile: " + df.getId() + " has weak digest type: " + ref.getDigestAlgorithm()));
                }
            }
            if (ref != null) {
                b = DigiDocVerifyFactory.verifyDataFileHash(sdoc, df, ref, lerrs);
            } else {
                b = false;
                lerrs.add(new DigiDocException(81, "Missing Reference for file: " + df.getFileName(), null));
            }
            if (b) continue;
            bOk = false;
        }
        for (i = 0; i < sdoc.countSignatures(); ++i) {
            Signature sig1 = sdoc.getSignature(i);
            for (int j = 0; j < sig.getSignedInfo().countReferences(); ++j) {
                Reference ref1 = sig.getSignedInfo().getReference(j);
                if (ref1.getType() != null || sdoc.getFormat().equals("BDOC") && ref1.getUri().indexOf("META-INF/manifest.xml") != -1 || (sdoc.getFormat().equals("DIGIDOC-XML") || sdoc.getFormat().equals("SK-XML")) && (ref1.getUri().indexOf("-MIME") != -1 || ref1.getUri().indexOf("-SignedProperties") != -1)) continue;
                boolean bFound = false;
                for (int l = 0; l < sdoc.countDataFiles(); ++l) {
                    DataFile df = sdoc.getDataFile(l);
                    String sFile = df.getFileName();
                    if (sFile != null && sFile.indexOf(47) != -1 || sFile.indexOf(92) != -1) {
                        File fT = new File(sFile);
                        sFile = fT.getName();
                    }
                    if (ref1.getUri() == null) continue;
                    if ((sdoc.getFormat().equals("DIGIDOC-XML") || sdoc.getFormat().equals("SK-XML")) && ref1.getUri().startsWith("#") && df.getId().equals(ref1.getUri().substring(1))) {
                        bFound = true;
                    }
                    if (!sdoc.getFormat().equals("BDOC") || ref1.getUri().indexOf(sFile) == -1) continue;
                    bFound = true;
                }
                if (bFound) continue;
                if (m_logger.isInfoEnabled()) {
                    m_logger.info((Object)("Missing DataFile for signature: " + sig.getId() + " reference " + ref1.getUri()));
                }
                lerrs.add(new DigiDocException(81, "Missing DataFile for signature: " + sig.getId() + " reference " + ref1.getUri(), null));
            }
        }
        if (sdoc.getFormat().equals("BDOC")) {
            for (i = 0; i < sig.getSignedInfo().countReferences(); ++i) {
                DataObjectFormat dof;
                Reference ref = sig.getSignedInfo().getReference(i);
                if (ref.getUri().startsWith("#") || (dof = sig.getSignedInfo().getDataObjectFormatForReference(ref)) != null) continue;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("No DataObjectFormat element for Reference: " + ref.getId()));
                }
                lerrs.add(new DigiDocException(30, "No DataObjectFormat element for Reference: " + ref.getId(), null));
            }
        }
        if (!sdoc.getFormat().equals("SK-XML")) {
            b = DigiDocVerifyFactory.verifySignedPropretiesHash(sig, lerrs);
        }
        if (!b) {
            bOk = false;
        }
        if (!(b = DigiDocVerifyFactory.verifySignatureValue(sdoc, sig, lerrs))) {
            bOk = false;
        }
        if (!(b = DigiDocVerifyFactory.verifySigningTime(sig, lerrs))) {
            bOk = false;
        }
        if (!(b = DigiDocVerifyFactory.verifySignersCerificate(sig, lerrs))) {
            bOk = false;
        }
        if (sdoc.getFormat().equals("BDOC") && !(b = DigiDocVerifyFactory.verifySignaturePolicies(sdoc, sig, lerrs))) {
            bOk = false;
        }
        if ((sdoc.getFormat().equals("SK-XML") || sdoc.getFormat().equals("DIGIDOC-XML") || sig.getProfile() != null && (sig.getProfile().equals("TM") || sig.getProfile().equals("TM-A") || sig.getProfile().equals("TS") || sig.getProfile().equals("TS-A"))) && !(b = DigiDocVerifyFactory.verifySignatureOCSP(sig, lerrs))) {
            bOk = false;
        }
        return bOk;
    }

    public static boolean verifySignaturePolicies(SignedDoc sdoc, Signature sig, List lerrs) {
        boolean bOk = false;
        if (m_logger.isInfoEnabled()) {
            m_logger.debug((Object)("Check signature: " + sig.getId() + " profile: " + sig.getProfile() + " format: " + sdoc.getFormat() + " policies"));
        }
        try {
            if (sig.getSignedProperties() != null && sig.getSignedProperties().getSignaturePolicyIdentifier() != null && sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId() != null && sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyId() != null && sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyId().getIdentifier() != null) {
                Identifier id = sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyId().getIdentifier();
                if (m_logger.isInfoEnabled()) {
                    m_logger.debug((Object)("Signature: " + sig.getId() + " has policy: " + id.getQualifier() + " uri: " + id.getUri() + " hash: " + Base64Util.encode(sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getDigestValue())));
                }
                if (id.getQualifier().equals(Identifier.OIDAsURN) && id.getUri().equals("urn:oid:1.3.6.1.4.1.10015.1000.3.2.1")) {
                    bOk = true;
                    if (sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getDigestValue() == null || sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getDigestValue().length == 0) {
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Signature: " + sig.getId() + " has no signature policy hash"));
                        }
                        lerrs.add(new DigiDocException(171, "Signature: " + sig.getId() + " has invalid signature policy hash", null));
                    }
                    boolean bUriOk = false;
                    for (int i = 0; i < sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().countSigPolicyQualifiers(); ++i) {
                        SpUri sna;
                        SigPolicyQualifier spq = sig.getSignedProperties().getSignaturePolicyIdentifier().getSignaturePolicyId().getSigPolicyQualifier(i);
                        if (!(spq instanceof SpUri) || (sna = (SpUri)spq).getUri() == null || sna.getUri().trim().length() <= 0) continue;
                        bUriOk = true;
                    }
                    if (!bUriOk) {
                        bOk = false;
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Signature: " + sig.getId() + " has no signature policy uri!"));
                        }
                        lerrs.add(new DigiDocException(170, "Signature: " + sig.getId() + " has no nonce policy uri!", null));
                    }
                } else {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Signature: " + sig.getId() + " has unknown policy: " + id.getQualifier() + " uri: " + id.getUri()));
                    }
                    lerrs.add(new DigiDocException(169, "Signature: " + sig.getId() + " has unknown policy: " + id.getQualifier() + " uri: " + id.getUri(), null));
                }
            } else {
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("No signature policy for sig: " + sig.getId()));
                }
                lerrs.add(new DigiDocException(168, "Signature: " + sig.getId() + " has no policy!", null));
            }
        }
        catch (Exception ex) {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Failed to verify sig policies: " + sig.getId() + " - " + ex));
            }
            lerrs.add(new DigiDocException(168, "Failed to verify sig policies: " + sig.getId() + " - " + ex, null));
            bOk = false;
        }
        return bOk;
    }

    private static List findRdns(String dn, char chSep) {
        ArrayList<Rdn> lrdn = new ArrayList<Rdn>();
        StringBuffer sbId = new StringBuffer();
        StringBuffer sbVal = new StringBuffer();
        boolean bId = true;
        for (int i = 0; dn != null && i < dn.length(); ++i) {
            char ch = dn.charAt(i);
            if (ch == chSep && (i == 0 || dn.charAt(i - 1) != '\\') || i == dn.length() - 1) {
                if (i == dn.length() - 1 && !bId) {
                    sbVal.append(ch);
                }
                if (sbId.length() > 0 && sbVal.length() > 0) {
                    lrdn.add(new Rdn(sbId.toString().trim(), null, sbVal.toString().trim()));
                }
                sbId = new StringBuffer();
                sbVal = new StringBuffer();
                bId = true;
                continue;
            }
            if (ch == '=' && (i == 0 || dn.charAt(i - 1) != '\\')) {
                bId = false;
                continue;
            }
            if (bId) {
                sbId.append(ch);
                continue;
            }
            sbVal.append(ch);
        }
        return lrdn;
    }

    public static List parseDN(String dn) {
        List al = DigiDocVerifyFactory.findRdns(dn, ',');
        if (al.size() < 3) {
            al = DigiDocVerifyFactory.findRdns(dn, '/');
        }
        return al;
    }
}

