/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.CompleteCertificateRefs;
import ee.sk.digidoc.CompleteRevocationRefs;
import ee.sk.digidoc.DataObjectFormat;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Identifier;
import ee.sk.digidoc.IncludeInfo;
import ee.sk.digidoc.KeyInfo;
import ee.sk.digidoc.Notary;
import ee.sk.digidoc.NoticeRef;
import ee.sk.digidoc.ObjectIdentifier;
import ee.sk.digidoc.OcspRef;
import ee.sk.digidoc.Reference;
import ee.sk.digidoc.SigPolicyQualifier;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignaturePolicyId;
import ee.sk.digidoc.SignaturePolicyIdentifier;
import ee.sk.digidoc.SignatureProductionPlace;
import ee.sk.digidoc.SignatureValue;
import ee.sk.digidoc.SignedDataObjectProperties;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.SignedInfo;
import ee.sk.digidoc.SignedProperties;
import ee.sk.digidoc.SpUri;
import ee.sk.digidoc.SpUserNotice;
import ee.sk.digidoc.TimestampInfo;
import ee.sk.digidoc.UnsignedProperties;
import ee.sk.utils.ConvertUtils;
import org.apache.log4j.Logger;

public class DigiDocXmlGenFactory {
    private SignedDoc m_sdoc;
    private static final int NS_NONE = 0;
    private static final int NS_XMLDSIG = 1;
    private static final int NS_XADES = 2;
    private static final int NS_ASIC = 3;
    private Logger m_logger = Logger.getLogger(DigiDocXmlGenFactory.class);

    public DigiDocXmlGenFactory(SignedDoc sdoc) {
        this.m_sdoc = sdoc;
    }

    private void xmlElemTagStart(StringBuffer sb, int nNs, String tag, boolean bEnd, boolean bLf) {
        sb.append("<");
        if (nNs == 1 && this.m_sdoc.getXmlDsigNs() != null && this.m_sdoc.getXmlDsigNs().length() > 0) {
            sb.append(this.m_sdoc.getXmlDsigNs());
            sb.append(":");
        }
        if (nNs == 2 && this.m_sdoc.getXadesNs() != null && this.m_sdoc.getXadesNs().length() > 0) {
            sb.append(this.m_sdoc.getXadesNs());
            sb.append(":");
        }
        if (nNs == 3 && this.m_sdoc.getAsicNs() != null && this.m_sdoc.getAsicNs().length() > 0) {
            sb.append(this.m_sdoc.getAsicNs());
            sb.append(":");
        }
        sb.append(tag);
        if (bEnd) {
            sb.append(">");
        }
        if (bLf) {
            sb.append("\n");
        }
    }

    private void xmlElemTagEnd(StringBuffer sb, boolean bLf) {
        sb.append(">");
        if (bLf) {
            sb.append("\n");
        }
    }

    private void xmlElemEnd(StringBuffer sb, int nNs, String tag, boolean bLf) {
        sb.append("</");
        if (nNs == 1 && this.m_sdoc.getXmlDsigNs() != null && this.m_sdoc.getXmlDsigNs().length() > 0) {
            sb.append(this.m_sdoc.getXmlDsigNs());
            sb.append(":");
        }
        if (nNs == 2 && this.m_sdoc.getXadesNs() != null && this.m_sdoc.getXadesNs().length() > 0) {
            sb.append(this.m_sdoc.getXadesNs());
            sb.append(":");
        }
        if (nNs == 3 && this.m_sdoc.getAsicNs() != null && this.m_sdoc.getAsicNs().length() > 0) {
            sb.append(this.m_sdoc.getAsicNs());
            sb.append(":");
        }
        sb.append(tag);
        sb.append(">");
        if (bLf) {
            sb.append("\n");
        }
    }

    private void xmlElemAttr(StringBuffer sb, String name, String value) {
        sb.append(" ");
        sb.append(name);
        sb.append("=\"");
        sb.append(value);
        sb.append("\"");
    }

    private void xmlElemNsAttr(StringBuffer sb, int nNs) {
        sb.append(" ");
        sb.append("xmlns");
        if (nNs == 1 && this.m_sdoc.getXmlDsigNs() != null && this.m_sdoc.getXmlDsigNs().length() > 0) {
            sb.append(":");
            sb.append(this.m_sdoc.getXmlDsigNs());
        }
        if (nNs == 2 && this.m_sdoc.getXadesNs() != null && this.m_sdoc.getXadesNs().length() > 0) {
            sb.append(":");
            sb.append(this.m_sdoc.getXadesNs());
        }
        if (nNs == 3 && this.m_sdoc.getAsicNs() != null && this.m_sdoc.getAsicNs().length() > 0) {
            sb.append(":");
            sb.append(this.m_sdoc.getAsicNs());
        }
        sb.append("=\"");
        if (nNs == 1) {
            sb.append(SignedDoc.xmlns_xmldsig);
        }
        if (nNs == 2) {
            sb.append(SignedDoc.xmlns_xades_123);
        }
        if (nNs == 3) {
            sb.append(SignedDoc.xmlns_asic);
        }
        sb.append("\"");
    }

    private void reference2xml(StringBuffer sb, Reference ref) {
        this.xmlElemTagStart(sb, 1, "Reference", false, false);
        if (ref.getId() != null && ref.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", ref.getId());
        }
        if (ref.getUri().indexOf("SignedProperties") != -1) {
            if (this.m_sdoc.getVersion().equals("1.2") || this.m_sdoc.getVersion().equals("1.3")) {
                this.xmlElemAttr(sb, "Type", "http://uri.etsi.org/01903/v1.1.1#SignedProperties");
            } else {
                this.xmlElemAttr(sb, "Type", "http://uri.etsi.org/01903#SignedProperties");
            }
            String s = ref.getUri();
            s = s.startsWith("/") || s.startsWith("#") ? s.charAt(0) + ConvertUtils.uriEncodePath(s.substring(1)) : ConvertUtils.uriEncodePath(s);
            this.xmlElemAttr(sb, "URI", s);
        } else {
            String s = ref.getUri();
            s = s.startsWith("/") || s.startsWith("#") ? s.charAt(0) + ConvertUtils.uriEncodePath(s.substring(1)) : ConvertUtils.uriEncodePath(s);
            this.xmlElemAttr(sb, "URI", s);
        }
        this.xmlElemTagEnd(sb, true);
        if (ref.getTransformAlgorithm() != null && ref.getTransformAlgorithm().length() > 0) {
            this.xmlElemTagStart(sb, 1, "Transforms", true, false);
            this.xmlElemTagStart(sb, 1, "Transform", false, false);
            this.xmlElemAttr(sb, "Algorithm", ref.getTransformAlgorithm());
            this.xmlElemTagEnd(sb, true);
            this.xmlElemEnd(sb, 1, "Transform", true);
            this.xmlElemEnd(sb, 1, "Transforms", true);
        }
        this.xmlElemTagStart(sb, 1, "DigestMethod", false, false);
        this.xmlElemAttr(sb, "Algorithm", ref.getDigestAlgorithm());
        this.xmlElemTagEnd(sb, true);
        this.xmlElemEnd(sb, 1, "DigestMethod", true);
        this.xmlElemTagStart(sb, 1, "DigestValue", true, false);
        sb.append(Base64Util.encode(ref.getDigestValue(), 0));
        this.xmlElemEnd(sb, 1, "DigestValue", true);
        this.xmlElemEnd(sb, 1, "Reference", true);
    }

    private void signedInfo2xml(StringBuffer sb, SignedInfo si, boolean bHashCalc) {
        this.xmlElemTagStart(sb, 1, "SignedInfo", false, false);
        if (si.getSignature() != null && si.getSignature().getSignedDoc() != null && si.getSignature().getSignedDoc().getFormat() != null && (si.getSignature().getSignedDoc().getFormat().equals("DIGIDOC-XML") || si.getSignature().getSignedDoc().getFormat().equals("SK-XML"))) {
            this.xmlElemNsAttr(sb, 1);
        }
        if (bHashCalc && si.getSignature() != null && si.getSignature().getSignedDoc() != null && si.getSignature().getSignedDoc().getFormat() != null && si.getSignature().getSignedDoc().getVersion() != null && si.getSignature().getSignedDoc().getFormat().equals("BDOC") && si.getSignature().getSignedDoc().getVersion().equals("2.1")) {
            this.xmlElemNsAttr(sb, 3);
            this.xmlElemNsAttr(sb, 1);
            this.xmlElemNsAttr(sb, 2);
        }
        if (si.getId() != null && si.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", si.getId());
        }
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 1, "CanonicalizationMethod", false, false);
        this.xmlElemAttr(sb, "Algorithm", si.getCanonicalizationMethod());
        this.xmlElemTagEnd(sb, true);
        this.xmlElemEnd(sb, 1, "CanonicalizationMethod", true);
        this.xmlElemTagStart(sb, 1, "SignatureMethod", false, false);
        this.xmlElemAttr(sb, "Algorithm", si.getSignatureMethod());
        this.xmlElemTagEnd(sb, true);
        this.xmlElemEnd(sb, 1, "SignatureMethod", true);
        for (int i = 0; i < si.countReferences(); ++i) {
            Reference ref = si.getReference(i);
            this.reference2xml(sb, ref);
        }
        this.xmlElemEnd(sb, 1, "SignedInfo", false);
    }

    public void signatureValue2xml(StringBuffer sb, SignatureValue sv, boolean bWithNs) {
        this.xmlElemTagStart(sb, 1, "SignatureValue", false, false);
        if (bWithNs) {
            this.xmlElemNsAttr(sb, 1);
        }
        if (sv.getId() != null && sv.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", sv.getId());
        }
        this.xmlElemTagEnd(sb, true);
        sb.append(Base64Util.encode(sv.getValue(), 0));
        this.xmlElemEnd(sb, 1, "SignatureValue", true);
    }

    private void certValue2xml(StringBuffer sb, CertValue cval) throws DigiDocException {
        if (cval.getType() == 1) {
            this.xmlElemTagStart(sb, 1, "X509Certificate", true, false);
        } else {
            this.xmlElemTagStart(sb, 2, "EncapsulatedX509Certificate", false, false);
            if (cval.getId() != null && cval.getId().length() > 0) {
                this.xmlElemAttr(sb, "Id", cval.getId());
            }
            this.xmlElemTagEnd(sb, true);
        }
        try {
            sb.append(Base64Util.encode(cval.getCert().getEncoded(), 64));
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 74);
        }
        if (cval.getType() == 1) {
            this.xmlElemEnd(sb, 1, "X509Certificate", false);
        } else {
            this.xmlElemEnd(sb, 2, "EncapsulatedX509Certificate", true);
        }
    }

    private void keyInfo2xml(StringBuffer sb, KeyInfo ki, Signature sig) throws DigiDocException {
        this.xmlElemTagStart(sb, 1, "KeyInfo", false, false);
        if (ki.getId() != null && ki.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", ki.getId());
        }
        this.xmlElemTagEnd(sb, true);
        if (!sig.getSignedDoc().getFormat().equals("BDOC")) {
            this.xmlElemTagStart(sb, 1, "KeyValue", true, true);
            if (!sig.isEllipticCurveSiganture()) {
                this.xmlElemTagStart(sb, 1, "RSAKeyValue", true, true);
                this.xmlElemTagStart(sb, 1, "Modulus", true, false);
                sb.append(Base64Util.encode(ki.getSignerKeyModulus().toByteArray(), 64));
                this.xmlElemEnd(sb, 1, "Modulus", true);
                this.xmlElemTagStart(sb, 1, "Exponent", true, false);
                sb.append(Base64Util.encode(ki.getSignerKeyExponent().toByteArray(), 64));
                this.xmlElemEnd(sb, 1, "Exponent", true);
                this.xmlElemEnd(sb, 1, "RSAKeyValue", true);
            }
            this.xmlElemEnd(sb, 1, "KeyValue", true);
        }
        this.xmlElemTagStart(sb, 1, "X509Data", true, false);
        CertValue cval = sig.getCertValueOfType(1);
        if (cval != null) {
            this.certValue2xml(sb, cval);
        }
        this.xmlElemEnd(sb, 1, "X509Data", false);
        this.xmlElemEnd(sb, 1, "KeyInfo", true);
    }

    private void certId2xml(StringBuffer sb, CertID ci, Signature sig) {
        this.xmlElemTagStart(sb, 2, "Cert", false, false);
        if (this.m_sdoc.getFormat().equals("DIGIDOC-XML") && (this.m_sdoc.getVersion().equals("1.1") || this.m_sdoc.getVersion().equals("1.2")) && ci.getId() != null && ci.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", ci.getId());
        }
        if (this.m_sdoc.getFormat().equals("BDOC") && ci.getUri() != null && ci.getUri().length() > 0) {
            this.xmlElemAttr(sb, "URI", ci.getUri());
        }
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 2, "CertDigest", true, true);
        this.xmlElemTagStart(sb, 1, "DigestMethod", false, false);
        this.xmlElemAttr(sb, "Algorithm", ci.getDigestAlgorithm());
        this.xmlElemTagEnd(sb, true);
        this.xmlElemEnd(sb, 1, "DigestMethod", true);
        this.xmlElemTagStart(sb, 1, "DigestValue", false, false);
        this.xmlElemTagEnd(sb, false);
        sb.append(Base64Util.encode(ci.getDigestValue()));
        this.xmlElemEnd(sb, 1, "DigestValue", true);
        this.xmlElemEnd(sb, 2, "CertDigest", true);
        if (this.m_sdoc.getFormat().equals("DIGIDOC-XML") && (this.m_sdoc.getVersion().equals("1.1") || this.m_sdoc.getVersion().equals("1.2"))) {
            this.xmlElemTagStart(sb, 1, "IssuerSerial", true, false);
            sb.append(ci.getSerial().toString());
            this.xmlElemEnd(sb, 1, "IssuerSerial", true);
        } else {
            this.xmlElemTagStart(sb, 2, "IssuerSerial", true, true);
            this.xmlElemTagStart(sb, 1, "X509IssuerName", false, false);
            if (!this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemNsAttr(sb, 1);
            }
            this.xmlElemTagEnd(sb, false);
            sb.append(ConvertUtils.escapeTextNode(ci.getIssuer()));
            this.xmlElemEnd(sb, 1, "X509IssuerName", true);
            this.xmlElemTagStart(sb, 1, "X509SerialNumber", false, false);
            if (!this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemNsAttr(sb, 1);
            }
            this.xmlElemTagEnd(sb, false);
            sb.append(ci.getSerial().toString());
            this.xmlElemEnd(sb, 1, "X509SerialNumber", true);
            this.xmlElemEnd(sb, 2, "IssuerSerial", true);
        }
        this.xmlElemEnd(sb, 2, "Cert", true);
    }

    private void signatureProductionPlace2xml(StringBuffer sb, SignatureProductionPlace adr) {
        this.xmlElemTagStart(sb, 2, "SignatureProductionPlace", true, true);
        if (adr.getCity() != null && adr.getCity().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "City", true, false);
            sb.append(ConvertUtils.escapeTextNode(adr.getCity()));
            this.xmlElemEnd(sb, 2, "City", true);
        }
        if (adr.getStateOrProvince() != null && adr.getStateOrProvince().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "StateOrProvince", true, false);
            sb.append(ConvertUtils.escapeTextNode(adr.getStateOrProvince()));
            this.xmlElemEnd(sb, 2, "StateOrProvince", true);
        }
        if (adr.getPostalCode() != null && adr.getPostalCode().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "PostalCode", true, false);
            sb.append(ConvertUtils.escapeTextNode(adr.getPostalCode()));
            this.xmlElemEnd(sb, 2, "PostalCode", true);
        }
        if (adr.getCountryName() != null && adr.getCountryName().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "CountryName", true, false);
            sb.append(ConvertUtils.escapeTextNode(adr.getCountryName()));
            this.xmlElemEnd(sb, 2, "CountryName", true);
        }
        this.xmlElemEnd(sb, 2, "SignatureProductionPlace", true);
    }

    private void identifier2xml(StringBuffer sb, Identifier idf, Signature sig) {
        this.xmlElemTagStart(sb, 2, "Identifier", false, false);
        if (idf.getQualifier() != null && idf.getQualifier().length() > 0) {
            this.xmlElemAttr(sb, "Qualifier", idf.getQualifier());
        }
        this.xmlElemTagEnd(sb, true);
        if (idf.getUri() != null && idf.getUri().trim().length() > 0) {
            sb.append(idf.getUri());
        }
        this.xmlElemEnd(sb, 2, "Identifier", true);
    }

    private void objectIdentifier2xml(StringBuffer sb, ObjectIdentifier odf, String tag, Signature sig) {
        this.xmlElemTagStart(sb, 2, tag, true, true);
        if (odf.getIdentifier() != null) {
            this.identifier2xml(sb, odf.getIdentifier(), sig);
        }
        if (odf.getDescription() != null) {
            this.xmlElemTagStart(sb, 2, "Description", true, false);
            sb.append(odf.getDescription());
            this.xmlElemEnd(sb, 2, "Description", true);
        }
        if (odf.countDocumentationReferences() > 0) {
            this.xmlElemTagStart(sb, 2, "DocumentationReferences", true, true);
            for (int i = 0; i < odf.countDocumentationReferences(); ++i) {
                this.xmlElemTagStart(sb, 2, "DocumentationReference", true, false);
                sb.append(odf.getDocumentationReference(i));
                this.xmlElemEnd(sb, 2, "DocumentationReference", true);
            }
            this.xmlElemEnd(sb, 2, "DocumentationReferences", true);
        }
        this.xmlElemEnd(sb, 2, tag, true);
    }

    private void noticeRef2xml(StringBuffer sb, NoticeRef nrf, Signature sig) {
        this.xmlElemTagStart(sb, 2, "NoticeRef", true, true);
        this.xmlElemTagStart(sb, 2, "Organization", true, true);
        sb.append(nrf.getOrganization());
        this.xmlElemEnd(sb, 2, "Organization", true);
        if (nrf.countNoticeNumbers() > 0) {
            this.xmlElemTagStart(sb, 2, "NoticeNumbers", true, true);
            for (int i = 0; i < nrf.countNoticeNumbers(); ++i) {
                this.xmlElemTagStart(sb, 2, "int", true, false);
                sb.append(new Integer(nrf.getNoticeNumber(i)).toString());
                this.xmlElemEnd(sb, 2, "int", true);
            }
            this.xmlElemEnd(sb, 2, "NoticeNumbers", true);
        }
        this.xmlElemEnd(sb, 2, "NoticeRef", true);
    }

    private void spUserNotice2xml(StringBuffer sb, SpUserNotice not, Signature sig) {
        if (not != null && (not.getExplicitText() != null || not.getNoticeRef() != null)) {
            this.xmlElemTagStart(sb, 2, "SPUserNotice", true, true);
            if (not.getNoticeRef() != null) {
                this.noticeRef2xml(sb, not.getNoticeRef(), sig);
            }
            if (not.getExplicitText() != null) {
                this.xmlElemTagStart(sb, 2, "ExplicitText", true, true);
                sb.append(not.getExplicitText());
                this.xmlElemEnd(sb, 2, "ExplicitText", true);
            }
            this.xmlElemEnd(sb, 2, "SPUserNotice", true);
        }
    }

    private void spUri2xml(StringBuffer sb, SpUri uri, Signature sig) {
        if (uri != null && uri.getUri() != null) {
            this.xmlElemTagStart(sb, 2, "SPURI", true, true);
            sb.append(uri.getUri());
            this.xmlElemEnd(sb, 2, "SPURI", true);
        }
    }

    private void sigPolicyQualifier2xml(StringBuffer sb, SigPolicyQualifier spq, Signature sig) {
        if (spq != null && (spq instanceof SpUserNotice || spq instanceof SpUri)) {
            this.xmlElemTagStart(sb, 2, "SigPolicyQualifier", true, true);
            if (spq instanceof SpUserNotice) {
                this.spUserNotice2xml(sb, (SpUserNotice)spq, sig);
            }
            if (spq instanceof SpUri) {
                this.spUri2xml(sb, (SpUri)spq, sig);
            }
            this.xmlElemEnd(sb, 2, "SigPolicyQualifier", true);
        }
    }

    private void signaturePolicyId2xml(StringBuffer sb, SignaturePolicyId spi, Signature sig) {
        if (spi != null) {
            this.xmlElemTagStart(sb, 2, "SignaturePolicyId", true, true);
            if (spi.getSigPolicyId() != null) {
                this.objectIdentifier2xml(sb, spi.getSigPolicyId(), "SigPolicyId", sig);
            }
            if (spi.getDigestAlgorithm() != null || spi.getDigestValue() != null) {
                this.xmlElemTagStart(sb, 2, "SigPolicyHash", true, true);
                this.xmlElemTagStart(sb, 1, "DigestMethod", false, false);
                this.xmlElemAttr(sb, "Algorithm", spi.getDigestAlgorithm());
                this.xmlElemTagEnd(sb, true);
                this.xmlElemEnd(sb, 1, "DigestMethod", true);
                this.xmlElemTagStart(sb, 1, "DigestValue", false, false);
                this.xmlElemTagEnd(sb, false);
                sb.append(Base64Util.encode(spi.getDigestValue()));
                this.xmlElemEnd(sb, 1, "DigestValue", true);
                this.xmlElemEnd(sb, 2, "SigPolicyHash", true);
            }
            if (spi.countSigPolicyQualifiers() > 0) {
                this.xmlElemTagStart(sb, 2, "SigPolicyQualifiers", true, true);
                for (int i = 0; i < spi.countSigPolicyQualifiers(); ++i) {
                    this.sigPolicyQualifier2xml(sb, spi.getSigPolicyQualifier(i), sig);
                }
                this.xmlElemEnd(sb, 2, "SigPolicyQualifiers", true);
            }
            this.xmlElemEnd(sb, 2, "SignaturePolicyId", true);
        }
    }

    private void signaturePolicyIdentifier2xml(StringBuffer sb, SignaturePolicyIdentifier spi, Signature sig) {
        this.xmlElemTagStart(sb, 2, "SignaturePolicyIdentifier", true, true);
        if (spi != null && spi.getSignaturePolicyId() != null) {
            this.signaturePolicyId2xml(sb, spi.getSignaturePolicyId(), sig);
        } else {
            this.xmlElemTagStart(sb, 2, "SignaturePolicyImplied", true, true);
            this.xmlElemEnd(sb, 2, "SignaturePolicyImplied", true);
        }
        this.xmlElemEnd(sb, 2, "SignaturePolicyIdentifier", true);
    }

    private void dataObjectFormat2xml(StringBuffer sb, DataObjectFormat dof, Signature sig) {
        this.xmlElemTagStart(sb, 2, "DataObjectFormat", false, false);
        if (dof.getObjectReference() != null && dof.getObjectReference().length() > 0) {
            this.xmlElemAttr(sb, "ObjectReference", dof.getObjectReference());
        }
        this.xmlElemTagEnd(sb, true);
        if (dof.getDescription() != null && dof.getDescription().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "Description", true, false);
            sb.append(dof.getDescription());
            this.xmlElemEnd(sb, 2, "Description", true);
        }
        if (dof.getObjectIdentifier() != null) {
            this.objectIdentifier2xml(sb, dof.getObjectIdentifier(), "ObjectIdentifier", sig);
        }
        if (dof.getMimeType() != null && dof.getMimeType().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "MimeType", true, false);
            sb.append(dof.getMimeType());
            this.xmlElemEnd(sb, 2, "MimeType", true);
        }
        if (dof.getEncoding() != null && dof.getEncoding().trim().length() > 0) {
            this.xmlElemTagStart(sb, 2, "Encoding", true, false);
            sb.append(dof.getEncoding());
            this.xmlElemEnd(sb, 2, "Encoding", true);
        }
        this.xmlElemEnd(sb, 2, "DataObjectFormat", true);
    }

    private void signedDataObjectProperties2xml(StringBuffer sb, SignedDataObjectProperties sdof, Signature sig) {
        this.xmlElemTagStart(sb, 2, "SignedDataObjectProperties", true, true);
        for (int i = 0; sdof != null && i < sdof.countDataObjectFormats(); ++i) {
            DataObjectFormat dof = sdof.getDataObjectFormat(i);
            if (dof == null) continue;
            this.dataObjectFormat2xml(sb, dof, sig);
        }
        this.xmlElemEnd(sb, 2, "SignedDataObjectProperties", true);
    }

    private void signedProperties2xml(StringBuffer sb, SignedProperties sp, Signature sig, boolean bWithNs) throws DigiDocException {
        this.xmlElemTagStart(sb, 2, "SignedProperties", false, false);
        if (this.m_sdoc.getFormat().equals("DIGIDOC-XML") && (this.m_sdoc.getVersion().equals("1.1") || this.m_sdoc.getVersion().equals("1.2"))) {
            this.xmlElemAttr(sb, "Target", "#" + sig.getId());
            this.xmlElemAttr(sb, "xmlns", SignedDoc.xmlns_xmldsig);
        } else if (bWithNs && sig != null && sig.getSignedDoc() != null && sig.getSignedDoc().getFormat() != null && sig.getSignedDoc().getVersion() != null && sig.getSignedDoc().getFormat().equals("BDOC") && sig.getSignedDoc().getVersion().equals("2.1")) {
            this.xmlElemNsAttr(sb, 3);
            this.xmlElemNsAttr(sb, 1);
            this.xmlElemNsAttr(sb, 2);
        }
        if (sp.getId() != null && sp.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", sp.getId());
        }
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 2, "SignedSignatureProperties", false, false);
        if (this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemAttr(sb, "Id", sig.getId() + "-SignedSignatureProperties");
        }
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 2, "SigningTime", true, false);
        sb.append(ConvertUtils.date2string(sp.getSigningTime(), this.m_sdoc));
        this.xmlElemEnd(sb, 2, "SigningTime", true);
        this.xmlElemTagStart(sb, 2, "SigningCertificate", true, true);
        CertID cid = sig.getCertIdOfType(1);
        if (cid != null) {
            this.certId2xml(sb, cid, sig);
        }
        this.xmlElemEnd(sb, 2, "SigningCertificate", true);
        if (sig.getSignedProperties() != null && sig.getSignedProperties().getSignaturePolicyIdentifier() != null) {
            this.signaturePolicyIdentifier2xml(sb, sig.getSignedProperties().getSignaturePolicyIdentifier(), sig);
        }
        if (sp.getSignatureProductionPlace() != null) {
            sb.append("\n");
            this.signatureProductionPlace2xml(sb, sp.getSignatureProductionPlace());
        }
        if (sp.countClaimedRoles() > 0) {
            sb.append("\n");
            this.xmlElemTagStart(sb, 2, "SignerRole", true, true);
            this.xmlElemTagStart(sb, 2, "ClaimedRoles", true, true);
            for (int i = 0; i < sp.countClaimedRoles(); ++i) {
                this.xmlElemTagStart(sb, 2, "ClaimedRole", true, false);
                sb.append(ConvertUtils.escapeTextNode(sp.getClaimedRole(i)));
                this.xmlElemEnd(sb, 2, "ClaimedRole", true);
            }
            this.xmlElemEnd(sb, 2, "ClaimedRoles", true);
            this.xmlElemEnd(sb, 2, "SignerRole", true);
        }
        this.xmlElemEnd(sb, 2, "SignedSignatureProperties", true);
        this.signedDataObjectProperties2xml(sb, sp.getSignedDataObjectProperties(), sig);
        this.xmlElemEnd(sb, 2, "SignedProperties", false);
    }

    public void timestampInfo2xml(StringBuffer sb, TimestampInfo ti, boolean bWithNs) {
        switch (ti.getType()) {
            case 1: {
                this.xmlElemTagStart(sb, 2, "AllDataObjectsTimeStamp", false, false);
                break;
            }
            case 2: {
                this.xmlElemTagStart(sb, 2, "IndividualDataObjectsTimeStamp", false, false);
                break;
            }
            case 3: {
                this.xmlElemTagStart(sb, 2, "SignatureTimeStamp", false, false);
                break;
            }
            case 4: {
                this.xmlElemTagStart(sb, 2, "SigAndRefsTimeStamp", false, false);
                break;
            }
            case 5: {
                this.xmlElemTagStart(sb, 2, "RefsOnlyTimeStamp", false, false);
                break;
            }
            case 6: {
                this.xmlElemTagStart(sb, 2, "ArchiveTimeStamp", false, false);
                break;
            }
            case 7: {
                this.xmlElemTagStart(sb, 2, "XAdESTimeStamp", false, false);
            }
        }
        if (bWithNs) {
            this.xmlElemNsAttr(sb, 1);
            this.xmlElemNsAttr(sb, 2);
        }
        if (ti.getId() != null && ti.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", ti.getId());
        }
        this.xmlElemTagEnd(sb, true);
        for (int i = 0; i < ti.countIncludeInfos(); ++i) {
            IncludeInfo inc = ti.getIncludeInfo(i);
            if (inc == null) continue;
            this.xmlElemTagStart(sb, 2, "Include", false, false);
            this.xmlElemAttr(sb, "URI", inc.getUri());
            this.xmlElemTagEnd(sb, true);
            this.xmlElemEnd(sb, 2, "Include", false);
        }
        this.xmlElemTagStart(sb, 2, "EncapsulatedTimeStamp", true, false);
        try {
            sb.append(Base64Util.encode(ti.getTimeStampToken().getEncoded()));
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error encoding stimestamp: " + ex));
        }
        this.xmlElemEnd(sb, 2, "EncapsulatedTimeStamp", false);
        switch (ti.getType()) {
            case 1: {
                this.xmlElemEnd(sb, 2, "AllDataObjectsTimeStamp", false);
                break;
            }
            case 2: {
                this.xmlElemEnd(sb, 2, "IndividualDataObjectsTimeStamp", false);
                break;
            }
            case 3: {
                this.xmlElemEnd(sb, 2, "SignatureTimeStamp", false);
                break;
            }
            case 4: {
                this.xmlElemEnd(sb, 2, "SigAndRefsTimeStamp", false);
                break;
            }
            case 5: {
                this.xmlElemEnd(sb, 2, "RefsOnlyTimeStamp", false);
                break;
            }
            case 6: {
                this.xmlElemEnd(sb, 2, "ArchiveTimeStamp", false);
                break;
            }
            case 7: {
                this.xmlElemEnd(sb, 2, "XAdESTimeStamp", false);
            }
        }
    }

    public void completeCertificateRefs2xml(StringBuffer sb, CompleteCertificateRefs crefs, Signature sig, boolean bWithNs) {
        this.xmlElemTagStart(sb, 2, "CompleteCertificateRefs", false, false);
        if (bWithNs) {
            this.xmlElemNsAttr(sb, 1);
            this.xmlElemNsAttr(sb, 2);
        }
        if (this.m_sdoc.getVersion().equals("1.3") || this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemAttr(sb, "Id", sig.getId() + "-CERTREFS");
        }
        this.xmlElemTagEnd(sb, false);
        if (this.m_sdoc.getVersion().equals("1.3") || this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemTagStart(sb, 2, "CertRefs", true, true);
        }
        for (int i = 0; i < crefs.countCertIDs(); ++i) {
            CertID cid = crefs.getCertID(i);
            if (cid.getType() == 1) continue;
            this.certId2xml(sb, cid, sig);
        }
        if (this.m_sdoc.getVersion().equals("1.3") || this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemEnd(sb, 2, "CertRefs", false);
        }
        this.xmlElemEnd(sb, 2, "CompleteCertificateRefs", false);
    }

    private void ocspRef2xml(StringBuffer sb, OcspRef orf) throws DigiDocException {
        String s;
        this.xmlElemTagStart(sb, 2, "OCSPRef", true, true);
        this.xmlElemTagStart(sb, 2, "OCSPIdentifier", false, false);
        this.xmlElemAttr(sb, "URI", orf.getUri());
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 2, "ResponderID", true, false);
        if (this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemTagStart(sb, 2, "ByName", true, false);
        }
        if ((s = orf.getResponderId()).startsWith("byName: ")) {
            s = s.substring("byName: ".length());
        }
        if (s.startsWith("byKey: ")) {
            s = s.substring("byKey: ".length());
        }
        sb.append(ConvertUtils.escapeTextNode(s));
        if (this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemEnd(sb, 2, "ByName", false);
        }
        this.xmlElemEnd(sb, 2, "ResponderID", false);
        this.xmlElemTagStart(sb, 2, "ProducedAt", true, false);
        sb.append(ConvertUtils.date2string(orf.getProducedAt(), this.m_sdoc));
        this.xmlElemEnd(sb, 2, "ProducedAt", true);
        this.xmlElemEnd(sb, 2, "OCSPIdentifier", true);
        this.xmlElemTagStart(sb, 2, "DigestAlgAndValue", true, true);
        this.xmlElemTagStart(sb, 1, "DigestMethod", false, false);
        this.xmlElemAttr(sb, "Algorithm", orf.getDigestAlgorithm());
        this.xmlElemTagEnd(sb, true);
        this.xmlElemEnd(sb, 1, "DigestMethod", false);
        this.xmlElemTagStart(sb, 1, "DigestValue", false, false);
        this.xmlElemTagEnd(sb, false);
        sb.append(Base64Util.encode(orf.getDigestValue(), 0));
        this.xmlElemEnd(sb, 1, "DigestValue", true);
        this.xmlElemEnd(sb, 2, "DigestAlgAndValue", true);
        this.xmlElemEnd(sb, 2, "OCSPRef", true);
    }

    public void completeRevocationRefs2xml(StringBuffer sb, CompleteRevocationRefs rrefs, Signature sig, boolean bWithNs) throws DigiDocException {
        this.xmlElemTagStart(sb, 2, "CompleteRevocationRefs", false, false);
        if (bWithNs) {
            this.xmlElemNsAttr(sb, 1);
            this.xmlElemNsAttr(sb, 2);
        }
        this.xmlElemAttr(sb, "Id", sig.getId() + "-REVOCREFS");
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 2, "OCSPRefs", true, true);
        for (int i = 0; i < rrefs.countOcspRefs(); ++i) {
            OcspRef orf = rrefs.getOcspRefById(i);
            this.ocspRef2xml(sb, orf);
        }
        this.xmlElemEnd(sb, 2, "OCSPRefs", true);
        this.xmlElemEnd(sb, 2, "CompleteRevocationRefs", false);
    }

    private void unsignedProperties2xml(StringBuffer sb, UnsignedProperties sp, Signature sig) throws DigiDocException {
        TimestampInfo ti;
        this.xmlElemTagStart(sb, 2, "UnsignedProperties", false, false);
        if (this.m_sdoc.getFormat().equals("DIGIDOC-XML") && (this.m_sdoc.getVersion().equals("1.1") || this.m_sdoc.getVersion().equals("1.2"))) {
            this.xmlElemAttr(sb, "Target", "#" + sig.getId());
        } else {
            if (this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemAttr(sb, "Id", sig.getId() + "-UnsigedProperties");
            }
            if (!this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemAttr(sb, "xmlns", SignedDoc.xmlns_etsi);
            }
        }
        this.xmlElemTagEnd(sb, true);
        this.xmlElemTagStart(sb, 2, "UnsignedSignatureProperties", false, false);
        if (this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemAttr(sb, "Id", sig.getId() + "-UnsigedSignatureProperties");
        }
        this.xmlElemTagEnd(sb, true);
        if ((sig.getProfile().equals("T") || sig.getProfile().equals("C-L") || sig.getProfile().equals("TS") || sig.getProfile().equals("TS-A")) && (ti = sig.getTimestampInfoOfType(3)) != null) {
            this.timestampInfo2xml(sb, ti, false);
        }
        if ((!this.m_sdoc.getFormat().equals("BDOC") || !this.m_sdoc.getVersion().equals("2.1")) && (sig.getProfile().equals("TM") || sig.getProfile().equals("TM-A") || sig.getProfile().equals("C-L") || sig.getProfile().equals("TS") || sig.getProfile().equals("TS-A"))) {
            this.completeCertificateRefs2xml(sb, sp.getCompleteCertificateRefs(), sig, false);
            this.completeRevocationRefs2xml(sb, sp.getCompleteRevocationRefs(), sig, false);
        }
        if ((sig.getProfile().equals("TS") || sig.getProfile().equals("TS-A")) && (ti = sig.getTimestampInfoOfType(4)) != null) {
            this.timestampInfo2xml(sb, ti, false);
        }
        if (sig.getProfile().equals("TM") || sig.getProfile().equals("TM-A") || sig.getProfile().equals("TS") || sig.getProfile().equals("TS-A")) {
            CertValue cval;
            int i;
            int nCerts = 0;
            for (i = 0; i < sig.countCertValues(); ++i) {
                cval = sig.getCertValue(i);
                if (cval == null || cval.getType() == 1) continue;
                ++nCerts;
            }
            if (nCerts > 0) {
                this.xmlElemTagStart(sb, 2, "CertificateValues", false, false);
                if (this.m_sdoc.getFormat().equals("BDOC")) {
                    this.xmlElemAttr(sb, "Id", sig.getId() + "-CertificateValues");
                }
                this.xmlElemTagEnd(sb, true);
                for (i = 0; i < sig.countCertValues(); ++i) {
                    cval = sig.getCertValue(i);
                    if (cval == null || cval.getType() == 1) continue;
                    this.certValue2xml(sb, cval);
                }
                this.xmlElemEnd(sb, 2, "CertificateValues", true);
            }
            this.xmlElemTagStart(sb, 2, "RevocationValues", false, false);
            if (this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemAttr(sb, "Id", sig.getId() + "-RevocationValues");
            }
            this.xmlElemTagEnd(sb, true);
            this.xmlElemTagStart(sb, 2, "OCSPValues", true, false);
            for (i = 0; i < sp.countNotaries(); ++i) {
                Notary not = sp.getNotaryById(i);
                this.xmlElemTagStart(sb, 2, "EncapsulatedOCSPValue", false, false);
                if (this.m_sdoc.getFormat().equals("BDOC") || this.m_sdoc.getFormat().equals("DIGIDOC-XML") && this.m_sdoc.getVersion().equals("1.3")) {
                    this.xmlElemAttr(sb, "Id", not.getId());
                }
                this.xmlElemTagEnd(sb, true);
                sb.append(Base64Util.encode(not.getOcspResponseData(), 64));
                this.xmlElemEnd(sb, 2, "EncapsulatedOCSPValue", true);
            }
            this.xmlElemEnd(sb, 2, "OCSPValues", false);
            this.xmlElemEnd(sb, 2, "RevocationValues", false);
        }
        this.xmlElemEnd(sb, 2, "UnsignedSignatureProperties", true);
        this.xmlElemEnd(sb, 2, "UnsignedProperties", false);
    }

    public String signature2xml(Signature sig) throws DigiDocException {
        StringBuffer sb = new StringBuffer();
        if (sig.getSignedDoc().getFormat().equals("BDOC")) {
            sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        if (sig.getSignedDoc().getVersion().equals("2.1")) {
            sb.append("<asic:XAdESSignatures xmlns:asic=\"http://uri.etsi.org/02918/v1.2.1#\" xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\">\n");
        }
        this.xmlElemTagStart(sb, 1, "Signature", false, false);
        if (sig.getId() != null && sig.getId().length() > 0) {
            this.xmlElemAttr(sb, "Id", sig.getId());
        }
        if (!this.m_sdoc.getFormat().equals("BDOC") || !this.m_sdoc.getVersion().equals("2.1")) {
            this.xmlElemNsAttr(sb, 1);
        }
        this.xmlElemTagEnd(sb, true);
        this.signedInfo2xml(sb, sig.getSignedInfo(), false);
        if (sig.getSignatureValue() != null) {
            this.signatureValue2xml(sb, sig.getSignatureValue(), false);
        }
        this.keyInfo2xml(sb, sig.getKeyInfo(), sig);
        if (this.m_sdoc.getFormat().equals("BDOC")) {
            this.xmlElemTagStart(sb, 1, "Object", false, false);
            this.xmlElemAttr(sb, "Id", sig.getId() + "-object-xades");
            this.xmlElemTagEnd(sb, false);
        } else {
            this.xmlElemTagStart(sb, 1, "Object", true, false);
        }
        this.xmlElemTagStart(sb, 2, "QualifyingProperties", false, false);
        if (this.m_sdoc.getVersion().equals("1.3") || this.m_sdoc.getFormat().equals("BDOC")) {
            if (this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemAttr(sb, "Id", sig.getId() + "-QualifyingProperties");
            }
            this.xmlElemAttr(sb, "Target", "#" + sig.getId());
            if (this.m_sdoc.getFormat().equals("BDOC")) {
                this.xmlElemNsAttr(sb, 2);
            } else {
                this.xmlElemAttr(sb, "xmlns", SignedDoc.xmlns_etsi);
            }
        }
        this.xmlElemTagEnd(sb, false);
        this.signedProperties2xml(sb, sig.getSignedProperties(), sig, false);
        if (sig.getUnsignedProperties() != null) {
            this.unsignedProperties2xml(sb, sig.getUnsignedProperties(), sig);
        }
        this.xmlElemEnd(sb, 2, "QualifyingProperties", false);
        this.xmlElemEnd(sb, 1, "Object", true);
        this.xmlElemEnd(sb, 1, "Signature", true);
        if (sig.getSignedDoc().getVersion().equals("2.1")) {
            sb.append("</asic:XAdESSignatures>");
        }
        return sb.toString();
    }

    public byte[] signatureToXML(Signature sig) throws DigiDocException {
        if (sig.getOrigContent() != null) {
            return sig.getOrigContent();
        }
        String sXml = this.signature2xml(sig);
        try {
            return ConvertUtils.str2data(sXml);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 89);
            return null;
        }
    }

    public byte[] signedPropertiesToXML(Signature sig, SignedProperties sp) throws DigiDocException {
        StringBuffer sb = new StringBuffer();
        this.signedProperties2xml(sb, sp, sig, true);
        String sXml = sb.toString();
        try {
            return ConvertUtils.str2data(sXml);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 89);
            return null;
        }
    }

    public byte[] unsignedPropertiesToXML(Signature sig, UnsignedProperties usp) throws DigiDocException {
        StringBuffer sb = new StringBuffer();
        this.unsignedProperties2xml(sb, usp, sig);
        String sXml = sb.toString();
        try {
            return ConvertUtils.str2data(sXml);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 89);
            return null;
        }
    }

    public byte[] signedInfoToXML(Signature sig, SignedInfo si) throws DigiDocException {
        StringBuffer sb = new StringBuffer();
        this.signedInfo2xml(sb, si, true);
        String sXml = sb.toString();
        try {
            return ConvertUtils.str2data(sXml);
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 89);
            return null;
        }
    }
}

