/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.TokenKeyInfo;
import ee.sk.digidoc.factory.SignatureFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.SlotInfo;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PKCS11SignatureFactory
implements SignatureFactory {
    private Module m_pkcs11Module = null;
    private TokenKeyInfo[] m_tokens = null;
    private Session m_currentSession = null;
    private TokenKeyInfo m_selToken = null;
    private Provider m_secProvider = null;
    private static Logger m_logger = Logger.getLogger(PKCS11SignatureFactory.class);
    private static boolean m_isInitialized;
    byte[] tsign = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};

    public PKCS11SignatureFactory() {
        m_isInitialized = false;
    }

    @Override
    public void init() throws DigiDocException {
        if (this.m_pkcs11Module == null) {
            this.initPKCS11();
        }
        if (this.m_secProvider == null) {
            this.initProvider();
        }
    }

    public void initPKCS11() throws DigiDocException {
        try {
            if (m_logger.isInfoEnabled()) {
                m_logger.info((Object)("Loading PKCS11 driver: " + ConfigManager.instance().getProperty("DIGIDOC_SIGN_PKCS11_DRIVER") + " libpath: " + System.getProperty("java.library.path")));
            }
            this.m_pkcs11Module = (Module)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String moduleName = ConfigManager.instance().getProperty("DIGIDOC_SIGN_PKCS11_DRIVER");
                    Module m = Module.getInstance((String)moduleName);
                    return m;
                }
            });
            try {
                if (!m_isInitialized) {
                    this.m_pkcs11Module.initialize(null);
                    m_isInitialized = true;
                }
            }
            catch (PKCS11Exception ex) {
                m_logger.error((Object)("Pkcs11 error: " + (Object)((Object)ex)));
                if (ex.getErrorCode() == 401L) {
                    m_logger.error((Object)"PKCS11 already loaded ok");
                    m_isInitialized = true;
                }
                DigiDocException.handleException((Exception)((Object)ex), 57);
            }
            this.m_tokens = this.getTokenKeys();
        }
        catch (Exception e) {
            this.m_pkcs11Module = null;
            DigiDocException.handleException(e, 57);
        }
        if (this.m_tokens == null || this.m_tokens.length == 0) {
            throw new DigiDocException(85, "Error reading signature certificates from card!", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenKeyInfo[] getTokenKeys() throws DigiDocException {
        Vector<TokenKeyInfo> vec = new Vector<TokenKeyInfo>();
        Session sess = null;
        try {
            CertificateFactory certFac = CertificateFactory.getInstance("X.509");
            Slot[] slots = this.m_pkcs11Module.getSlotList(true);
            int nNr = 0;
            for (int i = 0; slots != null && i < slots.length; ++i) {
                SlotInfo si = slots[i].getSlotInfo();
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Slot " + i + ": " + si));
                }
                if (!si.isTokenPresent()) continue;
                Token tok = slots[i].getToken();
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Token: " + tok));
                }
                sess = tok.openSession(true, false, null, null);
                X509PublicKeyCertificate templCert = new X509PublicKeyCertificate();
                sess.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)templCert);
                iaik.pkcs.pkcs11.objects.Object[] certs = null;
                do {
                    if ((certs = sess.findObjects(1)) == null || certs.length <= 0) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Certs: " + certs.length));
                    }
                    for (int j = 0; certs != null && j < certs.length; ++j) {
                        X509PublicKeyCertificate x509 = (X509PublicKeyCertificate)certs[j];
                        byte[] derCert = x509.getValue().getByteArrayValue();
                        X509Certificate cert = (X509Certificate)certFac.generateCertificate(new ByteArrayInputStream(derCert));
                        TokenKeyInfo tki = new TokenKeyInfo(nNr, slots[i].getSlotID(), tok, x509.getId().getByteArrayValue(), x509.getLabel().toString(), cert);
                        ++nNr;
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Slot: " + i + " cert: " + j + " nr: " + tki.getCertSerial() + " CN: " + tki.getCertName() + " id: " + tki.getIdHex() + " signature: " + tki.isSignatureKey()));
                        }
                        vec.add(tki);
                    }
                } while (certs != null && certs.length > 0);
                sess.closeSession();
                sess = null;
            }
        }
        catch (Exception e) {
            this.m_pkcs11Module = null;
            DigiDocException.handleException(e, 57);
        }
        finally {
            try {
                if (sess != null) {
                    sess.closeSession();
                }
            }
            catch (Exception ex) {
                m_logger.error((Object)("Error closing session: " + ex));
            }
        }
        TokenKeyInfo[] arr = new TokenKeyInfo[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            arr[i] = (TokenKeyInfo)vec.elementAt(i);
        }
        return arr;
    }

    private void initProvider() throws DigiDocException {
        try {
            this.m_secProvider = (Provider)Class.forName(ConfigManager.instance().getProperty("DIGIDOC_SECURITY_PROVIDER")).newInstance();
            Security.addProvider(this.m_secProvider);
        }
        catch (Exception ex) {
            this.m_secProvider = null;
            DigiDocException.handleException(ex, 58);
        }
    }

    @Override
    public TokenKeyInfo[] getTokensOfType(boolean bSign) {
        int nToks = 0;
        boolean bKeyUsageCheck = ConfigManager.instance().getBooleanProperty("KEY_USAGE_CHECK", true);
        for (int i = 0; this.m_tokens != null && i < this.m_tokens.length; ++i) {
            TokenKeyInfo tki = this.m_tokens[i];
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Token: " + i + " is-sign: " + tki.isSignatureKey() + " is-crypt: " + tki.isEncryptKey() + " nr: " + tki.getCertSerial() + " CN: " + tki.getCertName() + " id: " + tki.getIdHex()));
            }
            if ((!bSign || !tki.isSignatureKey() && bKeyUsageCheck) && (bSign || !tki.isEncryptKey())) continue;
            ++nToks;
        }
        TokenKeyInfo[] arr = new TokenKeyInfo[nToks];
        int j = 0;
        for (int i = 0; this.m_tokens != null && i < this.m_tokens.length; ++i) {
            TokenKeyInfo tki = this.m_tokens[i];
            if ((!bSign || !tki.isSignatureKey() && bKeyUsageCheck) && (bSign || !tki.isEncryptKey())) continue;
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Using token: " + i + " is-sign: " + tki.isSignatureKey() + " is-crypt: " + tki.isEncryptKey() + " nr: " + tki.getCertSerial() + " CN: " + tki.getCertName() + " id: " + tki.getIdHex()));
            }
            arr[j++] = tki;
        }
        return arr;
    }

    public TokenKeyInfo getTokenWithSlotIdAndLabel(long nSlotId, String label) {
        for (int i = 0; this.m_tokens != null && i < this.m_tokens.length; ++i) {
            TokenKeyInfo tki = this.m_tokens[i];
            if (tki.getSlot() != nSlotId || !tki.getLabel().equals(label)) continue;
            return tki;
        }
        return null;
    }

    public X509Certificate getCertificateWithSlotIdAndLabel(long nSlotId, String label) {
        TokenKeyInfo tki = this.getTokenWithSlotIdAndLabel(nSlotId, label);
        if (tki != null) {
            return tki.getCert();
        }
        return null;
    }

    @Override
    public String[] getAvailableTokenNames() throws DigiDocException {
        if (this.m_pkcs11Module == null) {
            this.initPKCS11();
        }
        String[] names = new String[this.m_tokens.length];
        for (int i = 0; this.m_tokens != null && i < this.m_tokens.length; ++i) {
            TokenKeyInfo tki = this.m_tokens[i];
            names[i] = tki.getCertName();
        }
        return names;
    }

    public void openSession(TokenKeyInfo tki, String pin) throws DigiDocException {
        block13: {
            if (this.m_pkcs11Module == null) {
                this.initPKCS11();
            }
            try {
                if (this.m_currentSession != null) {
                    this.closeSession();
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Open session for token: " + tki));
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Open session for: " + (tki != null ? tki.getCertName() + " id: " + tki.getIdHex() + " sign: " + tki.isSignatureKey() + " crypt: " + tki.isEncryptKey() : "NULL")));
                }
                if (tki != null) {
                    this.m_currentSession = tki.getToken().openSession(true, false, null, null);
                    this.m_selToken = tki;
                } else if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"No suitable token found!");
                }
                if (this.m_currentSession == null || this.m_selToken == null) break block13;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Login for: " + this.m_selToken.getCertName() + " id: " + this.m_selToken.getIdHex()));
                }
                try {
                    this.m_currentSession.login(true, pin.toCharArray());
                }
                catch (PKCS11Exception ex) {
                    m_logger.error((Object)("Pkcs11 error: " + (Object)((Object)ex)));
                    if (ex.getErrorCode() == 256L) {
                        m_logger.error((Object)"User already logged in ok");
                        break block13;
                    }
                    DigiDocException.handleException((Exception)((Object)ex), 60);
                }
            }
            catch (TokenException e) {
                this.m_selToken = null;
                this.m_currentSession = null;
                DigiDocException.handleException((Exception)((Object)e), 60);
            }
        }
    }

    public void openSession(boolean bSignSession, int token, String pin) throws DigiDocException {
        block14: {
            if (this.m_pkcs11Module == null) {
                this.initPKCS11();
            }
            try {
                if (this.m_currentSession != null && this.m_selToken != null && (!bSignSession || this.m_selToken.isSignatureKey()) && (bSignSession || !this.m_selToken.isSignatureKey())) break block14;
                if (this.m_currentSession != null) {
                    this.closeSession();
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Open session for token: " + token));
                }
                TokenKeyInfo tki = null;
                TokenKeyInfo[] tkis = this.getTokensOfType(bSignSession);
                if (token >= 0 && tkis != null && token < tkis.length) {
                    tki = tkis[token];
                }
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Open " + (bSignSession ? "sign" : "auth") + " session for: " + (tki != null ? tki.getCertName() + " id: " + tki.getIdHex() + " sign: " + tki.isSignatureKey() + " crypt: " + tki.isEncryptKey() : "NULL")));
                }
                if (tki != null) {
                    this.m_currentSession = tki.getToken().openSession(true, false, null, null);
                    this.m_selToken = tki;
                } else if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)"No suitable token found!");
                }
                if (this.m_currentSession == null || this.m_selToken == null) break block14;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Login for: " + this.m_selToken.getCertName() + " id: " + this.m_selToken.getIdHex()));
                }
                try {
                    this.m_currentSession.login(true, pin.toCharArray());
                }
                catch (PKCS11Exception ex) {
                    m_logger.error((Object)("Pkcs11 error: " + (Object)((Object)ex)));
                    if (ex.getErrorCode() == 256L) {
                        m_logger.error((Object)"User already logged in ok");
                        break block14;
                    }
                    DigiDocException.handleException((Exception)((Object)ex), 60);
                }
            }
            catch (TokenException e) {
                this.m_selToken = null;
                this.m_currentSession = null;
                DigiDocException.handleException((Exception)((Object)e), 60);
            }
        }
    }

    @Override
    public byte[] sign(byte[] digest, int token, String pin, Signature sig) throws DigiDocException {
        byte[] sigVal = null;
        if (this.m_currentSession == null) {
            this.openSession(true, token, pin);
        }
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Sign with token: " + token + " key: " + (this.m_selToken != null ? this.m_selToken.getCertName() : "NULL") + " id: " + (this.m_selToken != null ? this.m_selToken.getIdHex() : "NULL") + " dig-len: " + (digest != null ? digest.length : 0) + " dig: " + (digest != null ? Base64Util.encode(digest) : "NULL")));
            }
            RSAPrivateKey tempKey = new RSAPrivateKey();
            this.m_currentSession.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempKey);
            iaik.pkcs.pkcs11.objects.Object[] keys = null;
            RSAPrivateKey sigKey = null;
            boolean bFound = false;
            block2: do {
                if ((keys = this.m_currentSession.findObjects(1)) == null || keys.length <= 0) continue;
                for (int i = 0; !bFound && i < keys.length; ++i) {
                    sigKey = (RSAPrivateKey)keys[i];
                    String keyIdHex = SignedDoc.bin2hex(sigKey.getId().getByteArrayValue());
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Key " + i + " id: " + keyIdHex));
                    }
                    if (keyIdHex == null || this.m_selToken.getIdHex() == null || !keyIdHex.equals(this.m_selToken.getIdHex())) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Using key " + i + " id: " + keyIdHex));
                    }
                    Mechanism sigMech = Mechanism.RSA_PKCS;
                    this.m_currentSession.signInit(sigMech, (Key)sigKey);
                    byte[] ddata = ConvertUtils.addDigestAsn1Prefix(digest);
                    sigVal = this.m_currentSession.sign(ddata);
                    if (!m_logger.isDebugEnabled()) continue block2;
                    m_logger.debug((Object)("Signature len: " + (sigVal != null ? sigVal.length : 0)));
                    continue block2;
                }
            } while (!bFound && keys != null && keys.length > 0);
            this.m_currentSession.findObjectsFinal();
            this.closeSession();
        }
        catch (TokenException e) {
            DigiDocException.handleException((Exception)((Object)e), 61);
        }
        return sigVal;
    }

    public byte[] sign(byte[] digest, long nSlotId, String certLabel, String pin, Signature sig) throws DigiDocException {
        byte[] sigVal = null;
        TokenKeyInfo tki = this.getTokenWithSlotIdAndLabel(nSlotId, certLabel);
        if (tki == null) {
            m_logger.error((Object)("No token with slot: " + nSlotId + " and label: " + certLabel + " found!"));
            return null;
        }
        if (this.m_currentSession == null) {
            this.openSession(tki, pin);
        }
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Sign with token: " + tki + " key: " + (this.m_selToken != null ? this.m_selToken.getCertName() : "NULL") + " id: " + (this.m_selToken != null ? this.m_selToken.getIdHex() : "NULL") + " dig-len: " + (digest != null ? digest.length : 0) + " dig: " + (digest != null ? Base64Util.encode(digest) : "NULL")));
            }
            RSAPrivateKey tempKey = new RSAPrivateKey();
            this.m_currentSession.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)tempKey);
            iaik.pkcs.pkcs11.objects.Object[] foundKeys = null;
            boolean bFound = false;
            block2: do {
                if ((foundKeys = this.m_currentSession.findObjects(1)) == null || foundKeys.length <= 0) continue;
                RSAPrivateKey sigKey = null;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("Keys: " + foundKeys.length));
                }
                for (int i = 0; !bFound && i < foundKeys.length; ++i) {
                    sigKey = (RSAPrivateKey)foundKeys[i];
                    String keyLabel = null;
                    if (sigKey.getLabel() != null) {
                        keyLabel = sigKey.getLabel().toString();
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Key " + i + " label: " + keyLabel));
                        }
                    }
                    if (keyLabel == null || this.m_selToken.getLabel() == null || !keyLabel.equals(this.m_selToken.getLabel())) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Using key " + i + " label: " + keyLabel));
                    }
                    bFound = true;
                    Mechanism sigMech = Mechanism.RSA_PKCS;
                    this.m_currentSession.signInit(sigMech, (Key)sigKey);
                    byte[] ddata = ConvertUtils.addDigestAsn1Prefix(digest);
                    sigVal = this.m_currentSession.sign(ddata);
                    if (!m_logger.isDebugEnabled()) continue block2;
                    m_logger.debug((Object)("Signature len: " + (sigVal != null ? sigVal.length : 0)));
                    continue block2;
                }
            } while (!bFound && foundKeys != null && foundKeys.length > 0);
            if (!bFound) {
                m_logger.error((Object)("Failed to sign, token with slot: " + nSlotId + " and label: " + certLabel + " not found!"));
            }
            this.m_currentSession.findObjectsFinal();
            this.closeSession();
        }
        catch (TokenException e) {
            DigiDocException.handleException((Exception)((Object)e), 61);
        }
        return sigVal;
    }

    @Override
    public X509Certificate getCertificate(int token, String pin) throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Get cert in slot: " + token));
        }
        if (this.m_currentSession == null) {
            this.openSession(true, token, pin);
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Got cert in slot: " + token + " nr: " + this.m_selToken.getNr() + " sign: " + this.m_selToken.isSignatureKey() + " enc: " + this.m_selToken.isEncryptKey()));
        }
        if (this.m_selToken != null) {
            return this.m_selToken.getCert();
        }
        return null;
    }

    @Override
    public X509Certificate getAuthCertificate(int token, String pin) throws DigiDocException {
        if (this.m_currentSession == null) {
            this.openSession(false, token, pin);
        }
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)("Get cert for token: " + token));
        }
        if (this.m_selToken != null) {
            return this.m_selToken.getCert();
        }
        return null;
    }

    @Override
    public byte[] decrypt(byte[] data, int token, String pin) throws DigiDocException {
        byte[] value = null;
        if (this.m_currentSession == null) {
            this.openSession(false, token, pin);
        }
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypting " + data.length + " bytes"));
                m_logger.debug((Object)("Decrypting with token: " + this.m_selToken.getNr()));
                m_logger.debug((Object)("session: " + this.m_currentSession));
            }
            RSAPrivateKey authKey = new RSAPrivateKey();
            this.m_currentSession.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)authKey);
            iaik.pkcs.pkcs11.objects.Object[] keys = null;
            boolean bFound = false;
            block2: do {
                if ((keys = this.m_currentSession.findObjects(1)) == null || keys.length <= 0) continue;
                RSAPrivateKey key = null;
                for (int i = 0; !bFound && i < keys.length; ++i) {
                    key = (RSAPrivateKey)keys[i];
                    String keyIdHex = null;
                    if (key.getId() != null) {
                        keyIdHex = SignedDoc.bin2hex(key.getId().getByteArrayValue());
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Key " + i + " id: " + keyIdHex));
                        }
                    }
                    if (keyIdHex == null || this.m_selToken.getIdHex() == null || !keyIdHex.equals(this.m_selToken.getIdHex())) continue;
                    bFound = true;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Using key " + i + " id: " + keyIdHex));
                    }
                    Mechanism m = Mechanism.RSA_PKCS;
                    this.m_currentSession.decryptInit(m, (Key)key);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)"decryptInit OK");
                    }
                    value = this.m_currentSession.decrypt(data);
                    if (!m_logger.isDebugEnabled()) continue block2;
                    m_logger.debug((Object)("value = " + value));
                    continue block2;
                }
            } while (!bFound && keys != null && keys.length > 0);
            if (m_logger.isInfoEnabled()) {
                m_logger.info((Object)("Decrypted " + (data != null ? data.length : 0) + " bytes, got: " + value.length));
            }
            this.m_currentSession.findObjectsFinal();
            this.closeSession();
        }
        catch (TokenException e) {
            DigiDocException.handleException((Exception)((Object)e), 111);
        }
        return value;
    }

    public byte[] decrypt(byte[] data, long slot, String label, String pin) throws DigiDocException {
        byte[] value = null;
        TokenKeyInfo tki = this.getTokenWithSlotIdAndLabel(slot, label);
        if (tki == null) {
            m_logger.error((Object)("No token with slot: " + slot + " and label: " + label + " found!"));
            return null;
        }
        if (this.m_currentSession == null) {
            this.openSession(tki, pin);
        }
        try {
            RSAPrivateKey authKey = new RSAPrivateKey();
            this.m_currentSession.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)authKey);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypting " + data.length + " bytes"));
                m_logger.debug((Object)("Decrypting with token: " + this.m_selToken.getNr()));
                m_logger.debug((Object)("session: " + this.m_currentSession));
            }
            RSAPrivateKey key = null;
            boolean bFound = false;
            iaik.pkcs.pkcs11.objects.Object[] keys = null;
            block2: do {
                if ((keys = this.m_currentSession.findObjects(1)) == null || keys.length <= 0) continue;
                for (int i = 0; !bFound && i < keys.length; ++i) {
                    key = (RSAPrivateKey)keys[i];
                    String keyLabel = null;
                    if (key.getLabel() != null) {
                        keyLabel = key.getLabel().toString();
                        if (m_logger.isDebugEnabled()) {
                            m_logger.debug((Object)("Key " + i + " label: " + keyLabel));
                        }
                    }
                    if (keyLabel == null || this.m_selToken.getLabel() == null || !keyLabel.equals(this.m_selToken.getLabel())) continue;
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Using key " + i + " label: " + keyLabel));
                    }
                    bFound = true;
                    Mechanism m = Mechanism.RSA_PKCS;
                    this.m_currentSession.decryptInit(m, (Key)key);
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)"decryptInit OK");
                    }
                    value = this.m_currentSession.decrypt(data);
                    if (!m_logger.isDebugEnabled()) continue block2;
                    m_logger.debug((Object)("value = " + value));
                    continue block2;
                }
            } while (!bFound && keys != null && keys.length > 0);
            if (!bFound) {
                m_logger.error((Object)("Failed to sign, token with slot: " + slot + " and label: " + label + " not found!"));
            }
            if (m_logger.isInfoEnabled()) {
                m_logger.info((Object)("Decrypted " + (data != null ? data.length : 0) + " bytes, got: " + value.length));
            }
            this.m_currentSession.findObjectsFinal();
            this.closeSession();
        }
        catch (TokenException e) {
            DigiDocException.handleException((Exception)((Object)e), 111);
        }
        return value;
    }

    @Override
    public void closeSession() throws DigiDocException {
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)"Closing card session");
            }
            if (this.m_currentSession != null) {
                this.m_currentSession.closeSession();
            }
            this.m_currentSession = null;
        }
        catch (TokenException e) {
            DigiDocException.handleException((Exception)((Object)e), 63);
        }
    }

    public void finalize() throws DigiDocException {
        try {
            if (this.m_pkcs11Module != null) {
                this.m_pkcs11Module.finalize(null);
            }
            m_isInitialized = false;
            this.m_pkcs11Module = null;
        }
        catch (TokenException e) {
            DigiDocException.handleException((Exception)((Object)e), 64);
        }
    }

    @Override
    public void reset() throws DigiDocException {
        if (m_logger.isDebugEnabled()) {
            m_logger.debug((Object)"Resetting PKCS11SignatureFactory");
        }
        this.m_selToken = null;
        this.closeSession();
        m_isInitialized = false;
        this.m_pkcs11Module = null;
        this.m_secProvider = null;
        this.finalize();
    }

    @Override
    public String getType() {
        return "PKCS11";
    }
}

