/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.TokenKeyInfo;
import ee.sk.digidoc.factory.SignatureFactory;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public class Pkcs12SignatureFactory
implements SignatureFactory {
    private KeyStore m_keyStore;
    private static Logger m_logger = Logger.getLogger(Pkcs12SignatureFactory.class);
    private Provider m_secProvider;

    @Override
    public void init() throws DigiDocException {
        this.initProvider();
        if (this.m_keyStore == null) {
            ConfigManager cfg = ConfigManager.instance();
            String storeFile = cfg.getProperty("DIGIDOC_KEYSTORE_FILE");
            String storeType = cfg.getProperty("DIGIDOC_KEYSTORE_TYPE");
            String storePasswd = cfg.getProperty("DIGIDOC_KEYSTORE_PASSWD");
            if (storeFile != null && storeType != null && storePasswd != null) {
                this.load(storeFile, storeType, storePasswd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(String storeName, String storeType, String passwd) throws DigiDocException {
        FileInputStream fis = null;
        try {
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Load store: " + storeName + " type: " + storeType));
            }
            this.m_keyStore = KeyStore.getInstance(storeType);
            if (this.m_keyStore != null) {
                fis = new FileInputStream(storeName);
                this.m_keyStore.load(fis, passwd.toCharArray());
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error loading store: " + storeName + " - " + ex));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                    fis = null;
                }
                catch (Exception ex2) {
                    m_logger.error((Object)("Error closing pkcs12: " + storeName + " - " + ex2));
                }
            }
        }
        return false;
    }

    private void initProvider() throws DigiDocException {
        try {
            this.m_secProvider = (Provider)Class.forName(ConfigManager.instance().getProperty("DIGIDOC_SECURITY_PROVIDER")).newInstance();
            Security.addProvider(this.m_secProvider);
        }
        catch (Exception ex) {
            this.m_secProvider = null;
            DigiDocException.handleException(ex, 58);
        }
    }

    @Override
    public TokenKeyInfo[] getTokenKeys() throws DigiDocException {
        return null;
    }

    @Override
    public TokenKeyInfo[] getTokensOfType(boolean bSign) {
        return null;
    }

    @Override
    public String[] getAvailableTokenNames() throws DigiDocException {
        Vector<String> vec = new Vector<String>();
        try {
            if (this.m_keyStore != null) {
                Enumeration<String> eAliases = this.m_keyStore.aliases();
                while (eAliases.hasMoreElements()) {
                    String alias = eAliases.nextElement();
                    vec.add(alias);
                }
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading store aliases: " + ex));
        }
        String[] arr = new String[vec.size()];
        for (int i = 0; vec != null && i < vec.size(); ++i) {
            arr[i] = (String)vec.elementAt(i);
        }
        return arr;
    }

    private String getTokenName(int nIdx) {
        try {
            if (this.m_keyStore != null) {
                Enumeration<String> eAliases = this.m_keyStore.aliases();
                int i = 0;
                while (eAliases.hasMoreElements()) {
                    String alias = eAliases.nextElement();
                    if (i == nIdx) {
                        return alias;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading store aliases: " + ex));
        }
        return null;
    }

    public static java.security.Signature sigMeth2SigSignatureInstance(Signature sig, Key key) throws DigiDocException {
        java.security.Signature instance = null;
        String sigMeth = null;
        String sigType = null;
        try {
            if (sig != null && sig.getSignedInfo() != null && sig.getSignedInfo().getSignatureMethod() != null) {
                sigMeth = sig.getSignedInfo().getSignatureMethod();
            }
            ConfigManager.instance();
            sigType = ConfigManager.sigMeth2SigType(sigMeth, true);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Key: " + (key != null ? "OK, algorithm: " + key.getAlgorithm() : "NULL") + " method: " + sigMeth + " type: " + sigType));
            }
            if (sigType == null) {
                throw new DigiDocException(24, "SignatureMethod not specified!", null);
            }
            instance = java.security.Signature.getInstance(sigType, ConfigManager.addProvider());
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error constructing signature instance: " + ex));
        }
        return instance;
    }

    private boolean isCvcEcKey(Signature sig) {
        String sigMeth = sig.getSignedInfo().getSignatureMethod();
        ConfigManager.instance();
        String sSigType = ConfigManager.sigMeth2SigType(sigMeth, true);
        return ConfigManager.isEcdsaCvcAlgorithm(sSigType);
    }

    @Override
    public byte[] sign(byte[] xml, int token, String passwd, Signature sig) throws DigiDocException {
        try {
            if (this.m_keyStore == null) {
                throw new DigiDocException(16, "Keystore not initialized", null);
            }
            String alias = this.getTokenName(token);
            if (alias == null) {
                throw new DigiDocException(60, "Invalid token nr: " + token, null);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("loading key: " + alias + " passwd-len: " + (passwd != null ? passwd.length() : 0)));
            }
            Key key = this.m_keyStore.getKey(alias, passwd.toCharArray());
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Key: " + (key != null ? "OK, algorithm: " + key.getAlgorithm() : "NULL")));
            }
            if (key == null) {
                throw new DigiDocException(60, "Invalid password for token nr: " + token, null);
            }
            String sigMeth = null;
            if (sig != null && sig.getSignedInfo() != null && sig.getSignedInfo().getSignatureMethod() != null) {
                sigMeth = sig.getSignedInfo().getSignatureMethod();
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Signing\n---\n" + new String(xml) + "\n---\n method: " + sigMeth));
            }
            java.security.Signature instance = Pkcs12SignatureFactory.sigMeth2SigSignatureInstance(sig, key);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Signature instance: " + (instance != null ? "OK" : "NULL")));
            }
            instance.initSign((PrivateKey)key);
            instance.update(xml);
            byte[] signature = instance.sign();
            boolean bEcCvcKey = this.isCvcEcKey(sig);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Signature algorithm: " + key.getAlgorithm() + " siglen: " + signature.length + " ec-key: " + bEcCvcKey));
            }
            if (bEcCvcKey) {
                int nKeyLen = ((ECPrivateKey)key).getParams().getCurve().getField().getFieldSize();
                int nReqLen = (int)Math.ceil((double)nKeyLen / 8.0) * 2;
                int nSigLen = signature.length;
                if (m_logger.isDebugEnabled()) {
                    m_logger.debug((Object)("EC Signature length: " + nSigLen + " required: " + nReqLen));
                }
                if (nSigLen < nReqLen) {
                    if (m_logger.isDebugEnabled()) {
                        m_logger.debug((Object)("Padding EC signature length: " + nSigLen + " to required: " + nReqLen));
                    }
                    byte[] padsig = new byte[nReqLen];
                    System.arraycopy(signature, 0, padsig, (nReqLen - nSigLen) / 2, nSigLen / 2);
                    System.arraycopy(signature, nSigLen / 2, padsig, nReqLen / 2 + (nReqLen - nSigLen) / 2, nSigLen / 2);
                    signature = padsig;
                }
            }
            if (m_logger.isDebugEnabled() && signature != null) {
                m_logger.debug((Object)("Signature len: " + signature.length + "\n---\n sig: " + ConvertUtils.bin2hex(signature)));
            }
            return signature;
        }
        catch (DigiDocException ex) {
            m_logger.error((Object)("DigiDoc Error signing: " + ex));
            throw ex;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error signing: " + ex));
            return null;
        }
    }

    @Override
    public X509Certificate getCertificate(int token, String pin) throws DigiDocException {
        if (this.m_keyStore == null) {
            throw new DigiDocException(16, "Keystore not initialized", null);
        }
        String alias = this.getTokenName(token);
        if (alias == null) {
            throw new DigiDocException(60, "Invalid token nr: " + token, null);
        }
        try {
            return (X509Certificate)this.m_keyStore.getCertificate(alias);
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error reading cert for alias: " + alias + " - " + ex));
            return null;
        }
    }

    @Override
    public X509Certificate getAuthCertificate(int token, String pin) throws DigiDocException {
        return this.getCertificate(token, pin);
    }

    @Override
    public void reset() throws DigiDocException {
        this.m_keyStore = null;
    }

    @Override
    public void closeSession() throws DigiDocException {
        this.reset();
    }

    @Override
    public byte[] decrypt(byte[] data, int token, String pin) throws DigiDocException {
        try {
            if (this.m_keyStore == null) {
                throw new DigiDocException(16, "Keystore not initialized", null);
            }
            String alias = this.getTokenName(token);
            if (alias == null) {
                throw new DigiDocException(60, "Invalid token nr: " + token, null);
            }
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("loading key: " + alias + " passwd-len: " + (pin != null ? pin.length() : 0)));
            }
            Key key = this.m_keyStore.getKey(alias, pin.toCharArray());
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Key: " + (key != null ? "OK, algorithm: " + key.getAlgorithm() : "NULL")));
            }
            if (key == null) {
                throw new DigiDocException(60, "Invalid password for token: " + alias, null);
            }
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, key);
            byte[] decdata = cipher.doFinal(data);
            if (m_logger.isDebugEnabled()) {
                m_logger.debug((Object)("Decrypted len: " + (decdata != null ? decdata.length : 0)));
            }
            return decdata;
        }
        catch (Exception ex) {
            m_logger.error((Object)("Error decrypting: " + ex));
            return null;
        }
    }

    @Override
    public String getType() {
        return "PKCS12";
    }
}

