/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.factory;

import ee.sk.digidoc.Base64Util;
import ee.sk.digidoc.CertID;
import ee.sk.digidoc.CertValue;
import ee.sk.digidoc.CompleteCertificateRefs;
import ee.sk.digidoc.CompleteRevocationRefs;
import ee.sk.digidoc.DataFile;
import ee.sk.digidoc.DataFileAttribute;
import ee.sk.digidoc.DataObjectFormat;
import ee.sk.digidoc.DigiDocException;
import ee.sk.digidoc.Identifier;
import ee.sk.digidoc.IncludeInfo;
import ee.sk.digidoc.KeyInfo;
import ee.sk.digidoc.ManifestFileEntry;
import ee.sk.digidoc.Notary;
import ee.sk.digidoc.ObjectIdentifier;
import ee.sk.digidoc.OcspRef;
import ee.sk.digidoc.Reference;
import ee.sk.digidoc.SigPolicyQualifier;
import ee.sk.digidoc.Signature;
import ee.sk.digidoc.SignaturePolicyId;
import ee.sk.digidoc.SignaturePolicyIdentifier;
import ee.sk.digidoc.SignatureProductionPlace;
import ee.sk.digidoc.SignatureValue;
import ee.sk.digidoc.SignedDataObjectProperties;
import ee.sk.digidoc.SignedDoc;
import ee.sk.digidoc.SignedInfo;
import ee.sk.digidoc.SignedProperties;
import ee.sk.digidoc.SpUri;
import ee.sk.digidoc.TimestampInfo;
import ee.sk.digidoc.UnsignedProperties;
import ee.sk.digidoc.XmlElemInfo;
import ee.sk.digidoc.factory.BdocManifestParser;
import ee.sk.digidoc.factory.BouncyCastleTimestampFactory;
import ee.sk.digidoc.factory.CanonicalizationFactory;
import ee.sk.digidoc.factory.DigiDocFactory;
import ee.sk.digidoc.factory.DigiDocStructureValidator;
import ee.sk.digidoc.factory.DigiDocVerifyFactory;
import ee.sk.digidoc.factory.NotaryFactory;
import ee.sk.digidoc.factory.SAXDigiDocException;
import ee.sk.digidoc.factory.SignatureInputStream;
import ee.sk.utils.ConfigManager;
import ee.sk.utils.ConvertUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXDigiDocFactory
extends DefaultHandler
implements DigiDocFactory {
    private Stack m_tags = new Stack();
    private SignedDoc m_doc = null;
    private Signature m_sig = null;
    private String m_strSigValTs;
    private String m_strSigAndRefsTs;
    private StringBuffer m_sbCollectChars;
    private StringBuffer m_sbCollectItem = null;
    private StringBuffer m_sbCollectSignature = null;
    private boolean m_bCollectDigest = false;
    private String m_xmlnsAttr = null;
    private int m_nCollectMode;
    private long nMaxBdocFilCached;
    private Logger m_logger = Logger.getLogger(SAXDigiDocFactory.class);
    private MessageDigest m_digest = null;
    private MessageDigest m_altDigest = null;
    private FileOutputStream m_dfCacheOutStream = null;
    private String m_tempDir = null;
    private String m_fileName;
    private String m_sigComment;
    private String m_nsDsPref;
    private String m_nsXadesPref;
    private String m_nsAsicPref = null;
    private List m_errs = null;
    private XmlElemInfo m_elemRoot = null;
    private XmlElemInfo m_elemCurrent = null;
    public static final String FILE_MIMETYPE = "mimetype";
    public static final String FILE_MANIFEST = "META-INF/manifest.xml";
    public static final String CONTENTS_MIMETYPE = "application/vnd.bdoc";
    public static final String CONTENTS_MIMETYPE_1_0 = "application/vnd.bdoc-1.0";
    public static final String MIME_SIGNATURE_BDOC = "signature/bdoc";
    public static final String FILE_SIGNATURES = "META-INF/signature";
    private static final String xmlnsEtsi = "http://uri.etsi.org/01903/v1.3.2#";
    private static final String xmlnsDs = "http://www.w3.org/2000/09/xmldsig#";
    private static final String xmlnsAsic = "http://uri.etsi.org/02918/v1.2.1#";

    public SAXDigiDocFactory() {
        this.nMaxBdocFilCached = ConfigManager.instance().getLongProperty("DIGIDOC_MAX_DATAFILE_CACHED", Long.MAX_VALUE);
    }

    private void updateDigest(byte[] data) {
        try {
            if (this.m_digest == null) {
                this.m_digest = MessageDigest.getInstance("SHA-1");
            }
            this.m_digest.update(data);
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error calculating digest: " + ex));
        }
    }

    private void updateAltDigest(byte[] data) {
        try {
            if (this.m_altDigest == null) {
                this.m_altDigest = MessageDigest.getInstance("SHA-1");
            }
            this.m_altDigest.update(data);
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error calculating digest: " + ex));
        }
    }

    @Override
    public void setTempDir(String s) {
        this.m_tempDir = s;
    }

    private byte[] getDigest() {
        byte[] digest = null;
        try {
            digest = this.m_digest.digest();
            this.m_digest = null;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error calculating digest: " + ex));
        }
        return digest;
    }

    private byte[] getAltDigest() {
        byte[] digest = null;
        try {
            digest = this.m_altDigest.digest();
            this.m_altDigest = null;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error calculating digest: " + ex));
        }
        return digest;
    }

    @Override
    public void init() throws DigiDocException {
    }

    @Override
    public boolean isBdocExtension(String fname) {
        return fname.endsWith(".bdoc") || fname.endsWith(".asice") || fname.endsWith(".sce");
    }

    private boolean isBdocFile(InputStream is) throws DigiDocException {
        try {
            if (is.markSupported()) {
                is.mark(10);
            }
            byte[] tdata = new byte[10];
            int n = is.read(tdata);
            if (is.markSupported()) {
                is.reset();
            }
            if (n >= 2 && tdata[0] == 80 && tdata[1] == 75) {
                return true;
            }
            if (n >= 5 && tdata[0] == 60 && tdata[1] == 63 && tdata[2] == 120 && tdata[3] == 109 && tdata[4] == 108) {
                return false;
            }
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error determining file type: " + ex));
        }
        return false;
    }

    private boolean checkBdocMimetype(InputStream zis) throws DigiDocException {
        try {
            byte[] data = new byte[100];
            int nRead = zis.read(data);
            if (nRead >= CONTENTS_MIMETYPE.length()) {
                String s2 = new String(data, 0, nRead);
                String s = null;
                for (int i = 0; i < nRead; ++i) {
                    if (s2.charAt(i) != 'a') continue;
                    s = s2.substring(i);
                    break;
                }
                if (s == null) {
                    s = new String(data);
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("MimeType: '" + s + "'" + " len: " + s.length()));
                }
                if (s.trim().equals(CONTENTS_MIMETYPE_1_0)) {
                    this.m_doc.setVersion("1.0");
                    this.m_doc.setFormat("BDOC");
                    throw new DigiDocException(13, "Format BDOC supports only version 2.1", null);
                }
                if (s.trim().equals("application/vnd.bdoc-1.1")) {
                    this.m_doc.setVersion("1.1");
                    this.m_doc.setFormat("BDOC");
                    throw new DigiDocException(13, "Format BDOC supports only version 2.1", null);
                }
                if (s.trim().equals("application/vnd.etsi.asic-e+zip")) {
                    this.m_doc.setVersion("2.1");
                    this.m_doc.setFormat("BDOC");
                    this.m_doc.setProfile("TM");
                    return true;
                }
                if (s.trim().startsWith(CONTENTS_MIMETYPE)) {
                    throw new DigiDocException(13, "Invalid BDOC version!", null);
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Invalid MimeType: '" + s + "'" + " len: " + s.length() + " expecting: " + CONTENTS_MIMETYPE.length()));
                }
                throw new DigiDocException(12, "Not a BDOC format file!", null);
            }
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"Invalid empty MimeType");
            }
            throw new DigiDocException(12, "Not a BDOC format file! MimeType file is empty!", null);
        }
        catch (DigiDocException ex) {
            this.m_logger.error((Object)("Mimetype err: " + ex));
            throw ex;
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error reading mimetype file: " + ex));
            return false;
        }
    }

    private void handleError(Exception err) throws DigiDocException {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Handle err: " + err + " list: " + (this.m_errs != null)));
        }
        err.printStackTrace();
        DigiDocException err1 = null;
        if (err instanceof SAXDigiDocException) {
            err1 = ((SAXDigiDocException)err).getDigiDocException();
        } else if (err instanceof DigiDocException) {
            err1 = (DigiDocException)err;
            err1.printStackTrace();
            if (err1.getNestedException() != null) {
                err1.getNestedException().printStackTrace();
            }
        } else {
            err1 = new DigiDocException(75, "Invalid xml file!", err);
        }
        if (this.m_errs == null) {
            throw err1;
        }
        this.m_errs.add(err1);
    }

    private void handleSAXError(Exception err) throws SAXDigiDocException {
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Handle sa err: " + err + " list: " + (this.m_errs != null)));
            this.m_logger.debug((Object)("Trace: " + ConvertUtils.getTrace(err)));
        }
        DigiDocException err1 = null;
        SAXDigiDocException err2 = null;
        if (err instanceof SAXDigiDocException) {
            err1 = ((SAXDigiDocException)err).getDigiDocException();
            err2 = (SAXDigiDocException)err;
        } else if (err instanceof DigiDocException) {
            err1 = (DigiDocException)err;
            err2 = new SAXDigiDocException(err.getMessage());
            err2.setNestedException(err);
        } else {
            err1 = new DigiDocException(0, err.getMessage(), null);
            err2 = new SAXDigiDocException(err.getMessage());
            err2.setNestedException(err);
        }
        if (this.m_errs == null) {
            throw err2;
        }
        this.m_errs.add(err1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SignedDoc readSignedDocOfType(String fname, InputStream isSdoc, boolean isBdoc, List errs) throws DigiDocException {
        boolean bErrList;
        block75: {
            int nFil;
            boolean bManifest1;
            boolean bHasMimetype;
            ArrayList<String> lDataFnames;
            ArrayList<String> lSigFnames;
            Enumeration eFiles;
            File fTmp;
            InputStream isEntry;
            ZipArchiveEntry ze;
            ZipArchiveInputStream zis;
            ZipFile zf;
            SAXParserFactory factory;
            block74: {
                File inFile;
                SAXDigiDocFactory handler = this;
                this.m_errs = errs;
                DigiDocVerifyFactory.initProvider();
                factory = SAXParserFactory.newInstance();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Start reading ddoc/bdoc " + (fname != null ? "from file: " + fname : "from stream") + " bdoc: " + isBdoc));
                }
                if (fname == null && isSdoc == null) {
                    throw new DigiDocException(10, "No input file", null);
                }
                if (!(fname == null || (inFile = new File(fname)).canRead() && inFile.length() != 0L)) {
                    throw new DigiDocException(10, "Empty or unreadable input file", null);
                }
                zf = null;
                zis = null;
                ze = null;
                isEntry = null;
                fTmp = null;
                try {
                    factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    if (isBdoc) {
                        this.m_doc = new SignedDoc();
                        this.m_doc.setVersion("1.0");
                        this.m_doc.setFormat("BDOC");
                        eFiles = null;
                        if (fname != null) {
                            zf = new ZipFile(fname, "UTF-8");
                            eFiles = zf.getEntries();
                        } else if (isSdoc != null) {
                            zis = new ZipArchiveInputStream(isSdoc, "UTF-8", true, true);
                        }
                        lSigFnames = new ArrayList<String>();
                        lDataFnames = new ArrayList<String>();
                        bHasMimetype = false;
                        bManifest1 = false;
                        nFil = 0;
                        break block74;
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Reading ddoc: " + fname + " file: " + this.m_fileName));
                    }
                    this.m_fileName = fname;
                    SAXParser saxParser = factory.newSAXParser();
                    if (fname != null) {
                        saxParser.parse((InputStream)new SignatureInputStream(new FileInputStream(fname)), (DefaultHandler)this);
                        break block75;
                    }
                    if (isSdoc == null) break block75;
                    saxParser.parse(isSdoc, (DefaultHandler)this);
                    break block75;
                }
                catch (SAXParseException ex) {
                    this.m_logger.error((Object)("SAX Error: " + ex));
                    this.handleError(ex);
                    break block75;
                }
                catch (Exception ex) {
                    this.m_logger.error((Object)("Error reading3: " + ex));
                    ex.printStackTrace();
                    this.handleError(ex);
                    break block75;
                }
                finally {
                    try {
                        if (isEntry != null) {
                            isEntry.close();
                            isEntry = null;
                        }
                        if (zis != null) {
                            zis.close();
                        }
                        if (zf != null) {
                            zf.close();
                        }
                        if (fTmp != null) {
                            fTmp.delete();
                            fTmp = null;
                        }
                    }
                    catch (Exception ex) {
                        this.m_logger.error((Object)("Error closing streams and files: " + ex));
                    }
                }
            }
            while (zf != null && eFiles.hasMoreElements() || zis != null && (ze = zis.getNextZipEntry()) != null) {
                block76: {
                    byte[] data;
                    ByteArrayOutputStream bos;
                    ++nFil;
                    if (zf != null) {
                        ze = (ZipArchiveEntry)eFiles.nextElement();
                        isEntry = zf.getInputStream(ze);
                    } else {
                        int n = 0;
                        int nTot = 0;
                        if (ze.getName().equals(FILE_MIMETYPE) || ze.getName().equals(FILE_MANIFEST) || ze.getName().startsWith(FILE_SIGNATURES) && ze.getName().endsWith(".xml") || this.nMaxBdocFilCached <= 0L || ze.getSize() < this.nMaxBdocFilCached && ze.getSize() >= 0L) {
                            bos = new ByteArrayOutputStream();
                            byte[] data2 = new byte[2048];
                            while ((n = zis.read(data2)) > 0) {
                                bos.write(data2, 0, n);
                                nTot += n;
                            }
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Read: " + nTot + " bytes from zip"));
                            }
                            data2 = bos.toByteArray();
                            bos = null;
                            isEntry = new ByteArrayInputStream(data2);
                        } else {
                            File fCacheDir = new File(ConfigManager.instance().getStringProperty("DIGIDOC_DF_CACHE_DIR", System.getProperty("java.io.tmpdir")));
                            fTmp = File.createTempFile("bdoc-data", ".tmp", fCacheDir);
                            FileOutputStream fos = new FileOutputStream(fTmp);
                            data = new byte[2048];
                            while ((n = zis.read(data)) > 0) {
                                fos.write(data, 0, n);
                                nTot += n;
                            }
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Read: " + nTot + " bytes from zip to: " + fTmp.getAbsolutePath()));
                            }
                            fos.close();
                            isEntry = new FileInputStream(fTmp);
                        }
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Entry: " + ze.getName() + " nlen: " + ze.getName().length() + " size: " + ze.getSize() + " dir: " + ze.isDirectory() + " comp-size: " + ze.getCompressedSize()));
                    }
                    if (ze.getName().equals(FILE_MIMETYPE)) {
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)"Check mimetype!");
                        }
                        this.checkBdocMimetype(isEntry);
                        bHasMimetype = true;
                        this.m_doc.setComment(ze.getComment());
                        if (nFil != 1) {
                            this.m_logger.error((Object)("mimetype file is " + nFil + " file but must be first"));
                            this.handleError(new DigiDocException(12, "mimetype file is not first zip entry", null));
                        }
                    } else {
                        String s1;
                        int j;
                        boolean bExists;
                        if (ze.getName().equals(FILE_MANIFEST)) {
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)"Read manifest");
                            }
                            if (!bManifest1 && isEntry != null) {
                                bManifest1 = true;
                                BdocManifestParser mfparser = new BdocManifestParser(this.m_doc);
                                mfparser.readManifest(isEntry);
                                break block76;
                            } else {
                                this.m_logger.error((Object)"Found multiple manifest.xml files!");
                                throw new DigiDocException(182, "Found multiple manifest.xml files!", null);
                            }
                        }
                        if (ze.getName().startsWith(FILE_SIGNATURES) && ze.getName().endsWith(".xml")) {
                            this.m_fileName = ze.getName();
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Reading bdoc siganture: " + this.m_fileName));
                            }
                            bExists = false;
                            for (j = 0; j < lSigFnames.size(); ++j) {
                                s1 = (String)lSigFnames.get(j);
                                if (!s1.equals(this.m_fileName)) continue;
                                bExists = true;
                            }
                            if (bExists) {
                                this.m_logger.error((Object)("Duplicate signature filename: " + this.m_fileName));
                                this.handleError(new DigiDocException(12, "Duplicate signature filename: " + this.m_fileName, null));
                            } else {
                                lSigFnames.add(this.m_fileName);
                            }
                            SAXParser saxParser = factory.newSAXParser();
                            bos = new ByteArrayOutputStream();
                            int n = 0;
                            data = new byte[2048];
                            while ((n = isEntry.read(data)) > 0) {
                                bos.write(data, 0, n);
                            }
                            data = bos.toByteArray();
                            bos = null;
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Parsing bdoc: " + this.m_fileName + " size: " + (data != null ? data.length : 0)));
                            }
                            saxParser.parse((InputStream)new SignatureInputStream(new ByteArrayInputStream(data)), (DefaultHandler)this);
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Parsed bdoc: " + this.m_fileName));
                            }
                            Signature sig1 = this.m_doc.getLastSignature();
                            this.m_sigComment = ze.getComment();
                            if (sig1 != null) {
                                sig1.setPath(this.m_fileName);
                                sig1.setComment(ze.getComment());
                            }
                        } else {
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Read data file: " + ze.getName()));
                            }
                            if (!ze.isDirectory()) {
                                DataObjectFormat dof;
                                Reference dRef;
                                bExists = false;
                                for (j = 0; j < lDataFnames.size(); ++j) {
                                    s1 = (String)lDataFnames.get(j);
                                    if (!s1.equals(ze.getName())) continue;
                                    bExists = true;
                                }
                                if (bExists) {
                                    this.m_logger.error((Object)("Duplicate datafile filename: " + ze.getName()));
                                    this.handleError(new DigiDocException(12, "Duplicate datafile filename: " + ze.getName(), null));
                                } else {
                                    lDataFnames.add(ze.getName());
                                }
                                DataFile df = this.m_doc.findDataFileById(ze.getName());
                                if (df != null) {
                                    if (ze.getSize() > 0L) {
                                        df.setSize(ze.getSize());
                                    }
                                    df.setContentType("BINARY");
                                    df.setFileName(ze.getName());
                                } else {
                                    df = new DataFile(ze.getName(), "BINARY", ze.getName(), "application/binary", this.m_doc);
                                    if (this.m_doc.getDataFiles() == null) {
                                        this.m_doc.setDataFiles(new ArrayList());
                                    }
                                    this.m_doc.getDataFiles().add(df);
                                }
                                if (isEntry != null) {
                                    df.setOrCacheBodyAndCalcHashes(isEntry);
                                }
                                df.setComment(ze.getComment());
                                df.setLastModDt(new Date(ze.getTime()));
                                Signature sig1 = this.m_doc.getLastSignature();
                                if (sig1 != null && (dRef = sig1.getSignedInfo().getReferenceForDataFile(df)) != null && (dof = sig1.getSignedInfo().getDataObjectFormatForReference(dRef)) != null) {
                                    df.setMimeType(dof.getMimeType());
                                }
                            }
                        }
                    }
                }
                if (fTmp == null) continue;
                fTmp.delete();
                fTmp = null;
            }
            if (!bHasMimetype) {
                this.m_logger.error((Object)"No mimetype file");
                this.handleError(new DigiDocException(12, "Not a BDOC format file! No mimetype file!", null));
            }
            if (this.m_doc.countSignatures() == 0) {
                for (int i = 0; i < this.m_doc.countDataFiles(); ++i) {
                    DataFile df = this.m_doc.getDataFile(i);
                    if (this.m_doc.getManifest() == null) continue;
                    for (int j = 0; j < this.m_doc.getManifest().getNumFileEntries(); ++j) {
                        ManifestFileEntry mfe = this.m_doc.getManifest().getFileEntry(j);
                        if (mfe.getFullPath() == null || !mfe.getFullPath().equals(df.getFileName())) continue;
                        df.setMimeType(mfe.getMediaType());
                    }
                }
            }
        }
        boolean bl = bErrList = errs != null;
        if (errs == null) {
            errs = new ArrayList();
        }
        boolean bOk = DigiDocVerifyFactory.verifyManifestEntries(this.m_doc, errs);
        if (this.m_doc == null) {
            this.m_logger.error((Object)"Error reading4: doc == null");
            this.handleError(new DigiDocException(12, "This document is not in ddoc or bdoc format", null));
        }
        if (!bErrList && errs.size() > 0) {
            DigiDocException ex = (DigiDocException)errs.get(0);
            throw ex;
        }
        return this.m_doc;
    }

    @Override
    public SignedDoc readSignedDocOfType(String fname, boolean isBdoc) throws DigiDocException {
        return this.readSignedDocOfType(fname, null, isBdoc, null);
    }

    @Override
    public SignedDoc readSignedDocFromStreamOfType(InputStream is, boolean isBdoc) throws DigiDocException {
        return this.readSignedDocOfType(null, is, isBdoc, null);
    }

    @Override
    public SignedDoc readSignedDocOfType(String fname, boolean isBdoc, List lerr) throws DigiDocException {
        return this.readSignedDocOfType(fname, null, isBdoc, lerr);
    }

    @Override
    public SignedDoc readSignedDocFromStreamOfType(InputStream is, boolean isBdoc, List lerr) throws DigiDocException {
        return this.readSignedDocOfType(null, is, isBdoc, lerr);
    }

    @Override
    public SignedDoc readDigiDocFromStream(InputStream digiDocStream) throws DigiDocException {
        DigiDocVerifyFactory.initProvider();
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)"Start reading ddoc/bdoc");
        }
        try {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"Reading ddoc");
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(digiDocStream, (DefaultHandler)this);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc == null) {
            throw new DigiDocException(13, "This document is not in digidoc", null);
        }
        return this.m_doc;
    }

    @Override
    public SignedDoc readSignedDoc(String fileName) throws DigiDocException {
        try {
            FileInputStream fis = new FileInputStream(fileName);
            boolean bdoc = this.isBdocFile(fis);
            fis.close();
            SignedDoc sdoc = this.readSignedDocOfType(fileName, bdoc);
            File f = new File(fileName);
            this.m_fileName = fileName;
            sdoc.setFile(f.getName());
            String s = f.getAbsolutePath();
            int n = s.lastIndexOf(File.separator);
            if (n > 0) {
                s = s.substring(0, n);
                sdoc.setPath(s);
            }
            return sdoc;
        }
        catch (DigiDocException ex) {
            throw ex;
        }
        catch (FileNotFoundException ex) {
            throw new DigiDocException(10, "File not found: " + fileName, null);
        }
        catch (IOException ex) {
            throw new DigiDocException(10, "Error determning file type: " + fileName, null);
        }
    }

    @Override
    public Signature readSignature(InputStream digiSigStream) throws DigiDocException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(digiSigStream, (DefaultHandler)this);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_sig == null) {
            throw new DigiDocException(13, "This document is not in signature format", null);
        }
        return this.m_sig;
    }

    @Override
    public Signature readSignature(SignedDoc sdoc, InputStream sigStream) throws DigiDocException {
        this.m_doc = sdoc;
        this.m_nCollectMode = 0;
        try {
            if (sdoc != null && sdoc.getFormat() != null) {
                XmlElemInfo e = null;
                if ("BDOC".equals(sdoc.getFormat())) {
                    e = new XmlElemInfo("XAdESSignatures", null, null);
                } else if ("DIGIDOC-XML".equals(sdoc.getFormat())) {
                    e = new XmlElemInfo("SignedDoc", null, null);
                }
                if (e != null) {
                    this.m_elemRoot = this.m_elemCurrent = e;
                }
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(sigStream, (DefaultHandler)this);
        }
        catch (SAXDigiDocException ex) {
            throw ex.getDigiDocException();
        }
        catch (Exception ex) {
            DigiDocException.handleException(ex, 75);
        }
        if (this.m_doc.getLastSignature() == null) {
            throw new DigiDocException(13, "This document is not in Signature format", null);
        }
        return this.m_doc.getLastSignature();
    }

    private String canonicalizeXml(String xml) {
        try {
            CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
            byte[] tmp = canFac.canonicalize(xml.getBytes("UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            return new String(tmp, "UTF-8");
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Canonicalizing exception: " + ex));
            return null;
        }
    }

    public SignedDoc getSignedDoc() {
        return this.m_doc;
    }

    public Signature getLastSignature() {
        if (this.m_doc != null) {
            return this.m_doc.getLastSignature();
        }
        return this.m_sig;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_nCollectMode = 0;
        this.m_xmlnsAttr = null;
        this.m_dfCacheOutStream = null;
        this.m_nsDsPref = null;
        this.m_nsXadesPref = null;
        this.m_nsAsicPref = null;
    }

    private void findCertIDandCertValueTypes(Signature sig) {
        int i;
        if (this.m_logger.isDebugEnabled() && sig != null) {
            this.m_logger.debug((Object)("Sig: " + sig.getId() + " certids: " + sig.countCertIDs()));
        }
        for (i = 0; sig != null && i < sig.countCertIDs(); ++i) {
            CertValue cval;
            CertID cid = sig.getCertID(i);
            if (cid == null || cid.getType() != 0) continue;
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("CertId: " + cid.getId() + " type: " + cid.getType() + " nr: " + cid.getSerial()));
            }
            if ((cval = sig.findCertValueWithSerial(cid.getSerial())) == null) continue;
            String cn = null;
            try {
                cn = SignedDoc.getCommonName(cval.getCert().getSubjectDN().getName());
                if (this.m_logger.isDebugEnabled() && cid != null) {
                    this.m_logger.debug((Object)("CertId type: " + cid.getType() + " nr: " + cid.getSerial() + " cval: " + cval.getId() + " CN: " + cn));
                }
                if (ConvertUtils.isKnownOCSPCert(cn)) {
                    if (this.m_logger.isInfoEnabled()) {
                        this.m_logger.debug((Object)("Cert: " + cn + " is OCSP responders cert"));
                    }
                    cid.setType(2);
                    cval.setType(2);
                }
                if (!ConvertUtils.isKnownTSACert(cn)) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Cert: " + cn + " is TSA cert"));
                }
                cid.setType(3);
                cval.setType(3);
                if (!this.m_logger.isDebugEnabled()) continue;
                this.m_logger.debug((Object)("CertId: " + cid.getId() + " type: " + cid.getType() + " nr: " + cid.getSerial()));
                continue;
            }
            catch (DigiDocException ex) {
                this.m_logger.error((Object)("Error setting type on certid or certval: " + cn));
            }
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Sig: " + sig.getId() + " certvals: " + sig.countCertValues()));
        }
        for (i = 0; sig != null && i < sig.countCertValues(); ++i) {
            CertValue cval = sig.getCertValue(i);
            if (this.m_logger.isDebugEnabled() && cval != null) {
                this.m_logger.debug((Object)("CertValue: " + cval.getId() + " type: " + cval.getType()));
            }
            if (cval.getType() != 0) continue;
            String cn = null;
            try {
                cn = SignedDoc.getCommonName(cval.getCert().getSubjectDN().getName());
                if (ConvertUtils.isKnownOCSPCert(cn)) {
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Cert: " + cn + " is OCSP responders cert"));
                    }
                    cval.setType(2);
                }
                if (!ConvertUtils.isKnownTSACert(cn)) continue;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Cert: " + cn + " is TSA cert"));
                }
                cval.setType(3);
                continue;
            }
            catch (DigiDocException ex) {
                this.m_logger.error((Object)("Error setting type on certid or certval: " + cn));
            }
        }
    }

    private String findXmlElemContents(String str, String tag, String id) {
        String s1 = "<" + tag;
        String s2 = "</" + tag + ">";
        int nIdx1 = 0;
        int nIdx2 = 0;
        int nIdx3 = 0;
        int nIdx4 = 0;
        while ((nIdx1 = str.indexOf(s1, nIdx1)) > 0) {
            String sId;
            nIdx2 = str.indexOf(">", nIdx1);
            if (nIdx2 <= 0 || (nIdx3 = str.indexOf("Id", nIdx1)) <= 0 || nIdx3 >= nIdx2) continue;
            nIdx3 = str.indexOf("\"", nIdx3);
            nIdx4 = str.indexOf("\"", nIdx3 + 1);
            if (nIdx3 <= nIdx1 || nIdx3 >= nIdx2 || nIdx4 <= nIdx1 || nIdx4 >= nIdx2 || !(sId = str.substring(nIdx3 + 1, nIdx4)).equals(id) || (nIdx2 = str.indexOf(s2, nIdx2)) <= nIdx1) continue;
            String sEl = str.substring(nIdx1, nIdx2 += s2.length() + 1);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Elem: " + tag + " id: " + id + "\n---\n" + sEl + "\n---\n"));
            }
            return sEl;
        }
        return null;
    }

    @Override
    public void endDocument() throws SAXException {
    }

    private String findNsPrefForUri(Attributes attrs, String uri) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            String val = attrs.getValue(i);
            if (!val.equals(uri)) continue;
            int p = key.indexOf(58);
            if (p > 0) {
                return key.substring(p + 1);
            }
            return null;
        }
        return null;
    }

    private String findAttrValueByName(Attributes attrs, String aName) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String key = attrs.getQName(i);
            if (!key.equalsIgnoreCase(aName)) continue;
            return attrs.getValue(i);
        }
        return null;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) throws SAXDigiDocException {
        Serializable spi;
        OcspRef orf;
        CompleteRevocationRefs rrefs;
        SignedProperties sp;
        Reference ref;
        Signature sig;
        String Id;
        Signature sig2;
        DigiDocException exv;
        String tag;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("Start Element: " + qName + " lname: " + lName + " uri: " + namespaceURI));
        }
        if ((tag = qName).indexOf(58) != -1) {
            tag = qName.substring(qName.indexOf(58) + 1);
            if (this.m_nsDsPref == null) {
                this.m_nsDsPref = this.findNsPrefForUri(attrs, xmlnsDs);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Element: " + qName + " xmldsig pref: " + (this.m_nsDsPref != null ? this.m_nsDsPref : "NULL")));
                }
            }
            if (this.m_nsXadesPref == null) {
                this.m_nsXadesPref = this.findNsPrefForUri(attrs, xmlnsEtsi);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Element: " + qName + " xades pref: " + (this.m_nsXadesPref != null ? this.m_nsXadesPref : "NULL")));
                }
            }
            if (this.m_nsAsicPref == null) {
                this.m_nsAsicPref = this.findNsPrefForUri(attrs, xmlnsAsic);
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Element: " + qName + " asic pref: " + (this.m_nsAsicPref != null ? this.m_nsAsicPref : "NULL")));
                }
            }
        }
        XmlElemInfo e = new XmlElemInfo(tag, this.findAttrValueByName(attrs, "id"), tag.equals("XAdESSignatures") || tag.equals("SignedDoc") ? null : this.m_elemCurrent);
        if (this.m_elemCurrent != null && !tag.equals("XAdESSignatures") && !tag.equals("SignedDoc")) {
            this.m_elemCurrent.addChild(e);
        }
        this.m_elemCurrent = e;
        if (this.m_elemRoot == null || tag.equals("XAdESSignatures") || tag.equals("SignedDoc")) {
            this.m_elemRoot = e;
        }
        if ((exv = DigiDocStructureValidator.validateElementPath(this.m_elemCurrent)) != null) {
            this.handleSAXError(exv);
        }
        this.m_tags.push(tag);
        if (tag.equals("SigningTime") || tag.equals("IssuerSerial") || tag.equals("X509SerialNumber") || tag.equals("X509IssuerName") || tag.equals("ClaimedRole") || tag.equals("City") || tag.equals("StateOrProvince") || tag.equals("CountryName") || tag.equals("PostalCode") || tag.equals("SignatureValue") || tag.equals("DigestValue") || tag.equals("IssuerSerial") || tag.equals("ResponderID") && !this.m_doc.getFormat().equals("BDOC") || tag.equals("ByName") && this.m_doc.getFormat().equals("BDOC") || tag.equals("ByKey") && this.m_doc.getFormat().equals("BDOC") || tag.equals("X509SerialNumber") || tag.equals("ProducedAt") || tag.equals("EncapsulatedTimeStamp") || tag.equals("Identifier") || tag.equals("SPURI") || tag.equals("NonceAlgorithm") || tag.equals("MimeType") || tag.equals("EncapsulatedOCSPValue")) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Start collecting tag: " + tag));
            }
            this.m_sbCollectItem = new StringBuffer();
        }
        if (tag.equals("XAdESSignatures")) {
            try {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)"BDOC 2.0 - ASIC-E");
                }
                this.m_doc.setFormatAndVersion("BDOC", "2.1");
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509Certificate")) {
            sig2 = this.getLastSignature();
            CertValue cval = null;
            try {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Adding signers cert to: " + sig2.getId()));
                }
                cval = sig2.getOrCreateCertValueOfType(1);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            this.m_sbCollectItem = new StringBuffer();
        }
        if (tag.equals("EncapsulatedX509Certificate")) {
            sig2 = this.getLastSignature();
            String id = null;
            for (int i = 0; i < attrs.getLength(); ++i) {
                String key = attrs.getQName(i);
                if (!key.equalsIgnoreCase("Id")) continue;
                id = attrs.getValue(i);
            }
            CertValue cval = new CertValue();
            if (id != null) {
                cval.setId(id);
                try {
                    if (id.indexOf("RESPONDER_CERT") != -1 || id.indexOf("RESPONDER-CERT") != -1) {
                        cval.setType(2);
                    }
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (this.m_logger.isDebugEnabled() && cval != null) {
                this.m_logger.debug((Object)("Adding cval " + cval.getId() + " type: " + cval.getType() + " to: " + sig2.getId()));
            }
            sig2.addCertValue(cval);
            this.m_sbCollectItem = new StringBuffer();
        }
        boolean bDfDdoc13Bad = false;
        if (tag.equals("DataFile")) {
            String ContentType = null;
            String Filename = null;
            Id = null;
            String MimeType = null;
            String Size = null;
            String DigestType = null;
            String Codepage = null;
            byte[] DigestValue = null;
            this.m_digest = null;
            if (this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && this.m_doc.getVersion().equals("1.3")) {
                this.m_xmlnsAttr = SignedDoc.xmlns_digidoc13;
                bDfDdoc13Bad = true;
            } else {
                this.m_xmlnsAttr = null;
            }
            ArrayList<DataFileAttribute> dfAttrs = new ArrayList<DataFileAttribute>();
            for (int i = 0; i < attrs.getLength(); ++i) {
                String key = attrs.getQName(i);
                if (key.equals("ContentType")) {
                    ContentType = attrs.getValue(i);
                    continue;
                }
                if (key.equals("Filename")) {
                    Filename = attrs.getValue(i);
                    if (Filename.indexOf(47) == -1 && Filename.indexOf(92) == -1) continue;
                    DigiDocException ex = new DigiDocException(172, "Failed to parse DataFile name. Invalid file name!", null);
                    this.handleSAXError(ex);
                    continue;
                }
                if (key.equals("Id")) {
                    Id = attrs.getValue(i);
                    continue;
                }
                if (key.equals("MimeType")) {
                    MimeType = attrs.getValue(i);
                    continue;
                }
                if (key.equals("Size")) {
                    Size = attrs.getValue(i);
                    continue;
                }
                if (key.equals("DigestType")) {
                    DigestType = attrs.getValue(i);
                    continue;
                }
                if (key.equals("Codepage")) {
                    Codepage = attrs.getValue(i);
                    continue;
                }
                if (key.equals("DigestValue")) {
                    DigestValue = Base64Util.decode(attrs.getValue(i));
                    continue;
                }
                try {
                    if (!key.equals("xmlns")) {
                        DataFileAttribute attr = new DataFileAttribute(key, attrs.getValue(i));
                        dfAttrs.add(attr);
                        continue;
                    }
                    bDfDdoc13Bad = false;
                    continue;
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (this.m_nCollectMode == 0) {
                try {
                    DataFile df = new DataFile(Id, ContentType, Filename, MimeType, this.m_doc);
                    this.m_dfCacheOutStream = null;
                    if (Size != null) {
                        df.setSize(Long.parseLong(Size));
                    }
                    if (DigestValue != null) {
                        if (this.m_doc.getFormat().equals("SK-XML")) {
                            df.setAltDigest(DigestValue);
                        } else if (ContentType != null && ContentType.equals("HASHCODE")) {
                            df.setDigestValue(DigestValue);
                        }
                    }
                    if (Codepage != null) {
                        df.setInitialCodepage(Codepage);
                    }
                    for (int i = 0; i < dfAttrs.size(); ++i) {
                        df.addAttribute((DataFileAttribute)dfAttrs.get(i));
                    }
                    if (this.m_tempDir != null) {
                        File fCache = new File(this.m_tempDir + File.separator + df.getFileName());
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Parser temp DF: " + Id + " size: " + df.getSize() + " cache-file: " + fCache.getAbsolutePath()));
                        }
                        this.m_dfCacheOutStream = new FileOutputStream(fCache);
                        df.setCacheFile(fCache);
                    } else if (df.schouldUseTempFile()) {
                        File fCache = df.createCacheFile();
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Df-temp DF: " + Id + " size: " + df.getSize() + " cache-file: " + fCache.getAbsolutePath()));
                        }
                        df.setCacheFile(fCache);
                        this.m_dfCacheOutStream = new FileOutputStream(fCache);
                    }
                    this.m_doc.addDataFile(df);
                }
                catch (IOException ex) {
                    this.handleSAXError(ex);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            ++this.m_nCollectMode;
            try {
                if (Size != null) {
                    int nSize = Integer.parseInt(Size);
                    if (!ContentType.equals("HASHCODE")) {
                        if (ContentType.equals("EMBEDDED_BASE64")) {
                            nSize *= 2;
                            this.m_bCollectDigest = true;
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)"Start collecting digest");
                            }
                        }
                        if (this.m_doc.getFormat().equals("SK-XML")) {
                            this.m_bCollectDigest = false;
                        }
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Allocating buf: " + nSize + " Element: " + qName + " lname: " + lName + " uri: " + namespaceURI));
                        }
                        if (this.m_dfCacheOutStream == null) {
                            this.m_sbCollectChars = new StringBuffer(nSize);
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.m_logger.error((Object)("Error: " + ex));
            }
        }
        if (tag.equals("SignedInfo")) {
            if (this.m_nCollectMode == 0) {
                try {
                    this.m_xmlnsAttr = this.m_doc != null && (this.m_doc.getVersion().equals("1.3") || this.m_doc.getFormat().equals("BDOC") || this.m_doc.getFormat().equals("SK-XML")) ? null : SignedDoc.xmlns_xmldsig;
                    Signature sig3 = this.getLastSignature();
                    SignedInfo si = new SignedInfo(sig3);
                    if (sig3 != null) {
                        sig3.setSignedInfo(si);
                        Id = attrs.getValue("Id");
                        if (Id != null) {
                            si.setId(Id);
                        }
                    }
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(1024);
        }
        if (tag.equals("SignedProperties")) {
            String Id2 = attrs.getValue("Id");
            String Target = attrs.getValue("Target");
            if (this.m_nCollectMode == 0) {
                try {
                    this.m_xmlnsAttr = this.m_doc != null && (this.m_doc.getVersion().equals("1.3") || this.m_doc.getFormat().equals("BDOC")) ? null : SignedDoc.xmlns_xmldsig;
                    Signature sig4 = this.getLastSignature();
                    SignedProperties sp2 = new SignedProperties(sig4);
                    sp2.setId(Id2);
                    if (Target != null) {
                        sp2.setTarget(Target);
                    }
                    sig4.setSignedProperties(sp2);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(2048);
        }
        if (tag.equals("XAdESSignatures") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"Start collecting <XAdESSignatures>");
            }
            this.m_sbCollectSignature = new StringBuffer();
        }
        if (tag.equals("Signature") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"Start collecting <Signature>");
            }
            if (this.m_doc == null) {
                DigiDocException ex = new DigiDocException(75, "Invalid signature format. Missing signed container root element.", null);
                this.handleSAXError(ex);
                SAXDigiDocException sex1 = new SAXDigiDocException("Invalid signature format. Missing signed container root element.");
                throw sex1;
            }
            String str1 = attrs.getValue("Id");
            sig = null;
            if (this.m_doc != null && !this.m_doc.getFormat().equals("BDOC")) {
                sig = this.m_doc.findSignatureById(str1);
            }
            if (this.m_doc != null && this.m_doc.getFormat().equals("BDOC") && this.m_doc.getVersion().equals("2.1")) {
                this.m_doc.addSignatureProfile(str1, "TM");
                if (this.m_doc.getProfile() == null || !this.m_doc.getProfile().equals("TM")) {
                    this.m_doc.setProfile("TM");
                }
            }
            if (sig == null || sig.getId() != null && !sig.getId().equals(str1)) {
                String sProfile;
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Create signature: " + str1));
                }
                if (this.m_doc != null) {
                    sig = new Signature(this.m_doc);
                    try {
                        sig.setId(str1);
                    }
                    catch (DigiDocException ex) {
                        this.handleSAXError(ex);
                    }
                    sig.setPath(this.m_fileName);
                    sig.setComment(this.m_sigComment);
                    sProfile = this.m_doc.findSignatureProfile(this.m_fileName);
                    if (sProfile == null) {
                        sProfile = this.m_doc.findSignatureProfile(sig.getId());
                    }
                    if (sProfile != null) {
                        sig.setProfile(sProfile);
                    }
                    this.m_doc.addSignature(sig);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Sig1: " + this.m_fileName + " profile: " + sProfile + " doc: " + (this.m_doc != null ? "OK" : "NULL")));
                    }
                } else {
                    this.m_sig = new Signature(null);
                    this.m_sig.setPath(this.m_fileName);
                    this.m_sig.setComment(this.m_sigComment);
                    sProfile = null;
                    if (this.m_doc != null && this.m_fileName != null) {
                        sProfile = this.m_doc.findSignatureProfile(this.m_fileName);
                    }
                    if (sProfile != null) {
                        this.m_sig.setProfile(sProfile);
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Sig2: " + this.m_fileName + " profile: " + sProfile));
                    }
                    sig = this.m_sig;
                }
                for (int j = 0; this.m_doc != null && j < this.m_doc.countSignatures(); ++j) {
                    Signature sig22 = this.m_doc.getSignature(j);
                    if (sig22 == null || sig == null || !this.m_doc.getFormat().equals("BDOC") || sig22.getId() == null || sig.getId() == null || sig22.getId().equals(sig.getId()) || sig22.getPath() == null || sig.getPath() == null || !sig22.getPath().equals(sig.getPath())) continue;
                    this.m_logger.error((Object)("Signatures: " + sig.getId() + " and " + sig22.getId() + " are in same file: " + sig.getPath()));
                    DigiDocException ex = new DigiDocException(75, "More than one signature in signatures.xml file is unsupported", null);
                    this.handleSAXError(ex);
                }
            }
            if (this.m_sbCollectSignature == null) {
                this.m_sbCollectSignature = new StringBuffer();
            }
        }
        if (tag.equals("SignatureValue") && this.m_nCollectMode == 0) {
            this.m_strSigValTs = null;
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(1024);
        }
        if (tag.equals("SignatureTimeStamp") && this.m_nCollectMode == 0) {
            if (this.m_sig != null) {
                this.m_sig.setProfile("TS");
            }
            this.m_doc.setProfile("TS");
            this.m_strSigAndRefsTs = null;
            ++this.m_nCollectMode;
            this.m_sbCollectChars = new StringBuffer(2048);
        }
        if (this.m_sbCollectSignature != null) {
            this.m_sbCollectSignature.append("<");
            this.m_sbCollectSignature.append(qName);
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.m_sbCollectSignature.append(" ");
                this.m_sbCollectSignature.append(attrs.getQName(i));
                this.m_sbCollectSignature.append("=\"");
                String s = attrs.getValue(i);
                s = s.replaceAll("&", "&amp;");
                this.m_sbCollectSignature.append(s);
                this.m_sbCollectSignature.append("\"");
            }
            this.m_sbCollectSignature.append(">");
        }
        if (this.m_nCollectMode > 0 || this.m_sbCollectChars != null) {
            StringBuffer sb = new StringBuffer();
            String sDfTagBad = null;
            sb.append("<");
            sb.append(qName);
            for (int i = 0; i < attrs.getLength(); ++i) {
                if (attrs.getQName(i).equals("xmlns")) {
                    this.m_xmlnsAttr = null;
                    bDfDdoc13Bad = false;
                }
                sb.append(" ");
                sb.append(attrs.getQName(i));
                sb.append("=\"");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("Attr: " + attrs.getQName(i) + " ='" + attrs.getValue(i) + "'"));
                }
                if (!this.m_doc.getFormat().equals("SK-XML")) {
                    sb.append(ConvertUtils.escapeXmlSymbols(attrs.getValue(i)));
                } else {
                    String sv = attrs.getValue(i);
                    if (attrs.getQName(i).equals("DigestValue") && sv.endsWith(" ")) {
                        sv = sv.replaceAll(" ", "\n");
                    }
                    sb.append(sv);
                }
                sb.append("\"");
            }
            if (bDfDdoc13Bad) {
                sDfTagBad = sb.toString() + ">";
            }
            if (this.m_xmlnsAttr != null) {
                sb.append(" xmlns=\"" + this.m_xmlnsAttr + "\"");
                this.m_xmlnsAttr = null;
            }
            sb.append(">");
            if (tag.equals("DataFile") && this.m_nCollectMode == 1) {
                String strCan = null;
                if (!this.m_doc.getFormat().equals("SK-XML")) {
                    strCan = sb.toString() + "</DataFile>";
                    strCan = this.canonicalizeXml(strCan);
                    strCan = strCan.substring(0, strCan.length() - 11);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Canonicalized: '" + strCan + "'"));
                    }
                    if (sDfTagBad != null) {
                        strCan = sDfTagBad + "</DataFile>";
                        strCan = this.canonicalizeXml(strCan);
                        sDfTagBad = strCan.substring(0, strCan.length() - 11);
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("Canonicalized alternative: '" + sDfTagBad + "'"));
                        }
                    }
                    try {
                        this.updateDigest(ConvertUtils.str2data(strCan));
                        if (sDfTagBad != null) {
                            this.updateAltDigest(ConvertUtils.str2data(sDfTagBad));
                        }
                    }
                    catch (DigiDocException ex) {
                        this.handleSAXError(ex);
                    }
                }
            } else {
                if (this.m_sbCollectChars != null) {
                    this.m_sbCollectChars.append(sb.toString());
                }
                try {
                    if (this.m_dfCacheOutStream != null) {
                        this.m_dfCacheOutStream.write(ConvertUtils.str2data(sb.toString()));
                    }
                }
                catch (IOException ex) {
                    this.handleSAXError(ex);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
        }
        if (this.m_nCollectMode == 1) {
            DigiDocException ex;
            String sXmlns;
            if (tag.equals("CanonicalizationMethod")) {
                String Algorithm = attrs.getValue("Algorithm");
                try {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    si.setCanonicalizationMethod(Algorithm);
                }
                catch (DigiDocException ex2) {
                    this.handleSAXError(ex2);
                }
            }
            if (tag.equals("SignatureMethod")) {
                String Algorithm = attrs.getValue("Algorithm");
                try {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    si.setSignatureMethod(Algorithm);
                }
                catch (DigiDocException ex3) {
                    this.handleSAXError(ex3);
                }
            }
            if (tag.equals("Reference")) {
                String URI2 = attrs.getValue("URI");
                try {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    ref = new Reference(si);
                    String Id3 = attrs.getValue("Id");
                    if (Id3 != null) {
                        ref.setId(Id3);
                    }
                    ref.setUri(ConvertUtils.unescapeXmlSymbols(ConvertUtils.uriDecode(URI2)));
                    String sType = attrs.getValue("Type");
                    if (sType != null) {
                        ref.setType(sType);
                    }
                    si.addReference(ref);
                }
                catch (DigiDocException ex4) {
                    this.handleSAXError(ex4);
                }
            }
            if (tag.equals("X509SerialNumber") && this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && ((sXmlns = attrs.getValue("xmlns")) == null || !sXmlns.equals(SignedDoc.xmlns_xmldsig))) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("X509SerialNumber has none or invalid namespace: " + sXmlns));
                }
                ex = new DigiDocException(176, "X509SerialNumber has none or invalid namespace: " + sXmlns, null);
                this.handleSAXError(ex);
            }
            if (tag.equals("X509IssuerName") && this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && ((sXmlns = attrs.getValue("xmlns")) == null || !sXmlns.equals(SignedDoc.xmlns_xmldsig))) {
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("X509IssuerName has none or invalid namespace: " + sXmlns));
                }
                ex = new DigiDocException(176, "X509IssuerName has none or invalid namespace: " + sXmlns, null);
                this.handleSAXError(ex);
            }
            if (tag.equals("SignatureProductionPlace")) {
                try {
                    Signature sig5 = this.getLastSignature();
                    sp = sig5.getSignedProperties();
                    SignatureProductionPlace spp = new SignatureProductionPlace();
                    sp.setSignatureProductionPlace(spp);
                }
                catch (DigiDocException ex5) {
                    this.handleSAXError(ex5);
                }
            }
        }
        if (tag.equals("SignatureValue")) {
            String Id4 = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                SignatureValue spp = new SignatureValue(sig, Id4);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("OCSPRef")) {
            OcspRef orf2 = new OcspRef();
            sig = this.getLastSignature();
            UnsignedProperties usp = sig.getUnsignedProperties();
            rrefs = usp.getCompleteRevocationRefs();
            rrefs.addOcspRef(orf2);
        }
        if (tag.equals("DigestMethod")) {
            String Algorithm = attrs.getValue("Algorithm");
            try {
                if (this.m_tags.search("Reference") != -1) {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    ref = si.getLastReference();
                    ref.setDigestAlgorithm(Algorithm);
                } else if (this.m_tags.search("SigningCertificate") != -1) {
                    sig = this.getLastSignature();
                    CertID cid = sig.getOrCreateCertIdOfType(1);
                    cid.setDigestAlgorithm(Algorithm);
                } else if (this.m_tags.search("CompleteCertificateRefs") != -1) {
                    sig = this.getLastSignature();
                    CertID cid = sig.getLastCertId();
                    cid.setDigestAlgorithm(Algorithm);
                } else if (this.m_tags.search("CompleteRevocationRefs") != -1) {
                    sig = this.getLastSignature();
                    UnsignedProperties up = sig.getUnsignedProperties();
                    rrefs = up.getCompleteRevocationRefs();
                    orf = rrefs.getLastOcspRef();
                    if (orf != null) {
                        orf.setDigestAlgorithm(Algorithm);
                    }
                } else if (this.m_tags.search("SigPolicyHash") != -1) {
                    sig = this.getLastSignature();
                    SignedProperties sp3 = sig.getSignedProperties();
                    spi = sp3.getSignaturePolicyIdentifier();
                    SignaturePolicyId sppi = ((SignaturePolicyIdentifier)spi).getSignaturePolicyId();
                    sppi.setDigestAlgorithm(Algorithm);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Cert")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                if (this.m_tags.search("SigningCertificate") != -1) {
                    CertID cid = sig.getOrCreateCertIdOfType(1);
                    if (id != null) {
                        cid.setId(id);
                    }
                }
                if (this.m_tags.search("CompleteCertificateRefs") != -1) {
                    CertID cid = sig.getOrCreateCertIdOfType(2);
                    if (id != null) {
                        cid.setId(id);
                    }
                    sig.addCertID(cid);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("AllDataObjectsTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 1);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("IndividualDataObjectsTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 2);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 3);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SigAndRefsTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 4);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("RefsOnlyTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 5);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("ArchiveTimeStamp")) {
            String id = attrs.getValue("Id");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = new TimestampInfo(id, 6);
                sig.addTimestampInfo(ts);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Include")) {
            String uri = attrs.getValue("URI");
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = sig.getLastTimestampInfo();
                IncludeInfo inc = new IncludeInfo(uri);
                ts.addIncludeInfo(inc);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("CompleteCertificateRefs")) {
            String Target = attrs.getValue("Target");
            try {
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                CompleteCertificateRefs crefs = new CompleteCertificateRefs();
                up.setCompleteCertificateRefs(crefs);
                crefs.setUnsignedProperties(up);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("CompleteRevocationRefs")) {
            try {
                Signature sig6 = this.getLastSignature();
                UnsignedProperties up = sig6.getUnsignedProperties();
                CompleteRevocationRefs rrefs2 = new CompleteRevocationRefs();
                up.setCompleteRevocationRefs(rrefs2);
                rrefs2.setUnsignedProperties(up);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("OCSPIdentifier")) {
            String URI3 = attrs.getValue("URI");
            try {
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                rrefs = up.getCompleteRevocationRefs();
                orf = rrefs.getLastOcspRef();
                orf.setUri(URI3);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignaturePolicyIdentifier")) {
            try {
                Signature sig7 = this.getLastSignature();
                sp = sig7.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignaturePolicyId")) {
            try {
                Signature sig8 = this.getLastSignature();
                sp = sig8.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
                if ((spi = spid.getSignaturePolicyId()) == null) {
                    spi = new SignaturePolicyId(null);
                    spid.setSignaturePolicyId((SignaturePolicyId)spi);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Identifier")) {
            try {
                Signature sig9 = this.getLastSignature();
                sp = sig9.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
                if ((spi = spid.getSignaturePolicyId()) == null) {
                    spi = new SignaturePolicyId(null);
                    spid.setSignaturePolicyId((SignaturePolicyId)spi);
                }
                String sQualifier = attrs.getValue("Qualifier");
                Identifier id = new Identifier(sQualifier);
                ObjectIdentifier oi = ((SignaturePolicyId)spi).getSigPolicyId();
                if (oi == null) {
                    oi = new ObjectIdentifier(id);
                } else {
                    oi.setIdentifier(id);
                }
                ((SignaturePolicyId)spi).setSigPolicyId(oi);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SigPolicyQualifier")) {
            try {
                Signature sig10 = this.getLastSignature();
                sp = sig10.getSignedProperties();
                SignaturePolicyIdentifier spid = sp.getSignaturePolicyIdentifier();
                if (spid == null) {
                    spid = new SignaturePolicyIdentifier(null);
                    sp.setSignaturePolicyIdentifier(spid);
                }
                if ((spi = spid.getSignaturePolicyId()) == null) {
                    spi = new SignaturePolicyId(null);
                    spid.setSignaturePolicyId((SignaturePolicyId)spi);
                }
                SigPolicyQualifier spq = new SigPolicyQualifier();
                ((SignaturePolicyId)spi).addSigPolicyQualifier(spq);
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("DataObjectFormat")) {
            Signature sig11 = this.getLastSignature();
            try {
                if (sig11 != null && (sp = sig11.getSignedProperties()) != null) {
                    SignedDataObjectProperties sdps = sp.getSignedDataObjectProperties();
                    if (sdps == null) {
                        sdps = new SignedDataObjectProperties();
                        sp.setSignedDataObjectProperties(sdps);
                    }
                    String sObjectReference = attrs.getValue("ObjectReference");
                    DataObjectFormat dof = new DataObjectFormat(sObjectReference);
                    sdps.addDataObjectFormat(dof);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("NonceAlgorithm")) {
            // empty if block
        }
        if (this.m_nCollectMode == 0) {
            if (tag.equals("SignedDoc")) {
                String format = null;
                String version = null;
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String key = attrs.getQName(i);
                    if (key.equals("format")) {
                        format = attrs.getValue(i);
                    }
                    if (!key.equals("version")) continue;
                    version = attrs.getValue(i);
                }
                try {
                    this.m_doc = new SignedDoc();
                    this.m_doc.setFormat(format);
                    this.m_doc.setVersion(version);
                    if (format != null && (format.equals("SK-XML") || format.equals("DIGIDOC-XML"))) {
                        this.m_doc.setProfile("TM");
                    }
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("KeyInfo")) {
                try {
                    KeyInfo ki = new KeyInfo();
                    String Id5 = attrs.getValue("Id");
                    if (Id5 != null) {
                        ki.setId(Id5);
                    }
                    Signature sig12 = this.getLastSignature();
                    sig12.setKeyInfo(ki);
                    ki.setSignature(sig12);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("UnsignedProperties")) {
                String Target = attrs.getValue("Target");
                try {
                    sig = this.getLastSignature();
                    UnsignedProperties up = new UnsignedProperties(sig);
                    sig.setUnsignedProperties(up);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("EncapsulatedOCSPValue")) {
                String Id6 = attrs.getValue("Id");
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                Notary not = new Notary();
                if (Id6 != null) {
                    not.setId(Id6);
                }
                not.setId(Id6);
                up.addNotary(not);
                if (sig.getProfile() == null && (this.m_doc.getFormat().equals("DIGIDOC-XML") || this.m_doc.getFormat().equals("SK-XML"))) {
                    sig.setProfile("TM");
                }
            }
        }
    }

    private TreeSet collectNamespaces(String sCanInfo, TreeSet tsOtherAttr) {
        TreeSet<String> ts = new TreeSet<String>();
        int p1 = -1;
        int p2 = -1;
        p1 = sCanInfo.indexOf(62);
        if (p1 != -1) {
            String sHdr = sCanInfo.substring(0, p1);
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Header: " + sHdr));
            }
            String[] toks = sHdr.split(" ");
            for (int i = 0; toks != null && i < toks.length; ++i) {
                String tok = toks[i];
                if (tok == null || tok.trim().length() <= 0 || tok.charAt(0) == '<') continue;
                if (tok.indexOf("xmlns") != -1) {
                    ts.add(tok);
                    continue;
                }
                tsOtherAttr.add(tok);
            }
        }
        return ts;
    }

    private void addNamespaceIfMissing(TreeSet ts, String ns, String pref) {
        boolean bF = false;
        for (String s : ts) {
            if (s == null || s.indexOf(ns) == -1) continue;
            bF = true;
            break;
        }
        if (!bF) {
            StringBuffer sb = new StringBuffer("xmlns");
            if (pref != null) {
                sb.append(":");
                sb.append(pref);
            }
            sb.append("=\"");
            sb.append(ns);
            sb.append("\"");
            ts.add(sb.toString());
        }
    }

    private String getPrefOfNs(String ns) {
        if (ns.indexOf(xmlnsDs) != -1) {
            return this.m_nsDsPref;
        }
        if (ns.indexOf(xmlnsEtsi) != -1) {
            return this.m_nsXadesPref;
        }
        if (ns.indexOf(xmlnsAsic) != -1) {
            return this.m_nsAsicPref;
        }
        return null;
    }

    private byte[] addNamespaces(byte[] bCanInfo, boolean bDsNs, boolean bEtsiNs, String dsNsPref, String xadesNsPref, boolean bAsicNs, String asicPref) {
        byte[] bInfo = bCanInfo;
        try {
            String s;
            int p2;
            String s1 = new String(bCanInfo, "UTF-8");
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Input xml:\n------\n" + s1 + "\n------\n"));
            }
            TreeSet tsOtherAttr = new TreeSet();
            TreeSet tsNs = this.collectNamespaces(s1, tsOtherAttr);
            for (String s2 : tsNs) {
                this.m_logger.debug((Object)("Has ns: " + s2));
            }
            for (String s2 : tsOtherAttr) {
                this.m_logger.debug((Object)("Other attr: " + s2));
            }
            if (bDsNs) {
                this.addNamespaceIfMissing(tsNs, xmlnsDs, dsNsPref);
            }
            if (bEtsiNs) {
                this.addNamespaceIfMissing(tsNs, xmlnsEtsi, xadesNsPref);
            }
            if (bAsicNs) {
                this.addNamespaceIfMissing(tsNs, xmlnsAsic, asicPref);
            }
            for (String s2 : tsNs) {
                this.m_logger.debug((Object)("Now has ns: " + s2));
            }
            int p1 = s1.indexOf(32);
            if (p1 > (p2 = s1.indexOf(62))) {
                p1 = p2;
            }
            String sRest = s1.substring(p2);
            StringBuffer sb = new StringBuffer();
            sb.append(s1.substring(0, p1));
            Iterator iNs = tsNs.iterator();
            while (iNs.hasNext()) {
                sb.append(" ");
                s = (String)iNs.next();
                sb.append(s);
            }
            iNs = tsOtherAttr.iterator();
            while (iNs.hasNext()) {
                sb.append(" ");
                s = (String)iNs.next();
                sb.append(s);
            }
            sb.append(sRest);
            bInfo = sb.toString().getBytes("UTF-8");
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Modified xml:\n------\n" + sb.toString() + "\n------\n"));
            }
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error adding namespaces: " + ex));
        }
        return bInfo;
    }

    private byte[] addNamespaceOnChildElems(byte[] bCanInfo, String nsPref, String nsUri) {
        byte[] bInfo = bCanInfo;
        try {
            String s1 = new String(bCanInfo, "UTF-8");
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("AddChildNs: " + nsPref + "=" + nsUri + " Input xml:\n------\n" + s1 + "\n------\n"));
            }
            int p1 = s1.indexOf(62) + 1;
            int p2 = s1.lastIndexOf(60);
            String sRest = s1.substring(p2);
            StringBuffer sb = new StringBuffer();
            sb.append(s1.substring(0, p1));
            int p3 = p1;
            int p4 = 0;
            int p5 = 0;
            int p6 = 0;
            do {
                String pref;
                boolean bCopy = true;
                p4 = s1.indexOf(60, p3);
                if (p4 > p3 + 1) {
                    sb.append(s1.substring(p3, p4));
                }
                p3 = p4;
                p4 = s1.indexOf(62, p3) + 1;
                if (s1.charAt(p3) == '<' && s1.charAt(p3 + 1) != '/' && (p5 = s1.indexOf(58, p3)) > p3 && p5 < p4 && (pref = s1.substring(p3 + 1, p5)) != null && pref.equals(nsPref)) {
                    p6 = s1.indexOf(32, p5);
                    if (p6 > p4) {
                        p6 = p4 - 1;
                    }
                    sb.append(s1.substring(p3, p6));
                    sb.append(" xmlns:");
                    sb.append(nsPref);
                    sb.append("=\"");
                    sb.append(nsUri);
                    sb.append("\"");
                    bCopy = false;
                    sb.append(s1.substring(p6, p4));
                }
                if (bCopy) {
                    sb.append(s1.substring(p3, p4));
                }
                if (p4 <= 0 || p4 >= p2) continue;
                p3 = p4;
            } while (p4 > 0 && p4 < p2);
            sb.append(sRest);
            bInfo = sb.toString().getBytes("UTF-8");
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)("Modified xml:\n------\n" + sb.toString() + "\n------\n"));
            }
        }
        catch (Exception ex) {
            this.m_logger.error((Object)("Error adding namespaces: " + ex));
        }
        return bInfo;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        SignaturePolicyId spi;
        SignaturePolicyIdentifier spid;
        OcspRef orf;
        CompleteRevocationRefs rrefs;
        Signature sig;
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug((Object)("End Element: " + qName + " collect: " + this.m_nCollectMode));
        }
        String tag = qName;
        String nsPref = null;
        if (tag.indexOf(58) != -1) {
            tag = qName.substring(qName.indexOf(58) + 1);
            nsPref = qName.substring(0, qName.indexOf(58));
        }
        if (this.m_elemCurrent != null) {
            this.m_elemCurrent = this.m_elemCurrent.getParent();
        }
        String currTag = (String)this.m_tags.pop();
        StringBuffer sb = null;
        if (!(this.m_nCollectMode <= 0 || tag.equals("DataFile") && this.m_nCollectMode <= 1)) {
            sb = new StringBuffer();
            sb.append("</");
            sb.append(qName);
            sb.append(">");
        }
        if (this.m_sbCollectSignature != null) {
            this.m_sbCollectSignature.append("</");
            this.m_sbCollectSignature.append(qName);
            this.m_sbCollectSignature.append(">");
        }
        if (this.m_sbCollectChars != null && sb != null) {
            this.m_sbCollectChars.append(sb.toString());
        }
        if (tag.equals("DataFile")) {
            --this.m_nCollectMode;
            if (this.m_nCollectMode == 0) {
                try {
                    if (this.m_dfCacheOutStream != null) {
                        if (sb != null) {
                            this.m_dfCacheOutStream.write(ConvertUtils.str2data(sb.toString()));
                        }
                        this.m_dfCacheOutStream.close();
                        this.m_dfCacheOutStream = null;
                    }
                }
                catch (IOException ex) {
                    this.handleSAXError(ex);
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
                DataFile df = this.m_doc.getLastDataFile();
                if (df != null && df.getContentType().equals("EMBEDDED_BASE64")) {
                    try {
                        if (this.m_doc.getFormat().equals("SK-XML")) {
                            String sDf = null;
                            if (this.m_sbCollectChars != null) {
                                sDf = this.m_sbCollectChars.toString();
                                this.m_sbCollectChars = null;
                            } else if (df.getDfCacheFile() != null) {
                                byte[] data = null;
                                try {
                                    data = SignedDoc.readFile(df.getDfCacheFile());
                                    sDf = new String(data);
                                }
                                catch (Exception ex) {
                                    this.m_logger.error((Object)("Error reading cache file: " + df.getDfCacheFile() + " - " + ex));
                                }
                            }
                            if (sDf != null) {
                                byte[] bDf = Base64Util.decode(sDf);
                                this.updateDigest(bDf);
                            }
                            df.setDigest(this.getDigest());
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Digest: " + df.getId() + " - " + Base64Util.encode(df.getDigest()) + " size: " + df.getSize()));
                            }
                        } else {
                            long nSize = df.getSize();
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("DF: " + df.getId() + " cache-file: " + df.getDfCacheFile()));
                            }
                            if (df.getDfCacheFile() == null) {
                                byte[] b = Base64Util.decode(this.m_sbCollectChars.toString());
                                if (this.m_logger.isDebugEnabled()) {
                                    this.m_logger.debug((Object)("DF: " + df.getId() + " orig-size: " + nSize + " new size: " + b.length));
                                }
                                if (b != null && nSize == 0L) {
                                    nSize = b.length;
                                }
                                df.setBodyAsData(ConvertUtils.str2data(this.m_sbCollectChars.toString(), "UTF-8"), true, nSize);
                            }
                            this.updateDigest("</DataFile>".getBytes());
                            df.setDigest(this.getDigest());
                            if (this.m_logger.isDebugEnabled()) {
                                this.m_logger.debug((Object)("Digest: " + df.getId() + " - " + Base64Util.encode(df.getDigest()) + " size: " + df.getSize()));
                            }
                        }
                        if (this.m_altDigest != null) {
                            this.updateAltDigest(ConvertUtils.str2data("</DataFile>"));
                            df.setAltDigest(this.getAltDigest());
                        }
                        this.m_sbCollectChars = null;
                    }
                    catch (DigiDocException ex) {
                        this.handleSAXError(ex);
                    }
                }
                this.m_bCollectDigest = false;
            }
        }
        if (tag.equals("SignedInfo")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            try {
                sig = this.getLastSignature();
                SignedInfo si = sig.getSignedInfo();
                String sSigInf = this.m_sbCollectChars.toString();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SigInf:\n------\n" + sSigInf + "\n------\n"));
                }
                byte[] bCanSI = null;
                if (this.m_doc.getFormat().equals("SK-XML")) {
                    bCanSI = sSigInf.getBytes();
                } else {
                    CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                    bCanSI = si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#") ? canFac.canonicalize(ConvertUtils.str2data(sSigInf, "UTF-8"), "http://www.w3.org/2001/10/xml-exc-c14n#") : canFac.canonicalize(ConvertUtils.str2data(sSigInf, "UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                }
                si.setOrigDigest(SignedDoc.digestOfType(bCanSI, this.m_doc.getFormat().equals("BDOC") ? "SHA-256" : "SHA-1"));
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SigInf:\n------\n" + new String(bCanSI) + "\n------\nHASH: " + Base64Util.encode(si.getOrigDigest())));
                }
                if (this.m_doc.getFormat().equals("BDOC")) {
                    boolean bEtsiNs = false;
                    boolean bAsicNs = false;
                    if (this.m_nsXadesPref != null && this.m_nsXadesPref.length() > 0) {
                        bEtsiNs = true;
                    }
                    if (this.m_nsAsicPref != null && this.m_nsAsicPref.length() > 0) {
                        bAsicNs = true;
                    }
                    if (si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                        bAsicNs = false;
                    }
                    bCanSI = this.addNamespaces(bCanSI, true, bEtsiNs, this.m_nsDsPref, this.m_nsXadesPref, bAsicNs, this.m_nsAsicPref);
                    si.setOrigXml(bCanSI);
                    String sDigType = ConfigManager.sigMeth2Type(si.getSignatureMethod());
                    if (sDigType == null) {
                        throw new DigiDocException(24, "Invalid signature method: " + si.getSignatureMethod(), null);
                    }
                    si.setOrigDigest(SignedDoc.digestOfType(bCanSI, sDigType));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("\nHASH: " + Base64Util.encode(si.getOrigDigest())));
                    }
                }
                this.m_sbCollectChars = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignedProperties")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            try {
                sig = this.getLastSignature();
                SignedInfo si = sig.getSignedInfo();
                SignedProperties sp = sig.getSignedProperties();
                String sigProp = this.m_sbCollectChars.toString();
                byte[] bSigProp = ConvertUtils.str2data(sigProp, "UTF-8");
                byte[] bDig0 = SignedDoc.digestOfType(bSigProp, "SHA-1");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SigProp0:\n------\n" + sigProp + "\n------" + " len: " + sigProp.length() + " sha1 HASH0: " + Base64Util.encode(bDig0)));
                }
                CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                byte[] bCanProp = null;
                bCanProp = si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#") ? canFac.canonicalize(bSigProp, "http://www.w3.org/2001/10/xml-exc-c14n#") : canFac.canonicalize(bSigProp, "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SigProp can:\n------\n" + new String(bCanProp, "UTF-8") + "\n------" + " len: " + bCanProp.length));
                }
                if (this.m_doc.getFormat().equals("BDOC")) {
                    Reference spRef;
                    boolean bNeedDsNs = false;
                    String st1 = new String(bCanProp);
                    if (st1.indexOf("<ds:X509IssuerName>") != -1) {
                        bNeedDsNs = true;
                    }
                    boolean bEtsiNs = false;
                    boolean bAsicNs = false;
                    if (this.m_nsXadesPref != null && this.m_nsXadesPref.length() > 0) {
                        bEtsiNs = true;
                    }
                    if (this.m_nsAsicPref != null && this.m_nsAsicPref.length() > 0) {
                        bAsicNs = true;
                    }
                    if (si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                        bAsicNs = false;
                        bNeedDsNs = false;
                    }
                    bCanProp = this.addNamespaces(bCanProp, bNeedDsNs, bEtsiNs, this.m_nsDsPref, this.m_nsXadesPref, bAsicNs, this.m_nsAsicPref);
                    if (si.getCanonicalizationMethod().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                        bCanProp = this.addNamespaceOnChildElems(bCanProp, this.m_nsDsPref, xmlnsDs);
                    }
                    if ((spRef = sig.getSignedInfo().getReferenceForSignedProperties(sp)) != null) {
                        String sDigType = ConfigManager.digAlg2Type(spRef.getDigestAlgorithm());
                        if (sDigType != null) {
                            sp.setOrigDigest(SignedDoc.digestOfType(bCanProp, sDigType));
                        }
                        if (this.m_logger.isDebugEnabled()) {
                            this.m_logger.debug((Object)("\nHASH: " + Base64Util.encode(sp.getOrigDigest()) + " REF-HASH: " + Base64Util.encode(spRef.getDigestValue())));
                        }
                    }
                }
                this.m_sbCollectChars = null;
                CertID cid = sig.getCertIdOfType(1);
                if (cid != null) {
                    if (cid.getId() != null) {
                        sp.setCertId(cid.getId());
                    } else if (!sig.getSignedDoc().getVersion().equals("1.3") && !this.m_doc.getFormat().equals("BDOC")) {
                        sp.setCertId(sig.getId() + "-CERTINFO");
                    }
                    sp.setCertSerial(cid.getSerial());
                    sp.setCertDigestAlgorithm(cid.getDigestAlgorithm());
                    if (cid.getDigestValue() != null) {
                        sp.setCertDigestValue(cid.getDigestValue());
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("CID: " + cid.getId() + " ser: " + cid.getSerial() + " alg: " + cid.getDigestAlgorithm()));
                    }
                }
                if (this.m_doc.getFormat().equals("DIGIDOC-XML") || this.m_doc.getFormat().equals("SK-XML")) {
                    String sDigType1 = ConfigManager.digAlg2Type(sp.getCertDigestAlgorithm());
                    if (sDigType1 != null) {
                        sp.setOrigDigest(SignedDoc.digestOfType(bCanProp, sDigType1));
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("SigProp2:\n------\n" + new String(bCanProp) + "\n------\n" + " len: " + bCanProp.length + " digtype: " + sDigType1 + " HASH: " + Base64Util.encode(sp.getOrigDigest())));
                    }
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            catch (UnsupportedEncodingException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureValue")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            this.m_strSigValTs = this.m_sbCollectChars.toString();
            this.m_sbCollectChars = null;
        }
        if (tag.equals("CompleteRevocationRefs")) {
            if (this.m_nCollectMode > 0) {
                --this.m_nCollectMode;
            }
            if (this.m_sbCollectChars != null) {
                this.m_strSigAndRefsTs = this.m_strSigValTs + this.m_sbCollectChars.toString();
            }
            this.m_sbCollectChars = null;
        }
        if (tag.equals("Signature") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"End collecting <Signature>");
            }
            try {
                sig = this.getLastSignature();
                if (this.m_sbCollectSignature != null && !sig.getSignedDoc().getFormat().equals("BDOC")) {
                    sig.setOrigContent(ConvertUtils.str2data(this.m_sbCollectSignature.toString(), "UTF-8"));
                    this.m_sbCollectSignature = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("XAdESSignatures") && this.m_nCollectMode == 0) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"End collecting <XAdESSignatures>");
            }
            try {
                sig = this.getLastSignature();
                if (this.m_sbCollectSignature != null) {
                    sig.setOrigContent(ConvertUtils.str2data(this.m_sbCollectSignature.toString(), "UTF-8"));
                    this.m_sbCollectSignature = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureTimeStamp")) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"End collecting <SignatureTimeStamp>");
            }
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = sig.getTimestampInfoOfType(3);
                if (ts != null && this.m_strSigValTs != null) {
                    CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                    byte[] bCanXml = canFac.canonicalize(ConvertUtils.str2data(this.m_strSigValTs, "UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    byte[] hash = SignedDoc.digest(bCanXml);
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("SigValTS \n---\n" + new String(bCanXml) + "\n---\nHASH: " + Base64Util.encode(hash)));
                    }
                    ts.setHash(hash);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SigAndRefsTimeStamp")) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug((Object)"End collecting <SigAndRefsTimeStamp>");
            }
            try {
                sig = this.getLastSignature();
                TimestampInfo ts = sig.getTimestampInfoOfType(4);
                if (ts != null && this.m_strSigAndRefsTs != null) {
                    String canXml = "<a>" + this.m_strSigAndRefsTs + "</a>";
                    CanonicalizationFactory canFac = ConfigManager.instance().getCanonicalizationFactory();
                    byte[] bCanXml = canFac.canonicalize(ConvertUtils.str2data(canXml, "UTF-8"), "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    canXml = new String(bCanXml, "UTF-8");
                    canXml = canXml.substring(3, canXml.length() - 4);
                    byte[] hash = SignedDoc.digest(ConvertUtils.str2data(canXml, "UTF-8"));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("SigAndRefsTimeStamp \n---\n" + canXml + "\n---\n" + Base64Util.encode(hash)));
                    }
                    ts.setHash(hash);
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            catch (Exception ex) {
                this.handleSAXError(ex);
            }
        }
        if (this.m_nCollectMode == 1) {
            SignatureProductionPlace spp;
            if (tag.equals("SigningTime")) {
                try {
                    sig = this.getLastSignature();
                    SignedProperties sp = sig.getSignedProperties();
                    sp.setSigningTime(ConvertUtils.string2date(this.m_sbCollectItem.toString(), this.m_doc));
                    this.m_sbCollectItem = null;
                }
                catch (DigiDocException ex) {
                    this.handleSAXError(ex);
                }
            }
            if (tag.equals("ClaimedRole")) {
                sig = this.getLastSignature();
                SignedProperties sp = sig.getSignedProperties();
                sp.addClaimedRole(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("City")) {
                sig = this.getLastSignature();
                SignedProperties sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setCity(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("StateOrProvince")) {
                sig = this.getLastSignature();
                SignedProperties sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setStateOrProvince(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("CountryName")) {
                sig = this.getLastSignature();
                SignedProperties sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setCountryName(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
            if (tag.equals("PostalCode")) {
                sig = this.getLastSignature();
                SignedProperties sp = sig.getSignedProperties();
                spp = sp.getSignatureProductionPlace();
                spp.setPostalCode(this.m_sbCollectItem.toString());
                this.m_sbCollectItem = null;
            }
        }
        if (tag.equals("DigestValue")) {
            try {
                if (this.m_tags.search("Reference") != -1) {
                    sig = this.getLastSignature();
                    SignedInfo si = sig.getSignedInfo();
                    Reference ref = si.getLastReference();
                    ref.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("SigningCertificate") != -1) {
                    sig = this.getLastSignature();
                    SignedProperties sp = sig.getSignedProperties();
                    sp.setCertDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    CertID cid = sig.getCertIdOfType(1);
                    if (cid != null) {
                        cid.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    }
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("CompleteCertificateRefs") != -1) {
                    sig = this.getLastSignature();
                    UnsignedProperties up = sig.getUnsignedProperties();
                    CompleteCertificateRefs crefs = up.getCompleteCertificateRefs();
                    CertID cid = crefs.getLastCertId();
                    if (cid != null) {
                        cid.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    }
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("CertID: " + cid.getId() + " digest: " + this.m_sbCollectItem.toString()));
                    }
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("CompleteRevocationRefs") != -1) {
                    sig = this.getLastSignature();
                    UnsignedProperties up = sig.getUnsignedProperties();
                    rrefs = up.getCompleteRevocationRefs();
                    orf = rrefs.getLastOcspRef();
                    orf.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("Revoc ref: " + this.m_sbCollectItem.toString()));
                    }
                    this.m_sbCollectItem = null;
                } else if (this.m_tags.search("SigPolicyHash") != -1) {
                    sig = this.getLastSignature();
                    SignedProperties sp = sig.getSignedProperties();
                    SignaturePolicyIdentifier spi2 = sp.getSignaturePolicyIdentifier();
                    SignaturePolicyId sppi = spi2.getSignaturePolicyId();
                    sppi.setDigestValue(Base64Util.decode(this.m_sbCollectItem.toString()));
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("SignaturePolicyId hash: " + this.m_sbCollectItem.toString()));
                    }
                    this.m_sbCollectItem = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("IssuerSerial") && this.m_doc != null && !this.m_doc.getVersion().equals("1.3") && !this.m_doc.getFormat().equals("BDOC")) {
            try {
                sig = this.getLastSignature();
                CertID cid = sig.getLastCertId();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("X509SerialNumber 0: " + this.m_sbCollectItem.toString()));
                }
                if (cid != null) {
                    cid.setSerial(ConvertUtils.string2bigint(this.m_sbCollectItem.toString()));
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509SerialNumber") && this.m_doc != null && (this.m_doc.getVersion().equals("1.3") || this.m_doc.getFormat().equals("BDOC"))) {
            try {
                sig = this.getLastSignature();
                CertID cid = sig.getLastCertId();
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("X509SerialNumber: " + this.m_sbCollectItem.toString()));
                }
                if (cid != null) {
                    cid.setSerial(ConvertUtils.string2bigint(this.m_sbCollectItem.toString()));
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("X509SerialNumber: " + cid.getSerial() + " type: " + cid.getType()));
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509IssuerName") && this.m_doc != null && (this.m_doc.getVersion().equals("1.3") || this.m_doc.getFormat().equals("BDOC"))) {
            try {
                sig = this.getLastSignature();
                CertID cid = sig.getLastCertId();
                String s = this.m_sbCollectItem.toString();
                if (cid != null) {
                    cid.setIssuer(s);
                }
                if (this.m_logger.isDebugEnabled() && cid != null) {
                    this.m_logger.debug((Object)("X509IssuerName: " + s + " type: " + cid.getType() + " nr: " + cid.getSerial()));
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("EncapsulatedTimeStamp")) {
            sig = this.getLastSignature();
            TimestampInfo ts = sig.getLastTimestampInfo();
            try {
                BouncyCastleTimestampFactory tfac = new BouncyCastleTimestampFactory();
                ts.setTimeStampToken(tfac.readTsTok(Base64Util.decode(this.m_sbCollectItem.toString())));
                if (this.m_logger.isDebugEnabled() && ts != null) {
                    this.m_logger.debug((Object)("TS: " + ts.getId() + " type: " + ts.getType() + " time: " + ts.getTime() + " digest: " + Base64Util.encode(ts.getMessageImprint())));
                }
            }
            catch (Exception ex) {
                this.handleSAXError(new DigiDocException(124, "Invalid timestamp token", ex));
            }
            this.m_sbCollectItem = null;
        }
        if (tag.equals("ResponderID")) {
            try {
                if (!this.m_doc.getFormat().equals("BDOC")) {
                    sig = this.getLastSignature();
                    UnsignedProperties up = sig.getUnsignedProperties();
                    rrefs = up.getCompleteRevocationRefs();
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("ResponderID: " + this.m_sbCollectItem.toString()));
                    }
                    orf = rrefs.getLastOcspRef();
                    orf.setResponderId(this.m_sbCollectItem.toString());
                    this.m_sbCollectItem = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("ByName")) {
            try {
                if (this.m_doc.getFormat().equals("BDOC")) {
                    sig = this.getLastSignature();
                    UnsignedProperties up = sig.getUnsignedProperties();
                    rrefs = up.getCompleteRevocationRefs();
                    if (this.m_logger.isDebugEnabled()) {
                        this.m_logger.debug((Object)("ResponderID by-name: " + this.m_sbCollectItem.toString()));
                    }
                    orf = rrefs.getLastOcspRef();
                    orf.setResponderId(this.m_sbCollectItem.toString());
                    this.m_sbCollectItem = null;
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("ProducedAt")) {
            try {
                sig = this.getLastSignature();
                UnsignedProperties up = sig.getUnsignedProperties();
                rrefs = up.getCompleteRevocationRefs();
                orf = rrefs.getLastOcspRef();
                orf.setProducedAt(ConvertUtils.string2date(this.m_sbCollectItem.toString(), this.m_doc));
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("SignatureValue")) {
            try {
                sig = this.getLastSignature();
                SignatureValue sv = sig.getSignatureValue();
                if (this.m_sbCollectItem != null && this.m_sbCollectItem.length() > 0) {
                    sig.setSignatureValue(Base64Util.decode(this.m_sbCollectItem.toString().trim()));
                }
                if (this.m_logger.isDebugEnabled()) {
                    this.m_logger.debug((Object)("SIGVAL mode: " + this.m_nCollectMode + ":\n--\n" + (this.m_sbCollectItem != null ? this.m_sbCollectItem.toString() : "NULL") + "\n---\n len: " + (sv.getValue() != null ? sv.getValue().length : 0)));
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("X509Certificate")) {
            try {
                sig = this.getLastSignature();
                CertValue cval = sig.getLastCertValue();
                cval.setCert(SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectItem.toString())));
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("EncapsulatedX509Certificate")) {
            try {
                sig = this.getLastSignature();
                CertValue cval = sig.getLastCertValue();
                cval.setCert(SignedDoc.readCertificate(Base64Util.decode(this.m_sbCollectItem.toString())));
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("EncapsulatedOCSPValue")) {
            try {
                sig = this.getLastSignature();
                this.findCertIDandCertValueTypes(sig);
                UnsignedProperties up = sig.getUnsignedProperties();
                Notary not = up.getLastNotary();
                not.setOcspResponseData(Base64Util.decode(this.m_sbCollectItem.toString()));
                NotaryFactory notFac = ConfigManager.instance().getNotaryFactory();
                notFac.parseAndVerifyResponse(sig, not);
                if (this.m_doc != null && this.m_doc.getFormat().equals("DIGIDOC-XML") && this.m_doc.getVersion().equals("1.1")) {
                    CompleteRevocationRefs rrefs2 = up.getCompleteRevocationRefs();
                    OcspRef orf2 = rrefs2.getLastOcspRef();
                    orf2.setDigestValue(SignedDoc.digestOfType(not.getOcspResponseData(), this.m_doc.getFormat().equals("BDOC") ? "SHA-256" : "SHA-1"));
                }
                this.m_sbCollectItem = null;
            }
            catch (Exception ex) {
                this.handleSAXError(ex);
            }
        }
        if (tag.equals("Identifier")) {
            ObjectIdentifier oi;
            SignedProperties sp;
            sig = this.getLastSignature();
            if (sig != null && (sp = sig.getSignedProperties()) != null && (spid = sp.getSignaturePolicyIdentifier()) != null && (oi = (spi = spid.getSignaturePolicyId()).getSigPolicyId()) != null) {
                Identifier id = oi.getIdentifier();
                id.setUri(this.m_sbCollectItem.toString().trim());
                if (oi.getIdentifier().getUri().equals("urn:oid:1.3.6.1.4.1.10015.1000.3.2.1")) {
                    try {
                        this.m_doc.setVersion("2.1");
                    }
                    catch (Exception ex) {
                        this.m_logger.error((Object)("Error setting 2.1 ver: " + ex));
                    }
                }
            }
            this.m_sbCollectItem = null;
        }
        if (tag.equals("SPURI")) {
            SignedProperties sp;
            sig = this.getLastSignature();
            if (sig != null && (sp = sig.getSignedProperties()) != null && (spid = sp.getSignaturePolicyIdentifier()) != null && (spi = spid.getSignaturePolicyId()) != null) {
                spi.addSigPolicyQualifier(new SpUri(this.m_sbCollectItem.toString().trim()));
            }
            this.m_sbCollectItem = null;
        }
        if (tag.equals("MimeType")) {
            try {
                SignedDataObjectProperties sdps;
                DataObjectFormat dof;
                SignedProperties sp;
                sig = this.getLastSignature();
                if (sig != null && (sp = sig.getSignedProperties()) != null && (dof = (sdps = sp.getSignedDataObjectProperties()).getLastDataObjectFormat()) != null) {
                    dof.setMimeType(this.m_sbCollectItem.toString());
                    Reference ref = sig.getSignedInfo().getReferenceForDataObjectFormat(dof);
                    if (ref != null) {
                        for (int d = 0; d < sig.getSignedDoc().countDataFiles(); ++d) {
                            String sUri;
                            DataFile df = sig.getSignedDoc().getDataFile(d);
                            if (df.getFileName() == null || df.getFileName().length() <= 1 || ref.getUri() == null || ref.getUri().length() <= 1) continue;
                            String sFileName = df.getFileName();
                            if (sFileName.charAt(0) == '/') {
                                sFileName = sFileName.substring(1);
                            }
                            if ((sUri = ref.getUri()).charAt(0) == '/') {
                                sUri = sUri.substring(1);
                            }
                            if (!sFileName.equals(sUri)) continue;
                            df.setMimeType(this.m_sbCollectItem.toString());
                        }
                    }
                }
                this.m_sbCollectItem = null;
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String s = new String(buf, offset, len);
        if (s != null) {
            if (this.m_sbCollectItem != null) {
                this.m_sbCollectItem.append(s);
            }
            if (this.m_sbCollectChars != null) {
                if (this.m_logger.isDebugEnabled() && this.m_sbCollectChars.indexOf("SignedInfo") != -1) {
                    this.m_logger.debug((Object)("IN: '" + s + "' escaped: '" + ConvertUtils.escapeTextNode(s) + "'"));
                }
                this.m_sbCollectChars.append(ConvertUtils.escapeTextNode(s));
            }
            if (this.m_sbCollectSignature != null) {
                this.m_sbCollectSignature.append(ConvertUtils.escapeTextNode(s));
            }
            if (this.m_digest != null && this.m_bCollectDigest) {
                this.updateDigest(s.getBytes());
            }
            if (this.m_altDigest != null && this.m_bCollectDigest) {
                this.updateAltDigest(s.getBytes());
            }
            try {
                if (this.m_dfCacheOutStream != null) {
                    this.m_dfCacheOutStream.write(ConvertUtils.str2data(s));
                }
            }
            catch (DigiDocException ex) {
                this.handleSAXError(ex);
            }
            catch (IOException ex) {
                this.handleSAXError(ex);
            }
        }
    }
}

