/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.tsl;

import ee.sk.digidoc.tsl.MultiLangString;
import ee.sk.digidoc.tsl.PostalAddress;
import ee.sk.utils.ConvertUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SchemeInformation {
    private int m_version = 0;
    private int m_seqNr = 0;
    private String m_type = null;
    private List m_operatorNames = null;
    private List m_postalAddresses = null;
    private List m_electronicAddresses = null;
    private List m_schemeNames = null;
    private List m_schemeInformationUris = null;
    private String m_statusDeterminationApproach = null;
    private List m_schemeTypeCommunityRules = null;
    private String m_schemeTerritory = null;
    private List m_policyOrLegalNotices = null;
    private int m_historicalInformationPeriod = 0;
    private Date m_issueDate = null;
    private List m_nextUpdates = null;
    private List m_distributionPoints = null;
    public static final String TYPE_LOCAL = "LOCAL";
    public static final String TYPE_GENERIC = "http://uri.etsi.org/TrstSvc/eSigDir-1999-93-EC-TrustedList/TSLType/generic";

    public int getVersionIdentifier() {
        return this.m_version;
    }

    public int getSequenceNumber() {
        return this.m_seqNr;
    }

    public String getType() {
        return this.m_type;
    }

    public MultiLangString[] getOperatorNames() {
        return ConvertUtils.list2mls(this.m_operatorNames);
    }

    public PostalAddress[] getPostalAddresses() {
        PostalAddress[] arr = null;
        if (this.m_postalAddresses != null && this.m_postalAddresses.size() > 0) {
            arr = new PostalAddress[this.m_postalAddresses.size()];
            for (int i = 0; i < this.m_postalAddresses.size(); ++i) {
                arr[i] = (PostalAddress)this.m_postalAddresses.get(i);
            }
        }
        return arr;
    }

    public MultiLangString[] getElectronicAddresses() {
        return ConvertUtils.list2mls(this.m_electronicAddresses);
    }

    public MultiLangString[] getSchemeNames() {
        return ConvertUtils.list2mls(this.m_schemeNames);
    }

    public MultiLangString[] getSchemeInformationURIs() {
        return ConvertUtils.list2mls(this.m_schemeInformationUris);
    }

    public String getStatusDeterminationApproach() {
        return this.m_statusDeterminationApproach;
    }

    public MultiLangString[] getSchemeTypeCommunityRules() {
        return ConvertUtils.list2mls(this.m_schemeTypeCommunityRules);
    }

    public String getSchemeTerritory() {
        return this.m_schemeTerritory;
    }

    public MultiLangString[] getPolicyOrLegalNotices() {
        return ConvertUtils.list2mls(this.m_policyOrLegalNotices);
    }

    public int getHistoricalInformationPeriod() {
        return this.m_historicalInformationPeriod;
    }

    public Date getListIssueDate() {
        return this.m_issueDate;
    }

    public Date[] getNextUpdates() {
        return ConvertUtils.list2dates(this.m_nextUpdates);
    }

    public MultiLangString[] getDistributionPoints() {
        return ConvertUtils.list2mls(this.m_distributionPoints);
    }

    public MultiLangString getOperatorName(int n) {
        return ConvertUtils.getListObj(this.m_operatorNames, n);
    }

    public PostalAddress getPostalAddress(int n) {
        if (this.m_postalAddresses != null && n >= 0 && n < this.m_postalAddresses.size()) {
            return (PostalAddress)this.m_postalAddresses.get(n);
        }
        return null;
    }

    public MultiLangString getElectronicAddress(int n) {
        return ConvertUtils.getListObj(this.m_electronicAddresses, n);
    }

    public MultiLangString getDistributionPoint(int n) {
        return ConvertUtils.getListObj(this.m_distributionPoints, n);
    }

    public MultiLangString getSchemeName(int n) {
        return ConvertUtils.getListObj(this.m_schemeNames, n);
    }

    public MultiLangString getSchemeInformationURI(int n) {
        return ConvertUtils.getListObj(this.m_schemeInformationUris, n);
    }

    public MultiLangString getSchemeTypeCommunityRule(int n) {
        return ConvertUtils.getListObj(this.m_schemeTypeCommunityRules, n);
    }

    public MultiLangString getPolicyOrLegalNotice(int n) {
        return ConvertUtils.getListObj(this.m_policyOrLegalNotices, n);
    }

    public void setVersionIdentifier(int n) {
        this.m_version = n;
    }

    public void setSequenceNumber(int n) {
        this.m_seqNr = n;
    }

    public void setType(String s) {
        this.m_type = s;
    }

    public void addOperatorName(MultiLangString s) {
        this.m_operatorNames = ConvertUtils.addObject(this.m_operatorNames, s);
    }

    public void addPostalAddress(PostalAddress a) {
        if (this.m_postalAddresses == null) {
            this.m_postalAddresses = new ArrayList();
        }
        this.m_postalAddresses.add(a);
    }

    public void addElectronicAddress(MultiLangString s) {
        this.m_electronicAddresses = ConvertUtils.addObject(this.m_electronicAddresses, s);
    }

    public void addSchemeName(MultiLangString s) {
        this.m_schemeNames = ConvertUtils.addObject(this.m_schemeNames, s);
    }

    public void addSchemeInformationURI(MultiLangString s) {
        this.m_schemeInformationUris = ConvertUtils.addObject(this.m_schemeInformationUris, s);
    }

    public void setStatusDeterminationApproach(String s) {
        this.m_statusDeterminationApproach = s;
    }

    public void addSchemeTypeCommunityRule(MultiLangString s) {
        this.m_schemeTypeCommunityRules = ConvertUtils.addObject(this.m_schemeTypeCommunityRules, s);
    }

    public void setSchemeTerritory(String s) {
        this.m_schemeTerritory = s;
    }

    public void addPolicyOrLegalNotice(MultiLangString s) {
        this.m_policyOrLegalNotices = ConvertUtils.addObject(this.m_policyOrLegalNotices, s);
    }

    public void setHistoricalInformationPeriod(int n) {
        this.m_historicalInformationPeriod = n;
    }

    public void setListIssueDate(Date d) {
        this.m_issueDate = d;
    }

    public void addNextUpdate(Date d) {
        this.m_nextUpdates = ConvertUtils.addObject(this.m_nextUpdates, d);
    }

    public void addDistributionPoint(MultiLangString s) {
        this.m_distributionPoints = ConvertUtils.addObject(this.m_distributionPoints, s);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("[SchemeInformation");
        sb.append(ConvertUtils.intElemToString("ver", this.m_version));
        sb.append(ConvertUtils.intElemToString("seq", this.m_seqNr));
        sb.append(ConvertUtils.stringElemToString("type", this.m_type));
        sb.append("[OperatorNames");
        for (i = 0; this.m_operatorNames != null && i < this.m_operatorNames.size(); ++i) {
            sb.append((MultiLangString)this.m_operatorNames.get(i));
        }
        sb.append("][PostalAddresses");
        for (i = 0; this.m_postalAddresses != null && i < this.m_postalAddresses.size(); ++i) {
            sb.append((PostalAddress)this.m_postalAddresses.get(i));
        }
        sb.append("][ElectronicAddresses");
        for (i = 0; this.m_electronicAddresses != null && i < this.m_electronicAddresses.size(); ++i) {
            sb.append((MultiLangString)this.m_electronicAddresses.get(i));
        }
        sb.append("][SchemeNames");
        for (i = 0; this.m_schemeNames != null && i < this.m_schemeNames.size(); ++i) {
            sb.append((MultiLangString)this.m_schemeNames.get(i));
        }
        sb.append("][SchemeInfoURIs");
        for (i = 0; this.m_schemeInformationUris != null && i < this.m_schemeInformationUris.size(); ++i) {
            sb.append((MultiLangString)this.m_schemeInformationUris.get(i));
        }
        sb.append("]");
        sb.append(ConvertUtils.stringElemToString("status-approach", this.m_statusDeterminationApproach));
        sb.append("][CommunityRules");
        for (i = 0; this.m_schemeTypeCommunityRules != null && i < this.m_schemeTypeCommunityRules.size(); ++i) {
            sb.append((MultiLangString)this.m_schemeTypeCommunityRules.get(i));
        }
        sb.append(ConvertUtils.stringElemToString("territory", this.m_schemeTerritory));
        sb.append("][Policies");
        for (i = 0; this.m_policyOrLegalNotices != null && i < this.m_policyOrLegalNotices.size(); ++i) {
            sb.append((MultiLangString)this.m_policyOrLegalNotices.get(i));
        }
        sb.append("]");
        sb.append(ConvertUtils.intElemToString("info-period", this.m_historicalInformationPeriod));
        sb.append(ConvertUtils.dateElemToString("issue-date", this.m_issueDate));
        sb.append("[NextUpdate");
        for (i = 0; this.m_nextUpdates != null && i < this.m_nextUpdates.size(); ++i) {
            sb.append(ConvertUtils.dateElemToString("next-update", (Date)this.m_nextUpdates.get(i)));
        }
        sb.append("][DistributionPoints");
        for (i = 0; this.m_distributionPoints != null && i < this.m_distributionPoints.size(); ++i) {
            sb.append((MultiLangString)this.m_distributionPoints.get(i));
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

