/*
 * Decompiled with CFR 0.152.
 */
package ee.sk.digidoc.tsl;

import ee.sk.digidoc.tsl.MultiLangString;
import ee.sk.digidoc.tsl.PostalAddress;
import ee.sk.utils.ConvertUtils;
import java.util.ArrayList;
import java.util.List;

public class TSPInformation {
    private List m_names = null;
    private List m_tradeNames = null;
    private List m_postalAddresses = null;
    private List m_electronicAddresses = null;
    private List m_informationUris = null;

    public MultiLangString[] getNames() {
        return ConvertUtils.list2mls(this.m_names);
    }

    public MultiLangString[] getTradeNames() {
        return ConvertUtils.list2mls(this.m_tradeNames);
    }

    public PostalAddress[] getPostalAddresses() {
        PostalAddress[] arr = null;
        if (this.m_postalAddresses != null && this.m_postalAddresses.size() > 0) {
            arr = new PostalAddress[this.m_postalAddresses.size()];
            for (int i = 0; i < this.m_postalAddresses.size(); ++i) {
                arr[i] = (PostalAddress)this.m_postalAddresses.get(i);
            }
        }
        return arr;
    }

    public MultiLangString[] getElectronicAddresses() {
        return ConvertUtils.list2mls(this.m_electronicAddresses);
    }

    public MultiLangString[] getInformationURIs() {
        return ConvertUtils.list2mls(this.m_informationUris);
    }

    public MultiLangString getName(int n) {
        return ConvertUtils.getListObj(this.m_names, n);
    }

    public MultiLangString getTradeName(int n) {
        return ConvertUtils.getListObj(this.m_tradeNames, n);
    }

    public PostalAddress getPostalAddress(int n) {
        if (this.m_postalAddresses != null && n >= 0 && n < this.m_postalAddresses.size()) {
            return (PostalAddress)this.m_postalAddresses.get(n);
        }
        return null;
    }

    public MultiLangString getElectronicAddress(int n) {
        return ConvertUtils.getListObj(this.m_electronicAddresses, n);
    }

    public MultiLangString getInformationURI(int n) {
        return ConvertUtils.getListObj(this.m_informationUris, n);
    }

    public void addName(MultiLangString s) {
        this.m_names = ConvertUtils.addObject(this.m_names, s);
    }

    public void addTradeName(MultiLangString s) {
        this.m_tradeNames = ConvertUtils.addObject(this.m_tradeNames, s);
    }

    public void addPostalAddress(PostalAddress a) {
        if (this.m_postalAddresses == null) {
            this.m_postalAddresses = new ArrayList();
        }
        this.m_postalAddresses.add(a);
    }

    public void addElectronicAddress(MultiLangString s) {
        this.m_electronicAddresses = ConvertUtils.addObject(this.m_electronicAddresses, s);
    }

    public void addInformationURI(MultiLangString s) {
        this.m_informationUris = ConvertUtils.addObject(this.m_informationUris, s);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("[TSPInformation");
        sb.append("[Names");
        for (i = 0; this.m_names != null && i < this.m_names.size(); ++i) {
            sb.append((MultiLangString)this.m_names.get(i));
        }
        sb.append("][TradeNames");
        for (i = 0; this.m_tradeNames != null && i < this.m_tradeNames.size(); ++i) {
            sb.append((MultiLangString)this.m_tradeNames.get(i));
        }
        sb.append("][PostalAddresses");
        for (i = 0; this.m_postalAddresses != null && i < this.m_postalAddresses.size(); ++i) {
            sb.append((PostalAddress)this.m_postalAddresses.get(i));
        }
        sb.append("][ElectronicAddresses");
        for (i = 0; this.m_electronicAddresses != null && i < this.m_electronicAddresses.size(); ++i) {
            sb.append((MultiLangString)this.m_electronicAddresses.get(i));
        }
        sb.append("][InfoURIs");
        for (i = 0; this.m_informationUris != null && i < this.m_informationUris.size(); ++i) {
            sb.append((MultiLangString)this.m_informationUris.get(i));
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

